/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.workbench;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.application.SingleFrameApplication;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import rs.pezar.core.PzApplication;
import rs.pezar.core.gui.defaultWidgets.mainView.MainViewWidget;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzMenu;
import rs.pezar.swing.PzMenuBar;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.PzWindow;
import rs.pezar.swing.PzWorkArea;
import rs.pezar.swing.PzWorkbench;
import rs.pezar.swing.WorkArea;
import rs.pezar.swing.event.PzWorkbenchListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.util.PzFileUtility;

public class PzWorkbenchImplNew
extends SingleFrameApplication
implements PzWorkbench {
    private JPanel topPanel;
    private PzMenuBar menuBar;
    private PzWorkArea workArea;
    private MainViewWidget mainview;
    private PzStatusBar statusbar;
    private Vector<PzWorkbenchListener> listeners;

    private void init() {
        try {
            PzApplication.getApplication().setWorkbench(this);
            this.loadMenuBar();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

                @Override
                public void propertyChange(final PropertyChangeEvent e) {
                    if (e.getNewValue() instanceof PzFieldImpl) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PzFieldImpl textField = (PzFieldImpl)e.getNewValue();
                                if (!(textField instanceof PzDateField)) {
                                    textField.selectAll();
                                } else {
                                    textField.setCaretPosition(0);
                                }
                            }
                        });
                    }
                }
            });
            UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
            JFrame.setDefaultLookAndFeelDecorated(true);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this.getMainFrame(), e);
        }
    }

    private void loadMenuBar() {
        try {
            Document doc = PzFileUtility.loadXML("rs/pezar/core/resource/menu.xml", this.getClass().getClassLoader());
            NodeList list = doc.getElementsByTagName("menu");
            int i = 0;
            while (i < list.getLength()) {
                PzMenu menu = new PzMenu(list.item(i), this.getClass().getClassLoader());
                this.menuBar.addMenu(menu);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initGUI() {
        this.topPanel = new JPanel();
        BorderLayout panelLayout = new BorderLayout();
        this.topPanel.setLayout(panelLayout);
        this.menuBar = new PzMenuBar(this);
        this.workArea = new PzWorkArea();
        AnchorLayout workAreaLayout = new AnchorLayout();
        this.workArea.setLayout(workAreaLayout);
        this.workArea.setPaintGradient(true);
        this.workArea.setGradient(new Color(132, 5, 250), Color.WHITE, PzPanel.GRADIENT_NORTH_SOUTH);
        this.topPanel.add((Component)this.workArea, "Center");
        this.mainview = new MainViewWidget();
        this.workArea.add(this.mainview, new AnchorConstraint(0, 496, 974, 0, 1, 0, 1, 1));
        this.mainview.setPreferredSize(new Dimension(327, 547));
        this.statusbar = new PzStatusBar();
        this.statusbar.setPreferredSize(new Dimension(855, 24));
        this.statusbar.setBorder(BorderFactory.createBevelBorder(1));
        this.topPanel.add((Component)((Object)this.statusbar), "South");
        this.getMainFrame().setJMenuBar(this.menuBar);
        this.show(this.topPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PzParameter.getBoolean("FIRST.TIME", true) == null) {
                        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
                        PzWorkbenchImplNew.this.getMainFrame().setSize(new Dimension(320, (int)scrSize.getHeight() - 50));
                        PzParameter.setParameter("FIRST.TIME", "false");
                    }
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle(PzWorkbenchImplNew.this.getMainFrame(), e);
                }
            }
        });
    }

    protected void startup() {
        this.initGUI();
        this.init();
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        for (PzWorkbenchListener listener : this.listeners) {
            listener.workbenchExposed();
        }
    }

    protected void shutdown() {
        for (PzWorkbenchListener listener : this.listeners) {
            listener.workbenchClosed();
        }
        super.shutdown();
    }

    @Override
    public PzToolBar getToolBar() {
        return null;
    }

    @Override
    public PzStatusBar getStatusBar() {
        return this.statusbar;
    }

    @Override
    public PzMenuBar getWorkbenchMenuBar() {
        return this.menuBar;
    }

    @Override
    public void addWorkbenchListener(PzWorkbenchListener newPzWorkbenchListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(newPzWorkbenchListener);
    }

    @Override
    public List<PzWorkbenchListener> getWorkbenchListeners() {
        return this.listeners;
    }

    @Override
    public void instantiateWindow(Class windowClass) {
    }

    @Override
    public void fireWindowInstantiated(PzWindow window) {
    }

    @Override
    public void showDialog(Class<? extends PzDialog> type, String parameter) {
        try {
            Constructor<? extends PzDialog> c = parameter == null ? type.getConstructor(JFrame.class) : type.getConstructor(JFrame.class, String.class);
            PzDialog dialog = parameter == null ? c.newInstance(this.getMainFrame()) : c.newInstance(this.getMainFrame(), parameter);
            dialog.setModal(false);
            dialog.setDialogSessionOwner(true);
            if (dialog.shouldBeShown()) {
                this.fireDialogInstantiated(dialog);
                dialog.restoreSize();
                dialog.setVisible(true);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this.getMainFrame(), e);
        }
    }

    private void fireDialogInstantiated(PzDialog dialog) {
        for (PzWorkbenchListener listener : this.listeners) {
            listener.dialogInstantiated(dialog);
        }
    }

    @Override
    public void removeWorkbenchListener(PzWorkbenchListener wbListener) {
        this.listeners.remove(wbListener);
    }

    @Override
    public void save() {
    }

    @Override
    public void restore() {
    }

    @Override
    public WorkArea getWorkArea() {
        return this.workArea;
    }

    @Override
    public void expose() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isVisible() {
        return this.getMainFrame().isVisible();
    }
}

