/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.core.gui.menu.upravljanjeDokumentima.History;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Adtaksa;
import rs.pezar.db.entity.Aftaksa;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikaldokument;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalfakturaparameter;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Artikalkonsignacija;
import rs.pezar.db.entity.Artikalnalog;
import rs.pezar.db.entity.Artikalnalogprijem;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.DokumentLog;
import rs.pezar.db.entity.Dtaksa;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaopstidokument;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.Id_gen;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Kalkulacijazapisnik;
import rs.pezar.db.entity.Konsignacija;
import rs.pezar.db.entity.Koplaca;
import rs.pezar.db.entity.Nalogmagacinu;
import rs.pezar.db.entity.Nalogprijem;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.Stavkaporudzbine;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.db.entity.Taksafod;
import rs.pezar.db.entity.Taksainterniracun;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Taksakz;
import rs.pezar.db.entity.Taksanivelacija;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.Trosak;
import rs.pezar.db.entity.Udtaksa;
import rs.pezar.db.entity.Uslugadokument;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.globals.TipDokumentStructure;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzButtonPanel;
import rs.pezar.swing.PzCheckBoxList;
import rs.pezar.swing.PzCheckbox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzScrollableTableEntity;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzTextArea;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzFileUtility;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogUpravljanjeDokumentima
extends PzDialog {
    private static final long serialVersionUID = -8055073309127313669L;
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzTextField tfOznakaDokumenta;
    private JLabel lblOznakaDokumenta;
    private PzPanel pnlPolja;
    private PzButtonPanel btnPnlSnimanje;
    private PzButton btnTrazi;
    private PzPanel pnlButton;
    private JScrollPane scrollPaneFilter;
    private PzTextArea areaUpit;
    private JLabel lblUpit;
    private PzPanel jPanel1;
    private JScrollPane scrollPaneCb;
    private PzScrollableTableEntity tblDokumenti;
    private JScrollPane scrollPane;
    private PzPanel pnlFilter;
    private PzButton icnImport;
    private PzButton icnExport;
    private Box box;
    private PzCheckbox cbStorno;
    private PzCheckbox cbProknjizen;
    private PzCheckbox cbArhiviran;
    private PzCheckbox cbPriprema;
    private PzPanel pnlIzborDok;
    private ScrollableCursor cursor = null;
    private PzDateField dfKrajnjiDatum;
    private JLabel lblKrajnjiDatum;
    private PzDateField dfPocetniDatum;
    private JLabel lblPocetniDatum;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel("0");
    private PzCheckBoxList listTipovi;
    private PzButton icnStampa;
    private PzButton snimanjeSelektuj;
    private PzButton snimanjeDeselektuj;
    private PzButton icnBrisanje;
    private PzButton icnHistory;
    private JPanel pnlSelect;
    private PzButton icnSelektuj;
    private PzButton icnSelektujSve;
    private PzButton icnKloniraj;

    public PzDialogUpravljanjeDokumentima(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Pzuser user = PzApplication.getApplication().getSession().getLoggedUser();
        if (!user.isAdministrator()) {
            this.icnBrisanje.setFocusable(false);
            this.icnBrisanje.setEnabled(false);
            this.icnImport.setEnabled(false);
            this.icnExport.setEnabled(false);
            this.areaUpit.setFocusable(false);
            this.areaUpit.setEnabled(false);
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            this.mainPanel.setGradient(Color.WHITE, Color.LIGHT_GRAY, PzPanel.GRADIENT_WEST_EAST);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{74, 162, 7};
            mainPanelLayout.columnWeights = new double[]{0.1};
            mainPanelLayout.columnWidths = new int[]{7};
            this.mainPanel.setLayout(mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnImport = new PzButton();
            this.icnImport.setLayout(null);
            this.toolbar.add(this.icnImport);
            this.icnImport.setText("Import|dokumenata|(INSERT)");
            this.icnImport.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/import1.png")));
            this.icnImport.setActionCommand("import");
            this.icnImport.addActionListener(this);
            this.icnImport.setShortcut("INSERT");
            this.icnImport.setFocusable(false);
            this.icnImport.setOpaque(false);
            this.icnExport = new PzButton();
            this.icnExport.setLayout(null);
            this.toolbar.add(this.icnExport);
            this.icnExport.setText("Export|dokumenata|(F3)");
            this.icnExport.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/export1.png")));
            this.icnExport.setActionCommand("export");
            this.icnExport.addActionListener(this);
            this.icnExport.setShortcut("F3");
            this.icnExport.setFocusable(false);
            this.icnExport.setOpaque(false);
            this.icnStampa = new PzButton();
            this.icnStampa.setLayout(null);
            this.toolbar.add(this.icnStampa);
            this.icnStampa.setText("\u0160tampa|dokumenata|(F2)");
            this.icnStampa.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/export1.png")));
            this.icnStampa.setActionCommand("stampa");
            this.icnStampa.addActionListener(this);
            this.icnStampa.setShortcut("F2");
            this.icnStampa.setFocusable(false);
            this.icnStampa.setOpaque(false);
            this.icnBrisanje = new PzButton();
            this.icnBrisanje.setLayout(null);
            this.toolbar.add(this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|dokumenata|(DELETE)");
            this.icnBrisanje.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/delete.png")));
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener(this);
            this.icnBrisanje.setShortcut("DELETE");
            this.icnBrisanje.setFocusable(false);
            this.icnBrisanje.setOpaque(false);
            this.icnHistory = new PzButton();
            this.icnHistory.setLayout(null);
            this.toolbar.add(this.icnHistory);
            this.icnHistory.setText("Istorija|dokumenata|(CTRL+H)");
            this.icnHistory.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/history.png")));
            this.icnHistory.setActionCommand("history");
            this.icnHistory.addActionListener(this);
            this.icnHistory.setShortcut("ctrl+h");
            this.icnHistory.setFocusable(false);
            this.icnHistory.setOpaque(false);
            this.icnKloniraj = new PzButton();
            this.icnKloniraj.setLayout(null);
            this.toolbar.add(this.icnKloniraj);
            this.icnKloniraj.setText("Kloniraj|dokument|(CTRL+K)");
            this.icnKloniraj.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/history.png")));
            this.icnKloniraj.setActionCommand("clone");
            this.icnKloniraj.addActionListener(this);
            this.icnKloniraj.setShortcut("ctrl+k");
            this.icnKloniraj.setFocusable(false);
            this.icnKloniraj.setOpaque(false);
            this.pnlFilter = new PzPanel();
            GridBagLayout pnlFilterLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlFilter, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFilterLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlFilterLayout.rowHeights = new int[]{7, 20, 7, 7};
            pnlFilterLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFilterLayout.columnWidths = new int[]{259, 138, 233, 248, 214, 7};
            this.pnlFilter.setLayout(pnlFilterLayout);
            this.pnlFilter.setOpaque(false);
            this.pnlFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.scrollPaneCb = new JScrollPane();
            this.pnlFilter.add((Component)this.scrollPaneCb, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 9, 0, 0), 0, 0));
            this.scrollPaneCb.setBorder(BorderFactory.createTitledBorder("Izbor tipa dokumenta"));
            this.scrollPaneCb.setName("scrollPaneCb");
            this.listTipovi = new PzCheckBoxList();
            this.listTipovi.setListData(this.setDocumentList());
            this.scrollPaneCb.setViewportView(this.listTipovi);
            this.btnPnlSnimanje = new PzButtonPanel();
            GridBagLayout btnPnlSnimanjeLayout = new GridBagLayout();
            this.pnlFilter.add((Component)this.btnPnlSnimanje, new GridBagConstraints(0, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            btnPnlSnimanjeLayout.rowWeights = new double[]{0.1};
            btnPnlSnimanjeLayout.rowHeights = new int[]{7};
            btnPnlSnimanjeLayout.columnWeights = new double[]{0.1, 0.1};
            btnPnlSnimanjeLayout.columnWidths = new int[]{7, 7};
            this.btnPnlSnimanje.setLayout(btnPnlSnimanjeLayout);
            this.snimanjeSelektuj = new PzButton();
            this.btnPnlSnimanje.add((Component)this.snimanjeSelektuj, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.snimanjeSelektuj.setText("Selektuj sve");
            this.snimanjeSelektuj.addActionListener(this);
            this.snimanjeSelektuj.setActionCommand("snimanjeSelektuj");
            this.snimanjeSelektuj.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/selection_check.png")));
            this.snimanjeDeselektuj = new PzButton();
            this.btnPnlSnimanje.add((Component)this.snimanjeDeselektuj, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.snimanjeDeselektuj.setText("Deselektuj sve");
            this.snimanjeDeselektuj.addActionListener(this);
            this.snimanjeDeselektuj.setActionCommand("snimanjeDeselektuj");
            this.snimanjeDeselektuj.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/selection_delete.png")));
            this.pnlIzborDok = new PzPanel();
            GridBagLayout pnlIzborDokLayout1 = new GridBagLayout();
            this.pnlFilter.add((Component)this.pnlIzborDok, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlIzborDok.setBorder(BorderFactory.createTitledBorder("Izbor dokumenta"));
            pnlIzborDokLayout1.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlIzborDokLayout1.rowHeights = new int[]{7, 7, 7, 7, 7, 20};
            pnlIzborDokLayout1.columnWeights = new double[]{0.1};
            pnlIzborDokLayout1.columnWidths = new int[]{7};
            this.pnlIzborDok.setLayout(pnlIzborDokLayout1);
            this.pnlIzborDok.setOpaque(false);
            this.cbPriprema = new PzCheckbox();
            this.pnlIzborDok.add((Component)this.cbPriprema, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.cbPriprema.setName("cbPriprema");
            this.cbPriprema.setOpaque(false);
            this.cbArhiviran = new PzCheckbox();
            this.pnlIzborDok.add((Component)this.cbArhiviran, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.cbArhiviran.setName("cbArhiviran");
            this.cbArhiviran.setOpaque(false);
            this.cbProknjizen = new PzCheckbox();
            this.pnlIzborDok.add((Component)this.cbProknjizen, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.cbProknjizen.setName("cbProknjizen");
            this.cbProknjizen.setOpaque(false);
            this.cbProknjizen.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    PzDialogUpravljanjeDokumentima.this.cbProknjizenActionPerformed(evt);
                }
            });
            this.cbStorno = new PzCheckbox();
            this.pnlIzborDok.add((Component)this.cbStorno, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.cbStorno.setName("cbStorno");
            this.cbStorno.setOpaque(false);
            this.jPanel1 = new PzPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.pnlFilter.add((Component)this.jPanel1, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.setBorder(BorderFactory.createTitledBorder("Filter"));
            jPanel1Layout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            jPanel1Layout.rowHeights = new int[]{7, 7, 7, 7};
            jPanel1Layout.columnWeights = new double[]{0.1};
            jPanel1Layout.columnWidths = new int[]{7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.jPanel1.setOpaque(false);
            this.lblUpit = new JLabel();
            this.jPanel1.add((Component)this.lblUpit, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblUpit.setName("lblUpit");
            this.scrollPaneFilter = new JScrollPane();
            this.jPanel1.add((Component)this.scrollPaneFilter, new GridBagConstraints(0, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.areaUpit = new PzTextArea();
            this.scrollPaneFilter.setViewportView(this.areaUpit);
            this.pnlButton = new PzPanel();
            GridBagLayout pnlButtonLayout = new GridBagLayout();
            this.pnlFilter.add((Component)this.pnlButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlButtonLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            pnlButtonLayout.rowHeights = new int[]{20, 20, 20, 28, 7};
            pnlButtonLayout.columnWeights = new double[]{0.0, 0.1};
            pnlButtonLayout.columnWidths = new int[]{83, 7};
            this.pnlButton.setLayout(pnlButtonLayout);
            this.pnlButton.setOpaque(false);
            this.pnlButton.setBorder(BorderFactory.createTitledBorder("Interval pretrage"));
            this.lblPocetniDatum = new JLabel();
            this.pnlButton.add((Component)this.lblPocetniDatum, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
            this.lblPocetniDatum.setName("lblPocetniDatum");
            this.dfPocetniDatum = new PzDateField();
            this.pnlButton.add((Component)this.dfPocetniDatum, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 5), 0, 0));
            this.dfPocetniDatum.setVal(PzDateUtility.getFirstDayOfCurrentYear());
            this.lblKrajnjiDatum = new JLabel();
            this.pnlButton.add((Component)this.lblKrajnjiDatum, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
            this.lblKrajnjiDatum.setName("lblKrajnjiDatum");
            this.dfKrajnjiDatum = new PzDateField();
            this.pnlButton.add((Component)this.dfKrajnjiDatum, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 5), 0, 0));
            this.btnTrazi = new PzButton();
            this.pnlFilter.add((Component)this.btnTrazi, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 120), 0, 0));
            this.btnTrazi.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/find.png")));
            this.btnTrazi.setName("btnTrazi");
            this.btnTrazi.setActionCommand("trazi");
            this.btnTrazi.addActionListener(this);
            this.pnlPolja = new PzPanel();
            GridBagLayout pnlPoljaLayout = new GridBagLayout();
            this.pnlFilter.add((Component)this.pnlPolja, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlPolja.setBorder(BorderFactory.createTitledBorder("Filter"));
            pnlPoljaLayout.rowWeights = new double[]{0.1, 0.0, 0.1, 0.1, 0.1};
            pnlPoljaLayout.rowHeights = new int[]{7, 7, 7, 20, 7};
            pnlPoljaLayout.columnWeights = new double[]{0.0, 0.1};
            pnlPoljaLayout.columnWidths = new int[]{102, 7};
            this.pnlPolja.setLayout(pnlPoljaLayout);
            this.lblOznakaDokumenta = new JLabel();
            this.pnlPolja.add((Component)this.lblOznakaDokumenta, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.lblOznakaDokumenta.setName("lblOznakaDokumenta");
            this.tfOznakaDokumenta = new PzTextField();
            this.pnlPolja.add((Component)this.tfOznakaDokumenta, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
            this.tblDokumenti = new PzScrollableTableEntity(Dokument.class);
            this.scrollPane.setViewportView((Component)((Object)this.tblDokumenti));
            this.tblDokumenti.setFilter(new PzEntityFilter(){

                @Override
                public Object[] getValues(PzEntity entity) {
                    Dokument dok = (Dokument)entity;
                    String oznaka = dok.getStorno() == 0 ? dok.getOznDokumenta() : "Storno " + dok.getOznDokumenta();
                    String komitent = dok.getKomitent() == null ? " " : "[ " + dok.getKomitent().getSfrKomitent() + "] " + dok.getKomitent().getNaziv();
                    return new Object[]{dok.getArhiviran(), oznaka, dok.getIznos(), dok.getDatum(), komitent, dok.getTip(), dok.getIdDok()};
                }

                @Override
                public String[] getColumnNames() {
                    return new String[]{"Status", "Oznaka dokumenta", "Iznos", "Datum", "Komitent", "Tip", "iddok"};
                }
            });
            this.tblDokumenti.setCheckboxColumn(0);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)((Object)this.statusBar), "South");
            this.statusBar.add(this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            JLabel renderer1 = new JLabel();
            renderer1.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/nav_plain_red.png")));
            renderer1.setText("- Izbrisan ");
            JLabel renderer2 = new JLabel();
            renderer2.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/nav_plain_green.png")));
            renderer2.setText("- U pripremi ");
            JLabel renderer3 = new JLabel();
            renderer3.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/nav_plain_blue.png")));
            renderer3.setText("- Arhiviran ");
            this.statusBar.add(this.brDok);
            this.statusBar.add(renderer1);
            this.statusBar.add(renderer2);
            this.statusBar.add(renderer3);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setRestorable(false);
            this.setSize(1136, 744);
            this.setMinimumSize(new Dimension(1136, 744));
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equalsIgnoreCase("trazi")) {
            this.tblDokumenti.setVisible(false);
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus("Molim, sa\u010dekajte...", this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogUpravljanjeDokumentima.this.cursor != null) {
                        PzDialogUpravljanjeDokumentima.this.cursor.close();
                    }
                    Query q = null;
                    String tipovi = PzDialogUpravljanjeDokumentima.getTipovi(PzDialogUpravljanjeDokumentima.this.createListTip(PzDialogUpravljanjeDokumentima.this.listTipovi));
                    String upit = "Select d From Dokument d left join fetch  d.komitent Where d.datum>=:datumOD and d.datum<=:datumDO %filter% %tip% %polja% %uslov%";
                    upit = upit.replace("%filter%", PzDialogUpravljanjeDokumentima.this.getUslov()).replace("%tip%", tipovi.equals("") ? " " : " and d.tip IN (" + tipovi + ")").replace("%uslov%", PzDialogUpravljanjeDokumentima.this.areaUpit.getText().equals("") ? " " : " " + PzDialogUpravljanjeDokumentima.this.areaUpit.getText()).replace("%polja%", PzDialogUpravljanjeDokumentima.this.tfOznakaDokumenta.getVal().equals("") ? " " : " and d.oznDokumenta='" + PzDialogUpravljanjeDokumentima.this.tfOznakaDokumenta.getVal() + "'");
                    q = em.createQuery(upit);
                    q.setParameter("datumOD", (Object)PzDialogUpravljanjeDokumentima.this.dfPocetniDatum.getVal());
                    q.setParameter("datumDO", (Object)PzDialogUpravljanjeDokumentima.this.dfKrajnjiDatum.getVal());
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    q.setHint("eclipselink.read-only", (Object)"True");
                    PzDialogUpravljanjeDokumentima.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao: " + PzDialogUpravljanjeDokumentima.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    block7: {
                        try {
                            try {
                                this.get();
                                if (PzDialogUpravljanjeDokumentima.this.cursor != null && PzDialogUpravljanjeDokumentima.this.cursor.size() != 0) {
                                    PzDialogUpravljanjeDokumentima.this.tblDokumenti.setVisible(true);
                                    PzDialogUpravljanjeDokumentima.this.brDok.setText(Integer.toString(PzDialogUpravljanjeDokumentima.this.cursor.size()));
                                    PzDialogUpravljanjeDokumentima.this.tblDokumenti.read(PzDialogUpravljanjeDokumentima.this.cursor);
                                    if (PzDialogUpravljanjeDokumentima.this.cursor.size() > 0) {
                                        PzDialogUpravljanjeDokumentima.this.tblDokumenti.setRowSelectionInterval(0, 0);
                                        PzDialogUpravljanjeDokumentima.this.tblDokumenti.requestFocusInWindow();
                                    }
                                    PzDialogUpravljanjeDokumentima.this.setRenderer();
                                    break block7;
                                }
                                JOptionPane.showMessageDialog(PzDialogUpravljanjeDokumentima.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle(PzDialogUpravljanjeDokumentima.this, e);
                                em.close();
                                PzWorkerDialog.hideStatus();
                            }
                        }
                        finally {
                            em.close();
                            PzWorkerDialog.hideStatus();
                        }
                    }
                }
            };
            worker.execute();
            return;
        }
        if (actionCommand.equalsIgnoreCase("export")) {
            if (this.tblDokumenti.getRowCount() != 0) {
                File directory = PzFileUtility.selectDirectory("Izaberite direktorijum za export dokumenata", this);
                if (directory == null) {
                    return;
                }
                final String PATH = directory.getAbsolutePath();
                System.out.println("Putanja je : " + PATH);
                final List listaDok = this.tblDokumenti.getCheckedEntities();
                if (listaDok.size() == 0) {
                    PzSwingUtility.showInformationMessage(this, "Morate cekirati dokumenta koja \u017eelite da exportujete");
                    return;
                }
                PzWorkerDialog.showStatus("Molim, sa\u010dekajte...", this);
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        for (Dokument dok : listaDok) {
                            PzDialogUpravljanjeDokumentima.this.getAllObjects(dok);
                            File f = new File(String.valueOf(PATH) + File.separator + dok.getIdDok() + ".txt");
                            f.createNewFile();
                            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
                            oos.writeObject(dok);
                            oos.close();
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            try {
                                this.get();
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle(PzDialogUpravljanjeDokumentima.this, e);
                                PzWorkerDialog.hideStatus();
                            }
                        }
                        finally {
                            PzWorkerDialog.hideStatus();
                        }
                    }
                };
                worker.execute();
                return;
            }
        } else {
            if (actionCommand.equalsIgnoreCase("import")) {
                final EntityManager em = PzEntityManager.getEm();
                final File[] files = PzFileUtility.selectFiles(new String[]{"txt"}, "Izbor fajlova za import dokumenta", this);
                if (files == null || files.length == 0) {
                    return;
                }
                PzWorkerDialog.showStatus("Molim, sa\u010dekajte...", this);
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        em.getTransaction().begin();
                        String iddoks = "";
                        int i = 0;
                        while (i < files.length) {
                            File file = files[i];
                            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
                            Dokument dok = (Dokument)ois.readObject();
                            ois.close();
                            Id_gen dokId = (Id_gen)em.find(Id_gen.class, (Object)"DOKUMENT_ID");
                            if (dokId == null) {
                                dokId = new Id_gen();
                                dokId.setIdName("DOKUMENT_ID");
                                dokId.setIdVal(1);
                            }
                            dokId.setIdVal(dokId.getIdVal() + 1);
                            em.merge((Object)dokId);
                            dok.setIdDok(dokId.getIdVal());
                            if (dok.getArhiviran() == 0) {
                                PzDokumentManager.getInstance().snimiDokument(dok, true, null, em);
                            } else {
                                PzDokumentManager.getInstance().arhivirajDokument(dok, true, null, em);
                            }
                            iddoks = String.valueOf(iddoks) + (i == 0 ? "" : ",") + "'" + dok.getIdDok() + "'";
                            ++i;
                        }
                        if (PzDialogUpravljanjeDokumentima.this.cursor != null) {
                            PzDialogUpravljanjeDokumentima.this.cursor.close();
                        }
                        Query q = null;
                        String upit = "Select d From Dokument d Where iddok IN (%iddok%) ";
                        upit = upit.replace("%iddok%", iddoks);
                        q = em.createQuery(upit);
                        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                        q.setHint("eclipselink.read-only", (Object)"True");
                        PzDialogUpravljanjeDokumentima.this.cursor = (ScrollableCursor)q.getSingleResult();
                        System.out.println("Kursor je nasao: " + PzDialogUpravljanjeDokumentima.this.cursor.size());
                        em.getTransaction().commit();
                        return null;
                    }

                    @Override
                    protected void done() {
                        block7: {
                            try {
                                try {
                                    this.get();
                                    if (PzDialogUpravljanjeDokumentima.this.cursor != null && PzDialogUpravljanjeDokumentima.this.cursor.size() != 0) {
                                        PzDialogUpravljanjeDokumentima.this.brDok.setText(Integer.toString(PzDialogUpravljanjeDokumentima.this.cursor.size()));
                                        PzDialogUpravljanjeDokumentima.this.tblDokumenti = new PzScrollableTableEntity(Dokument.class);
                                        PzDialogUpravljanjeDokumentima.this.tblDokumenti.read(PzDialogUpravljanjeDokumentima.this.cursor);
                                        if (PzDialogUpravljanjeDokumentima.this.cursor.size() > 0) {
                                            PzDialogUpravljanjeDokumentima.this.tblDokumenti.setRowSelectionInterval(0, 0);
                                            PzDialogUpravljanjeDokumentima.this.tblDokumenti.requestFocusInWindow();
                                        }
                                        break block7;
                                    }
                                    JOptionPane.showMessageDialog(PzDialogUpravljanjeDokumentima.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                                }
                                catch (Exception e) {
                                    PzMysqlExceptionHandler.handle(PzDialogUpravljanjeDokumentima.this, e);
                                    em.close();
                                    PzWorkerDialog.hideStatus();
                                }
                            }
                            finally {
                                em.close();
                                PzWorkerDialog.hideStatus();
                            }
                        }
                    }
                };
                worker.execute();
                return;
            }
            if (actionCommand.equalsIgnoreCase("stampa")) {
                try {
                    List checked = this.tblDokumenti.getCheckedEntities();
                    if (checked.size() == 0) {
                        return;
                    }
                    Vector<PzDokument> dokumenta = new Vector<PzDokument>();
                    for (PzDokument d : checked) {
                        Class<?> c = TipDokumentConfig.getClassByValue(d.getTip());
                        PzDokument dokument = (PzDokument)PzEntityManager.find(c, d.getIdDok());
                        dokumenta.add(dokument);
                    }
                    PzGenericService s = PzApplication.getApplication().getGenericServiceRegistry().getService("REPORTING_SERVICE");
                    HashMap<Object, Object> args = new HashMap<Object, Object>();
                    args.put("DOKUMENTI", dokumenta);
                    s.run(args);
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle(this, e1);
                }
            } else if (actionCommand.equalsIgnoreCase("brisanje")) {
                try {
                    List checked = this.tblDokumenti.getCheckedEntities();
                    if (checked.size() == 0) {
                        return;
                    }
                    new Vector();
                    for (PzDokument d : checked) {
                        Class<?> c = TipDokumentConfig.getClassByValue(d.getTip());
                        PzDokument dokument = (PzDokument)PzEntityManager.find(c, d.getIdDok());
                        PzDokumentManager.getInstance().deleteDokument(dokument, null);
                    }
                    this.btnTrazi.doClick();
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle(this, e1);
                }
            } else if (actionCommand.equalsIgnoreCase("history")) {
                if (this.tblDokumenti.getSelectedEntity() == null) {
                    return;
                }
                this.getSession().putParameter("dokument", this.tblDokumenti.getSelectedEntity());
                this.showDialog(History.class);
            } else if (actionCommand.equalsIgnoreCase("snimanjeSelektuj")) {
                this.listTipovi.setSelectedAll();
            } else if (actionCommand.equalsIgnoreCase("snimanjeDeselektuj")) {
                this.listTipovi.setDeselectAll();
            } else if (actionCommand.equalsIgnoreCase("clone")) {
                try {
                    List l = this.tblDokumenti.getCheckedEntities();
                    if (l.size() > 0) {
                        this.klonirajDokument((PzDokument)this.tblDokumenti.getCheckedEntities().get(0));
                        PzSwingUtility.showInformationMessage(this, "Dokument uspe\u0161no kloniran");
                    }
                }
                catch (Exception e1) {
                    PzMysqlExceptionHandler.handle(e1);
                }
            }
        }
    }

    private void setRenderer() {
        if (this.tblDokumenti.getColumnByName("") == null) {
            return;
        }
        this.tblDokumenti.getColumnByName("Status").setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean isSelected, boolean arg3, int arg4, int arg5) {
                JLabel renderer = new JLabel();
                Short ind = (Short)value;
                if (ind == -1) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/nav_plain_red.png")));
                } else if (ind == 0) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/nav_plain_green.png")));
                } else if (ind == 1) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/nav_plain_blue.png")));
                }
                if (isSelected) {
                    Color col = PzDialogUpravljanjeDokumentima.this.tblDokumenti.getDefaultRenderer(Object.class).getTableCellRendererComponent((JTable)((Object)PzDialogUpravljanjeDokumentima.this.tblDokumenti), value, isSelected, arg3, arg4, arg5).getBackground();
                    renderer.setBackground(col);
                }
                renderer.setOpaque(true);
                renderer.setHorizontalAlignment(0);
                return renderer;
            }
        });
    }

    private List<TipDokumentStructure.Tip> getShemaTip() {
        ArrayList<TipDokumentStructure.Tip> tipovi = new ArrayList<TipDokumentStructure.Tip>();
        List tipSheme = PzEntityManagerFactory.getInstance().createEm().createQuery("SELECT distinct s.id.tipDok FROM Shema s WHERE s.abstrakt=0 ORDER BY s.id.tipDok ASC").getResultList();
        for (String tip : tipSheme) {
            tipovi.add(this.getNazivDokumenta(tip));
        }
        return tipovi;
    }

    private TipDokumentStructure.Tip getNazivDokumenta(String tip) {
        List<TipDokumentStructure.Tip> tipovi = TipDokumentStructure.loadStructure();
        TipDokumentStructure.Tip tipReturn = null;
        for (TipDokumentStructure.Tip tipPom : tipovi) {
            if (!tipPom.getTip().equals(tip)) continue;
            tipReturn = tipPom;
            break;
        }
        return tipReturn;
    }

    private Vector<JCheckBox> setDocumentList() {
        Vector<JCheckBox> cbList = new Vector<JCheckBox>();
        List<TipDokumentStructure.Tip> tipovi = TipDokumentStructure.loadStructure();
        ArrayList<String> t = new ArrayList<String>();
        for (TipDokumentStructure.Tip tip : tipovi) {
            t.add(tip.getNaziv());
        }
        Collections.sort(t);
        for (String string : t) {
            JCheckBox cb = new JCheckBox();
            cb.setText(string);
            cbList.add(cb);
        }
        return cbList;
    }

    private List<String> createListTip(PzCheckBoxList list) {
        ArrayList<String> tips = new ArrayList<String>();
        int i = 0;
        while (i < list.getModel().getSize()) {
            if (((JCheckBox)list.getModel().getElementAt(i)).isSelected()) {
                tips.add(this.getTip(((JCheckBox)list.getModel().getElementAt(i)).getText()).getTip());
            }
            ++i;
        }
        return tips;
    }

    private TipDokumentStructure.Tip getTip(String naziv) {
        List<TipDokumentStructure.Tip> tipovi = TipDokumentStructure.loadStructure();
        TipDokumentStructure.Tip tipReturn = null;
        for (TipDokumentStructure.Tip tipPom : tipovi) {
            if (!tipPom.getNaziv().equals(naziv)) continue;
            tipReturn = tipPom;
            break;
        }
        return tipReturn;
    }

    public static String getTipovi(List<String> tips) {
        String res = "";
        if (tips == null || tips.size() == 0) {
            return res;
        }
        int i = 0;
        while (i < tips.size()) {
            res = String.valueOf(res) + (i == 0 ? "" : ",") + "'" + tips.get(i) + "'";
            ++i;
        }
        return res;
    }

    private void getAllObjects(Dokument dok) {
        PzDokument k;
        Faktura f;
        for (Artikaldokument art : dok.getArtikaldokuments()) {
            art.getId();
            for (Adtaksa adtaksa : art.getAdtaksas()) {
                adtaksa.getId();
                adtaksa.getArtikaldokument();
            }
            art.getDokument();
        }
        dok.getKomitent();
        dok.getUserKraj();
        dok.getUserPoc();
        dok.getRadnajedinica();
        dok.getTrosak();
        for (Stavkanzk s : dok.getStavkanzks()) {
            s.getId();
            s.getDokument();
            s.getKomitent();
            s.getKonto();
            s.getNzk();
            s.getRadnajedinica();
        }
        for (Dtaksa t : dok.getDtaksas()) {
            t.getId();
            t.getDokument();
            t.getTarifnagrupa();
        }
        dok.getOriginal();
        dok.getShemaKnjizenja();
        for (Uslugadokument us : dok.getUslugadokuments()) {
            us.getId();
            us.getDokument();
            for (Udtaksa udtaksa : us.getUdtaksas()) {
                udtaksa.getId();
                udtaksa.getUslugadokument();
            }
        }
        for (Nalogmagacinu nalog : dok.getNalogmagacinus()) {
            for (Artikalnalog artikalnalog : nalog.getArtikalnalogs()) {
                artikalnalog.getId();
                artikalnalog.getNalogmagacinu();
            }
            for (Koplaca koplaca : nalog.getKoplacas()) {
                koplaca.getBrzaposta();
                koplaca.getId();
                koplaca.getNalogmagacinu();
            }
            nalog.getDokument();
            nalog.getRadnajedinica();
            nalog.getPzusers();
        }
        for (Nalogprijem prijem : dok.getNalogprijems()) {
            for (Artikalnalogprijem artikalnalogprijem : prijem.getArtikalnalogprijems()) {
                artikalnalogprijem.getId();
                artikalnalogprijem.getNalogprijem();
            }
            prijem.getDokument();
            prijem.getPzuser();
            prijem.getRadnajedinica();
        }
        for (DokumentLog log : dok.getLogs()) {
            log.getDokument();
            log.getPzuser();
        }
        PzDokument d = dok.getKonkretanDokument();
        if (d instanceof Faktura) {
            f = (Faktura)d;
            for (Artikalfaktura artikalfaktura : f.getArtikalfakturas()) {
                artikalfaktura.getId();
                for (Aftaksa aftaksa : artikalfaktura.getAftaksas()) {
                    aftaksa.getId();
                    aftaksa.getArtikalfaktura();
                }
                this.getArtikal(artikalfaktura.getArtikal());
                artikalfaktura.getFaktura();
                for (Artikalfakturaparameter artikalfakturaparameter : artikalfaktura.getArtikalFakturaParameters()) {
                    artikalfakturaparameter.getId();
                    artikalfakturaparameter.getArtikalFaktura();
                }
            }
            f.getFakturaBean();
            f.getFakturas();
            for (Fakturaopstidokument fakturaopstidokument : f.getFakturaopstidokuments()) {
                fakturaopstidokument.getFaktura();
                fakturaopstidokument.getZaduzenjeodobrenje();
                fakturaopstidokument.getPrihodRashod();
                for (Taksafod taksafod : fakturaopstidokument.getTaksafods()) {
                    taksafod.getId();
                    taksafod.getFakturaopstidokument();
                    taksafod.getTarifnagrupa();
                }
            }
            f.getDokument();
            f.getKomitent();
            f.getRadninalog();
            f.getRadnajedinica();
            f.getUserKraj();
            f.getUserPoc();
            for (Taksafaktura taksafaktura : f.getTaksafakturas()) {
                taksafaktura.getFaktura();
                taksafaktura.getTarifnagrupa();
            }
            f.getOriginal();
            for (Stavkaporudzbine stavkaporudzbine : f.getStavkaporudzbines()) {
                stavkaporudzbine.getId();
                stavkaporudzbine.getFaktura();
                stavkaporudzbine.getStanjeartikal();
            }
            f.getFizickolice();
            for (Fakturaparameter fakturaparameter : f.getFakturaparameters()) {
                fakturaparameter.getId();
                fakturaparameter.getFaktura();
            }
        }
        if (d instanceof Kalkulacija) {
            k = (Kalkulacija)d;
            for (Artikalkalkulacija artikalkalkulacija : ((Kalkulacija)k).getArtikalkalkulacijas()) {
                this.getArtikal(artikalkalkulacija.getArtikal());
                artikalkalkulacija.getDokument();
                artikalkalkulacija.getId();
                artikalkalkulacija.getAktaksas();
            }
            ((Kalkulacija)k).getRadnajedinica();
            ((Kalkulacija)k).getDokument();
            for (Kalkulacijazapisnik kalkulacijazapisnik : ((Kalkulacija)k).getKalkulacijazapisniks1()) {
                kalkulacijazapisnik.getId();
                kalkulacijazapisnik.getKalkulacija();
                for (Taksakz taksakz : kalkulacijazapisnik.getTaksakzs()) {
                    taksakz.getKalkulacijazapisnik();
                    taksakz.getId();
                    taksakz.getTarifnagrupa();
                }
                kalkulacijazapisnik.getZapisnik();
            }
            for (Kalkulacijazapisnik kalkulacijazapisnik : ((Kalkulacija)k).getKalkulacijazapisniks2()) {
                kalkulacijazapisnik.getId();
                kalkulacijazapisnik.getKalkulacija();
                for (Taksakz taksakz : kalkulacijazapisnik.getTaksakzs()) {
                    taksakz.getKalkulacijazapisnik();
                    taksakz.getId();
                    taksakz.getTarifnagrupa();
                }
                kalkulacijazapisnik.getZapisnik();
            }
            ((Kalkulacija)k).getKomitent();
            ((Kalkulacija)k).getUserKraj();
            ((Kalkulacija)k).getUserPoc();
            for (Taksakalkulacija taksakalkulacija : ((Kalkulacija)k).getTaksakalkulacijas()) {
                taksakalkulacija.getId();
                taksakalkulacija.getTarifnagrupa();
                taksakalkulacija.getKalkulacija();
            }
            for (Trosak trosak : ((Kalkulacija)k).getTrosaks()) {
                trosak.getKalkulacija();
                trosak.getDokument();
            }
            ((Kalkulacija)k).getOriginal();
        }
        if (d instanceof Fakturausluga) {
            f = (Fakturausluga)d;
            for (Stavkafaktureusl stavkafaktureusl : f.getStavkafaktureusls()) {
                stavkafaktureusl.getId();
                stavkafaktureusl.getSfutaksas();
                stavkafaktureusl.getUsluga();
                stavkafaktureusl.getFakturausluga();
            }
            ((Fakturausluga)f).getPutnitrosaks();
        }
        if (d instanceof Interniracun) {
            Interniracun racun = (Interniracun)d;
            for (Artikalinterniracun artikalinterniracun : racun.getArtikalinterniracuns()) {
                artikalinterniracun.getId();
                artikalinterniracun.getAirtaksas();
                artikalinterniracun.getInterniracun();
                this.getArtikal(artikalinterniracun.getArtikal());
            }
            racun.getUlaznaRJ();
            racun.getIzlaznaRJ();
            racun.getDokument1();
            racun.getDokument2();
            racun.getUserPoc();
            racun.getUserKraj();
            for (Taksainterniracun taksainterniracun : racun.getTaksainterniracuns()) {
                taksainterniracun.getId();
                taksainterniracun.getInterniracun();
                taksainterniracun.getTarifnagrupa();
            }
        }
        if (d instanceof Konsignacija) {
            k = (Konsignacija)d;
            for (Artikalkonsignacija artikalkonsignacija : ((Konsignacija)k).getArtikalkonsignacijas()) {
                artikalkonsignacija.getId();
                artikalkonsignacija.getAkonstaksas();
                this.getArtikal(artikalkonsignacija.getArtikal());
                artikalkonsignacija.getKonsignacija();
            }
            ((Konsignacija)k).getRadnajedinica();
            ((Konsignacija)k).getDokument();
            ((Konsignacija)k).getUserKraj();
            ((Konsignacija)k).getUserPoc();
        }
        if (d instanceof Nivelacija) {
            Nivelacija n = (Nivelacija)d;
            for (Artikalnivelacija artikalnivelacija : n.getArtikalnivelacijas()) {
                artikalnivelacija.getId();
                artikalnivelacija.getAntaksas();
                artikalnivelacija.getNivelacija();
                this.getArtikal(artikalnivelacija.getArtikal());
            }
            for (Taksanivelacija taksanivelacija : n.getTaksanivelacijas()) {
                taksanivelacija.getId();
                taksanivelacija.getNivelacija();
                taksanivelacija.getTarifnagrupa();
            }
            n.getDokument();
            n.getRadnajedinica();
            n.getUserKraj();
            n.getUserPoc();
        }
        if (d instanceof Opstidokument) {
            Opstidokument od = (Opstidokument)d;
            for (Artikalopstidokument artikalopstidokument : od.getArtikalopstidokuments()) {
                artikalopstidokument.getId();
                artikalopstidokument.getAodtaksas();
                artikalopstidokument.getArtikalopstidokument();
                artikalopstidokument.getArtikalopstidokuments();
                this.getArtikal(artikalopstidokument.getArtikal());
                artikalopstidokument.getOpstidokument();
            }
            od.getRadnajedinica();
            od.getPrjmestotroska();
            od.getRadninalog();
            od.getKomitent();
            od.getUserKraj();
            od.getUserPoc();
            for (Taksaopstidokument taksaopstidokument : od.getTaksaopstidokuments()) {
                taksaopstidokument.getId();
                taksaopstidokument.getOpstidokument();
                taksaopstidokument.getTarifnagrupa();
                taksaopstidokument.getUplata();
            }
            od.getDokument();
            od.getOriginal();
        }
    }

    private void getArtikal(Artikal a) {
        a.getSlikas();
        a.getProizvodjac();
        a.getDobavljac();
        a.getKonsignacija();
        a.getArtikalfakturas();
        a.getArtikalinterniracuns();
        a.getArtikalkalkulacijas();
        a.getArtikalkonsignacijas();
        a.getArtikalnivelacijas();
        a.getArtikalopstidokuments();
        a.getTarifnagrupas();
        a.getRobnagrupa();
        a.getModel();
        a.getAmbalaza();
        a.getProizvod();
        a.getLokacijas();
        a.getOebrojs();
        a.getRabatnaskalas();
        a.getStanjes();
        a.getStavkakarticeartiklas();
        a.getDeloviGarniture();
        a.getGarnitura();
        a.getZamenas();
        a.getArtikals();
    }

    private void cbProknjizenActionPerformed(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.cbArhiviran.setSelected(false);
            this.cbArhiviran.setEnabled(false);
            this.cbPriprema.setSelected(false);
            this.cbPriprema.setEnabled(false);
        } else {
            this.cbArhiviran.setEnabled(true);
            this.cbPriprema.setEnabled(true);
        }
    }

    private String getUslov() {
        String res = " ";
        if (this.cbPriprema.isSelected()) {
            res = String.valueOf(res) + " and d.arhiviran= 0 ";
        }
        if (this.cbArhiviran.isSelected()) {
            res = String.valueOf(res) + " and d.arhiviran = 1 ";
        }
        if (this.cbProknjizen.isSelected()) {
            res = String.valueOf(res) + " and d.proknjizen=1 ";
        }
        if (this.cbStorno.isSelected()) {
            res = String.valueOf(res) + " and d.storno = 1 ";
        }
        return res;
    }

    private void klonirajDokument(PzDokument d) throws Exception {
        Class<?> c = TipDokumentConfig.getClassByValue(d.getTip());
        PzDokument dokument = (PzDokument)PzEntityManager.find(c, d.getIdDok());
        PzDokument clone = (PzDokument)BeanUtils.cloneBean((Object)dokument);
        if (clone.getDokument() != null) {
            clone.setDokument(null);
        }
        if (clone.getIdDok() != 0) {
            clone.setIdDok(0);
        }
        if (clone.getTaksadokuments() != null && clone.getTaksadokuments().size() > 0) {
            clone.setTaksadokuments(null);
        }
        PzDokumentManager.getInstance().arhivirajDokument(clone, true, null);
    }
}

