/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Parameter;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelInt;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogOstaliParametri1
extends PzDialog {
    private PzPanel panelGlavni;
    private JTabbedPane tabbedPane;
    private PzPanel panel;
    private JPanel pnlButton;
    private PzButton btnPotvrdi;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogOstaliParametri1 inst = new PzDialogOstaliParametri1(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogOstaliParametri1(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        em.getTransaction().begin();
        for (PzPanelInt pnl : PzApplication.getApplication().getSettingsManager().getPanelIntList()) {
            pnl.loadParamaters(em);
            this.tabbedPane.add(pnl.getTabName(), (Component)((Object)pnl));
        }
        em.getTransaction().commit();
        em.close();
        this.tabbedPane.setSelectedIndex(0);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Ostali parametri");
            this.panelGlavni = new PzPanel();
            this.panelGlavni.setPaintGradient(true);
            this.panelGlavni.setGradient(Color.LIGHT_GRAY, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
            BorderLayout panelGlavniLayout = new BorderLayout();
            this.getContentPane().add((Component)this.panelGlavni, "Center");
            this.panelGlavni.setLayout(panelGlavniLayout);
            this.panelGlavni.setPreferredSize(new Dimension(586, 260));
            this.tabbedPane = new JTabbedPane();
            this.panelGlavni.add((Component)this.tabbedPane, "Center");
            this.tabbedPane.setOpaque(false);
            this.pnlButton = new JPanel();
            this.panelGlavni.add((Component)this.pnlButton, "South");
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 25, 0, 25), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setPreferredSize(new Dimension(130, 35));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener(this);
            this.setSize(600, 298);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("potvrdi")) {
                    em.getTransaction().begin();
                    int broj = this.tabbedPane.getComponentCount();
                    int i = 0;
                    while (i < broj) {
                        List<Parameter> parametri = ((PzPanelInt)((Object)this.tabbedPane.getComponent(i))).getParameters();
                        int j = 0;
                        while (j < parametri.size()) {
                            PzParameter.setParameter(parametri.get(j).getName(), parametri.get(j).getValue().replaceAll("\\+", "\\"), em);
                            ++j;
                        }
                        ++i;
                    }
                    em.getTransaction().commit();
                }
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle(this, e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

