/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.menu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.core.gui.menu.rabat.Dodavanje;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Rabat;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogDefinicijaRabata
extends PzDialog {
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzToolBarIcon icnDodavanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisi;
    private PzTable tblRabat;
    private JScrollPane scrollPane;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();

    public PzDialogDefinicijaRabata(JFrame frame) {
        super(frame);
        this.initGUI();
        this.refresh();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{77, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout(mainPanelLayout);
            this.toolbar = new JToolBar();
            this.mainPanel.add((Component)this.toolbar, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add(this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|rabata|(INSERT)");
            this.icnDodavanje.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/percent_add.png")));
            this.icnDodavanje.setActionCommand("dodaj");
            this.icnDodavanje.addActionListener(this);
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add(this.icnIzmena);
            this.icnIzmena.setText("Izmena|rabata|(F3)");
            this.icnIzmena.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/percent_edit.png")));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.addActionListener(this);
            this.icnIzmena.setShortcut("F3");
            this.icnBrisi = new PzToolBarIcon();
            this.toolbar.add(this.icnBrisi);
            this.icnBrisi.setText("Brisanje|rabata|(DELETE)");
            this.icnBrisi.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/percent_delete.png")));
            this.icnBrisi.setActionCommand("brisi");
            this.icnBrisi.addActionListener(this);
            this.icnBrisi.setShortcut("Delete");
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.tblRabat = new PzTable(Rabat.class);
            this.scrollPane.setViewportView((Component)((Object)this.tblRabat));
            this.tblRabat.setEnterAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogDefinicijaRabata.this.icnDodavanje.doClick();
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)((Object)this.statusBar), "South");
            this.statusBar.add(this.jlStatusBar);
            this.jlStatusBar.setText("  Broj stavki");
            this.statusBar.add(this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setTitle("Definisanje rabata");
            this.setSize(530, 455);
            this.setMinimumSize(new Dimension(500, 350));
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        try {
            this.getSession().putParameter("tabela", (Object)this.tblRabat);
            if (actionCommand.equals("dodaj")) {
                this.getSession().putParameter("update", false);
                this.showDialog(Dodavanje.class);
                this.refresh();
            } else if (actionCommand.equals("izmena")) {
                this.getSession().putParameter("update", true);
                this.showDialog(Dodavanje.class);
            } else if (actionCommand.equals("brisi")) {
                this.tblRabat.removeSelectedEntity(true, true);
                this.refresh();
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle(this, e1);
        }
    }

    @Override
    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery("Select f From Faktura f where f.arhiviran = 0");
        List data = q.getResultList();
        if (data.size() != 0) {
            this.icnDodavanje.setEnabled(false);
            this.icnBrisi.setEnabled(false);
            this.icnIzmena.setEnabled(false);
            PzSwingUtility.showInformationMessage(this, "Rad sa rabatima nije mogu\u0107 jer postoje fakture u pripremi.");
        }
        return true;
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogDefinicijaRabata.this.brDok.setText(String.valueOf(PzDialogDefinicijaRabata.this.tblRabat.getRowCount()));
            }
        });
    }
}

