/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core.gui.defaultWidgets.calendar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Locale;
import org.jdesktop.swingx.JXMonthView;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.swing.PzWidget;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class CalendarWidget
extends PzWidget {
    private static final long serialVersionUID = 4551238459987683467L;
    public static final String ID = "CALENDARWIDGET";
    private JXMonthView mw;

    public CalendarWidget() {
        this.initGUI();
        this.setID(ID);
        this.setTitle("Kalendar");
        this.setDefaultLocation(new PzWidget.Location(2, 2, 1, 1));
    }

    private void initGUI() {
        this.mw = new JXMonthView();
        this.setLayout(new BorderLayout());
        this.mw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Date d = CalendarWidget.this.mw.getSelectionDate();
                if (!PzDateUtility.isDateAlowed(d)) {
                    PzSwingUtility.showErrorMessage(CalendarWidget.this, "Nije vam dozvoljeno da radite sa izabranim datumom jer je u sistemu definisan limit od " + PzDateUtility.getDateLimit() + " dana.");
                    return;
                }
                PzDateUtility.setCurrentDate(new java.sql.Date(d.getTime()));
                PzSwingUtility.showInformationMessage(CalendarWidget.this, "Radni datum je postavljen na " + PzFormatFactory.getDateFormat().format(d));
            }
        });
        this.mw.setTraversable(true);
        this.mw.setLocale(new Locale("sr"));
        this.add((Component)this.mw, "Center");
    }
}

