/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import rs.pezar.core.PzApplication;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.StopWatch;

public class PzLocalPropertiesManager {
    private File propertiesDir;

    public PzLocalPropertiesManager(String dataDir) {
        this.propertiesDir = new File(String.valueOf(dataDir) + File.separator + "properties");
        if (!this.propertiesDir.exists()) {
            this.propertiesDir.mkdir();
        }
    }

    public PropertiesConfiguration getPropertiesFromFile(String fileName) {
        File propFile = new File(String.valueOf(this.propertiesDir.getPath()) + File.separator + fileName);
        PropertiesConfiguration prop = null;
        try {
            prop = new PropertiesConfiguration(propFile);
            prop.setAutoSave(true);
            prop.setProperty("osgi.install.area", (Object)System.getProperty("osgi.install.area"));
        }
        catch (ConfigurationException e) {
            PzMysqlExceptionHandler.handle(e);
        }
        return prop;
    }

    public Object loadObject(String fileName) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(new File(String.valueOf(PzApplication.getApplication().getConfigFolder().getPath()) + File.separator + fileName));
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object o = ois.readObject();
        ois.close();
        fis.close();
        return o;
    }

    public Object loadBufferedObject(String fileName, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(new File(String.valueOf(PzApplication.getApplication().getConfigFolder().getPath()) + File.separator + fileName));
        BufferedInputStream bis = new BufferedInputStream(fis);
        ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(classLoader, (InputStream)bis);
        StopWatch sw = new StopWatch();
        sw.start();
        Object o = ois.readObject();
        sw.stop();
        System.out.println("Object deserialization time: " + sw.getTimeInMills());
        ois.close();
        fis.close();
        bis.close();
        return o;
    }

    public Object loadBufferedObject(String fileName, String path, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(new File(String.valueOf(path) + File.separator + fileName));
        BufferedInputStream bis = new BufferedInputStream(fis);
        ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(classLoader, (InputStream)bis);
        StopWatch sw = new StopWatch();
        sw.start();
        Object o = ois.readObject();
        sw.stop();
        System.out.println("Object deserialization time: " + sw.getTimeInMills());
        ois.close();
        fis.close();
        bis.close();
        return o;
    }

    public Object loadBufferedObject(String fileName) throws IOException, ClassNotFoundException {
        return this.loadBufferedObject(fileName, this.getClass().getClassLoader());
    }

    public Object loadBufferedObject(String fileName, String path) throws IOException, ClassNotFoundException {
        return this.loadBufferedObject(fileName, path, this.getClass().getClassLoader());
    }

    public void saveObject(Object o, String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(String.valueOf(PzApplication.getApplication().getConfigFolder().getPath()) + File.separator + fileName));
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(o);
        oos.close();
        ((OutputStream)fos).close();
    }

    public void saveBufferedObject(Object o, String fileName) throws IOException {
        StopWatch sw = new StopWatch();
        sw.start();
        FileOutputStream fos = new FileOutputStream(new File(String.valueOf(PzApplication.getApplication().getConfigFolder().getPath()) + File.separator + fileName));
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        sw.stop();
        System.out.println("Object serialization time: " + sw.getTimeInMills());
        oos.close();
        bos.close();
        ((OutputStream)fos).close();
    }

    public void saveBufferedObject(Object o, String fileName, String path) throws IOException {
        StopWatch sw = new StopWatch();
        sw.start();
        FileOutputStream fos = new FileOutputStream(new File(String.valueOf(path) + File.separator + fileName));
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        sw.stop();
        System.out.println("Object serialization time: " + sw.getTimeInMills());
        oos.close();
        bos.close();
        ((OutputStream)fos).close();
    }

    public void clear(String fileName) {
        new File(String.valueOf(PzApplication.getApplication().getConfigFolder().getPath()) + File.separator + fileName).delete();
    }
}

