/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar;

import com.cloudgarden.layout.AnchorConstraint;
import com.cloudgarden.layout.AnchorLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXStatusBar;
import rs.pezar.core.gui.defaultWidgets.info.InfoWidget;
import rs.pezar.core.gui.defaultWidgets.izvestaj.IzvestajWidget;
import rs.pezar.core.gui.defaultWidgets.mainView.PzTreeCellRenderer;
import rs.pezar.core.gui.defaultWidgets.mainView.TreeListener;
import rs.pezar.core.gui.defaultWidgets.mainView.WidgetTree;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.util.PzFileUtility;

public class PzMainFrame
extends JFrame {
    private static final long serialVersionUID = -5601872572651129530L;
    private PzPanel mainPanel;
    private JXStatusBar jXStatusBar1;
    private WidgetTree stablo;
    private JXMonthView kalendar;
    private IzvestajWidget pnllzvestaj;
    private JXPanel jPanel1;
    private InfoWidget pnlInfo;
    private PzPanel pnlDodaci;
    private static PzMainFrame thisFrame;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzMainFrame inst = PzMainFrame.getInstance();
                inst.setLocation(0, 0);
                inst.setVisible(true);
            }
        });
    }

    public PzMainFrame() {
        this.initGUI();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent e) {
                if (e.getNewValue() instanceof PzFieldImpl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PzFieldImpl textField = (PzFieldImpl)e.getNewValue();
                            textField.selectAll();
                        }
                    });
                }
            }
        });
    }

    public static PzMainFrame getInstance() {
        if (thisFrame == null) {
            thisFrame = new PzMainFrame();
            return thisFrame;
        }
        return thisFrame;
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("PEZAR - robno, finansijsko i materijalno knjigovodstvo");
            this.setMinimumSize(new Dimension(0, 550));
            this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/core/resource/img/book_blue_new.png")).getImage());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    PzMainFrame.this.thisWindowClosing(evt);
                }
            });
            this.jXStatusBar1 = new JXStatusBar();
            this.getContentPane().add((Component)this.jXStatusBar1, "South");
            this.jXStatusBar1.setPreferredSize(new Dimension(855, 24));
            this.jXStatusBar1.setBorder(BorderFactory.createBevelBorder(1));
            this.mainPanel = new PzPanel();
            AnchorLayout mainPanelLayout = new AnchorLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setLayout(mainPanelLayout);
            this.mainPanel.setLocale(new Locale("sr", "RS"));
            this.mainPanel.setPaintGradient(true);
            this.mainPanel.setGradient(Color.BLUE, Color.WHITE, PzPanel.GRADIENT_NORTH_SOUTH);
            this.pnlDodaci = new PzPanel();
            this.mainPanel.add((Component)this.pnlDodaci, new AnchorConstraint(12, 730, 16, 360, 2, 0, 2, 2));
            this.pnlDodaci.setOpaque(false);
            this.pnlDodaci.setPreferredSize(new Dimension(270, 608));
            this.kalendar = new JXMonthView();
            this.pnlDodaci.add((Component)this.kalendar);
            this.kalendar.setDaysOfTheWeek(new String[]{"Ned", "Pon", "Uto", "Sre", "Cet", "Pet", "Sub"});
            this.kalendar.setTraversable(true);
            this.kalendar.setBounds(0, 0, 177, 173);
            this.pnllzvestaj = new IzvestajWidget();
            this.pnlDodaci.add(this.pnllzvestaj);
            this.pnllzvestaj.setBounds(384, 303, 371, 171);
            this.pnllzvestaj.setPreferredSize(new Dimension(265, 129));
            this.pnlInfo = new InfoWidget();
            this.pnlDodaci.add(this.pnlInfo);
            this.pnlInfo.setPreferredSize(new Dimension(265, 127));
            this.jPanel1 = new JXPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
            this.jPanel1.setAlpha(0.9f);
            this.mainPanel.add((Component)this.jPanel1, new AnchorConstraint(12, 345, 16, 12, 2, 0, 2, 2));
            this.jPanel1.setBackground(new Color(255, 255, 255));
            this.jPanel1.setPreferredSize(new Dimension(345, 608));
            PzFileUtility.loadXML("rs/pezar/resource/mainTree.xml");
            this.stablo = new WidgetTree();
            PzTreeCellRenderer renderer = new PzTreeCellRenderer();
            this.stablo.setCellRenderer(renderer);
            this.stablo.setSelectionRow(1);
            TreeListener listener = new TreeListener();
            this.stablo.addMouseListener(listener);
            this.stablo.addKeyListener(listener);
            JScrollPane scrollPane = new JScrollPane((Component)((Object)this.stablo));
            this.jPanel1.add((Component)scrollPane, (Object)"Center");
            scrollPane.setOpaque(false);
            scrollPane.getViewport().setOpaque(false);
            this.pack();
            Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(650, scrSize.height - 30);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setData() {
        try {
            this.pnlInfo.setData();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(this, e);
        }
    }

    private void thisWindowClosing(WindowEvent evt) {
    }
}

