/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.nalogZaKnjizenje.akcije;

import com.swtdesigner.FocusTraversalOnArray;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.entity.Uplata;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.UplataDobavljacuManager;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.UplataManager;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.FakturaDobavljaca;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzComponentFactory;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzDialogAkcija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class UplataDobavljacu
extends PzDialogAkcija {
    private static final long serialVersionUID = -5862964371278645971L;
    private final JPanel contentPanel = new JPanel();
    private PzPanelHeader pnlHeader;
    private PzPanel pnlForm;
    private PzDateField datDatum;
    private JLabel lblDatum;
    private JLabel lblifraKupca;
    private PzNumericOnlyTextField numSifraDobavljaca;
    private JLabel lblOznakafakture;
    private PzDoubleField dfUplataUValuti;
    private JLabel lblUplataUValuti;
    private PzTextField txtOznakaFakture;
    private JLabel lblIznosFakture;
    private JLabel lblStorniranoZa;
    private JLabel lblUkupneUplate;
    private JLabel lblDug;
    private PzDoubleField dblIznosFakture;
    private PzDoubleField dblStorniranoZa;
    private PzDoubleField dblUkupneUplate;
    private PzDoubleField dblDug;
    private JLabel lblUplata;
    private PzDoubleField dblUplata;
    private PzRadioGroup<PzChoice> rgrTip;
    private PzTextField txtNazivDobavljaca;
    private Uplata uplata;
    private Kalkulacija fakturaDobavljaca;
    private Komitent komitent;
    protected Kurs kurs;
    private String stranaValuta;
    private EntityManager em;

    public static void main(String[] args) {
        try {
            UplataDobavljacu dialog = new UplataDobavljacu();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UplataDobavljacu() {
        try {
            this.initGUI();
            this.stranaValuta = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
            this.lblUplataUValuti.setText("Uplata u valuti-" + this.stranaValuta);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public UplataDobavljacu(PzDialog parent) {
        super(parent);
        try {
            this.initGUI();
            this.datDatum.setVal((Object)this.getDatKnjizenjaTemp());
            this.stranaValuta = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
            this.lblUplataUValuti.setText("Uplata u valuti-" + this.stranaValuta);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void initGUI() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.contentPanel.add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.setIcon(new ImageIcon(FakturaDobavljaca.class.getResource("/rs/pezar/finansije/resource/img/check.png")));
        okButton.addActionListener((ActionListener)((Object)this));
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        this.pnlHeader = new PzPanelHeader();
        this.pnlHeader.setTitle("Knji\u017eenje uplate dobavlja\u010du");
        this.contentPanel.add((Component)this.pnlHeader, "North");
        this.pnlForm = new PzPanel();
        GridBagLayout gbl_pnlForm = new GridBagLayout();
        this.contentPanel.add((Component)this.pnlForm, "Center");
        int[] nArray = new int[7];
        nArray[0] = 98;
        nArray[1] = 102;
        nArray[2] = 96;
        nArray[3] = 99;
        nArray[4] = 58;
        nArray[5] = 144;
        gbl_pnlForm.columnWidths = nArray;
        int[] nArray2 = new int[9];
        nArray2[1] = 27;
        nArray2[6] = 26;
        nArray2[7] = 36;
        gbl_pnlForm.rowHeights = nArray2;
        gbl_pnlForm.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_pnlForm.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.pnlForm.setLayout((LayoutManager)gbl_pnlForm);
        this.lblDatum = new JLabel("Datum:");
        GridBagConstraints gbc_lblDatum = new GridBagConstraints();
        gbc_lblDatum.insets = new Insets(0, 0, 5, 5);
        gbc_lblDatum.anchor = 13;
        gbc_lblDatum.gridx = 0;
        gbc_lblDatum.gridy = 0;
        this.pnlForm.add((Component)this.lblDatum, (Object)gbc_lblDatum);
        this.datDatum = new PzDateField();
        GridBagConstraints gbc_datDatum = new GridBagConstraints();
        gbc_datDatum.insets = new Insets(0, 0, 5, 5);
        gbc_datDatum.fill = 2;
        gbc_datDatum.gridx = 1;
        gbc_datDatum.gridy = 0;
        this.pnlForm.add((Component)this.datDatum, (Object)gbc_datDatum);
        this.lblUplata = new JLabel("Uplata:");
        GridBagConstraints gbc_lblUplata = new GridBagConstraints();
        gbc_lblUplata.anchor = 13;
        gbc_lblUplata.insets = new Insets(0, 0, 5, 5);
        gbc_lblUplata.gridx = 3;
        gbc_lblUplata.gridy = 0;
        this.pnlForm.add((Component)this.lblUplata, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.dblUplata = new PzDoubleField();
        this.dblUplata.setVerifyInput(true);
        GridBagConstraints gbc_dblUplata = new GridBagConstraints();
        gbc_dblUplata.insets = new Insets(0, 0, 5, 0);
        gbc_dblUplata.fill = 2;
        gbc_dblUplata.gridx = 4;
        gbc_dblUplata.gridy = 0;
        this.pnlForm.add((Component)this.dblUplata, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.lblifraKupca = new JLabel("\u0160ifra dobavlja\u010da:");
        GridBagConstraints gbc_lblifraKupca = new GridBagConstraints();
        gbc_lblifraKupca.anchor = 13;
        gbc_lblifraKupca.insets = new Insets(0, 0, 5, 5);
        gbc_lblifraKupca.gridx = 0;
        gbc_lblifraKupca.gridy = 1;
        this.pnlForm.add((Component)this.lblifraKupca, (Object)gbc_lblifraKupca);
        this.numSifraDobavljaca = PzComponentFactory.createKomitentField();
        GridBagConstraints gbc_numSifraDobavljaca = new GridBagConstraints();
        gbc_numSifraDobavljaca.insets = new Insets(0, 0, 5, 5);
        gbc_numSifraDobavljaca.fill = 2;
        gbc_numSifraDobavljaca.gridx = 1;
        gbc_numSifraDobavljaca.gridy = 1;
        this.pnlForm.add((Component)this.numSifraDobavljaca, (Object)gbc_numSifraDobavljaca);
        this.numSifraDobavljaca.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent arg0) {
                if (UplataDobavljacu.this.komitent.getDomaciKomitent() != 1) {
                    EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                    UplataDobavljacu.this.kurs = (Kurs)em.find(Kurs.class, (Object)new KursPK(UplataDobavljacu.this.komitent.getStranaValuta(), UplataDobavljacu.this.datDatum.getVal()));
                    em.close();
                    if (UplataDobavljacu.this.kurs == null) {
                        PzSwingUtility.showErrorMessage((Component)((Object)UplataDobavljacu.this), (String)("Na datum knji\u017eenja ne postoji kurs valute! Preuzmite kurs za valutu - " + UplataDobavljacu.this.stranaValuta + " na datum prometa kroz opciju: \u0160ifarnici->Kursna lista"));
                        UplataDobavljacu.this.datDatum.requestFocus();
                        return false;
                    }
                    UplataDobavljacu.this.lblUplataUValuti.setText("Uplata u valuti " + UplataDobavljacu.this.komitent.getStranaValuta());
                    UplataDobavljacu.this.lblUplataUValuti.setVisible(true);
                    UplataDobavljacu.this.dfUplataUValuti.setVisible(true);
                }
                return true;
            }
        });
        this.txtNazivDobavljaca = new PzTextField();
        this.txtNazivDobavljaca.setFocusable(false);
        this.txtNazivDobavljaca.setEditable(false);
        GridBagConstraints gbc_txtNazivDobavljaca = new GridBagConstraints();
        gbc_txtNazivDobavljaca.gridwidth = 3;
        gbc_txtNazivDobavljaca.insets = new Insets(0, 0, 5, 0);
        gbc_txtNazivDobavljaca.fill = 2;
        gbc_txtNazivDobavljaca.gridx = 2;
        gbc_txtNazivDobavljaca.gridy = 1;
        this.pnlForm.add((Component)this.txtNazivDobavljaca, (Object)gbc_txtNazivDobavljaca);
        this.rgrTip = PzComponentFactory.createGroupTipUplate();
        this.rgrTip.setBorder((Border)new TitledBorder(null, "Na\u010din pla\u0107anja:", 4, 2, null, null));
        GridBagConstraints gbc_rgrTip = new GridBagConstraints();
        gbc_rgrTip.gridheight = 6;
        gbc_rgrTip.fill = 1;
        gbc_rgrTip.gridx = 4;
        gbc_rgrTip.gridy = 2;
        this.pnlForm.add(this.rgrTip, (Object)new GridBagConstraints(5, 2, 1, 6, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.lblOznakafakture = new JLabel("Oznaka fakture:");
        GridBagConstraints gbc_lblOznakafakture = new GridBagConstraints();
        gbc_lblOznakafakture.anchor = 13;
        gbc_lblOznakafakture.insets = new Insets(0, 0, 5, 5);
        gbc_lblOznakafakture.gridx = 0;
        gbc_lblOznakafakture.gridy = 2;
        this.pnlForm.add((Component)this.lblOznakafakture, (Object)gbc_lblOznakafakture);
        this.txtOznakaFakture = PzComponentFactory.createOznDokumentaField(this.numSifraDobavljaca, 2, null, null, this, null, null);
        GridBagConstraints gbc_txtOznakaFakture = new GridBagConstraints();
        gbc_txtOznakaFakture.gridwidth = 2;
        gbc_txtOznakaFakture.insets = new Insets(0, 0, 5, 5);
        gbc_txtOznakaFakture.fill = 2;
        gbc_txtOznakaFakture.gridx = 1;
        gbc_txtOznakaFakture.gridy = 2;
        this.pnlForm.add((Component)this.txtOznakaFakture, (Object)gbc_txtOznakaFakture);
        this.lblUplataUValuti = new JLabel();
        this.pnlForm.add((Component)this.lblUplataUValuti, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblUplataUValuti.setName("lblUplataUValuti");
        this.lblUplataUValuti.setVisible(false);
        this.dfUplataUValuti = new PzDoubleField();
        this.pnlForm.add((Component)this.dfUplataUValuti, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.dfUplataUValuti.setVisible(false);
        this.dfUplataUValuti.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent arg0) {
                if (UplataDobavljacu.this.dfUplataUValuti.getVal() != 0.0 && UplataDobavljacu.this.kurs != null) {
                    UplataDobavljacu.this.dblUplata.setVal((Object)(UplataDobavljacu.this.dfUplataUValuti.getVal() * UplataDobavljacu.this.kurs.getSrednji().doubleValue()));
                }
                return true;
            }
        });
        this.lblIznosFakture = new JLabel("Iznos fakture:");
        GridBagConstraints gbc_lblIznosFakture = new GridBagConstraints();
        gbc_lblIznosFakture.anchor = 13;
        gbc_lblIznosFakture.insets = new Insets(0, 0, 5, 5);
        gbc_lblIznosFakture.gridx = 0;
        gbc_lblIznosFakture.gridy = 3;
        this.pnlForm.add((Component)this.lblIznosFakture, (Object)gbc_lblIznosFakture);
        this.dblIznosFakture = new PzDoubleField();
        this.dblIznosFakture.setBackground(new Color(176, 196, 222));
        this.dblIznosFakture.setFocusable(false);
        this.dblIznosFakture.setEditable(false);
        GridBagConstraints gbc_dblIznosFakture = new GridBagConstraints();
        gbc_dblIznosFakture.insets = new Insets(0, 0, 5, 5);
        gbc_dblIznosFakture.fill = 2;
        gbc_dblIznosFakture.gridx = 1;
        gbc_dblIznosFakture.gridy = 3;
        this.pnlForm.add((Component)this.dblIznosFakture, (Object)gbc_dblIznosFakture);
        this.lblStorniranoZa = new JLabel("Stornirano za:");
        GridBagConstraints gbc_lblStorniranoZa = new GridBagConstraints();
        gbc_lblStorniranoZa.anchor = 13;
        gbc_lblStorniranoZa.insets = new Insets(0, 0, 5, 5);
        gbc_lblStorniranoZa.gridx = 0;
        gbc_lblStorniranoZa.gridy = 4;
        this.pnlForm.add((Component)this.lblStorniranoZa, (Object)gbc_lblStorniranoZa);
        this.dblStorniranoZa = new PzDoubleField();
        this.dblStorniranoZa.setBackground(new Color(176, 196, 222));
        this.dblStorniranoZa.setFocusable(false);
        this.dblStorniranoZa.setEditable(false);
        GridBagConstraints gbc_dblStorniranoZa = new GridBagConstraints();
        gbc_dblStorniranoZa.insets = new Insets(0, 0, 5, 5);
        gbc_dblStorniranoZa.fill = 2;
        gbc_dblStorniranoZa.gridx = 1;
        gbc_dblStorniranoZa.gridy = 4;
        this.pnlForm.add((Component)this.dblStorniranoZa, (Object)gbc_dblStorniranoZa);
        this.lblUkupneUplate = new JLabel("Ukupne uplate:");
        GridBagConstraints gbc_lblUkupneUplate = new GridBagConstraints();
        gbc_lblUkupneUplate.anchor = 13;
        gbc_lblUkupneUplate.insets = new Insets(0, 0, 5, 5);
        gbc_lblUkupneUplate.gridx = 0;
        gbc_lblUkupneUplate.gridy = 5;
        this.pnlForm.add((Component)this.lblUkupneUplate, (Object)gbc_lblUkupneUplate);
        this.dblUkupneUplate = new PzDoubleField();
        this.dblUkupneUplate.setBackground(new Color(176, 196, 222));
        this.dblUkupneUplate.setFocusable(false);
        this.dblUkupneUplate.setEditable(false);
        GridBagConstraints gbc_dblUkupneUplate = new GridBagConstraints();
        gbc_dblUkupneUplate.insets = new Insets(0, 0, 5, 5);
        gbc_dblUkupneUplate.fill = 2;
        gbc_dblUkupneUplate.gridx = 1;
        gbc_dblUkupneUplate.gridy = 5;
        this.pnlForm.add((Component)this.dblUkupneUplate, (Object)gbc_dblUkupneUplate);
        this.lblDug = new JLabel("DUG:");
        GridBagConstraints gbc_lblDug = new GridBagConstraints();
        gbc_lblDug.anchor = 13;
        gbc_lblDug.insets = new Insets(0, 0, 5, 5);
        gbc_lblDug.gridx = 0;
        gbc_lblDug.gridy = 6;
        this.pnlForm.add((Component)this.lblDug, (Object)gbc_lblDug);
        this.dblDug = new PzDoubleField();
        this.dblDug.setBackground(new Color(176, 196, 222));
        this.dblDug.setFocusable(false);
        this.dblDug.setEditable(false);
        GridBagConstraints gbc_dblDug = new GridBagConstraints();
        gbc_dblDug.insets = new Insets(0, 0, 5, 5);
        gbc_dblDug.fill = 2;
        gbc_dblDug.gridx = 1;
        gbc_dblDug.gridy = 6;
        this.pnlForm.add((Component)this.dblDug, (Object)gbc_dblDug);
        this.pnlForm.setFocusTraversalPolicyProvider(true);
        this.pnlForm.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.datDatum, this.numSifraDobavljaca, this.txtOznakaFakture, this.dblUplata, this.rgrTip.getSelectedButton()}));
        this.pack();
        this.setRestorable(false);
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.numSifraDobavljaca.setVal((Object)((Komitent)entity).getSfrKomitent());
            this.txtNazivDobavljaca.setVal((Object)((Komitent)entity).getNaziv());
            this.txtOznakaFakture.setVal((Object)"");
            if (this.komitent.getDomaciKomitent() != 1) {
                this.pnlForm.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.datDatum, this.numSifraDobavljaca, this.txtOznakaFakture, this.dfUplataUValuti, this.dblUplata, this.rgrTip.getSelectedButton()}));
            } else {
                this.dfUplataUValuti.setVisible(false);
                this.lblUplataUValuti.setVisible(false);
                this.pnlForm.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(new Component[]{this.datDatum, this.numSifraDobavljaca, this.txtOznakaFakture, this.dblUplata, this.rgrTip.getSelectedButton()}));
            }
        } else if (entity instanceof PzDokument) {
            this.fakturaDobavljaca = (Kalkulacija)entity;
            this.dblIznosFakture.setVal((Object)this.fakturaDobavljaca.getIznos());
            this.dblStorniranoZa.setVal((Object)this.fakturaDobavljaca.getStornoIznos());
            this.dblUkupneUplate.setVal((Object)this.fakturaDobavljaca.getUplata());
            this.dblDug.setVal((Object)this.fakturaDobavljaca.getDug());
            this.dblUplata.setVal((Object)this.fakturaDobavljaca.getDug());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.pnlForm.validateForm(true)) {
            return;
        }
        this.setDatKnjizenjaTemp(this.datDatum.getVal());
        this.commit();
    }

    @Override
    public Date getDatKnjizenja() {
        return this.datDatum.getVal();
    }

    @Override
    public PzDokument getNewDokument() throws Exception {
        this.uplata = new Uplata();
        this.uplata.setDatum(this.datDatum.getVal());
        this.uplata.setIznos(this.dblUplata.getBigDecimal());
        this.uplata.setPoDokumentu(this.fakturaDobavljaca.getIdDok());
        this.uplata.setOznDokumenta(this.fakturaDobavljaca.getOznDokumenta());
        this.uplata.setTipDokumentaUpl(this.fakturaDobavljaca.getTip());
        this.uplata.setRadnajedinica(this.fakturaDobavljaca.getRadnajedinica());
        this.uplata.setTip(TipDokumentConfig.get().UPLATA_DOBAVLJACU);
        this.uplata.setPodTip((String)((PzChoice)this.rgrTip.getSelectedValue()).getValue());
        this.uplata.setKomitent(this.komitent);
        return this.uplata;
    }

    @Override
    public void initData(EntityManager em) {
        this.em = em;
    }

    @Override
    public UplataManager getUplataManager() {
        return new UplataDobavljacuManager((PzDokument)this.fakturaDobavljaca, this.uplata);
    }

    private InputVerifier getInputVerifier() {
        return new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (UplataDobavljacu.this.komitent.getDomaciKomitent() != 1) {
                    UplataDobavljacu.this.kurs = (Kurs)UplataDobavljacu.this.em.find(Kurs.class, (Object)new KursPK(UplataDobavljacu.this.komitent.getStranaValuta(), UplataDobavljacu.this.datDatum.getVal()));
                    if (UplataDobavljacu.this.kurs == null) {
                        PzSwingUtility.showErrorMessage((Component)((Object)UplataDobavljacu.this), (String)("Na datum prometa ne postoji kurs valute! Preuzmite kurs za valutu - " + UplataDobavljacu.this.stranaValuta + " na datum prometa kroz opciju: \u0160ifarnici->Kursna lista"));
                        return false;
                    }
                }
                return true;
            }
        };
    }
}

