/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.nalogZaKnjizenje.akcije;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzComponentFactory;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzDialogAkcija;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.custom.PzTablePorez;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.fields.PzCalculatedField;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class FaktureKupca
extends PzDialogAkcija {
    private static final String SA_POREZOM = "Sa porezom";
    private static final String BEZ_POREZA = "Bez poreza";
    private static final String SA_PRAVOM = "Sa pravom na odbitak";
    private static final String BEZ_PRAVA = "Bez prava na odbitak";
    private static final String KEPU_R_Z = "KEPU: zadu\u017eenje i razdu\u017eenje";
    private static final String KEPU_R = "KEPU: razdu\u017eenje";
    private PzPanel mainPanel;
    private PzPanelHeader pnlHeader;
    private PzPanel contentPanel;
    private PzTextField tfRadnaJedinica;
    private PzFieldIndikator indRj;
    private PzTextField tfBrojFakture;
    private JLabel lblBrojFakture;
    private PzTextField tfNazivKupca;
    private PzFieldIndikator indKupac;
    private PzNumericOnlyTextField tfSifraKupca;
    private JLabel lblSifraKupca;
    private JButton btnPotvrdi;
    private PzDateField dfDatumValute;
    private JLabel lblDatumValute;
    private PzDateField dfDatumDPO;
    private JLabel lblDatumDPO;
    private PzDateField dfDatumFakture;
    private JLabel lblDatumFakture;
    private PzDoubleField dfObracunatIznos;
    private JLabel lblObracunatIznos;
    private JScrollPane scrollPane;
    private PzRadioGroup<String> panelRbs1;
    private PzDoubleField dfIznos;
    private JLabel lblIznos;
    private PzTextField tfNazivRadneJedinice;
    private JLabel lblRadnaJedinica;
    private PzRadioGroup<String> panelRbs2;
    private PzTablePorez tblPorez;
    private PzRadioGroup<String> panelRbs3;
    private Komitent komitent;
    private PzDokument faktura;
    private Radnajedinica radnajedinica;
    private PzCalculatedField dfPdv;

    public static void main(String[] args) {
        try {
            FaktureKupca dialog = new FaktureKupca();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FaktureKupca() {
        this.initGUI();
    }

    public FaktureKupca(PzDialog parent) {
        super(parent);
        this.initGUI();
    }

    @Override
    public Date getDatKnjizenja() {
        return this.dfDatumFakture.getVal();
    }

    @Override
    public PzDokument getNewDokument() throws Exception {
        Faktura f = new Faktura();
        f.setDatPrometa(this.dfDatumDPO.getVal());
        f.setDatum(this.dfDatumFakture.getVal());
        f.setDatValute(this.dfDatumValute.getVal());
        f.setIznos(this.dfIznos.getBigDecimal());
        f.setIznosBezPoreza(new BigDecimal(0));
        f.setKomitent(this.komitent);
        f.setNabavnaUkupno(new BigDecimal(0));
        f.setrBroj(1);
        f.setOznDokumenta(this.tfBrojFakture.getVal());
        f.setPodTip(TipDokumentConfig.get().PODTIP_FAKTURA_SA_NALOGA);
        f.setTip(TipDokumentConfig.get().FAKTURA);
        f.setSaPorezom(((String)this.panelRbs1.getSelectedValue()).equals(SA_POREZOM) ? 1 : 0);
        f.setSaPravomNaOdbitak(((String)this.panelRbs2.getSelectedValue()).equals(SA_PRAVOM) ? 1 : 0);
        f.setVrsta(((String)this.panelRbs3.getSelectedValue()).equals(KEPU_R) ? "R" : "Z");
        f.setTaksafakturas(this.tblPorez.getPorezi());
        f.setRadnajedinica(this.radnajedinica);
        return f;
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            BorderLayout mainPanelLayout = new BorderLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setPreferredSize(new Dimension(612, 350));
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.pnlHeader = new PzPanelHeader();
            this.pnlHeader.setOpaque(false);
            this.pnlHeader.setTitle("Knji\u017eenje fakture kupca");
            this.mainPanel.add((Component)this.pnlHeader, (Object)"North");
            this.contentPanel = new PzPanel();
            GridBagLayout contentPanelLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.contentPanel, (Object)"Center");
            contentPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            contentPanelLayout.rowHeights = new int[]{20, 20, 20, 7, 46, 60, 7, 30, 20, 20};
            contentPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            contentPanelLayout.columnWidths = new int[]{100, 120, 220, 220, 7};
            this.contentPanel.setLayout((LayoutManager)contentPanelLayout);
            this.lblRadnaJedinica = new JLabel();
            this.contentPanel.add((Component)this.lblRadnaJedinica, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 3, 0), 0, 0));
            this.lblRadnaJedinica.setText("Radna jedinica");
            this.tfRadnaJedinica = new PzTextField();
            this.tfRadnaJedinica.setEditable(false);
            this.tfRadnaJedinica.setFocusable(false);
            this.contentPanel.add((Component)this.tfRadnaJedinica, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.indRj = new PzFieldIndikator();
            this.indRj.setVisible(false);
            this.contentPanel.add((Component)this.indRj, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNazivRadneJedinice = new PzTextField();
            this.contentPanel.add((Component)this.tfNazivRadneJedinice, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 3, 0), 0, 0));
            this.tfNazivRadneJedinice.setFocusable(false);
            this.tfNazivRadneJedinice.setEnabled(false);
            this.lblSifraKupca = new JLabel();
            this.contentPanel.add((Component)this.lblSifraKupca, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 3, 0), 0, 0));
            this.lblSifraKupca.setText("\u0160ifra kupca");
            this.tfSifraKupca = PzComponentFactory.createKomitentField();
            this.contentPanel.add((Component)this.tfSifraKupca, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.indKupac = new PzFieldIndikator();
            this.contentPanel.add((Component)this.indKupac, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.tfNazivKupca = new PzTextField();
            this.contentPanel.add((Component)this.tfNazivKupca, (Object)new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 3, 0), 0, 0));
            this.tfNazivKupca.setFocusable(false);
            this.tfNazivKupca.setEnabled(false);
            this.lblBrojFakture = new JLabel();
            this.contentPanel.add((Component)this.lblBrojFakture, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 3, 0), 0, 0));
            this.lblBrojFakture.setText("Broj fakture");
            this.tfBrojFakture = new PzTextField();
            this.contentPanel.add((Component)this.tfBrojFakture, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfBrojFakture.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (FaktureKupca.this.getEm().createQuery("SELECT r FROM Faktura r WHERE r.oznDokumenta='" + FaktureKupca.this.tfBrojFakture.getVal() + "' AND r.komitent.sfrKomitent=" + FaktureKupca.this.tfSifraKupca.getVal()).getResultList().size() > 0) {
                        PzSwingUtility.showErrorMessage((Component)((Object)FaktureKupca.this), (String)("Ra\u010dun " + FaktureKupca.this.tfBrojFakture.getVal() + " za kupca [" + FaktureKupca.this.komitent.getSfrKomitent() + "] " + FaktureKupca.this.komitent.getNaziv() + " ve\u0107 postoji. Ne mo\u017eete nastaviti dalje."));
                        return false;
                    }
                    return !FaktureKupca.this.tfBrojFakture.getText().equals("");
                }
            });
            this.lblIznos = new JLabel();
            this.contentPanel.add((Component)this.lblIznos, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 25, 3, 0), 0, 0));
            this.lblIznos.setText("Iznos fakture");
            this.dfIznos = new PzDoubleField();
            this.contentPanel.add((Component)this.dfIznos, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 100, 3, 0), 0, 0));
            this.panelRbs1 = new PzRadioGroup((Object[])new String[]{SA_POREZOM, BEZ_POREZA});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRbs1, 1);
            this.panelRbs1.setLayout((LayoutManager)panelRBs2Layout);
            this.contentPanel.add(this.panelRbs1, (Object)new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.panelRbs1.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRbs1.setSelectedValue((Object)SA_POREZOM);
            this.panelRbs1.setOpaque(false);
            this.panelRbs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(FaktureKupca.SA_POREZOM)) {
                            FaktureKupca.this.panelRbs2.setEnabled(false);
                            FaktureKupca.this.tblPorez.setEnabled(true);
                        } else if (evt.getValue().equals(FaktureKupca.BEZ_POREZA)) {
                            FaktureKupca.this.panelRbs2.setEnabled(true);
                            FaktureKupca.this.tblPorez.setEnabled(false);
                        }
                    }
                }
            });
            this.panelRbs2 = new PzRadioGroup((Object[])new String[]{SA_PRAVOM, BEZ_PRAVA});
            panelRBs2Layout = new BoxLayout((Container)this.panelRbs2, 1);
            this.panelRbs2.setLayout((LayoutManager)panelRBs2Layout);
            this.contentPanel.add(this.panelRbs2, (Object)new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.panelRbs2.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRbs2.setSelectedValue((Object)SA_PRAVOM);
            this.panelRbs2.setOpaque(false);
            this.panelRbs2.setEnabled(false);
            this.panelRbs3 = new PzRadioGroup((Object[])new String[]{KEPU_R_Z, KEPU_R});
            panelRBs2Layout = new BoxLayout((Container)this.panelRbs3, 1);
            this.panelRbs3.setLayout((LayoutManager)panelRBs2Layout);
            this.contentPanel.add(this.panelRbs3, (Object)new GridBagConstraints(0, 6, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 10, 3, 0), 0, 0));
            this.panelRbs3.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.panelRbs3.setSelectedValue((Object)KEPU_R_Z);
            this.panelRbs3.setOpaque(false);
            this.scrollPane = new JScrollPane();
            this.contentPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(2, 4, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 5, 3, 0), 0, 0));
            this.tblPorez = this.createTablePorez();
            this.scrollPane.setViewportView((Component)this.tblPorez);
            this.lblObracunatIznos = new JLabel();
            this.contentPanel.add((Component)this.lblObracunatIznos, (Object)new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 25, 0, 0), 0, 0));
            this.lblObracunatIznos.setText("Obra\u010dunat iznos");
            this.dfObracunatIznos = this.tblPorez.createExpresionField("$2$+$3$");
            this.dfObracunatIznos.setFocusable(false);
            this.contentPanel.add((Component)this.dfObracunatIznos, (Object)new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 12, 1, new Insets(0, 120, 0, 0), 0, 0));
            this.lblDatumFakture = new JLabel();
            this.contentPanel.add((Component)this.lblDatumFakture, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 0, 0), 0, 0));
            this.lblDatumFakture.setText("Datum fakture");
            this.dfDatumFakture = new PzDateField();
            this.contentPanel.add((Component)this.dfDatumFakture, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblDatumDPO = new JLabel();
            this.contentPanel.add((Component)this.lblDatumDPO, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 25, 0, 0), 0, 0));
            this.lblDatumDPO.setText("Datum dospe\u0107a");
            this.dfDatumDPO = new PzDateField();
            this.contentPanel.add((Component)this.dfDatumDPO, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 120, 0, 0), 0, 0));
            this.lblDatumValute = new JLabel();
            this.contentPanel.add((Component)this.lblDatumValute, (Object)new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblDatumValute.setText("Datum valute");
            this.dfDatumValute = new PzDateField();
            this.contentPanel.add((Component)this.dfDatumValute, (Object)new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 120, 0, 0), 0, 0));
            this.btnPotvrdi = new JButton();
            this.contentPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    FaktureKupca.this.actionPerformedokButton(arg0);
                }
            });
            this.btnPotvrdi.setIcon(new ImageIcon(FaktureKupca.class.getResource("/rs/pezar/finansije/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("OK");
            this.tfSifraKupca.setStateIndikator(this.indKupac);
            this.tfRadnaJedinica.setStateIndikator(this.indRj);
            this.pack();
            this.setSize(905, 460);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PzTablePorez createTablePorez() {
        return PzComponentFactory.createPzTablePorezFakturaKupca();
    }

    protected void actionPerformedokButton(ActionEvent arg0) {
        if (!this.contentPanel.validateForm(true)) {
            return;
        }
        if (!this.tfBrojFakture.getInputVerifier().verify((JComponent)this.tfBrojFakture)) {
            return;
        }
        this.commit();
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.tfSifraKupca.setVal((Object)((Komitent)entity).getSfrKomitent());
            this.tfNazivKupca.setVal((Object)((Komitent)entity).getNaziv());
        } else if (entity instanceof PzDokument) {
            this.faktura = (PzDokument)entity;
            if (entity instanceof Faktura) {
                Faktura cfr_ignored_0 = (Faktura)entity;
            }
        }
    }

    @Override
    public void commit() {
        if (((String)this.panelRbs1.getSelectedValue()).equals(SA_POREZOM)) {
            if (!this.dfObracunatIznos.getVal().equals(this.dfIznos.getVal())) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Unet iznos se ne poklapa sa zbirom unete osnovice i PDV-a. Ne mo\u017eete nastaviti dalje.");
            } else {
                super.commit();
            }
        } else {
            this.tblPorez.resetPorezi();
            super.commit();
        }
    }

    public boolean shouldBeShown() {
        Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)this);
        if (rj == null) {
            return false;
        }
        this.radnajedinica = rj;
        this.tfRadnaJedinica.setVal((Object)rj.getNaziv());
        this.tfNazivRadneJedinice.setVal((Object)rj.getNaziv());
        return true;
    }
}

