/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.gui.nalogZaKnjizenje;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Nzk;
import rs.pezar.db.entity.Stavkanzk;
import rs.pezar.db.entity.StavkanzkPK;
import rs.pezar.finansije.engine.sifreKnjizenja.ManagerLoader;
import rs.pezar.finansije.engine.sifreKnjizenja.manager.UplataManager;
import rs.pezar.finansije.gui.izvod.PzDialogIzvodImport;
import rs.pezar.finansije.gui.nalogZaKnjizenje.Dodavanje;
import rs.pezar.finansije.gui.nalogZaKnjizenje.IzborStampe;
import rs.pezar.finansije.gui.nalogZaKnjizenje.IzmenaOpisa;
import rs.pezar.finansije.gui.nalogZaKnjizenje.akcije.PzDialogAkcija;
import rs.pezar.finansije.gui.util.LockUtility;
import rs.pezar.finansije.gui.util.TableModelAkcije;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBar;
import rs.pezar.swing.event.PzTablePropertyListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogIzradaNaloga
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private final PzPanel contentPanel = new PzPanel();
    private PzPanelHeader pnlHeader;
    private Nzk nzk;
    private JSplitPane splitPane;
    private PzPanel pnlAkcije;
    private PzPanel pnlStavke;
    private JScrollPane scpAkcije;
    private JScrollPane scpStavke;
    private PzTable tblAkcije;
    private PzTable tblStavke;
    private TableModelAkcije tableModelAkcije;
    private PzToolBar toolbar;
    private PzButton icnDodavanje;
    private PzButton icnIzmena;
    private PzButton icnBrisanje;
    private PzButton icnIzmenaOpisa;
    private PzButton icnStampa;
    private PzButton icnArhiva;
    private PzStatusBar statusBar;
    private JLabel lblBrojStavki;
    private JLabel lblDuguje;
    private PzDoubleField dblDuguje;
    private JLabel lblPotrazuje;
    private PzDoubleField dblPotrazuje;
    private JLabel lblSaldo;
    private PzDoubleField dblSaldo;
    private JLabel lblStavke;
    private PzButton icnImport;

    public static void main(String[] args) {
        try {
            PzDialogIzradaNaloga dialog = new PzDialogIzradaNaloga();
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PzDialogIzradaNaloga() {
        this.initGUI();
        this.fillTableAkcija();
    }

    public PzDialogIzradaNaloga(PzDialog parent) {
        super(parent);
        this.nzk = (Nzk)this.getSession().getParameter("nzk");
        this.initGUI();
        this.paintGradient();
        this.fillTableAkcija();
        this.lblBrojStavki.setText(String.valueOf(this.tblStavke.getRowCount()));
        try {
            this.splitPane.setDividerLocation((Integer)PzApplication.getApplication().getPropManager().loadObject("nzk_div"));
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void paintGradient() {
        this.contentPanel.setPaintGradient(true);
        this.contentPanel.setGradient(Color.WHITE, Color.BLUE, PzPanel.GRADIENT_WEST_EAST);
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogIzradaNaloga.this.lblBrojStavki.setText(String.valueOf(PzDialogIzradaNaloga.this.tblStavke.getRowCount()));
            }
        });
    }

    private void initGUI() {
        try {
            this.setTitle("Izrada naloga za knjizenje");
            this.setBounds(100, 100, 450, 300);
            this.getContentPane().setLayout(new BorderLayout());
            this.contentPanel.setLayout((LayoutManager)new BorderLayout());
            this.contentPanel.setBorder((Border)new EmptyBorder(8, 8, 8, 8));
            this.getContentPane().add((Component)this.contentPanel, "Center");
            this.pnlHeader = new PzPanelHeader();
            this.pnlHeader.setOpaque(false);
            this.pnlHeader.setTitle("Izrada naloga za knji\u017eenje broj " + this.nzk.getIdNalog());
            this.pnlHeader.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/rs/pezar/finansije/resource/img/nzk.png")));
            this.contentPanel.add((Component)this.pnlHeader, (Object)"North");
            this.splitPane = new JSplitPane();
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setContinuousLayout(true);
            this.contentPanel.add((Component)this.splitPane, (Object)"Center");
            this.pnlAkcije = new PzPanel();
            this.splitPane.setLeftComponent((Component)this.pnlAkcije);
            GridBagLayout gbl_pnlAkcije = new GridBagLayout();
            gbl_pnlAkcije.columnWidths = new int[2];
            gbl_pnlAkcije.rowHeights = new int[2];
            gbl_pnlAkcije.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gbl_pnlAkcije.rowWeights = new double[]{1.0, Double.MIN_VALUE};
            this.pnlAkcije.setLayout((LayoutManager)gbl_pnlAkcije);
            this.scpAkcije = new JScrollPane();
            GridBagConstraints gbc_scpAkcije = new GridBagConstraints();
            gbc_scpAkcije.fill = 1;
            gbc_scpAkcije.gridx = 0;
            gbc_scpAkcije.gridy = 0;
            this.pnlAkcije.add((Component)this.scpAkcije, (Object)gbc_scpAkcije);
            this.pnlStavke = new PzPanel();
            this.splitPane.setRightComponent((Component)this.pnlStavke);
            this.pnlStavke.setLayout((LayoutManager)new BorderLayout(0, 0));
            this.scpStavke = new JScrollPane();
            this.pnlStavke.add((Component)this.scpStavke);
            this.tblStavke = new PzTable(this.nzk.getStavkanzks(), Stavkanzk.class);
            this.tblStavke.setSortable(false);
            this.tblStavke.setId("TABLE_STAVKE");
            this.scpStavke.setViewportView((Component)this.tblStavke);
            this.tblStavke.setPropertyListener(new PzTablePropertyListener(){

                public void entityRemoved(PzEntity entity) {
                    PzDialogIzradaNaloga.this.refresh();
                }

                public void entityAdded(PzEntity entity) {
                    PzDialogIzradaNaloga.this.refresh();
                }
            });
            this.toolbar = new PzToolBar();
            this.pnlStavke.add((Component)this.toolbar, (Object)"North");
            this.icnDodavanje = new PzButton();
            this.icnDodavanje.setFocusable(false);
            this.icnDodavanje.setShortcut("insert");
            this.icnDodavanje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaNaloga.this.actionPerformedicnDodavanje(arg0);
                }
            });
            this.icnDodavanje.setIcon((Icon)new ImageIcon(PzDialogIzradaNaloga.class.getResource("/rs/pezar/finansije/resource/img/component_add.png")));
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnIzmena = new PzButton();
            this.icnIzmena.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = -2355577127933856217L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaNaloga.this.actionPerformedicnIzmena(arg0);
                }
            });
            this.icnIzmena.setFocusable(false);
            this.icnIzmena.setShortcut("f3");
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(PzDialogIzradaNaloga.class.getResource("/rs/pezar/finansije/resource/img/component_edit.png")));
            this.toolbar.add((Component)this.icnIzmena);
            this.icnBrisanje = new PzButton();
            this.icnBrisanje.setFocusable(false);
            this.icnBrisanje.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = -2355577127933856217L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaNaloga.this.actionPerformedicnBrisanje(arg0);
                }
            });
            this.icnBrisanje.setShortcut("delete");
            this.icnBrisanje.setText("Brisanje|(DEL)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(PzDialogIzradaNaloga.class.getResource("/rs/pezar/finansije/resource/img/component_delete.png")));
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnIzmenaOpisa = new PzButton();
            this.icnIzmenaOpisa.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 6476705789874623587L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaNaloga.this.icnIzmenaOpisaactionPerformed(arg0);
                }
            });
            this.icnIzmenaOpisa.setFocusable(false);
            this.icnIzmenaOpisa.setShortcut("f4");
            this.icnIzmenaOpisa.setIcon((Icon)new ImageIcon(PzDialogIzradaNaloga.class.getResource("/rs/pezar/finansije/resource/img/component_view.png")));
            this.icnIzmenaOpisa.setText("Izmena|opisa(F4)");
            this.toolbar.add((Component)this.icnIzmenaOpisa);
            this.icnStampa = new PzButton();
            this.icnStampa.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = 719024139222109712L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaNaloga.this.icnStampaactionPerformed(arg0);
                }
            });
            this.icnStampa.setFocusable(false);
            this.icnStampa.setShortcut("alt+s");
            this.icnStampa.setText("\u0160tampa|(ALT+S)");
            this.icnStampa.setIcon((Icon)new ImageIcon(PzDialogIzradaNaloga.class.getResource("/rs/pezar/finansije/resource/img/printer.png")));
            this.toolbar.add((Component)this.icnStampa);
            this.icnArhiva = new PzButton();
            this.icnArhiva.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = -2854964412166096393L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaNaloga.this.icnArhivaactionPerformed(arg0);
                }
            });
            this.icnArhiva.setFocusable(false);
            this.icnArhiva.setShortcut("ctrl+w");
            this.icnArhiva.setText("Arhiva|(CTRL+W)");
            this.icnArhiva.setIcon((Icon)new ImageIcon(PzDialogIzradaNaloga.class.getResource("/rs/pezar/finansije/resource/img/cabinet.png")));
            this.toolbar.add((Component)this.icnArhiva);
            this.icnImport = new PzButton();
            this.icnImport.addActionListener((ActionListener)new AbstractAction(){
                private static final long serialVersionUID = -2854964412166096393L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PzDialogIzradaNaloga.this.icnImportActionPerformed(arg0);
                }
            });
            this.icnImport.setFocusable(false);
            this.icnImport.setShortcut("ctrl+u");
            this.icnImport.setText("Uvoz|izvoda (CTRL+U)");
            this.icnImport.setIcon((Icon)new ImageIcon(PzDialogIzradaNaloga.class.getResource("/rs/pezar/finansije/resource/img/lifebelt.png")));
            this.toolbar.add((Component)this.icnImport);
            this.statusBar = new PzStatusBar();
            this.statusBar.setAlignmentX(1.0f);
            this.lblStavke = new JLabel("Broj stavki: ");
            this.lblStavke.setFont(new Font("SansSerif", 1, 12));
            this.statusBar.add((Component)this.lblStavke);
            this.contentPanel.add((Component)this.statusBar, (Object)"South");
            this.lblBrojStavki = new JLabel("0");
            this.lblBrojStavki.setFont(new Font("SansSerif", 1, 12));
            this.statusBar.add((Component)this.lblBrojStavki);
            this.lblDuguje = new JLabel("Duguje:");
            this.lblDuguje.setFont(new Font("SansSerif", 1, 14));
            this.statusBar.add((Component)this.lblDuguje);
            this.dblDuguje = this.tblStavke.createExpresionField("$3$");
            this.dblDuguje.setFocusable(false);
            this.dblDuguje.setEditable(false);
            this.dblDuguje.setFont(new Font("SansSerif", 1, 16));
            this.dblDuguje.setForeground(Color.BLUE);
            this.dblDuguje.setColumns(10);
            this.statusBar.add((Component)this.dblDuguje);
            this.lblPotrazuje = new JLabel("Potra\u017euje:");
            this.lblPotrazuje.setFont(new Font("SansSerif", 1, 14));
            this.statusBar.add((Component)this.lblPotrazuje);
            this.dblPotrazuje = this.tblStavke.createExpresionField("$4$");
            this.dblPotrazuje.setFocusable(false);
            this.dblPotrazuje.setEditable(false);
            this.dblPotrazuje.setFont(new Font("SansSerif", 1, 16));
            this.dblPotrazuje.setForeground(Color.MAGENTA);
            this.dblPotrazuje.setColumns(10);
            this.statusBar.add((Component)this.dblPotrazuje);
            this.lblSaldo = new JLabel("Saldo:");
            this.lblSaldo.setFont(new Font("SansSerif", 1, 14));
            this.statusBar.add((Component)this.lblSaldo);
            this.dblSaldo = this.tblStavke.createExpresionField("$3$-$4$");
            this.dblSaldo.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    if (arg0.getPropertyName().equals("value")) {
                        if (arg0.getNewValue().equals(new Double(0.0))) {
                            PzDialogIzradaNaloga.this.dblSaldo.setForeground(Color.GREEN);
                        } else {
                            PzDialogIzradaNaloga.this.dblSaldo.setForeground(Color.RED);
                        }
                    }
                }
            });
            this.dblSaldo.setFocusable(false);
            this.dblSaldo.setEditable(false);
            this.dblSaldo.setFont(new Font("SansSerif", 1, 16));
            this.dblSaldo.setForeground(Color.GREEN);
            this.dblSaldo.setColumns(10);
            this.statusBar.add((Component)this.dblSaldo);
            this.tblStavke.calculateFields();
            this.setOptimalSize();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void fillTableAkcija() {
        try {
            this.tableModelAkcije = new TableModelAkcije(new XMLConfiguration(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/finansije/resource/akcije.xml")).getDocument());
            this.tblAkcije = new PzTable();
            this.tblAkcije.setSortable(false);
            this.tblAkcije.setModel((TableModel)this.tableModelAkcije);
            this.tblAkcije.setEnterAction(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PzDialogIzradaNaloga.this.tblAkcije.getSelectedRow() == -1) {
                        return;
                    }
                    try {
                        Stavkanzk stavka = new Stavkanzk();
                        stavka.setId(new StavkanzkPK());
                        stavka.getId().setIdNalog(PzDialogIzradaNaloga.this.nzk.getIdNalog());
                        stavka.setDatKnjizenja(PzDateUtility.getCurrentDate());
                        PzDialogIzradaNaloga.this.getSession().putParameter("stavka", (Object)stavka);
                        PzDialogIzradaNaloga.this.getSession().putParameter("update", (Object)Boolean.FALSE);
                        PzDialogIzradaNaloga.this.getSession().putParameter("sfr", (Object)PzDialogIzradaNaloga.this.tableModelAkcije.getSfr(PzDialogIzradaNaloga.this.tblAkcije.getSelectedRow()));
                        Class<PzDialogAkcija> c = PzDialogIzradaNaloga.this.tableModelAkcije.getActionClass(PzDialogIzradaNaloga.this.tblAkcije.getSelectedRow());
                        PzDialogIzradaNaloga.this.launchDialog(c, stavka, Boolean.FALSE, PzDialogIzradaNaloga.this.tableModelAkcije.getSfr(PzDialogIzradaNaloga.this.tblAkcije.getSelectedRow()));
                    }
                    catch (Exception e1) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogIzradaNaloga.this), (Throwable)e1);
                    }
                }
            });
            this.tblAkcije.setId("TABLE_AKCIJE");
            this.scpAkcije.setViewportView((Component)this.tblAkcije);
            if (this.tblAkcije.getRowCount() > 0) {
                this.tblAkcije.setRowSelectionInterval(0, 0);
            }
        }
        catch (ConfigurationException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void launchDialog(Class<PzDialogAkcija> c, Stavkanzk stavka, Boolean update, int sfrKnjizenja) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            PzDialogAkcija dlg;
            PzDokument dokument = null;
            if (stavka != null && stavka.getDokument() != null) {
                Class c1 = TipDokumentConfig.getClassByValue((String)stavka.getDokument().getTip());
                dokument = (PzDokument)PzEntityManager.find((Class)c1, (Object)stavka.getDokument().getIdDok());
            }
            if (!(dlg = c.getConstructor(PzDialog.class).newInstance(new Object[]{this})).shouldBeShown()) {
                return;
            }
            Integer brojac = (Integer)em.createQuery("SELECT MAX(s.id.rBroj) FROM Stavkanzk s WHERE s.id.idNalog=" + this.getNzk().getIdNalog()).getSingleResult();
            if (brojac == null) {
                brojac = 0;
            }
            dlg.setBrojac(brojac);
            dlg.setTblStavke(this.tblStavke);
            dlg.setStavka(stavka);
            dlg.setUpdate(update);
            if (update.booleanValue()) {
                dlg.setDokument(dokument);
            }
            dlg.setNzk(this.nzk);
            dlg.setEm(em);
            dlg.setSfrKnjizenja(sfrKnjizenja);
            dlg.initData(em);
            dlg.setLocationRelativeTo((Component)((Object)this));
            dlg.setModal(true);
            dlg.restoreSize();
            dlg.setVisible(true);
            this.getSession().putParameter("update", null);
            if (!dlg.isCommited()) {
                return;
            }
            PzDokument dok = dlg.getNewDokument();
            List<PzDokument> dokumenti = dlg.getNewDokuments();
            if (dok == null && (dokumenti == null || dokumenti.size() == 0) && dlg.getStavke() == null) {
                return;
            }
            try {
                em.getTransaction().begin();
                if (dok != null) {
                    dok.setArhiviran((short)1);
                    dok.setProknjizen((short)1);
                    PzDokumentManager.getInstance().arhivirajDokument(dok, true, null, em);
                    dlg.updateNzk(dok, dlg.getDatKnjizenja());
                } else if (dokumenti != null) {
                    for (PzDokument dok1 : dokumenti) {
                        dok1.setArhiviran((short)1);
                        dok1.setProknjizen((short)1);
                        PzDokumentManager.getInstance().arhivirajDokument(dok1, true, null, em);
                        dlg.updateNzk(dok1, dlg.getDatKnjizenja());
                    }
                }
                brojac = dlg.getBrojac();
                if (dlg.getStavke() != null) {
                    for (Stavkanzk s : dlg.getStavke()) {
                        brojac = brojac + 1;
                        s.getId().setIdNalog(this.nzk.getIdNalog());
                        s.getId().setrBroj(brojac);
                        if (dok != null) {
                            s.setDatdokumenta(dok.getDatum());
                        } else if (s.getTempDok() != null) {
                            s.setDokument(s.getTempDok().getDokument());
                            s.setDatdokumenta(s.getTempDok().getDatum());
                            s.getTempDok().getDokument().getStavkanzks().add(s);
                        }
                        s.setDatKnjizenja(dlg.getDatKnjizenja());
                        this.tblStavke.insert((PzEntity)s, em);
                    }
                }
                if (dlg.getUplataManager() != null) {
                    dlg.getUplataManager().doInTransaction(em);
                }
                em.getTransaction().commit();
                this.tblStavke.commitInsert();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                this.tblStavke.rollBack();
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public PzTable getTableStavke() {
        return this.tblStavke;
    }

    public Nzk getNzk() {
        return this.nzk;
    }

    protected void actionPerformedicnDodavanje(ActionEvent arg0) {
        this.showDialog(Dodavanje.class);
        if (this.getSession().getParameter("sfr") == null) {
            return;
        }
        Class<PzDialogAkcija> c = null;
        try {
            Integer sfrKnjizenja = (Integer)this.getSession().getParameter("sfr");
            c = this.tableModelAkcije.getClassBySfr(sfrKnjizenja);
            if (c == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Nepostoje\u0107a \u0161ifra knji\u017eenja");
                return;
            }
            this.getSession().putParameter("update", (Object)Boolean.FALSE);
            Stavkanzk stavka = new Stavkanzk();
            stavka.setId(new StavkanzkPK());
            stavka.getId().setIdNalog(this.nzk.getIdNalog());
            stavka.setDatKnjizenja(PzDateUtility.getCurrentDate());
            this.getSession().putParameter("stavka", (Object)stavka);
            this.launchDialog(c, stavka, Boolean.FALSE, sfrKnjizenja);
        }
        catch (ClassNotFoundException e) {
            this.getSession().putParameter("sfr", null);
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void actionPerformedicnBrisanje(ActionEvent arg0) {
        if (((Stavkanzk)this.tblStavke.getSelectedEntity()).getSfrKnjizenja() == null && ((Stavkanzk)this.tblStavke.getSelectedEntity()).getDokument() != null) {
            JOptionPane.showConfirmDialog((Component)((Object)this), "Ne mo\u017eete obrisati stav koji je nastao automatskim prenosom dokumenta iz robnog u finansijsko.", "Obave\u0161tenje", -1, 1);
        } else if (((Stavkanzk)this.tblStavke.getSelectedEntity()).getDokument() == null) {
            this.tblStavke.removeSelectedEntity(true, true);
        } else {
            EntityManager emTemp = PzEntityManagerFactory.getInstance().createEm();
            try {
                if (JOptionPane.showConfirmDialog((Component)((Object)this), "Brisanjem ove stavke obrisa\u0107ete i sve ostale koje su nastale knji\u017eenjem istog dokumenta. Da li ste sigurni?", "Brisanje?", 0) != 0) {
                    return;
                }
                try {
                    Dokument dok = ((Stavkanzk)this.tblStavke.getSelectedEntity()).getDokument();
                    emTemp.getTransaction().begin();
                    for (Stavkanzk stavka : dok.getStavkanzks()) {
                        this.tblStavke.remove(this.nzk.getStavkanzks().indexOf(stavka), false, emTemp);
                    }
                    UplataManager m = ManagerLoader.getManagerBySfr(((Stavkanzk)this.tblStavke.getSelectedEntity()).getSfrKnjizenja().toString());
                    if (m != null) {
                        m.reverse(emTemp, (Stavkanzk)this.tblStavke.getSelectedEntity());
                    }
                    Object o = emTemp.find(TipDokumentConfig.getClassByValue((String)dok.getTip()), (Object)dok.getIdDok());
                    emTemp.remove(o);
                    emTemp.flush();
                    dok = this.createDokumentGreska(dok);
                    emTemp.persist((Object)dok);
                    emTemp.getTransaction().commit();
                    this.tblStavke.commitRemove();
                }
                catch (Exception e) {
                    if (emTemp.getTransaction().isActive()) {
                        emTemp.getTransaction().rollback();
                    }
                    this.tblStavke.rollBack();
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            }
            finally {
                if (emTemp.isOpen()) {
                    emTemp.close();
                }
            }
        }
    }

    private Dokument createDokumentGreska(Dokument dok) {
        Dokument gdok = null;
        try {
            gdok = (Dokument)BeanUtils.cloneBean((Object)dok);
            gdok.setOpis("Greska u knjizenju. Tip: " + gdok.getTip());
            gdok.setTip(TipDokumentConfig.get().DOKUMENT_GRESKA);
            gdok.setArtikaldokuments(null);
            gdok.setOpstidokument(null);
            gdok.setDtaksas(null);
            gdok.setIznos(new BigDecimal(0));
            gdok.setRadnajedinica(null);
            gdok.setKalkulacija(null);
            gdok.setFaktura(null);
            gdok.setFakturausluga(null);
            gdok.setInterniracun(null);
            gdok.setInterniracun1(null);
            gdok.setNivelacija(null);
            gdok.setKonsignacija(null);
            gdok.setStavkanzks(null);
            gdok.setDokument(null);
            gdok.setOriginal(null);
            gdok.setUslugadokuments(null);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        return gdok;
    }

    protected void actionPerformedicnIzmena(ActionEvent arg0) {
        try {
            if (this.tblStavke.getSelectedRow() == -1) {
                return;
            }
            this.getSession().putParameter("update", (Object)Boolean.TRUE);
            this.getSession().putParameter("stavka", (Object)PzEntityManager.find(Stavkanzk.class, (Object)((Stavkanzk)this.tblStavke.getSelectedEntity()).getId()));
            if (((Stavkanzk)this.tblStavke.getSelectedEntity()).getDokument() != null && ((Stavkanzk)this.tblStavke.getSelectedEntity()).getSfrKnjizenja() != null) {
                JOptionPane.showConfirmDialog((Component)((Object)this), "Ova opcija trenutno nije podr\u017eana. Morate prvo obrisati stavku pa je ponovo dodati.", "Obave\u0161tenje", -1, 1);
            } else {
                this.launchDialog(this.tableModelAkcije.getClassBySfr(1), (Stavkanzk)this.tblStavke.getSelectedEntity(), Boolean.TRUE, 1);
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void icnIzmenaOpisaactionPerformed(ActionEvent arg0) {
        if (this.tblStavke.getSelectedRow() == -1) {
            return;
        }
        this.showDialog(IzmenaOpisa.class);
        String opis = (String)this.getSession().getParameter("opis");
        if (opis != null) {
            this.getSession().putParameter("opis", null);
            Stavkanzk s = (Stavkanzk)this.tblStavke.getSelectedEntity();
            s.setOpis(opis);
            this.tblStavke.updateSelectedEntity((PzEntity)s, true);
        }
    }

    protected void icnStampaactionPerformed(ActionEvent arg0) {
        if (this.tblStavke.getRowCount() == 0) {
            return;
        }
        this.getSession().putParameter("arhiva", (Object)Boolean.FALSE);
        this.showDialog(IzborStampe.class);
    }

    protected void icnArhivaactionPerformed(ActionEvent arg0) {
        if (this.tblStavke.getRowCount() == 0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ne mo\u017eete arhivirati nalog koji nema ni jedan stav.");
            return;
        }
        if (this.dblSaldo.getVal() != 0.0) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ne mo\u017eete arhivirati nalog koji nije u ravnote\u017ei.");
            return;
        }
        this.getSession().putParameter("arhiva", (Object)Boolean.TRUE);
        this.getSession().putParameter("duguje", (Object)new BigDecimal(this.dblDuguje.getVal()));
        this.getSession().putParameter("potrazuje", (Object)new BigDecimal(this.dblPotrazuje.getVal()));
        this.showDialog(IzborStampe.class);
        if (IzborStampe.EXECUTED) {
            IzborStampe.EXECUTED = false;
            this.nzk.setArhiviran(Integer.valueOf(1));
            this.nzk.setDatum(IzborStampe.DATE);
            this.dispose();
        }
    }

    private void icnImportActionPerformed(ActionEvent arg0) {
        this.showDialog(PzDialogIzvodImport.class);
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        try {
            LockUtility.unLock(this.nzk);
            PzApplication.getApplication().getPropManager().saveObject((Object)new Integer(this.splitPane.getDividerLocation()), "nzk_div");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

