/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.finansije.engine.izvod.loaderImpl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import rs.pezar.finansije.engine.izvod.IzvodBanke;
import rs.pezar.finansije.engine.izvod.IzvodLoader;
import rs.pezar.finansije.engine.izvod.IzvodLoaderException;
import rs.pezar.finansije.engine.izvod.TransakcijaIzvodaBanke;
import rs.pezar.finansije.engine.izvod.loaderImpl.fxclient.Pmtnotification;
import rs.pezar.finansije.engine.izvod.loaderImpl.fxclient.Stmtrs;

public class FxClientLoader
implements IzvodLoader {
    private static final String FILE_EXCEPTION = "Gre\u0161ka prilikom u\u010ditavanja izvoda iz fajla. ";

    @Override
    public List<IzvodBanke> loadIzvodList(File izvod) throws IzvodLoaderException, JAXBException, SAXException, IOException, ParserConfigurationException {
        ArrayList<IzvodBanke> lipz = new ArrayList<IzvodBanke>();
        try {
            Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(izvod);
            NodeList list1 = d.getElementsByTagName("smtmtrs");
            NodeList list2 = d.getElementsByTagName("pmtnotification");
            int i = 0;
            while (i < list1.getLength()) {
                lipz.add(this.getStmtrs(list1.item(i)));
                ++i;
            }
            i = 0;
            while (i < list2.getLength()) {
                lipz.add(this.getPmtnotification(list2.item(i)));
                ++i;
            }
            if (lipz.size() == 0) {
                NodeList list3 = d.getElementsByTagName("stmtrs");
                int i2 = 0;
                while (i2 < list3.getLength()) {
                    lipz.add(this.getStmtrs(list3.item(i2)));
                    ++i2;
                }
            }
            if (lipz.size() == 0) {
                throw new IzvodLoaderException("Fajl ne sadr\u017ei ni jedan izvod banke. Uvoz nemogu\u0107!");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IzvodLoaderException("Gre\u0161ka prilikom u\u010ditavanja izvoda iz fajla. Fajl ne postoji.");
        }
        return lipz;
    }

    private IzvodBanke getStmtrs(Node izvod) throws JAXBException, IzvodLoaderException {
        IzvodBanke ipz = null;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Stmtrs.class});
        Unmarshaller u = jc.createUnmarshaller();
        Stmtrs ifx = (Stmtrs)u.unmarshal(izvod);
        if (ifx.getStatus().getCode() != 0) {
            throw new IzvodLoaderException("Izvod nije validan. Ponovite postupak preuzimanja izvoda od banke i njegov eksport u fajl.");
        }
        ipz = new IzvodBanke();
        ipz.setBrojRacuna(ifx.getAcctid());
        ipz.setPrethodnoStanje(ifx.getLedgerbal().getBalamt());
        ipz.setStanje(ifx.getAvailbal().getBalamt());
        ipz.setDatum(new Date(ifx.getAvailbal().getDtasof().toGregorianCalendar().getTime().getTime()));
        ipz.setValuta(ifx.getCurdef());
        ipz.setrBroj(ifx.getStmtnumber());
        if (ifx.getTrnlist() == null || ifx.getTrnlist().getStmttrn() == null || ifx.getTrnlist().getStmttrn().size() == 0) {
            return ipz;
        }
        ipz.setTransakcije(new ArrayList<TransakcijaIzvodaBanke>());
        for (Stmtrs.Trnlist.Stmttrn tfx : ifx.getTrnlist().getStmttrn()) {
            TransakcijaIzvodaBanke tpz = new TransakcijaIzvodaBanke();
            tpz.setIdTransakcije(tfx.getFitid());
            tpz.setStrana(tfx.getBenefit().equals("credit") ? "ODOBRENJE" : "ZADUZENJE");
            tpz.setNazivKomitenta(tfx.getPayeeinfo().getName());
            tpz.setSedisteKomitenta(tfx.getPayeeinfo().getCity());
            tpz.setBrojRacuna(tfx.getPayeeaccountinfo().getAcctid());
            tpz.setNazivBanke(tfx.getPayeeaccountinfo().getBankname());
            tpz.setIznos(tfx.getTrnamt());
            tpz.setValuta(tfx.getCurdef());
            tpz.setSvrhaPlacanja(tfx.getPurpose());
            tpz.setSifraPlacanja(String.valueOf(tfx.getPurposecode()));
            tpz.setDatumPlacanja(new Date(tfx.getDtposted().toGregorianCalendar().getTime().getTime()));
            tpz.setModel(tfx.getPayeerefmodel());
            tpz.setPozivNaBroj(tfx.getPayeerefnumber());
            tpz.setIzvod(ipz);
            ipz.getTransakcije().add(tpz);
        }
        return ipz;
    }

    private IzvodBanke getPmtnotification(Node izvod) throws JAXBException, IzvodLoaderException {
        IzvodBanke ipz = null;
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Pmtnotification.class});
        Unmarshaller u = jc.createUnmarshaller();
        Pmtnotification ifx = (Pmtnotification)u.unmarshal(izvod);
        if (ifx.getStatus().getCode() != 0) {
            throw new IzvodLoaderException("Izvod nije validan. Ponovite postupak preuzimanja izvoda od banke i njegov eksport u fajl.");
        }
        ipz = new IzvodBanke();
        ipz.setBrojRacuna(ifx.getAcctid());
        ipz.setPrethodnoStanje(ifx.getLedgerbal().getBalamt());
        ipz.setStanje(ifx.getAvailbal().getBalamt());
        ipz.setDatum(new Date(ifx.getAvailbal().getDtasof().toGregorianCalendar().getTime().getTime()));
        ipz.setValuta(ifx.getCurdef());
        ipz.setrBroj(ifx.getStmtnumber());
        if (ifx.getTrnlist() == null || ifx.getTrnlist().getStmttrn() == null || ifx.getTrnlist().getStmttrn().size() == 0) {
            return ipz;
        }
        ipz.setTransakcije(new ArrayList<TransakcijaIzvodaBanke>());
        for (Pmtnotification.Trnlist.Stmttrn tfx : ifx.getTrnlist().getStmttrn()) {
            TransakcijaIzvodaBanke tpz = new TransakcijaIzvodaBanke();
            tpz.setStrana(tfx.getBenefit().equals("credit") ? "ODOBRENJE" : "ZADUZENJE");
            tpz.setNazivKomitenta(tfx.getPayeeinfo().getName());
            tpz.setSedisteKomitenta(tfx.getPayeeinfo().getCity());
            tpz.setBrojRacuna(tfx.getPayeeaccountinfo().getAcctid());
            tpz.setNazivBanke(tfx.getPayeeaccountinfo().getBankname());
            tpz.setIznos(tfx.getTrnamt());
            tpz.setValuta(tfx.getCurdef());
            tpz.setSvrhaPlacanja(tfx.getPurpose());
            tpz.setSifraPlacanja(String.valueOf(tfx.getPurposecode()));
            tpz.setDatumPlacanja(new Date(tfx.getDtposted().toGregorianCalendar().getTime().getTime()));
            tpz.setModel(tfx.getPayeerefmodel());
            tpz.setPozivNaBroj(tfx.getPayeerefnumber());
            tpz.setIzvod(ipz);
            ipz.getTransakcije().add(tpz);
        }
        return ipz;
    }

    public static void main(String[] args) throws IzvodLoaderException, JAXBException, SAXException, IOException, ParserConfigurationException {
        File izvod = new File("E:\\Razmena\\izvod.xml");
        List<IzvodBanke> izvodi = new FxClientLoader().loadIzvodList(izvod);
        System.out.println(izvodi);
    }

    public String toString() {
        return "FX Client XML format";
    }
}

