/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application.session;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.TableState;

public class TableProperty
implements PropertySupport {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof JTable)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    @Override
    public Object getSessionState(Component c) {
        this.checkComponent(c);
        JTable table = (JTable)c;
        int[] columnWidths = new int[table.getColumnCount()];
        boolean resizableColumnExists = false;
        int i = 0;
        while (i < columnWidths.length) {
            TableColumn tc = table.getColumnModel().getColumn(i);
            int n = columnWidths[i] = tc.getResizable() ? tc.getWidth() : -1;
            if (tc.getResizable()) {
                resizableColumnExists = true;
            }
            ++i;
        }
        return resizableColumnExists ? new TableState(columnWidths) : null;
    }

    @Override
    public void setSessionState(Component c, Object state) {
        this.checkComponent(c);
        if (!(state instanceof TableState)) {
            throw new IllegalArgumentException("invalid state");
        }
        JTable table = (JTable)c;
        int[] columnWidths = ((TableState)state).getColumnWidths();
        if (table.getColumnCount() == columnWidths.length) {
            int i = 0;
            while (i < columnWidths.length) {
                TableColumn tc;
                if (columnWidths[i] != -1 && (tc = table.getColumnModel().getColumn(i)).getResizable()) {
                    tc.setPreferredWidth(columnWidths[i]);
                }
                ++i;
            }
        }
    }
}

