/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.View;
import org.jdesktop.application.utils.SwingHelper;

public abstract class SingleFrameApplication
extends Application {
    private static final String INITIALIZATION_MARKER = "SingleFrameApplication.initRootPaneContainer";
    private static final Logger logger = Logger.getLogger(SingleFrameApplication.class.getName());
    private FrameView mainView = null;

    public final JFrame getMainFrame() {
        return this.getMainView().getFrame();
    }

    protected final void setMainFrame(JFrame mainFrame) {
        this.getMainView().setFrame(mainFrame);
    }

    private String sessionFilename(Window window) {
        if (window == null) {
            return null;
        }
        String name = window.getName();
        return name == null ? null : String.valueOf(name) + ".session.xml";
    }

    protected void configureWindow(Window root) {
        this.getContext().getResourceMap().injectComponents(root);
    }

    private void initRootPaneContainer(RootPaneContainer c) {
        Window window;
        JFrame mainFrame;
        JRootPane rootPane = c.getRootPane();
        if (rootPane.getClientProperty(INITIALIZATION_MARKER) != null) {
            return;
        }
        rootPane.putClientProperty(INITIALIZATION_MARKER, Boolean.TRUE);
        Container root = rootPane.getParent();
        if (root instanceof Window) {
            this.configureWindow((Window)root);
        }
        if (c == (mainFrame = this.getMainFrame())) {
            mainFrame.addWindowListener(new MainFrameListener());
            mainFrame.setDefaultCloseOperation(0);
        } else if (root instanceof Window) {
            window = (Window)root;
            window.addHierarchyListener(new SecondaryWindowListener());
        }
        if (root instanceof JFrame) {
            root.addComponentListener(new FrameBoundsListener());
        }
        if (root instanceof Window) {
            String filename;
            window = (Window)root;
            if (!root.isValid() || root.getWidth() == 0 || root.getHeight() == 0) {
                window.pack();
            }
            if ((filename = this.sessionFilename((Window)root)) != null) {
                try {
                    this.getContext().getSessionStorage().restore(root, filename);
                }
                catch (Exception e) {
                    String msg = String.format("couldn't restore session [%s]", filename);
                    logger.log(Level.WARNING, msg, e);
                }
            }
            Point defaultLocation = SwingHelper.defaultLocation(window);
            if (!window.isLocationByPlatform() && (double)root.getX() == defaultLocation.getX() && (double)root.getY() == defaultLocation.getY()) {
                Dimension screenSize = window.getToolkit().getScreenSize();
                Dimension windowSIze = window.getSize();
                if (screenSize.getWidth() / windowSIze.getWidth() > 1.25 && screenSize.getHeight() / windowSIze.getHeight() > 1.25) {
                    Window owner = window.getOwner();
                    if (owner == null) {
                        owner = window != mainFrame ? mainFrame : null;
                    }
                    window.setLocationRelativeTo(owner);
                }
            }
        }
    }

    protected void show(JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException("null JComponent");
        }
        JFrame f = this.getMainFrame();
        f.getContentPane().add((Component)c, "Center");
        this.initRootPaneContainer(f);
        f.setVisible(true);
    }

    public void show(JDialog c) {
        if (c == null) {
            throw new IllegalArgumentException("null JDialog");
        }
        this.initRootPaneContainer(c);
        c.setVisible(true);
    }

    public void show(JFrame c) {
        if (c == null) {
            throw new IllegalArgumentException("null JFrame");
        }
        this.initRootPaneContainer(c);
        c.setVisible(true);
    }

    private void saveSession(Window window) {
        String filename = this.sessionFilename(window);
        if (filename != null) {
            try {
                this.getContext().getSessionStorage().save(window, filename);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "couldn't save session", e);
            }
        }
    }

    private boolean isVisibleWindow(Window w) {
        return w.isVisible() && (w instanceof JFrame || w instanceof JDialog || w instanceof JWindow);
    }

    private List<Window> getVisibleSecondaryWindows() {
        ArrayList<Window> rv = new ArrayList<Window>();
        Window[] windowArray = Window.getWindows();
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window window = windowArray[n2];
            if (this.isVisibleWindow(window)) {
                rv.add(window);
            }
            ++n2;
        }
        return rv;
    }

    @Override
    protected void shutdown() {
        if (this.isReady()) {
            for (Window window : this.getVisibleSecondaryWindows()) {
                this.saveSession(window);
            }
        }
    }

    public FrameView getMainView() {
        if (this.mainView == null) {
            this.mainView = new FrameView(this);
        }
        return this.mainView;
    }

    @Override
    public void show(View view) {
        if (this.mainView == null && view instanceof FrameView) {
            this.mainView = (FrameView)view;
        }
        RootPaneContainer c = (RootPaneContainer)((Object)view.getRootPane().getParent());
        this.initRootPaneContainer(c);
        ((Window)((Object)c)).setVisible(true);
    }

    @Override
    protected void end() {
        JFrame mainFrame = this.getMainFrame();
        if (mainFrame != null || mainFrame.isDisplayable()) {
            mainFrame.setVisible(false);
            mainFrame.dispose();
        }
        super.end();
    }

    private static class FrameBoundsListener
    implements ComponentListener {
        private FrameBoundsListener() {
        }

        private void maybeSaveFrameSize(ComponentEvent e) {
            JFrame f;
            if (e.getComponent() instanceof JFrame && ((f = (JFrame)e.getComponent()).getExtendedState() & 6) == 0) {
                SwingHelper.putWindowNormalBounds(f, f.getBounds());
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.maybeSaveFrameSize(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    private class MainFrameListener
    extends WindowAdapter {
        private MainFrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SingleFrameApplication.this.exit(e);
        }
    }

    private class SecondaryWindowListener
    implements HierarchyListener {
        private SecondaryWindowListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            Window secondaryWindow;
            if ((e.getChangeFlags() & 4L) != 0L && e.getSource() instanceof Window && !(secondaryWindow = (Window)e.getSource()).isShowing()) {
                SingleFrameApplication.this.saveSession(secondaryWindow);
            }
        }
    }
}

