/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ActionMap;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ProxyActions;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;

public class ApplicationActionMap
extends ActionMap {
    private final ApplicationContext context;
    private final ResourceMap resourceMap;
    private final Class actionsClass;
    private final Object actionsObject;
    private final List<ApplicationAction> proxyActions;

    public ApplicationActionMap(ApplicationContext context, Class actionsClass, Object actionsObject, ResourceMap resourceMap) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        if (actionsClass == null) {
            throw new IllegalArgumentException("null actionsClass");
        }
        if (actionsObject == null) {
            throw new IllegalArgumentException("null actionsObject");
        }
        if (!actionsClass.isInstance(actionsObject)) {
            throw new IllegalArgumentException("actionsObject not an instanceof actionsClass");
        }
        this.context = context;
        this.actionsClass = actionsClass;
        this.actionsObject = actionsObject;
        this.resourceMap = resourceMap;
        this.proxyActions = new ArrayList<ApplicationAction>();
        this.addAnnotationActions(resourceMap);
        this.maybeAddActionsPCL();
    }

    public final ApplicationContext getContext() {
        return this.context;
    }

    public final Class getActionsClass() {
        return this.actionsClass;
    }

    public final Object getActionsObject() {
        return this.actionsObject;
    }

    public List<ApplicationAction> getProxyActions() {
        ArrayList<ApplicationAction> allProxyActions = new ArrayList<ApplicationAction>(this.proxyActions);
        ActionMap parent = this.getParent();
        while (parent != null) {
            if (parent instanceof ApplicationActionMap) {
                allProxyActions.addAll(((ApplicationActionMap)parent).proxyActions);
            }
            parent = parent.getParent();
        }
        return Collections.unmodifiableList(allProxyActions);
    }

    private String aString(String s, String emptyValue) {
        return s.length() == 0 ? emptyValue : s;
    }

    private void putAction(String key, ApplicationAction action) {
        this.get(key);
        this.put(key, action);
    }

    private void addAnnotationActions(ResourceMap resourceMap) {
        Class actionsClass = this.getActionsClass();
        Method[] methodArray = actionsClass.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            Action action = m.getAnnotation(Action.class);
            if (action != null) {
                String methodName = m.getName();
                String enabledProperty = this.aString(action.enabledProperty(), null);
                String disabledProperty = this.aString(action.disabledProperty(), null);
                String selectedProperty = this.aString(action.selectedProperty(), null);
                String actionName = this.aString(action.name(), methodName);
                String taskService = this.aString(action.taskService(), "default");
                Task.BlockingScope block = action.block();
                if (enabledProperty != null && disabledProperty != null) {
                    throw new IllegalArgumentException("Action annotation contains both enabled and disabled attributes.");
                }
                boolean inverted = disabledProperty != null;
                ApplicationAction appAction = new ApplicationAction(this, resourceMap, actionName, m, inverted ? disabledProperty : enabledProperty, inverted, selectedProperty, taskService, block);
                this.putAction(actionName, appAction);
            }
            ++n2;
        }
        ProxyActions proxyActionsAnnotation = actionsClass.getAnnotation(ProxyActions.class);
        if (proxyActionsAnnotation != null) {
            String[] stringArray = proxyActionsAnnotation.value();
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String actionName = stringArray[n];
                ApplicationAction appAction = new ApplicationAction(this, resourceMap, actionName);
                appAction.setEnabled(false);
                this.putAction(actionName, appAction);
                this.proxyActions.add(appAction);
                ++n;
            }
        }
    }

    private void maybeAddActionsPCL() {
        boolean needsPCL = false;
        Object[] keys = this.keys();
        if (keys != null) {
            Object[] objectArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                ApplicationAction actionAdapter;
                Object key = objectArray[n2];
                javax.swing.Action value = this.get(key);
                if (value instanceof ApplicationAction && ((actionAdapter = (ApplicationAction)value).getEnabledProperty() != null || actionAdapter.getSelectedProperty() != null)) {
                    needsPCL = true;
                    break;
                }
                ++n2;
            }
            if (needsPCL) {
                try {
                    Class actionsClass = this.getActionsClass();
                    Method m = actionsClass.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                    m.invoke(this.getActionsObject(), new ActionsPCL());
                }
                catch (Exception e) {
                    String s = "addPropertyChangeListener undefined " + this.actionsClass;
                    throw new Error(s, e);
                }
            }
        }
    }

    private class ActionsPCL
    implements PropertyChangeListener {
        private ActionsPCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            Object[] keys = ApplicationActionMap.this.keys();
            if (keys != null) {
                Object[] objectArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    Object key = objectArray[n2];
                    javax.swing.Action value = ApplicationActionMap.this.get(key);
                    if (value instanceof ApplicationAction) {
                        ApplicationAction appAction = (ApplicationAction)value;
                        if (propertyName.equals(appAction.getEnabledProperty())) {
                            appAction.forwardPropertyChangeEvent(event, "enabled");
                        } else if (propertyName.equals(appAction.getSelectedProperty())) {
                            appAction.forwardPropertyChangeEvent(event, "selected");
                        }
                    }
                    ++n2;
                }
            }
        }
    }
}

