/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.gui;

import com.swtdesigner.FocusTraversalOnArray;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingx.JXStatusBar;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzArtikalDokument;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Proizvod;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.kasa.display.Display;
import rs.pezar.kasa.gui.ArhiviranjeNew;
import rs.pezar.kasa.gui.IzborDokumenta;
import rs.pezar.kasa.gui.IzborKomitenta;
import rs.pezar.kasa.gui.IzmenaStavke;
import rs.pezar.kasa.gui.PzDialogFaktura;
import rs.pezar.kasa.gui.PzDialogKonacniRacun;
import rs.pezar.kasa.gui.PzDialogPIN;
import rs.pezar.kasa.gui.PzDialogTaxMap;
import rs.pezar.kasa.gui.UzmiDokument;
import rs.pezar.kasa.gui.util.KasaGradientUtil;
import rs.pezar.kasa.gui.util.PzKasaUtil;
import rs.pezar.kasa.lpfr.LPFRException;
import rs.pezar.kasa.lpfr.model.InvoiceTransaction;
import rs.pezar.kasa.lpfr.rest.LPFRClient;
import rs.pezar.kasa.utility.BarcodeParser;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.event.PzShortcutListener;
import rs.pezar.swing.event.PzStanjeartikalChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldImpl;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.renderers.PzTableCellRenderer;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogIzradaMaloprodajnogRacunaNew
extends PzDialog {
    private static final long serialVersionUID = 1619875502080924638L;
    private PzPanel pnlContent;
    private JToolBar toolBar;
    private PzButton btnBrisanje;
    private PzButton btnBrisanjeSvega;
    private PzButton btnArhiva;
    private PzPanel pnlTable;
    private JScrollPane scp;
    private PzDateField dfDatum;
    private PzPanel pnlIznos;
    private JLabel lblStatus;
    private JXStatusBar statusBar;
    private PzTable table;
    private PzPanel pnlFields;
    private JLabel lblSifra;
    private PzTextField tfSifraProizvoda;
    private PzTextField tfNaziv;
    private PzDoubleField dfKolicina;
    private PzDoubleField dfCena;
    private JLabel lblNewLabel_1;
    private JLabel lblKolicina;
    private JLabel lblCena;
    private JLabel lblNewLabel_4;
    private JLabel lblNewLabel_5;
    private PzDoubleField dfProcRabata;
    private PzDoubleField dfIznosStavke;
    private PzButton btnDodaj;
    private JLabel lblBrojArtikala;
    private JLabel lblNewLabel_6;
    private PzDoubleField dfUkupno;
    private JEditorPane editorPane;
    private PzDialogIzradaMaloprodajnogRacunaNew thisDialog;
    private Radnajedinica rj;
    private boolean first;
    private Fiskalniracun racun;
    private Stanjeartikal a;
    private PzDoubleField dfRaspKol;
    private PzDoubleField dfCenaStanje;
    private JScrollPane scpEditor;
    private PzButton btnIzmena;
    private PzTableCellRenderer renderer;
    private String nacin;
    private Stanjeartikal artikal;
    private Artikal art;
    private PzButton btnPrekoSifre;
    private PzButton btnPrekoBarkoda;
    private PzButton btnPredracun;
    private BarcodeParser barcodeParser;
    private Komitent komitent;
    private boolean updateKolicine;
    private List<String> kolicinaCenaOrder;
    private Boolean eksterniDisplej;
    private PzButton btnTaxMap;
    private PzButton btnFaktura;
    private PzButton btnProfaktura;
    private PzButton btnKonacniRacun;
    public static String KASA_NACIN_SIFRA = "SIFRA";
    public static String KASA_NACIN_BARKOD = "BARKOD";
    public static String KASA_NACIN = "KASA_NACIN";

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogIzradaMaloprodajnogRacunaNew inst = new PzDialogIzradaMaloprodajnogRacunaNew(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogIzradaMaloprodajnogRacunaNew() {
        this.initGUI();
    }

    public PzDialogIzradaMaloprodajnogRacunaNew(JFrame frame) {
        super(frame);
        this.thisDialog = this;
        this.initGUI();
        this.nacin = (String)PzApplication.getApplication().getLocalMachineUserSettings().getProperty(KASA_NACIN);
        if (PzParameter.getParameterValue((String)"OBLIK_SIFRE", (String)"NUMERIK").equals("BARCODE")) {
            this.nacin = KASA_NACIN_BARKOD;
            this.btnPrekoSifre.setEnabled(false);
        }
        if (this.nacin == null || this.nacin.length() == 0) {
            this.nacin = KASA_NACIN_SIFRA;
        }
        if (!"stavka".equals(PzParameter.getParameterValue((String)"KASA_POPUST", (String)"")) || PzApplication.getApplication().getSession().getLoggedUser().getDozvola("POSEBNA DOZVOLA", "FAKTURA_PROMENA_RABATA") == null) {
            this.dfProcRabata.setEnabled(false);
        }
        if (PzApplication.getApplication().getSession().getLoggedUser().getDozvola("POSEBNA DOZVOLA", "FAKTURA_PROMENA_CENE") == null) {
            this.dfCena.setEnabled(false);
            this.dfCena.addKeyListener(this.createEnterKeyListener());
        }
        this.eksterniDisplej = PzParameter.getBoolean((String)"KASA_EKSTERNI_DISPLEJ", (boolean)true);
        this.barcodeParser = new BarcodeParser();
        this.barcodeParser.loadSettingsFromDB();
        this.setEnterAction();
        this.setShortcuts();
    }

    private void setShortcuts() {
        String arhivaShortcut = PzParameter.getParameterValue((String)"KASA_ARHIVA_SHORTCUT");
        if (arhivaShortcut != null && !"".equals(arhivaShortcut)) {
            this.btnArhiva.setText(this.btnArhiva.getText().replace("CTRL+W", arhivaShortcut));
            this.btnArhiva.setShortcut(arhivaShortcut);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Izrada maloprodajnog ra\u010duna u radnoj jedinici ");
            Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize((int)scrSize.getSize().getWidth() - 50, (int)scrSize.getSize().getHeight() - 50);
            this.setMinimumSize(new Dimension(1024, 600));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pnlContent = new PzPanel();
        GridBagLayout gbl_pnlContent = new GridBagLayout();
        this.getContentPane().add((Component)this.pnlContent, "Center");
        gbl_pnlContent.columnWeights = new double[]{1.0};
        gbl_pnlContent.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 0.0};
        this.pnlContent.setLayout((LayoutManager)gbl_pnlContent);
        this.toolBar = new JToolBar();
        this.toolBar.setOpaque(false);
        this.toolBar.setLayout(new FlowLayout(0, 5, 5));
        GridBagConstraints gbc_toolBar = new GridBagConstraints();
        gbc_toolBar.insets = new Insets(0, 0, 0, 0);
        gbc_toolBar.fill = 2;
        gbc_toolBar.gridx = 0;
        gbc_toolBar.gridy = 0;
        this.pnlContent.add((Component)this.toolBar, (Object)gbc_toolBar);
        this.btnIzmena = new PzButton();
        this.btnIzmena.setName("btnIzmena");
        this.btnIzmena.setOpaque(false);
        this.btnIzmena.setActionCommand("izmena");
        this.btnIzmena.addActionListener((ActionListener)((Object)this));
        this.btnIzmena.setShortcut("F3");
        this.btnIzmena.setFocusable(false);
        this.btnIzmena.setText("A\u017euriranje reda");
        this.btnIzmena.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/row_preferences.png")));
        this.toolBar.add((Component)this.btnIzmena);
        this.btnBrisanje = new PzButton();
        this.btnBrisanje.setName("btnBrisanje");
        this.btnBrisanje.setOpaque(false);
        this.btnBrisanje.setActionCommand("brisanje");
        this.btnBrisanje.addActionListener((ActionListener)((Object)this));
        this.btnBrisanje.setShortcut("ctrl+delete");
        this.btnBrisanje.setFocusable(false);
        this.btnBrisanje.setText("Brisanje reda");
        this.btnBrisanje.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/row_delete.png")));
        this.toolBar.add((Component)this.btnBrisanje);
        this.btnBrisanjeSvega = new PzButton();
        this.btnBrisanjeSvega.setName("btnBrisanjeSvega");
        this.btnBrisanjeSvega.setOpaque(false);
        this.btnBrisanjeSvega.setActionCommand("brisanjeSvega");
        this.btnBrisanjeSvega.addActionListener((ActionListener)((Object)this));
        this.btnBrisanjeSvega.setShortcut("CTRL+Q");
        this.btnBrisanjeSvega.setFocusable(false);
        this.btnBrisanjeSvega.setText("Brisanje svega");
        this.btnBrisanjeSvega.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/delete2.png")));
        this.toolBar.add((Component)this.btnBrisanjeSvega);
        this.btnArhiva = new PzButton();
        this.btnArhiva.setName("btnArhiva");
        this.btnArhiva.setOpaque(false);
        this.btnArhiva.setActionCommand("ArhivaStampa");
        this.btnArhiva.addActionListener((ActionListener)((Object)this));
        this.btnArhiva.setShortcut("CTRL+W");
        this.btnArhiva.setFocusable(false);
        this.btnArhiva.setText("Izdaj ra\u010dun");
        this.btnArhiva.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/cashier.png")));
        this.toolBar.add((Component)this.btnArhiva);
        this.btnPrekoSifre = new PzButton();
        this.btnPrekoSifre.setOpaque(false);
        this.btnPrekoSifre.setActionCommand("prekosifre");
        this.btnPrekoSifre.addActionListener((ActionListener)((Object)this));
        this.btnPrekoSifre.setShortcut("F11");
        this.btnPrekoSifre.setFocusable(false);
        this.btnPrekoSifre.setText("Unos preko|\u0161ifre(F11)");
        this.btnPrekoSifre.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/sifra.png")));
        this.toolBar.add((Component)this.btnPrekoSifre);
        this.btnPrekoBarkoda = new PzButton();
        this.btnPrekoBarkoda.setOpaque(false);
        this.btnPrekoBarkoda.setActionCommand("prekobarkoda");
        this.btnPrekoBarkoda.addActionListener((ActionListener)((Object)this));
        this.btnPrekoBarkoda.setShortcut("F12");
        this.btnPrekoBarkoda.setFocusable(false);
        this.btnPrekoBarkoda.setText("Unos preko|bar koda(F12)");
        this.btnPrekoBarkoda.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/barcode.png")));
        this.toolBar.add((Component)this.btnPrekoBarkoda);
        this.btnPredracun = new PzButton();
        this.btnPredracun.setOpaque(false);
        this.btnPredracun.setActionCommand("uzmipredracun");
        this.btnPredracun.addActionListener((ActionListener)((Object)this));
        this.btnPredracun.setShortcut("CTRL+P");
        this.btnPredracun.setFocusable(false);
        this.btnPredracun.setText("Uzmi predra\u010dun|(CTRL+P)");
        this.btnPredracun.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/index_up.png")));
        this.toolBar.add((Component)this.btnPredracun);
        this.btnProfaktura = new PzButton();
        this.btnProfaktura.setOpaque(false);
        this.btnProfaktura.setActionCommand("uzmiprofakturu");
        this.btnProfaktura.addActionListener((ActionListener)((Object)this));
        this.btnProfaktura.setShortcut("f10");
        this.btnProfaktura.setFocusable(false);
        this.btnProfaktura.setText("Uzmi profakturu|(f10)");
        this.btnProfaktura.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/index_up.png")));
        this.toolBar.add((Component)this.btnProfaktura);
        this.btnFaktura = new PzButton();
        this.btnFaktura.setOpaque(false);
        this.btnFaktura.setActionCommand("izdajfakturu");
        this.btnFaktura.addActionListener((ActionListener)((Object)this));
        this.btnFaktura.setShortcut("CTRL+F");
        this.btnFaktura.setFocusable(false);
        this.btnFaktura.setText("Izdaj fakturu|(CTRL+F)");
        this.btnFaktura.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/printer_preferences_small.png")));
        this.toolBar.add((Component)this.btnFaktura);
        this.btnKonacniRacun = new PzButton();
        this.btnKonacniRacun.setOpaque(false);
        this.btnKonacniRacun.setActionCommand("konacniracun");
        this.btnKonacniRacun.addActionListener((ActionListener)((Object)this));
        this.btnKonacniRacun.setShortcut("CTRL+K");
        this.btnKonacniRacun.setFocusable(false);
        this.btnKonacniRacun.setText("Konacni racun|(CTRL+K)");
        this.btnKonacniRacun.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/printer_preferences_small.png")));
        this.toolBar.add((Component)this.btnKonacniRacun);
        this.pnlTable = new PzPanel();
        this.pnlTable.setOpaque(false);
        GridBagConstraints gbc_pnlTable = new GridBagConstraints();
        gbc_pnlTable.insets = new Insets(10, 10, 10, 10);
        gbc_pnlTable.fill = 1;
        gbc_pnlTable.gridx = 0;
        gbc_pnlTable.gridy = 1;
        this.pnlContent.add((Component)this.pnlTable, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 5, 10), 0, 0));
        this.pnlTable.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.scp = new JScrollPane();
        this.pnlTable.add((Component)this.scp, (Object)"Center");
        this.table = new PzTable();
        this.renderer = new PzTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                renderer.setFont(new Font("SansSerif", 1, 18));
                return renderer;
            }
        };
        this.renderer.setDecimalFormat(3, PzFormatFactory.getKolicinaFormat());
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)this.renderer);
        this.table.setFocusable(false);
        this.table.setRowHeight(22);
        this.table.getTableHeader().setFont(new Font("SansSerif", 1, 20));
        this.table.getTableHeader().setFocusable(false);
        this.table.setSortable(false);
        this.scp.setViewportView((Component)this.table);
        this.pnlFields = new PzPanel();
        this.pnlFields.setOpaque(false);
        GridBagConstraints gbc_pnlFields = new GridBagConstraints();
        gbc_pnlFields.insets = new Insets(0, 10, 5, 10);
        gbc_pnlFields.fill = 1;
        gbc_pnlFields.gridx = 0;
        gbc_pnlFields.gridy = 2;
        this.pnlContent.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        GridBagLayout gbl_pnlFields = new GridBagLayout();
        gbl_pnlFields.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0};
        gbl_pnlFields.rowWeights = new double[]{0.0, 0.0, 0.0};
        int[] nArray = new int[3];
        nArray[0] = 7;
        nArray[1] = 7;
        gbl_pnlFields.rowHeights = nArray;
        gbl_pnlFields.columnWidths = new int[]{7, 7, 7, 7, 7, 7, 7};
        this.pnlFields.setLayout((LayoutManager)gbl_pnlFields);
        this.lblSifra = new JLabel("\u0160ifra:");
        this.lblSifra.setFont(new Font("SansSerif", 1, 16));
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        this.pnlFields.add((Component)this.lblSifra, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.lblNewLabel_1 = new JLabel("Naziv:");
        this.lblNewLabel_1.setFont(new Font("SansSerif", 1, 16));
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.anchor = 17;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_1.gridx = 1;
        gbc_lblNewLabel_1.gridy = 0;
        this.pnlFields.add((Component)this.lblNewLabel_1, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.lblKolicina = new JLabel("Koli\u010dina:");
        this.lblKolicina.setFont(new Font("SansSerif", 1, 16));
        GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
        gbc_lblNewLabel_2.anchor = 17;
        gbc_lblNewLabel_2.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_2.gridx = 2;
        gbc_lblNewLabel_2.gridy = 0;
        this.lblCena = new JLabel("Cena:");
        this.lblCena.setFont(new Font("SansSerif", 1, 16));
        GridBagConstraints gbc_lblNewLabel_3 = new GridBagConstraints();
        gbc_lblNewLabel_3.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_3.anchor = 17;
        gbc_lblNewLabel_3.gridx = 3;
        gbc_lblNewLabel_3.gridy = 0;
        this.lblNewLabel_4 = new JLabel("% popusta");
        this.lblNewLabel_4.setFont(new Font("SansSerif", 1, 16));
        GridBagConstraints gbc_lblNewLabel_4 = new GridBagConstraints();
        gbc_lblNewLabel_4.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_4.gridx = 4;
        gbc_lblNewLabel_4.gridy = 0;
        this.pnlFields.add((Component)this.lblNewLabel_4, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.lblNewLabel_5 = new JLabel("Iznos:");
        this.lblNewLabel_5.setFont(new Font("SansSerif", 1, 16));
        GridBagConstraints gbc_lblNewLabel_5 = new GridBagConstraints();
        gbc_lblNewLabel_5.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_5.gridx = 5;
        gbc_lblNewLabel_5.gridy = 0;
        this.pnlFields.add((Component)this.lblNewLabel_5, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.tfSifraProizvoda = new PzTextField();
        this.tfSifraProizvoda.addKeyListener(this.getSifraKeyListener());
        this.tfSifraProizvoda.setFKField(Stanjeartikal.class, PzArtikliBrowser.class, true, null);
        this.tfSifraProizvoda.setColumns(10);
        GridBagConstraints gbc_tfSifra = new GridBagConstraints();
        gbc_tfSifra.anchor = 17;
        gbc_tfSifra.insets = new Insets(0, 0, 0, 5);
        gbc_tfSifra.gridx = 0;
        gbc_tfSifra.gridy = 1;
        this.pnlFields.add((Component)this.tfSifraProizvoda, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.tfNaziv = new PzTextField();
        this.tfNaziv.setFocusable(false);
        this.tfNaziv.setEditable(false);
        this.tfNaziv.setColumns(20);
        GridBagConstraints gbc_tfNaziv = new GridBagConstraints();
        gbc_tfNaziv.anchor = 17;
        gbc_tfNaziv.insets = new Insets(0, 0, 0, 5);
        gbc_tfNaziv.gridx = 1;
        gbc_tfNaziv.gridy = 1;
        this.pnlFields.add((Component)this.tfNaziv, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.dfKolicina = new PzDoubleField();
        this.dfKolicina.addKeyListener(this.getSifraKeyListener());
        this.dfKolicina.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent arg0) {
                if (PzDialogIzradaMaloprodajnogRacunaNew.this.art.getTarifnaGrupa("PDV").getOznTarGr().startsWith("U")) {
                    return true;
                }
                if (PzDialogIzradaMaloprodajnogRacunaNew.this.rj.getTip().equals("EL") && PzDialogIzradaMaloprodajnogRacunaNew.this.rj.getMinusKolicine().equals("ZABRANJEN") && PzDialogIzradaMaloprodajnogRacunaNew.this.a.getRaspKolicina() - PzDialogIzradaMaloprodajnogRacunaNew.this.dfKolicina.getVal() < 0.0) {
                    PzSwingUtility.showErrorMessage((Component)((Object)PzDialogIzradaMaloprodajnogRacunaNew.this), (String)"Nema dovoljno raspolo\u017eive koli\u010dine!");
                    PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.requestFocusInWindow();
                    return false;
                }
                if (PzDialogIzradaMaloprodajnogRacunaNew.this.rj.getTip().equals("EL") && PzDialogIzradaMaloprodajnogRacunaNew.this.rj.getMinusKolicine().equals("DOZVOLJEN") && PzDialogIzradaMaloprodajnogRacunaNew.this.a.getRaspKolicina() - PzDialogIzradaMaloprodajnogRacunaNew.this.dfKolicina.getVal() < 0.0) {
                    PzDialogIzradaMaloprodajnogRacunaNew.this.editorPane.setText("Artikal " + PzDialogIzradaMaloprodajnogRacunaNew.this.a.getNaziv() + " nema dovoljno raspolo\u017eive koli\u010dine.");
                    return true;
                }
                return true;
            }
        });
        this.dfKolicina.setColumns(8);
        this.dfKolicina.addFocusListener(this.getFocusListener());
        this.dfKolicina.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
        this.dfKolicina.setVal((Object)new Double(1.0));
        this.dfKolicina.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent() == PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda) {
                    PzDialogIzradaMaloprodajnogRacunaNew.this.dfKolicinaFocusGained();
                }
            }
        });
        GridBagConstraints gbc_dfKolicina = new GridBagConstraints();
        gbc_dfKolicina.anchor = 18;
        gbc_dfKolicina.insets = new Insets(0, 0, 0, 5);
        gbc_dfKolicina.gridx = 2;
        gbc_dfKolicina.gridy = 1;
        this.dfCena = new PzDoubleField();
        this.dfCena.addKeyListener(this.getSifraKeyListener());
        this.dfCena.setColumns(8);
        this.dfCena.addFocusListener(this.getFocusListener());
        this.dfCena.setDecimalFormat(PzFormatFactory.getProdCenaFormat());
        GridBagConstraints gbc_dfCena = new GridBagConstraints();
        gbc_dfCena.insets = new Insets(0, 0, 0, 5);
        gbc_dfCena.anchor = 18;
        gbc_dfCena.gridx = 3;
        gbc_dfCena.gridy = 1;
        this.dfProcRabata = new PzDoubleField();
        this.dfProcRabata.addKeyListener(this.getSifraKeyListener());
        this.dfProcRabata.setColumns(8);
        this.dfProcRabata.addFocusListener(this.getFocusListener());
        this.dfProcRabata.setDecimalFormat(PzFormatFactory.getProcRabataFormat());
        GridBagConstraints gbc_dfPopust = new GridBagConstraints();
        gbc_dfPopust.insets = new Insets(0, 0, 0, 5);
        gbc_dfPopust.fill = 2;
        gbc_dfPopust.gridx = 4;
        gbc_dfPopust.gridy = 1;
        this.pnlFields.add((Component)this.dfProcRabata, (Object)new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.dfIznosStavke = new PzDoubleField();
        this.dfIznosStavke.setFocusable(false);
        this.dfIznosStavke.setEditable(false);
        this.dfIznosStavke.setColumns(8);
        this.dfIznosStavke.setDecimalFormat(PzFormatFactory.getIznosFormat());
        GridBagConstraints gbc_dfIznos = new GridBagConstraints();
        gbc_dfIznos.insets = new Insets(0, 0, 0, 5);
        gbc_dfIznos.fill = 2;
        gbc_dfIznos.gridx = 5;
        gbc_dfIznos.gridy = 1;
        this.pnlFields.add((Component)this.dfIznosStavke, (Object)new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.btnDodaj = new PzButton();
        this.btnDodaj.setActionCommand("potvrdi");
        this.btnDodaj.addActionListener((ActionListener)((Object)this));
        this.btnDodaj.setText("Dodaj");
        this.btnDodaj.setIcon((Icon)new ImageIcon(PzDialogIzradaMaloprodajnogRacunaNew.class.getResource("/rs/pezar/kasa/resource/img/check.png")));
        GridBagConstraints gbc_btnDodaj = new GridBagConstraints();
        gbc_btnDodaj.anchor = 17;
        gbc_btnDodaj.gridx = 6;
        gbc_btnDodaj.gridy = 1;
        this.pnlFields.add((Component)this.btnDodaj, (Object)new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.dfRaspKol = new PzDoubleField();
        this.dfRaspKol.setFocusable(false);
        this.dfRaspKol.setEditable(false);
        this.dfRaspKol.setColumns(8);
        this.dfRaspKol.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
        this.dfCenaStanje = new PzDoubleField();
        this.dfCenaStanje.setEditable(false);
        this.dfCenaStanje.setFocusable(false);
        this.dfCenaStanje.setColumns(8);
        this.dfCenaStanje.setDecimalFormat(PzFormatFactory.getProdCenaFormat());
        this.editorPane = new JEditorPane();
        this.editorPane.setEditorKit(new HTMLEditorKit());
        this.editorPane.setFont(new Font("SansSerif", 1, 20));
        this.editorPane.setPreferredSize(new Dimension(100, 50));
        PzKasaUtil.setTxtComponent(this.editorPane);
        GridBagConstraints gbc_textArea = new GridBagConstraints();
        gbc_textArea.insets = new Insets(0, 10, 5, 10);
        gbc_textArea.fill = 1;
        gbc_textArea.gridx = 0;
        gbc_textArea.gridy = 4;
        this.scpEditor = new JScrollPane();
        this.pnlContent.add((Component)this.scpEditor, (Object)gbc_textArea);
        this.scpEditor.setViewportView(this.editorPane);
        this.statusBar = new JXStatusBar();
        this.pnlContent.add((Component)this.statusBar, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.lblStatus = new JLabel("Broj artikala");
        this.statusBar.add((Component)this.lblStatus);
        this.lblBrojArtikala = new JLabel("0");
        this.statusBar.add((Component)this.lblBrojArtikala);
        this.pnlIznos = new PzPanel();
        this.pnlIznos.setOpaque(false);
        GridBagLayout pnlIznosLayout = new GridBagLayout();
        this.pnlContent.add((Component)this.pnlIznos, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        pnlIznosLayout.rowWeights = new double[]{0.1};
        pnlIznosLayout.rowHeights = new int[]{7};
        pnlIznosLayout.columnWeights = new double[]{0.1, 0.1, 0.0};
        int[] nArray2 = new int[3];
        nArray2[0] = 7;
        nArray2[1] = 7;
        pnlIznosLayout.columnWidths = nArray2;
        this.pnlIznos.setLayout((LayoutManager)pnlIznosLayout);
        this.pnlIznos.setBorder(BorderFactory.createEmptyBorder(2, 10, 5, 10));
        this.dfDatum = new PzDateField();
        this.dfDatum.setFont(new Font("SansSerif", 1, 14));
        this.dfDatum.setFocusable(false);
        this.dfDatum.setEditable(false);
        this.dfDatum.setColumns(8);
        JLabel lblVerzija = new JLabel("PEZAR ESIR VERZIJA : 8/1.0   SERIJSKI BROJ : " + PzKasaUtil.getSN());
        lblVerzija.setFont(new Font("SansSerif", 1, 18));
        this.pnlIznos.add((Component)lblVerzija, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.lblNewLabel_6 = new JLabel("Ukupno:");
        this.lblNewLabel_6.setFont(new Font("SansSerif", 1, 16));
        GridBagConstraints gbc_lblNewLabel_6 = new GridBagConstraints();
        gbc_lblNewLabel_6.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel_6.anchor = 13;
        gbc_lblNewLabel_6.gridx = 1;
        gbc_lblNewLabel_6.gridy = 0;
        this.pnlIznos.add((Component)this.lblNewLabel_6, (Object)gbc_lblNewLabel_6);
        this.dfUkupno = new PzDoubleField();
        this.dfUkupno.setFont(new Font("SansSerif", 1, 18));
        this.dfUkupno.setFocusable(false);
        this.dfUkupno.setEditable(false);
        this.dfUkupno.setColumns(10);
        GridBagConstraints gbc_dfUkupno = new GridBagConstraints();
        gbc_dfUkupno.anchor = 13;
        gbc_dfUkupno.gridx = 2;
        gbc_dfUkupno.gridy = 0;
        this.pnlIznos.add((Component)this.dfUkupno, (Object)gbc_dfUkupno);
        this.addKolicinaCenaFields();
        this.setShortcutListener(this.createShortcutListener());
        this.registerShortcuts(new String[]{"ctrl+alt+b"});
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.requestFocusInWindow();
            }
        });
    }

    private void addKolicinaCenaFields() {
        String strFocus = PzParameter.getParameterValue((String)"KASA_FOCUS", (String)"dfKolicina dfCena");
        String[] strArr = strFocus.split("\\s+");
        this.kolicinaCenaOrder = Arrays.asList(strArr);
        int kolicinax = this.kolicinaCenaOrder.indexOf("dfKolicina") + 2;
        int cenax = this.kolicinaCenaOrder.indexOf("dfCena") + 2;
        this.pnlFields.add((Component)this.dfKolicina, (Object)new GridBagConstraints(kolicinax, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.pnlFields.add((Component)this.lblKolicina, (Object)new GridBagConstraints(kolicinax, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.pnlFields.add((Component)this.dfRaspKol, (Object)new GridBagConstraints(kolicinax, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.pnlFields.add((Component)this.dfCena, (Object)new GridBagConstraints(cenax, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.pnlFields.add((Component)this.lblCena, (Object)new GridBagConstraints(cenax, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.pnlFields.add((Component)this.dfCenaStanje, (Object)new GridBagConstraints(cenax, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
    }

    protected void dfKolicinaFocusGained() {
        if (BDConverter.getProdCena((double)this.dfCena.getVal()).equals(BDConverter.getProdCena((double)0.0)) || BDConverter.getKolicina((double)this.dfKolicina.getVal()).equals(BDConverter.getKolicina((double)0.0))) {
            this.dfCena.setEnabled(true);
            return;
        }
        if (!this.nacin.equals("SIFRA")) {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            try {
                try {
                    this.dodajArtikal(em);
                }
                catch (Exception e) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Throwable)e);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }

    private KeyListener getSifraKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 127) {
                    PzDialogIzradaMaloprodajnogRacunaNew.this.brisiRed();
                } else if (e.getSource() == PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda && e.getKeyCode() != 10) {
                    PzDialogIzradaMaloprodajnogRacunaNew.this.dfCena.setVal((Object)new Double(0.0));
                }
            }
        };
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Stanjeartikal) {
            this.a = (Stanjeartikal)entity;
            this.setArtikalData(this.a);
        }
    }

    private PzShortcutListener createShortcutListener() {
        return new PzShortcutListener(){

            public void actionPerformed(PzShortcutListener.PzShortcutEvent evt) {
                if (evt.getShortcut().equals("ctrl+alt+b")) {
                    Boolean bezKase = (Boolean)PzDialogIzradaMaloprodajnogRacunaNew.this.getSession().getParameter("bez_kase");
                    if (!bezKase.booleanValue()) {
                        int izbor = PzSwingUtility.daNeDijalog((Component)((Object)PzDialogIzradaMaloprodajnogRacunaNew.this), (Object)"Pokrenuli ste akciju za prelazak na re\u017eim bez fiskalnog \u0161tampa\u010da!\nSvaki ra\u010dun koji izradite u ovom re\u017eimu ne\u0107e pro\u0107i kroz fiskalni \u0161tampa\u010d!\nDa li ste sigurni da \u017eelite da nastavite?", (String)"Ra\u010dun bez \u0161tampa\u010da", null, (boolean)true);
                        if (izbor != 0) {
                            return;
                        }
                        PzDialogIzradaMaloprodajnogRacunaNew.this.getSession().putParameter("bez_kase", (Object)Boolean.TRUE);
                        PzDialogIzradaMaloprodajnogRacunaNew.this.pnlContent.setGradient(Color.WHITE, Color.RED, PzPanel.GRADIENT_WEST_EAST);
                        PzDialogIzradaMaloprodajnogRacunaNew.this.pnlContent.repaint();
                    } else {
                        PzDialogIzradaMaloprodajnogRacunaNew.this.getSession().putParameter("bez_kase", (Object)Boolean.FALSE);
                        PzDialogIzradaMaloprodajnogRacunaNew.this.pnlContent.setGradient(Color.WHITE, Color.BLUE, PzPanel.GRADIENT_WEST_EAST);
                        PzDialogIzradaMaloprodajnogRacunaNew.this.pnlContent.repaint();
                    }
                }
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent e) {
        block38: {
            em = PzEntityManagerFactory.getInstance().createEm();
            try {
                block39: {
                    button = (PzButton)e.getSource();
                    actionCommand = button.getActionCommand();
                    if (actionCommand.equals("potvrdi")) {
                        this.dodajArtikal(em);
                        break block38;
                    }
                    if (!actionCommand.equals("izmena")) break block39;
                    if (this.table.getSelectedEntity() == null) lbl-1000:
                    // 3 sources

                    {
                        return;
                    }
                    this.getSession().putParameter("kasa_table", (Object)this.table);
                    this.showDialog(IzmenaStavke.class);
                    this.refreshIznos();
                    ** GOTO lbl-1000
                }
                if (actionCommand.equals("prekosifre")) {
                    PzApplication.getApplication().getLocalMachineUserSettings().setProperty(PzDialogIzradaMaloprodajnogRacunaNew.KASA_NACIN, (Object)PzDialogIzradaMaloprodajnogRacunaNew.KASA_NACIN_SIFRA);
                    this.nacin = PzDialogIzradaMaloprodajnogRacunaNew.KASA_NACIN_SIFRA;
                    this.resetDialogData();
                    break block38;
                }
                if (actionCommand.equals("prekobarkoda")) {
                    PzApplication.getApplication().getLocalMachineUserSettings().setProperty(PzDialogIzradaMaloprodajnogRacunaNew.KASA_NACIN, (Object)PzDialogIzradaMaloprodajnogRacunaNew.KASA_NACIN_BARKOD);
                    this.nacin = PzDialogIzradaMaloprodajnogRacunaNew.KASA_NACIN_BARKOD;
                    this.resetDialogData();
                    break block38;
                }
                if (actionCommand.equals("brisanjeSvega")) {
                    if (this.table.getRowCount() != 0) ** break;
                    ** continue;
                    rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)this), "Da li ste sigurni?!", "Brisanje", 0);
                    if (rez == 0) {
                        em.getTransaction().begin();
                        racZaBrisanje = (Fiskalniracun)em.find(Fiskalniracun.class, (Object)this.racun.getIdDok());
                        PzKasaUtil.setIznosRacuna(racZaBrisanje);
                        racZaBrisanje.setGotovina(racZaBrisanje.getIznos());
                        racZaBrisanje.setArhiviran((short)-1);
                        racZaBrisanje.setTip("FISKALNI_RACUN");
                        if (racZaBrisanje.getDokument() != null) {
                            racZaBrisanje.getDokument().setArhiviran((short)-1);
                        }
                        if (this.updateKolicine) {
                            for (Proizvodfiskalniracun p : this.racun.getProizvodfiskalniracuns()) {
                                s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(p.getId().getSfrProizvod(), this.rj));
                                s.setAlocKolicina(s.getAlocKolicina() - p.getKolicina());
                            }
                        }
                        this.createFiskalniRacun(em);
                        em.getTransaction().commit();
                        this.refreshDataTable();
                        this.emptyFields(true);
                        this.refreshIznos();
                        this.tfSifraProizvoda.requestFocus();
                    }
                    break block38;
                }
                if (actionCommand.equals("brisanje")) {
                    this.brisiRed();
                    break block38;
                }
                if (actionCommand.equals("ArhivaStampa")) {
                    if (this.racun.getProizvodfiskalniracuns().size() == 0) {
                        PzSwingUtility.showInformationMessage((Component)this, (String)"Izdavanje ra\u010duna nije mogu\u0107e jer nema podataka.");
                    } else {
                        Display.instance().displayTotal(this.dfUkupno.getBigDecimal());
                        this.racun.setIznos(this.dfUkupno.getBigDecimal());
                        this.getSession().putParameter("racun", (Object)this.racun);
                        this.getSession().putParameter("parameter", (Object)"izradaRacuna");
                        this.getSession().putParameter("updateKolicine", (Object)this.updateKolicine);
                        this.showDialog(ArhiviranjeNew.class);
                    }
                    break block38;
                }
                if (actionCommand.equals("izdajfakturu")) {
                    if (this.racun.getProizvodfiskalniracuns().size() == 0) {
                        PzSwingUtility.showInformationMessage((Component)this, (String)"Izdavanje ra\u010duna nije mogu\u0107e jer nema podataka.");
                    } else {
                        this.getSession().putParameter("racun", (Object)this.racun);
                        this.getSession().putParameter("updateKolicine", (Object)this.updateKolicine);
                        this.showDialog(PzDialogFaktura.class);
                    }
                    break block38;
                }
                if (!actionCommand.equals("konacniracun")) ** GOTO lbl87
                if (this.racun.getProizvodfiskalniracuns().size() == 0) {
                    PzSwingUtility.showInformationMessage((Component)this, (String)"Izdavanje ra\u010duna nije mogu\u0107e jer nema podataka.");
                    break block38;
                }
                k = IzborKomitenta.getKomitent(this);
                if (k == null) {
                    return;
                }
                try {
                    this.getSession().putParameter("komitent", (Object)k);
                    this.getSession().putParameter("racun", (Object)this.racun);
                    this.getSession().putParameter("updateKolicine", (Object)this.updateKolicine);
                    this.showDialog(PzDialogKonacniRacun.class);
                    break block38;
lbl87:
                    // 1 sources

                    if (actionCommand.equals("nefiskal")) {
                        if (this.racun.getProizvodfiskalniracuns().size() == 0) {
                            PzSwingUtility.showInformationMessage((Component)this, (String)"\u0160tampanje predra\u010duna nije dozvoljeno jer isti nema stavke");
                        } else {
                            PzKasaUtil.stampajRacun((PzDokument)this.racun, true, null);
                        }
                    } else if (actionCommand.equals("uzmipredracun")) {
                        predracun = IzborDokumenta.getFiskalniracun(this, this.racun.getRadnajedinica(), Arrays.asList(new InvoiceTransaction[]{InvoiceTransaction.PROFORMA_SALE}));
                        if (predracun != null) {
                            this.racun.kopirajArtikleSaRacuna(predracun);
                            PzEntityManager.update((Object)this.racun);
                            this.refreshDataTable();
                            this.refreshIznos();
                        }
                    } else if (actionCommand.equals("uzmiprofakturu")) {
                        this.komitent = IzborKomitenta.getKomitent(this);
                        if (this.komitent != null) {
                            this.getSession().putParameter("komitent", (Object)this.komitent);
                            this.getSession().putParameter("racun", (Object)this.racun);
                            this.showDialog(UzmiDokument.class);
                            this.refreshDataTable();
                            this.refreshIznos();
                        }
                    } else if (actionCommand.equals("poreskestope")) {
                        this.showDialog(PzDialogTaxMap.class);
                    }
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    this.table.rollBack();
                    PzMysqlExceptionHandler.handle((Component)this, (Throwable)e1);
                }
            }
            finally {
                em.close();
            }
        }
    }

    private void dodajArtikal(EntityManager em) {
        if (!this.validateForm(true)) {
            return;
        }
        Proizvodfiskalniracun proizvod = this.racun.getProizvod(this.artikal.getId().getSfrProizvod(), this.racun.getIdDok(), this.dfCena.getVal().doubleValue(), this.dfProcRabata.getVal().doubleValue());
        em.getTransaction().begin();
        Stanje s = null;
        if (!this.tfSifraProizvoda.getVal().startsWith("U") && this.updateKolicine) {
            s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(this.artikal.getId().getSfrProizvod(), this.rj));
            if (s == null) {
                s = new Stanje();
                s.setId(new StanjePK(this.artikal.getId().getSfrProizvod(), this.rj));
                s.setAlocKolicina(s.getAlocKolicina() + this.dfKolicina.getVal());
                s.setArtikal(this.art);
                em.persist((Object)s);
            } else {
                s.setAlocKolicina(s.getAlocKolicina() + this.dfKolicina.getVal());
            }
        }
        proizvod = new Proizvodfiskalniracun();
        Proizvod p = (Proizvod)em.find(Proizvod.class, (Object)this.artikal.getId().getSfrProizvod());
        proizvod.init(this.racun, p);
        proizvod.setKolicina(this.dfKolicina.getVal().doubleValue());
        proizvod.setBliziOpis(this.a != null ? this.a.getBliziOpis() : "");
        proizvod.setJm(this.a != null ? this.a.getJedMere() : "");
        proizvod.setNaziv(this.tfNaziv.getVal());
        proizvod.setProcRabata(this.dfProcRabata.getVal().doubleValue());
        proizvod.setRabat(this.dfCena.getVal() * proizvod.getKolicina() * proizvod.getProcRabata() / 100.0);
        proizvod.setCena(this.dfCena.getVal() - this.dfCena.getVal() * proizvod.getProcRabata() / 100.0);
        proizvod.setDobSifra(this.a.getDobSifra());
        this.table.insert((PzEntity)proizvod, em);
        em.getTransaction().commit();
        this.table.commitInsert();
        this.emptyFields(true);
        this.refreshIznos();
        this.tfSifraProizvoda.requestFocusInWindow();
    }

    private boolean validateForm(boolean b) {
        Boolean res = false;
        if (this.tfSifraProizvoda.getText().equals("") || this.dfKolicina.getVal() == 0.0 || this.dfCena.getVal() == 0.0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.getText().equals("")) {
                        PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.requestFocusInWindow();
                    } else if (PzDialogIzradaMaloprodajnogRacunaNew.this.dfKolicina.getVal() == 0.0) {
                        PzDialogIzradaMaloprodajnogRacunaNew.this.dfKolicina.requestFocusInWindow();
                    } else if (PzDialogIzradaMaloprodajnogRacunaNew.this.dfCena.getVal() == 0.0) {
                        PzDialogIzradaMaloprodajnogRacunaNew.this.dfCena.requestFocusInWindow();
                    }
                }
            });
        } else if (!this.isKolicinaValid()) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Greska. Kolicina nije ispravna!");
            this.dfKolicina.requestFocusInWindow();
        } else {
            res = true;
        }
        return res;
    }

    private boolean isKolicinaValid() {
        if (this.dfKolicina.getVal() < 0.0) {
            return false;
        }
        if (this.dfKolicina.getVal() % 1.0 == 0.0) {
            return this.dfKolicina.getVal().toString().length() < 7;
        }
        return this.dfKolicina.getVal().toString().length() < 6;
    }

    private void brisiRed() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            if (this.table.getSelectedEntity() == null) {
                return;
            }
            int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0);
            if (rez != 0) {
                return;
            }
            try {
                Stanje s;
                em.getTransaction().begin();
                Proizvodfiskalniracun proizvod = (Proizvodfiskalniracun)this.table.getSelectedEntity();
                if (this.updateKolicine && (s = (Stanje)em.find(Stanje.class, (Object)new StanjePK(proizvod.getId().getSfrProizvod(), this.rj))) != null) {
                    s.setAlocKolicina(s.getAlocKolicina() - proizvod.getKolicina());
                }
                this.table.removeSelectedEntity(false, em);
                em.getTransaction().commit();
                this.table.commitRemove();
                this.refreshIznos();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
        finally {
            em.close();
        }
    }

    public void resetDialogData() {
        this.tfSifraProizvoda.setText(null);
        this.tfNaziv.setText(null);
        this.tfSifraProizvoda.requestFocusInWindow();
        this.dfCena.setVal((Object)BigDecimal.ZERO);
        this.dfCenaStanje.setVal((Object)BigDecimal.ZERO);
        this.dfIznosStavke.setVal((Object)BigDecimal.ZERO);
        this.dfKolicina.setVal((Object)BigDecimal.ONE);
        this.dfProcRabata.setVal((Object)BigDecimal.ZERO);
        this.dfRaspKol.setVal((Object)BigDecimal.ZERO);
        this.dfUkupno.setVal((Object)BigDecimal.ZERO);
        this.art = null;
        this.setDependentEntityChecker();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldBeShown() {
        this.pnlContent.setPaintGradient(true);
        this.pnlContent.setGradient(KasaGradientUtil.MALOPRODAJNI_RACUN_GRADIENT);
        this.getSession().putParameter("gradient", (Object)KasaGradientUtil.MALOPRODAJNI_RACUN_GRADIENT);
        this.rj = PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf('E')});
        if (this.rj == null) {
            return false;
        }
        this.getSession().putParameter("kasa_rj", (Object)this.rj);
        if (this.rj.getRefRadnajedinica() != null) {
            this.tfSifraProizvoda.setParamToPass((Object)this.rj.getRefRadnajedinica());
        } else {
            this.tfSifraProizvoda.setParamToPass((Object)this.rj);
        }
        this.setDependentEntityChecker();
        this.updateKolicine = this.rj.getpTip().equals("L") ? true : (this.rj.getpTip().equals("V") ? PzParameter.getBoolean((String)"KOLICINE_U_VRED_PROD", (boolean)false).booleanValue() : true);
        this.setTitle("Izrada maloprodajnog ra\u010duna iz: " + this.rj.getPunNaziv());
        try {
            LPFRClient lpfr = new LPFRClient();
            String attention = lpfr.attention();
            if (!"".equals(attention)) {
                if (!"1500".equals(attention)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), LPFRClient.getMessage(attention), "L-PFR greska", 0);
                    return false;
                }
                String pin = PzDialogPIN.getPIN(this);
                if (pin == null) {
                    return false;
                }
                String response = lpfr.verifyPIN(pin);
                if (!"0100".equals(response)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), response, "L-PFR greska", 0);
                    return false;
                }
                PzApplication.getApplication().getLocalMachineUserSettings().setProperty("LPFR_PIN", (Object)pin);
            }
            PzDialogTaxMap.checkRates(this);
        }
        catch (LPFRException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), e.getFullMessage(), "L-PFR greska", 0);
            return false;
        }
        this.dfDatum.setVal(PzApplication.getApplication().getSession().getRuntimeStore().get("KASA_DATUM"));
        this.first = false;
        if (this.getFiskalniRacun().booleanValue()) {
            this.dfUkupno.setVal((Object)this.racun.getIznosRacuna());
        } else {
            EntityManager em = PzEntityManagerFactory.getInstance().createEm();
            em.getTransaction().begin();
            try {
                try {
                    this.createFiskalniRacun(em);
                    em.getTransaction().commit();
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    em.close();
                    return false;
                }
            }
            finally {
                em.close();
            }
        }
        this.refreshDataTable();
        Display.initialize();
        if (this.table.getDataSize() != 0) {
            this.table.setRowSelectionInterval(0, 0);
            Display.instance().displayLine((PzArtikalDokument)this.table.getSelectedEntity(), this.dfUkupno.getBigDecimal());
        }
        this.getSession().putParameter("bez_kase", (Object)Boolean.FALSE);
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PzDialogIzradaMaloprodajnogRacunaNew.this.lblBrojArtikala.setText("" + PzDialogIzradaMaloprodajnogRacunaNew.this.table.getRowCount());
                        Display.instance().displayLine((PzArtikalDokument)((Proizvodfiskalniracun)PzDialogIzradaMaloprodajnogRacunaNew.this.table.getSelectedEntity()), PzDialogIzradaMaloprodajnogRacunaNew.this.dfUkupno.getBigDecimal());
                    }
                });
            }
        });
        return true;
    }

    void setDependentEntityChecker() {
        if (!this.nacin.equals(KASA_NACIN_SIFRA)) {
            this.lblSifra.setText("Bar kod:");
            this.tfSifraProizvoda.setEntityChecker(new PzEntityChecker(){

                public PzEntity getEntity() {
                    try {
                        Stanjeartikal a = null;
                        if (PzDialogIzradaMaloprodajnogRacunaNew.this.barcodeParser.isTBarkod(PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.getText())) {
                            String sfr = PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.getText();
                            PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.setText((String)PzDialogIzradaMaloprodajnogRacunaNew.this.barcodeParser.getTValue(sfr, 1));
                            PzDialogIzradaMaloprodajnogRacunaNew.this.dfKolicina.setVal(PzDialogIzradaMaloprodajnogRacunaNew.this.barcodeParser.getTValue(sfr, 2));
                        } else if (PzDialogIzradaMaloprodajnogRacunaNew.this.barcodeParser.isCBarkod(PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.getText())) {
                            String sfr = PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.getText();
                            PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.setText((String)PzDialogIzradaMaloprodajnogRacunaNew.this.barcodeParser.getCValue(sfr, 1));
                            a = (Stanjeartikal)PzEntityManager.getList((String)("SELECT a FROM Stanjeartikal a WHERE a.barKod='" + PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.getVal() + "' AND a.id.oznRj='" + PzDialogIzradaMaloprodajnogRacunaNew.this.rj.getId().getOznRj() + "'")).get(0);
                            a.setProdCena(((Double)PzDialogIzradaMaloprodajnogRacunaNew.this.barcodeParser.getCValue(sfr, 3)).doubleValue());
                        }
                        if (a == null) {
                            a = (Stanjeartikal)PzEntityManager.getList((String)("SELECT a FROM Stanjeartikal a WHERE a.barKod='" + PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda.getVal() + "' AND a.id.oznRj='" + PzDialogIzradaMaloprodajnogRacunaNew.this.rj.getId().getOznRj() + "'")).get(0);
                        }
                        return a;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogIzradaMaloprodajnogRacunaNew.this), (Throwable)e);
                    }
                    return null;
                }
            });
        } else {
            this.lblSifra.setText("\u0160ifra:");
            this.tfSifraProizvoda.setEntityChecker((PzEntityChecker)new PzStanjeartikalChecker((PzField)this.tfSifraProizvoda, this.rj));
        }
    }

    public Boolean getFiskalniRacun() {
        Boolean res = false;
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                Query q = null;
                q = em.createQuery("SELECT f FROM Fiskalniracun f where f.arhiviran=0 and f.radnajedinica=:rj and f.pzuser=:user");
                q.setParameter("rj", (Object)this.rj);
                q.setParameter("user", (Object)PzApplication.getApplication().getSession().getLoggedUser());
                if (q.getResultList().size() != 0) {
                    this.racun = (Fiskalniracun)q.getResultList().get(0);
                    res = true;
                }
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
        return res;
    }

    public void createFiskalniRacun(EntityManager em) throws Exception {
        this.racun = new Fiskalniracun();
        Calendar cal = Calendar.getInstance();
        int sat = cal.get(11);
        int min = cal.get(12);
        int sec = cal.get(13);
        cal.setTime(PzDateUtility.getServerTime());
        cal.set(11, sat);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, 0);
        Timestamp datum = new Timestamp(cal.getTimeInMillis());
        this.racun.setVreme(datum);
        this.racun.setRadnajedinica(this.rj);
        this.racun.setTaksafiskalniracuns(new ArrayList());
        this.racun.setGotovina(BigDecimal.ZERO);
        this.racun.setCekovi(BigDecimal.ZERO);
        this.racun.setKartice(BigDecimal.ZERO);
        this.racun.setVirman(BigDecimal.ZERO);
        this.racun.setVaucer(BigDecimal.ZERO);
        this.racun.setOstalo(BigDecimal.ZERO);
        this.racun.setIps(BigDecimal.ZERO);
        this.racun.setArhiviran((short)0);
        this.racun.setStorno(0);
        this.racun.setIznos(new BigDecimal(0));
        this.racun.setPzuser(PzApplication.getApplication().getSession().getLoggedUser());
        this.racun.setProizvodfiskalniracuns(new ArrayList());
        PzDokumentManager.getInstance().snimiDokument((PzDokument)this.racun, true, null, em);
    }

    public void refreshDataTable() {
        this.table.setData(this.racun.getProizvodfiskalniracuns(), Proizvodfiskalniracun.class);
    }

    public void emptyFields(Boolean all) {
        this.dfRaspKol.setVal((Object)0);
        this.tfNaziv.setVal((Object)"");
        this.dfCena.setVal((Object)0);
        this.dfCenaStanje.setVal((Object)0);
        this.dfKolicina.setVal((Object)1);
        this.dfProcRabata.setVal((Object)0);
        if (all.booleanValue()) {
            this.tfSifraProizvoda.setText("");
            this.dfKolicina.setVal((Object)1);
            this.dfIznosStavke.setVal((Object)0.0);
        }
        if (PzApplication.getApplication().getSession().getLoggedUser().getDozvola("POSEBNA DOZVOLA", "FAKTURA_PROMENA_CENE") == null) {
            this.dfCena.setEnabled(false);
        }
    }

    public void refreshIznos() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogIzradaMaloprodajnogRacunaNew.this.dfUkupno.setVal((Object)PzDialogIzradaMaloprodajnogRacunaNew.this.racun.getIznosRacuna());
            }
        });
    }

    private boolean setArtikalData(Stanjeartikal a) {
        this.artikal = a;
        this.art = (Artikal)PzEntityManager.findEntity(Artikal.class, (Object)a.getId().getSfrProizvod());
        if (this.nacin.equals("SIFRA")) {
            this.tfSifraProizvoda.setVal((Object)a.getId().getSfrProizvod());
        } else {
            if (a.getBarKod() == null || "".equals(a.getBarKod())) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Izabrani artikal nema bar kod. Da biste mogli da ga koristite \nmorate da promenite na\u010din unosa preko \u0161ifre (F11).");
                return false;
            }
            this.tfSifraProizvoda.setVal((Object)a.getBarKod());
        }
        this.dfRaspKol.setVal((Object)a.getRaspKolicina());
        this.dfRaspKol.setVal((Object)a.getRaspKolicina());
        if (this.dfCena.getVal().equals(new Double(0.0))) {
            this.dfCena.setVal((Object)a.getProdCena());
        }
        this.dfCenaStanje.setVal((Object)a.getProdCena());
        this.tfNaziv.setVal((Object)a.getNaziv());
        if (this.kolicinaCenaOrder.indexOf("dfKolicina") < this.kolicinaCenaOrder.indexOf("dfCena")) {
            this.dfKolicina.requestFocusInWindow();
        } else {
            this.dfCena.requestFocusInWindow();
        }
        return true;
    }

    private FocusListener getFocusListener() {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                BigDecimal iznos = BDConverter.getIznos((double)(PzDialogIzradaMaloprodajnogRacunaNew.this.dfKolicina.getVal() * PzDialogIzradaMaloprodajnogRacunaNew.this.dfCena.getVal()));
                BigDecimal procRabata = BDConverter.getProcRabata100((double)PzDialogIzradaMaloprodajnogRacunaNew.this.dfProcRabata.getVal());
                BigDecimal rabat = BDConverter.getIznos((double)(BDConverter.getProdCena((double)(PzDialogIzradaMaloprodajnogRacunaNew.this.dfCena.getVal() * procRabata.doubleValue())).doubleValue() * PzDialogIzradaMaloprodajnogRacunaNew.this.dfKolicina.getVal()));
                PzDialogIzradaMaloprodajnogRacunaNew.this.dfIznosStavke.setVal((Object)iznos.subtract(rabat));
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent() == PzDialogIzradaMaloprodajnogRacunaNew.this.tfSifraProizvoda) {
                    PzDialogIzradaMaloprodajnogRacunaNew.this.dfKolicinaFocusGained();
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void setEnterAction() {
        void var5_7;
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(this.tfSifraProizvoda);
        if (this.kolicinaCenaOrder.indexOf("dfKolicina") < this.kolicinaCenaOrder.indexOf("dfCena")) {
            fields.add(this.dfKolicina);
            fields.add(this.dfCena);
        } else {
            fields.add(this.dfCena);
            fields.add(this.dfKolicina);
        }
        fields.add(this.dfProcRabata);
        PzFieldImpl last = null;
        ArrayList<PzFieldImpl> enabledFields = new ArrayList<PzFieldImpl>();
        for (PzFieldImpl pzFieldImpl : fields) {
            if (!pzFieldImpl.isEditable() || !pzFieldImpl.isEnabled()) continue;
            last = pzFieldImpl;
            enabledFields.add(pzFieldImpl);
        }
        if (last != null) {
            last.addKeyListener(this.createEnterKeyListener());
        }
        Component[] flds = new Component[enabledFields.size()];
        boolean bl = false;
        while (var5_7 < flds.length) {
            flds[var5_7] = (Component)enabledFields.get((int)var5_7);
            ++var5_7;
        }
        this.pnlFields.setFocusTraversalPolicyProvider(true);
        this.pnlFields.setFocusTraversalPolicy((FocusTraversalPolicy)new FocusTraversalOnArray(flds));
        this.setKeyStroke(enabledFields);
    }

    private KeyListener createEnterKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                    try {
                        try {
                            PzDialogIzradaMaloprodajnogRacunaNew.this.dodajArtikal(em);
                        }
                        catch (Exception e1) {
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().rollback();
                            }
                            PzDialogIzradaMaloprodajnogRacunaNew.this.table.rollBack();
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogIzradaMaloprodajnogRacunaNew.this), (Throwable)e1);
                            em.close();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            }
        };
    }

    public boolean isUpdateKolicine() {
        return this.updateKolicine;
    }

    private void setKeyStroke(List<PzFieldImpl> fields) {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        String shortCut = PzParameter.getParameterValue((String)"KASA_btnIzmena", (String)"F3", (EntityManager)em);
        this.btnIzmena.setShortcut(shortCut);
        this.btnIzmena.setText("A\u017euriranje reda|" + shortCut);
        this.setShortcut(fields, shortCut, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzDialogIzradaMaloprodajnogRacunaNew.this.btnIzmena.doClick();
            }
        });
        shortCut = PzParameter.getParameterValue((String)"KASA_btnBrisanje", (String)"CTRL+DEL", (EntityManager)em);
        this.btnBrisanje.setShortcut(shortCut);
        this.btnBrisanje.setText("Brisanje reda|" + shortCut);
        this.setShortcut(fields, shortCut, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PzDialogIzradaMaloprodajnogRacunaNew.this.btnBrisanje.doClick();
            }
        });
        shortCut = PzParameter.getParameterValue((String)"KASA_btnBrisanjeSvega", (String)"CTRL+Q", (EntityManager)em);
        this.btnBrisanjeSvega.setShortcut(shortCut);
        this.btnBrisanjeSvega.setText("Brisanje svega|" + shortCut);
        this.setShortcut(fields, shortCut, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PzDialogIzradaMaloprodajnogRacunaNew.this.btnBrisanjeSvega.doClick();
            }
        });
        shortCut = PzParameter.getParameterValue((String)"KASA_btnArhiva", (String)"CTRL+W", (EntityManager)em);
        this.btnArhiva.setShortcut(shortCut);
        this.btnArhiva.setText("Izdaj ra\u010dun|" + shortCut);
        this.setShortcut(fields, shortCut, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PzDialogIzradaMaloprodajnogRacunaNew.this.btnArhiva.doClick();
            }
        });
        em.close();
        this.setShortcut(fields, "UP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogIzradaMaloprodajnogRacunaNew.this.table.getRowCount() > 0 && PzDialogIzradaMaloprodajnogRacunaNew.this.table.getSelectedRow() != 0) {
                    PzDialogIzradaMaloprodajnogRacunaNew.this.table.setRowSelectionInterval(PzDialogIzradaMaloprodajnogRacunaNew.this.table.getSelectedRow() - 1, PzDialogIzradaMaloprodajnogRacunaNew.this.table.getSelectedRow() - 1);
                }
            }
        });
        this.setShortcut(fields, "DOWN", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogIzradaMaloprodajnogRacunaNew.this.table.getRowCount() > 0 && PzDialogIzradaMaloprodajnogRacunaNew.this.table.getSelectedRow() != PzDialogIzradaMaloprodajnogRacunaNew.this.table.getRowCount() - 1) {
                    PzDialogIzradaMaloprodajnogRacunaNew.this.table.setRowSelectionInterval(PzDialogIzradaMaloprodajnogRacunaNew.this.table.getSelectedRow() + 1, PzDialogIzradaMaloprodajnogRacunaNew.this.table.getSelectedRow() + 1);
                }
            }
        });
    }

    public void setShortcut(List<PzFieldImpl> fields, String keys, Action action) {
        String[] key = keys.split("\\+");
        String keyStrokeStr = "";
        String separator = " ";
        int i = 0;
        while (i < key.length) {
            if (i == key.length - 1) {
                separator = "";
            }
            if (key[i].equalsIgnoreCase("alt") || key[i].equalsIgnoreCase("ctrl") || key[i].equalsIgnoreCase("shift")) {
                if (key[i].equalsIgnoreCase("ctrl")) {
                    key[i] = "control";
                }
                key[i] = key[i].toLowerCase();
            } else {
                key[i] = key[i].equalsIgnoreCase("backspace") ? "BACK_SPACE" : key[i].toUpperCase();
            }
            key[i] = String.valueOf(key[i]) + separator;
            keyStrokeStr = String.valueOf(keyStrokeStr) + key[i];
            ++i;
        }
        for (PzFieldImpl field : fields) {
            InputMap map = field.getInputMap(0);
            KeyStroke stroke = KeyStroke.getKeyStroke(keyStrokeStr);
            map.put(stroke, keys);
            field.getActionMap().put(keys, action);
        }
    }
}

