/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura;

import com.helger.ubl21.UBL21Writer;
import com.helger.ubl21.UBL21WriterBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.BaseQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import rs.pezar.db.entity.ZaduzenjeOdobrenje;
import rs.pezar.efaktura.EZaduzenjeOdobrenjeExporter;
import rs.pezar.util.PzDateUtility;

public class EZaduzenjeExporter
extends EZaduzenjeOdobrenjeExporter<InvoiceType> {
    private static final String CREDIT_NOTE_TYPE_CODE = "383";
    private static final String CUSTOMIZATION_ID = "urn:cen.eu:en16931:2017#compliant#urn:mfin.gov.rs:srbdt:2022";
    private ZaduzenjeOdobrenje z;

    public EZaduzenjeExporter(ZaduzenjeOdobrenje z) {
        super(z);
        this.z = z;
    }

    @Override
    public InvoiceType build() throws Exception {
        InvoiceType i = new InvoiceType();
        i.setCustomizationID(CUSTOMIZATION_ID);
        i.setInvoiceTypeCode(CREDIT_NOTE_TYPE_CODE);
        i.setProfileID("eRacun");
        i.setDocumentCurrencyCode("RSD");
        i.setID(this.getInvoiceNumber());
        i.setIssueDate(this.date(this.z.getDatum()));
        i.addInvoicePeriod(this.invoicePeriod());
        i.setAccountingSupplierParty(this.supplier());
        i.setAccountingCustomerParty(this.customer());
        i.addContractDocumentReference(this.contractReference());
        i.addTaxTotal(this.taxTotal());
        i.setBillingReference(this.billingReference());
        i.addPaymentMeans(this.paymentMeans(this.pb(this.z.getOznDokumenta())));
        i.setLegalMonetaryTotal(this.monetaryTotalType());
        i.setInvoiceLine(this.lines());
        i.setNote(this.note());
        return i;
    }

    private List<NoteType> note() {
        return Arrays.asList(new NoteType(this.z.getPoruka()));
    }

    private PeriodType invoicePeriod() {
        PeriodType period = new PeriodType();
        period.addDescriptionCode(new DescriptionCodeType("3"));
        return period;
    }

    @Override
    protected String getInvoiceNumber() {
        return "KZ" + this.z.getOznDokumenta() + "/" + PzDateUtility.getCurrentYear();
    }

    private List<InvoiceLineType> lines() {
        TaxTotalType t = this.taxTotal();
        ArrayList<InvoiceLineType> lines = new ArrayList<InvoiceLineType>();
        int count = 0;
        for (TaxSubtotalType s : t.getTaxSubtotal()) {
            InvoiceLineType line = new InvoiceLineType();
            line.setID("" + ++count);
            InvoicedQuantityType q = new InvoicedQuantityType(BigDecimal.ONE);
            q.setUnitCode("H87");
            line.setInvoicedQuantity(q);
            LineExtensionAmountType ea = new LineExtensionAmountType(s.getTaxableAmountValue());
            ea.setCurrencyID("RSD");
            line.setLineExtensionAmount(ea);
            TaxTotalType tt = new TaxTotalType();
            tt.setTaxAmount(s.getTaxAmount());
            tt.addTaxSubtotal(s);
            line.addTaxTotal(tt);
            ItemType i = new ItemType();
            i.setName("Knjizno zaduzenje " + s.getTaxCategory().getPercentValue() + "%");
            i.addClassifiedTaxCategory(this.taxCategory("VAT", s.getTaxCategory().getPercentValue()));
            PriceType p = new PriceType();
            PriceAmountType pa = new PriceAmountType();
            pa.setCurrencyID("RSD");
            pa.setValue(s.getTaxableAmountValue());
            p.setPriceAmount(pa);
            BaseQuantityType bq = new BaseQuantityType();
            bq.setUnitCode("HUR");
            bq.setValue(this.decimal(1.0, 3));
            p.setBaseQuantity(bq);
            line.setPrice(p);
            line.setItem(i);
            lines.add(line);
        }
        return lines;
    }

    @Override
    protected UBL21WriterBuilder<InvoiceType> builder() {
        return UBL21Writer.invoice();
    }
}

