/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.efaktura;

import com.helger.ubl21.UBL21Writer;
import com.helger.ubl21.UBL21WriterBuilder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.AllowanceChargeType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.BillingReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.CommodityClassificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DeliveryType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.InvoiceLineType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemIdentificationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.ItemType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.LocationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.MonetaryTotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PaymentTermsType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PeriodType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.PriceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxSubtotalType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21.TaxTotalType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceChargeReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AllowanceTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.AmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.BaseAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ChargeTotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.DescriptionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.InvoicedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ItemClassificationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.LineExtensionAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PayableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PrepaidAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxExclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxInclusiveAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TaxableAmountType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_21.ExtensionContentType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_21.UBLExtensionType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_21.UBLExtensionsType;
import oasis.names.specification.ubl.schema.xsd.invoice_21.InvoiceType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.PzUslugaDokument;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalfakturaparameter;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Taksaopstidokument;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Uplata;
import rs.pezar.efaktura.EDokumentExporter;
import rs.pezar.efaktura.UnitConverter;
import rs.pezar.efaktura.model.InvoicedPrepaymentAmmount;
import rs.pezar.efaktura.model.NSMapper;
import rs.pezar.efaktura.model.ReducedTotals;
import rs.pezar.efaktura.model.SrbDtExtType;
import rs.pezar.globals.TipDokumentConfig;

public class EFakturaExporter
extends EDokumentExporter<Faktura, InvoiceType> {
    private static JAXBContext sbtCtx;
    private static final String INVOICE_TYPE_CODE = "380";
    protected static final String CUSTOMIZATION_ID = "urn:cen.eu:en16931:2017#compliant#urn:mfin.gov.rs:srbdt:2022#conformant#urn:mfin.gov.rs:srbdtext:2022";
    private Faktura f;
    private List<Uplata> advanceList;

    public EFakturaExporter(Faktura dokument) {
        super(dokument);
        this.f = dokument;
    }

    public EFakturaExporter(Faktura dokument, List<Uplata> advanceList) {
        super(dokument);
        this.f = dokument;
        this.advanceList = advanceList;
    }

    @Override
    protected UBL21WriterBuilder<InvoiceType> builder() {
        return UBL21Writer.invoice();
    }

    @Override
    public InvoiceType build() throws Exception {
        InvoiceType i = new InvoiceType();
        i.setCustomizationID(CUSTOMIZATION_ID);
        i.setInvoiceTypeCode(this.getInvoiceTypeCode());
        i.setProfileID("eRacun");
        i.setDocumentCurrencyCode("RSD");
        i.setID(this.f.getOznDokumenta());
        i.setIssueDate(this.date(this.f.getDatum()));
        i.addInvoicePeriod(this.invoicePeriod());
        i.setAccountingSupplierParty(this.supplier());
        i.setAccountingCustomerParty(this.customer());
        i.addContractDocumentReference(this.contractReference());
        i.addTaxTotal(this.taxTotal());
        i.setDueDate(this.date(this.f.getDatValute()));
        i.setDespatchDocumentReference(this.despatchDocumentList());
        i.addDelivery(this.delivery());
        i.addPaymentMeans(this.paymentMeans(this.pb(this.f.getOznDokumenta())));
        i.addPaymentTerms(this.paymentTerms(this.f.getPoruka()));
        i.addNote(new NoteType(this.f.getPoruka()));
        i.setLegalMonetaryTotal(this.monetaryTotalType(this.advanceList()));
        i.setInvoiceLine(this.lines());
        InvoiceLineType expense = this.expense();
        if (expense != null) {
            i.getInvoiceLine().add(expense);
        }
        i.setUBLExtensions(this.extensions(this.advanceList()));
        i.setBillingReference(this.billingReference());
        i.addAdditionalDocumentReference(this.originalPDF());
        if (this.additionalDocumentReferences() != null) {
            for (DocumentReferenceType ref : this.additionalDocumentReferences()) {
                i.addAdditionalDocumentReference(ref);
            }
        }
        return i;
    }

    protected String getInvoiceTypeCode() {
        return INVOICE_TYPE_CODE;
    }

    private UBLExtensionsType extensions(List<Uplata> advanceList) throws Exception {
        if (advanceList == null || advanceList.size() == 0) {
            return null;
        }
        UBLExtensionsType list = new UBLExtensionsType();
        UBLExtensionType e = new UBLExtensionType();
        ExtensionContentType c = new ExtensionContentType();
        SrbDtExtType ext = new SrbDtExtType();
        ArrayList<PzTaksaDokument> porezSuma = new ArrayList<PzTaksaDokument>();
        for (Uplata advance : advanceList) {
            InvoicedPrepaymentAmmount a = new InvoicedPrepaymentAmmount();
            a.setID(new IDType(advance.getOznDokumentaUpl()));
            TaxTotalType t = this.taxTotal(advance.getTaksadokuments());
            a.addTaxTotal(t);
            ext.addInvoicedPrepaymentAmmount(a);
            this.totalTax(porezSuma, advance.getTaksaopstidokuments());
        }
        TaxTotalType t = this.taxTotal(porezSuma);
        ext.setReducedTotals(this.reducedTotals(t));
        c.setAny(this.marshallExtension(ext));
        e.setExtensionContent(c);
        list.addUBLExtension(e);
        return list;
    }

    private void totalTax(List<PzTaksaDokument> summary, List<Taksaopstidokument> list) {
        for (Taksaopstidokument t : list) {
            Taksaopstidokument found = null;
            Iterator<PzTaksaDokument> iterator = summary.iterator();
            while (iterator.hasNext() && found == null) {
                PzTaksaDokument temp = iterator.next();
                if (!temp.getTarifnagrupa().getOznTarGr().equals(t.getTarifnagrupa().getOznTarGr())) continue;
                found = temp;
            }
            if (found != null) {
                found.setIznos(found.getIznos().add(t.getIznos()));
                found.setOsnovica(found.getOsnovica().add(t.getOsnovica()));
                continue;
            }
            found = new Taksaopstidokument(t.getId().getIdDok(), t.getId().getOznTarGr(), t.getTip());
            found.setIznos(t.getIznos());
            found.setOsnovica(t.getOsnovica());
            found.setTarifnagrupa(t.getTarifnagrupa());
            found.setTip(t.getTip());
            found.setVrsta(t.getVrsta());
            found.setDokument(t.getDokument());
            summary.add((PzTaksaDokument)found);
        }
    }

    private ReducedTotals reducedTotals(TaxTotalType total) {
        TaxTotalType reduced = this.taxTotal();
        BigDecimal taxExclusiveAmount = BigDecimal.ZERO;
        BigDecimal taxInclusiveAmount = BigDecimal.ZERO;
        for (TaxSubtotalType s : total.getTaxSubtotal()) {
            for (TaxSubtotalType tmp : reduced.getTaxSubtotal()) {
                if (!s.getTaxCategory().getIDValue().equals(tmp.getTaxCategory().getIDValue()) || s.getTaxCategory().getPercentValue().compareTo(tmp.getTaxCategory().getPercentValue()) != 0) continue;
                tmp.setTaxableAmount(tmp.getTaxableAmountValue().subtract(s.getTaxableAmountValue()));
                tmp.setTaxAmount(tmp.getTaxAmountValue().subtract(s.getTaxAmountValue()));
            }
        }
        for (TaxSubtotalType s : reduced.getTaxSubtotal()) {
            taxExclusiveAmount = taxExclusiveAmount.add(s.getTaxableAmountValue());
            taxInclusiveAmount = taxInclusiveAmount.add(s.getTaxableAmountValue().add(s.getTaxAmountValue()));
        }
        reduced.setTaxAmount(this.taxAmount(reduced.getTaxSubtotal()));
        ReducedTotals r = new ReducedTotals();
        r.addTaxTotal(reduced);
        MonetaryTotalType m = new MonetaryTotalType();
        TaxExclusiveAmountType e = new TaxExclusiveAmountType(taxExclusiveAmount);
        e.setCurrencyID("RSD");
        TaxInclusiveAmountType i = new TaxInclusiveAmountType(taxInclusiveAmount);
        i.setCurrencyID("RSD");
        PayableAmountType p = new PayableAmountType(taxInclusiveAmount);
        p.setCurrencyID("RSD");
        m.setTaxExclusiveAmount(e);
        m.setTaxInclusiveAmount(i);
        m.setPayableAmount(p);
        r.setLegalMonetaryTotal(m);
        return r;
    }

    private List<BillingReferenceType> billingReference() {
        if (this.advanceList == null || this.advanceList.size() == 0) {
            return null;
        }
        ArrayList<BillingReferenceType> list = null;
        for (Uplata advance : this.advanceList) {
            if (list == null) {
                list = new ArrayList<BillingReferenceType>();
            }
            BillingReferenceType b = new BillingReferenceType();
            DocumentReferenceType d = new DocumentReferenceType();
            d.setID(new IDType(advance.getOznDokumentaUpl()));
            if (advance.getOriginal() != null) {
                d.setIssueDate(this.date(advance.getOriginal().getDatPrometa()));
            } else {
                d.setIssueDate(this.date(advance.getDatPrometa()));
            }
            b.setInvoiceDocumentReference(d);
            list.add(b);
        }
        return list;
    }

    private Object marshallExtension(SrbDtExtType ext) throws Exception {
        if (sbtCtx == null) {
            sbtCtx = JAXBContext.newInstance((Class[])new Class[]{SrbDtExtType.class});
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document extDocument = dbf.newDocumentBuilder().newDocument();
        Marshaller marshaller = sbtCtx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NSMapper());
        marshaller.marshal((Object)new JAXBElement(new QName("http://mfin.gov.rs/srbdt/srbdtext", "SrbDtExt", "sbt"), SrbDtExtType.class, (Object)ext), (Node)extDocument);
        Element e = extDocument.getDocumentElement();
        return e;
    }

    protected PeriodType invoicePeriod() {
        PeriodType period = new PeriodType();
        period.setStartDate(this.date(this.f.getDatPrometa()));
        period.setEndDate(this.date(this.f.getDatPrometa()));
        period.addDescriptionCode(new DescriptionCodeType("35"));
        return period;
    }

    @Override
    protected String documentTaxExemptionCode() {
        Fakturaparameter p = this.f.getFakturaparameter(this.f.getIdDok(), "TAX_EXEMPTION");
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    private InvoiceLineType expense() throws Exception {
        BigDecimal trosak = this.trosak();
        if (trosak == null) {
            return null;
        }
        BigDecimal trosakTaksa = this.trosakTaksa();
        InvoiceLineType line = new InvoiceLineType();
        line.setID("1000");
        InvoicedQuantityType q = new InvoicedQuantityType(BigDecimal.ONE);
        q.setUnitCode(UnitConverter.convert("kom"));
        line.setInvoicedQuantity(q);
        PriceType p = new PriceType();
        PriceAmountType pa = new PriceAmountType();
        pa.setCurrencyID("RSD");
        pa.setValue(trosak);
        p.setPriceAmount(pa);
        line.setPrice(p);
        LineExtensionAmountType ea = new LineExtensionAmountType(trosak);
        ea.setCurrencyID("RSD");
        line.setLineExtensionAmount(ea);
        String oznTarGr = this.f.getFakturaParameterValue("DOD_TROS_TG");
        Tarifnagrupa t = (Tarifnagrupa)PzEntityManager.find(Tarifnagrupa.class, (Object)oznTarGr);
        if (t != null) {
            TaxTotalType tax = new TaxTotalType();
            TaxAmountType amount = new TaxAmountType(trosakTaksa);
            amount.setCurrencyID("RSD");
            tax.setTaxAmount(amount);
            TaxSubtotalType sub = new TaxSubtotalType();
            TaxableAmountType taxable = new TaxableAmountType(trosak);
            taxable.setCurrencyID("RSD");
            amount = new TaxAmountType(trosakTaksa);
            amount.setCurrencyID("RSD");
            sub.setTaxCategory(this.taxCategory(t));
            sub.setTaxableAmount(taxable);
            sub.setTaxAmount(amount);
            tax.addTaxSubtotal(sub);
            line.addTaxTotal(tax);
            ItemType i = new ItemType();
            i.setName(this.f.getFakturaParameterValue("DOD_TROS_NAZIV"));
            i.addClassifiedTaxCategory(this.taxCategory(t));
            line.setItem(i);
        }
        return line;
    }

    protected List<InvoiceLineType> lines() {
        PriceAmountType pa;
        PriceType p;
        BigDecimal price;
        ItemType i;
        LineExtensionAmountType ea;
        InvoicedQuantityType q;
        InvoiceLineType line;
        ArrayList<InvoiceLineType> lines = new ArrayList<InvoiceLineType>();
        for (Artikalfaktura af : this.f.getArtikalfakturas()) {
            line = new InvoiceLineType();
            line.setID(String.valueOf(af.getId().getrBroj()));
            q = new InvoicedQuantityType(this.decimal(af.getKolicina(), 3));
            if (q.getValue().compareTo(BigDecimal.ZERO) == 0) continue;
            q.setUnitCode(UnitConverter.convert(af.getJm()));
            line.setInvoicedQuantity(q);
            ea = new LineExtensionAmountType(af.calculateOsnovica("PDV"));
            ea.setCurrencyID("RSD");
            line.setLineExtensionAmount(ea);
            if (!this.f.izMaloprodaje() && af.getProcRabata() > 0.0) {
                AllowanceChargeType a = new AllowanceChargeType();
                a.setChargeIndicator(false);
                BigDecimal multiplier = this.decimal(af.getProcRabata(), 2);
                a.setMultiplierFactorNumeric(multiplier);
                BigDecimal multiplier100 = multiplier.divide(new BigDecimal("100"), 3, RoundingMode.HALF_UP);
                BigDecimal baseAmount = this.decimal(af.getCena(), 2).multiply(this.decimal(af.getKolicina(), 3));
                BigDecimal amount = baseAmount.multiply(multiplier100);
                AmountType at = new AmountType(amount);
                at.setCurrencyID("RSD");
                a.setAmount(at);
                BaseAmountType b = new BaseAmountType(baseAmount);
                b.setCurrencyID("RSD");
                a.setBaseAmount(b);
                line.addAllowanceCharge(a);
            }
            if (af.getArtikal() != null) {
                i = new ItemType();
                i.setName(af.getNaziv().trim());
                ItemIdentificationType ident = new ItemIdentificationType();
                ident.setID(new IDType(af.getArtikal().getSfrProizvod()));
                i.setSellersItemIdentification(ident);
                String gtin = af.getArtikal().getBarKod();
                if (gtin != null && gtin.length() > 7 && gtin.length() < 14) {
                    ident = new ItemIdentificationType();
                    IDType id = new IDType(gtin);
                    id.setSchemeID("0160");
                    ident.setID(id);
                    i.setStandardItemIdentification(ident);
                }
                i.addClassifiedTaxCategory(this.taxCategory(af.getTaksa("PDV")));
                Artikalfakturaparameter object = af.getArtikalfakturaparameter("NEPOKRETNOST");
                if (object != null && "true".equals(object.getValue())) {
                    CommodityClassificationType comm = new CommodityClassificationType();
                    ItemClassificationCodeType ic = new ItemClassificationCodeType();
                    ic.setListID("GN");
                    ic.setValue("PDV-RS-OBJ");
                    comm.setItemClassificationCode(ic);
                    i.getCommodityClassification().add(comm);
                }
                line.setItem(i);
            }
            price = this.f.izMaloprodaje() ? af.calculateOsnovica("PDV").divide(this.decimal(af.getKolicina(), 2), 2, RoundingMode.HALF_UP) : af.getProdCena();
            p = new PriceType();
            pa = new PriceAmountType();
            pa.setCurrencyID("RSD");
            pa.setValue(price);
            p.setPriceAmount(pa);
            line.setPrice(p);
            lines.add(line);
        }
        if (this.f.getUslugaDocuments() != null) {
            for (PzUslugaDokument s : this.f.getUslugaDocuments()) {
                line = new InvoiceLineType();
                line.setID("U" + s.getId().getrBroj());
                q = new InvoicedQuantityType(this.decimal(s.getKolicina(), 3));
                q.setUnitCode("H87");
                line.setInvoicedQuantity(q);
                ea = new LineExtensionAmountType(s.calculateOsnovica("PDV"));
                ea.setCurrencyID("RSD");
                line.setLineExtensionAmount(ea);
                if (this.getFirma().getPdvObveznik() == 1) {
                    TaxTotalType tax = new TaxTotalType();
                    TaxAmountType amount = new TaxAmountType(this.f.getSaPorezom() == 1 ? s.calculateTaksa("PDV") : BigDecimal.ZERO);
                    amount.setCurrencyID("RSD");
                    tax.setTaxAmount(amount);
                    TaxSubtotalType sub = new TaxSubtotalType();
                    TaxableAmountType taxable = new TaxableAmountType(s.calculateOsnovica("PDV"));
                    taxable.setCurrencyID("RSD");
                    amount = new TaxAmountType(this.f.getSaPorezom() == 1 ? s.calculateTaksa("PDV") : BigDecimal.ZERO);
                    amount.setCurrencyID("RSD");
                    sub.setTaxCategory(this.f.getSaPorezom() == 1 ? this.taxCategory(s.getTaksa("PDV")) : this.taxCategory("VAT", BigDecimal.ZERO));
                    sub.setTaxableAmount(taxable);
                    sub.setTaxAmount(amount);
                    tax.addTaxSubtotal(sub);
                    line.addTaxTotal(tax);
                }
                if (s.getUsluga() != null) {
                    i = new ItemType();
                    i.setName(s.getUsluga().getNaziv().trim());
                    i.addClassifiedTaxCategory(this.taxCategory(s.getTaksa("PDV")));
                    line.setItem(i);
                } else {
                    i = new ItemType();
                    i.setName(s.getNaziv().trim());
                    i.addClassifiedTaxCategory(((TaxSubtotalType)this.taxTotal().getTaxSubtotal().get(0)).getTaxCategory());
                    line.setItem(i);
                }
                price = this.f.izMaloprodaje() ? s.calculateOsnovica("PDV").divide(this.decimal(s.getKolicina(), 2), 2, RoundingMode.HALF_UP) : this.decimal(s.getCena(), 2);
                p = new PriceType();
                pa = new PriceAmountType();
                pa.setCurrencyID("RSD");
                pa.setValue(price);
                p.setPriceAmount(pa);
                line.setPrice(p);
                lines.add(line);
            }
        }
        return lines;
    }

    private MonetaryTotalType monetaryTotalType(List<Uplata> advanceList) throws Exception {
        MonetaryTotalType m = new MonetaryTotalType();
        LineExtensionAmountType le = this.lineExtensionAmount();
        le.setCurrencyID("RSD");
        BigDecimal trosak = this.trosak();
        if (trosak == null) {
            trosak = BigDecimal.ZERO;
        }
        TaxExclusiveAmountType te = new TaxExclusiveAmountType(le.getValue().add(trosak));
        te.setCurrencyID("RSD");
        TaxInclusiveAmountType ti = new TaxInclusiveAmountType(this.f.getIznos());
        ti.setCurrencyID("RSD");
        AllowanceTotalAmountType t = new AllowanceTotalAmountType(this.f.getRabatUkupno());
        t.setCurrencyID("RSD");
        ChargeTotalAmountType c = new ChargeTotalAmountType(trosak);
        c.setCurrencyID("RSD");
        BigDecimal prepaid = this.prepaid(advanceList);
        PrepaidAmountType p = new PrepaidAmountType(prepaid);
        p.setCurrencyID("RSD");
        PayableAmountType pa = new PayableAmountType(this.f.getIznos().subtract(prepaid));
        pa.setCurrencyID("RSD");
        m.setLineExtensionAmount(le);
        m.setTaxExclusiveAmount(te);
        m.setTaxInclusiveAmount(ti);
        m.setAllowanceTotalAmount(t);
        m.setChargeTotalAmount(c);
        m.setPrepaidAmount(p);
        m.setPayableAmount(pa);
        return m;
    }

    protected LineExtensionAmountType lineExtensionAmount() {
        LineExtensionAmountType le = new LineExtensionAmountType();
        if (this.f.getRadnajedinica() != null && this.f.izMaloprodaje()) {
            le.setValue(this.f.getIznosBezPorezaMaloprodaja(this.f.getArtikalfakturas()));
        } else {
            le.setValue(this.f.getVrednostRobe().add(this.f.getVrednostUsluga()).subtract(this.f.getRabatUkupno()));
        }
        return le;
    }

    private BigDecimal prepaid(List<Uplata> advanceList) throws Exception {
        BigDecimal prepaid = BigDecimal.ZERO;
        for (Uplata uplata : advanceList) {
            prepaid = prepaid.add(uplata.getIznos());
        }
        return prepaid;
    }

    protected List<Uplata> advanceList() throws Exception {
        if (this.advanceList != null && this.advanceList.size() > 0) {
            return this.advanceList;
        }
        return PzEntityManager.getList((String)("SELECT u FROM Uplata u WHERE u.poDokumentu = " + this.f.getIdDok() + " AND u.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC + "'"));
    }

    private AllowanceChargeType allowanceCharge() throws Exception {
        BigDecimal amount = this.trosak();
        if (amount == null) {
            return null;
        }
        AllowanceChargeType a = new AllowanceChargeType();
        a.setChargeIndicator(true);
        a.addAllowanceChargeReason(new AllowanceChargeReasonType("Trosak"));
        AmountType value = new AmountType(amount);
        value.setCurrencyID("RSD");
        a.setAmount(value);
        BaseAmountType base = new BaseAmountType(this.f.getVrednostRobe().subtract(this.f.getRabatUkupno()));
        base.setCurrencyID("RSD");
        a.setBaseAmount(base);
        String oznTarGr = this.f.getFakturaParameterValue("DOD_TROS_TG");
        Tarifnagrupa t = (Tarifnagrupa)PzEntityManager.find(Tarifnagrupa.class, (Object)oznTarGr);
        if (t != null) {
            a.addTaxCategory(this.taxCategory(t));
        }
        return a;
    }

    protected BigDecimal trosak() {
        BigDecimal tax;
        String amount = this.f.getFakturaParameterValue("DOD_TROS_IZNOS");
        if (amount == null || "".equals(amount)) {
            return null;
        }
        if (this.f.izMaloprodaje() && (tax = this.trosakTaksa()) != null) {
            return new BigDecimal(amount).subtract(tax);
        }
        return new BigDecimal(amount);
    }

    private BigDecimal trosakTaksa() {
        String amount = this.f.getFakturaParameterValue("DOD_TROS_TG_IZNOS");
        if (amount == null || "".equals(amount)) {
            return null;
        }
        return new BigDecimal(amount);
    }

    private PaymentTermsType paymentTerms(String note) {
        PaymentTermsType p = new PaymentTermsType();
        p.addNote(new NoteType(note));
        return p;
    }

    protected DeliveryType delivery() {
        DeliveryType d = new DeliveryType();
        d.setActualDeliveryDate(this.date(this.f.getDatPrometa()));
        Komitent k = this.f.getKomitent();
        LocationType l = new LocationType();
        l.setAddress(this.postalAddress(k.getAdresa(), k.getPostBroj(), k.getGrad(), "RS"));
        d.setDeliveryLocation(l);
        return d;
    }

    private List<DocumentReferenceType> despatchDocumentList() {
        if (this.f.getFakturas() == null || this.f.getFakturas().size() == 0) {
            return null;
        }
        ArrayList<DocumentReferenceType> list = new ArrayList<DocumentReferenceType>();
        for (Faktura o : this.f.getFakturas()) {
            DocumentReferenceType ref = new DocumentReferenceType();
            ref.setID(o.getOznDokumenta());
            list.add(ref);
        }
        return list;
    }

    @Override
    protected String getBankAccount() {
        if (this.f.getTekuciRacun() == null) {
            return super.getBankAccount();
        }
        return this.f.getTekuciRacun().split(",")[0];
    }
}

