/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.util.Priority;
import java.util.ArrayList;
import java.util.List;

public class DockTitleVersion
implements DockTitleFactory {
    private DockTitleFactory[] factories = new DockTitleFactory[3];
    private String id;
    private DockController controller;
    private List<DockTitleRequest> requests = new ArrayList<DockTitleRequest>();
    private boolean onThemeChange = false;

    public DockTitleVersion(DockController controller, String id) {
        if (controller == null) {
            throw new NullPointerException("Controller must not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("The ID must not be null");
        }
        this.controller = controller;
        this.id = id;
        controller.getThemeManager().addUIListener(new UIListener(){

            @Override
            public void updateUI(DockController controller) {
            }

            @Override
            public void themeWillChange(DockController controller, DockTheme oldTheme, DockTheme newTheme) {
                DockTitleVersion.this.onThemeChange = true;
            }

            @Override
            public void themeChanged(DockController controller, DockTheme oldTheme, DockTheme newTheme) {
                DockTitleVersion.this.onThemeChange = false;
            }
        });
    }

    @Override
    public void install(DockTitleRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        this.requests.add(request);
        DockTitleFactory factory = this.getFactory();
        if (factory != null) {
            factory.install(request);
        }
    }

    @Override
    public void uninstall(DockTitleRequest request) {
        this.requests.remove(request);
        DockTitleFactory factory = this.getFactory();
        if (factory != null) {
            factory.uninstall(request);
        }
    }

    @Override
    public void request(DockTitleRequest request) {
        DockTitleFactory factory = this.getFactory();
        if (factory != null) {
            factory.request(request);
        }
    }

    public void request() {
        for (DockTitleRequest request : this.requests) {
            request.request();
        }
    }

    private int map(Priority priority) {
        switch (priority) {
            case CLIENT: {
                return 0;
            }
            case THEME: {
                return 1;
            }
        }
        return 2;
    }

    public DockTitleFactory getFactory() {
        int i = 0;
        while (i < this.factories.length) {
            if (this.factories[i] != null) {
                return this.factories[i];
            }
            ++i;
        }
        return null;
    }

    public void setFactory(DockTitleFactory factory, Priority priority) {
        DockTitleFactory oldFactory = this.getFactory();
        this.factories[this.map((Priority)priority)] = factory;
        DockTitleFactory newFactory = this.getFactory();
        if (oldFactory != newFactory) {
            if (oldFactory != null) {
                for (DockTitleRequest request : this.requests) {
                    oldFactory.uninstall(request);
                }
            }
            if (newFactory != null) {
                for (DockTitleRequest request : this.requests) {
                    newFactory.install(request);
                    if (this.onThemeChange) continue;
                    request.request();
                }
            }
        }
    }

    public DockTitleFactory getFactory(Priority priority) {
        return this.factories[this.map(priority)];
    }

    public boolean isSet(Priority priority) {
        return this.factories[this.map(priority)] != null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DockTitleVersion && ((DockTitleVersion)obj).id.equals(this.id);
    }

    public String getID() {
        return this.id;
    }

    public DockController getController() {
        return this.controller;
    }
}

