/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.menu;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.MenuDockAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.themes.basic.action.menu.AbstractMenuHandler;
import bibliothek.gui.dock.themes.basic.action.menu.MenuViewItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class MenuMenuHandler
extends AbstractMenuHandler<JMenu, MenuDockAction> {
    private DockActionSource source;
    private Menu menu;
    private List<ActionItem> actions = new ArrayList<ActionItem>();
    private Listener sourceListener = new Listener();
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private ViewTarget<? extends MenuViewItem<JComponent>> target = ViewTarget.MENU;

    public MenuMenuHandler(MenuDockAction action, Dockable dockable) {
        this(action, dockable, ViewTarget.MENU);
    }

    public MenuMenuHandler(MenuDockAction action, Dockable dockable, ViewTarget<? extends MenuViewItem<JComponent>> target) {
        super(action, dockable, new JMenu());
        if (target == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        this.target = target;
        this.setup(action.getMenu(dockable), new JMenuWrapper((JMenu)this.item));
    }

    public MenuMenuHandler(DockActionSource source, Dockable dockable, JPopupMenu menu) {
        super(null, dockable, null);
        this.setup(source, new JPopupMenuWrapper(menu));
    }

    private void setup(DockActionSource source, Menu menu) {
        this.source = source;
        this.menu = menu;
    }

    @Override
    public void addActionListener(ActionListener listener) {
    }

    @Override
    public void removeActionListener(ActionListener listener) {
    }

    public void addChildrenActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeChildrenActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireActionEvent(ActionEvent event) {
        ActionListener[] actionListenerArray = this.listeners.toArray(new ActionListener[this.listeners.size()]);
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener listener = actionListenerArray[n2];
            listener.actionPerformed(event);
            ++n2;
        }
    }

    @Override
    public void bind() {
        super.bind();
        this.source.addDockActionSourceListener(this.sourceListener);
        int i = 0;
        int n = this.source.getDockActionCount();
        while (i < n) {
            DockAction action = this.source.getDockAction(i);
            ActionItem item = new ActionItem();
            item.action = action;
            this.actions.add(item);
            MenuViewItem<JComponent> handler = this.handlerFor(action);
            if (handler != null) {
                item.handler = handler;
                item.bind();
                item.action.bind(this.dockable);
                handler.bind();
                this.menu.add((JComponent)handler.getItem());
            }
            ++i;
        }
    }

    protected MenuViewItem<JComponent> handlerFor(DockAction action) {
        Dockable dockable = this.getDockable();
        MenuViewItem<JComponent> result = dockable.getController().getActionViewConverter().createView(action, this.target, dockable);
        return result;
    }

    public MenuViewItem<JComponent> getViewFor(DockAction action) {
        for (ActionItem item : this.actions) {
            if (item.action != action) continue;
            return item.handler;
        }
        return null;
    }

    @Override
    public void unbind() {
        super.unbind();
        this.source.removeDockActionSourceListener(this.sourceListener);
        this.menu.removeAll();
        for (ActionItem item : this.actions) {
            item.unbind();
            if (item.handler == null) continue;
            item.handler.unbind();
            item.action.unbind(this.dockable);
        }
        this.actions.clear();
    }

    private class ActionItem
    implements ActionListener {
        public DockAction action;
        public MenuViewItem<JComponent> handler;

        private ActionItem() {
        }

        public void bind() {
            if (this.handler != null) {
                this.handler.addActionListener(this);
            }
        }

        public void unbind() {
            if (this.handler != null) {
                this.handler.removeActionListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuMenuHandler.this.fireActionEvent(new ActionEvent(this.action, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
        }
    }

    private static class JMenuWrapper
    implements Menu {
        private JMenu menu;

        public JMenuWrapper(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void add(JComponent item) {
            this.menu.add(item);
        }

        @Override
        public JMenuItem getItem() {
            return this.menu;
        }

        @Override
        public void removeAll() {
            this.menu.removeAll();
        }
    }

    private static class JPopupMenuWrapper
    implements Menu {
        private JPopupMenu menu;

        public JPopupMenuWrapper(JPopupMenu menu) {
            this.menu = menu;
        }

        @Override
        public void add(JComponent item) {
            this.menu.add(item);
        }

        @Override
        public JMenuItem getItem() {
            return null;
        }

        @Override
        public void removeAll() {
            this.menu.removeAll();
        }
    }

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        private void reput() {
            MenuMenuHandler.this.menu.removeAll();
            for (ActionItem item : MenuMenuHandler.this.actions) {
                if (item.handler == null) continue;
                MenuMenuHandler.this.menu.add((JComponent)item.handler.getItem());
            }
        }

        @Override
        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            int i = firstIndex;
            while (i <= lastIndex) {
                DockAction action = source.getDockAction(i);
                ActionItem item = new ActionItem();
                item.action = action;
                MenuMenuHandler.this.actions.add(i, item);
                MenuViewItem<JComponent> handler = MenuMenuHandler.this.handlerFor(action);
                if (handler != null) {
                    action.bind(MenuMenuHandler.this.dockable);
                    handler.bind();
                    item.handler = handler;
                    item.bind();
                }
                ++i;
            }
            this.reput();
        }

        @Override
        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            int i = lastIndex;
            while (i >= firstIndex) {
                ActionItem item = (ActionItem)MenuMenuHandler.this.actions.remove(i);
                item.unbind();
                if (item.handler != null) {
                    item.handler.unbind();
                    item.action.unbind(MenuMenuHandler.this.dockable);
                }
                --i;
            }
        }
    }

    private static interface Menu {
        public void add(JComponent var1);

        public void removeAll();

        public JMenuItem getItem();
    }
}

