/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.actions.SimpleMenuAction;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    private DockTitle.Orientation orientation = DockTitle.Orientation.FREE_HORIZONTAL;
    private Dockable dockable;
    private DockActionSource source;
    private Listener listener = new Listener();
    private List<ActionItem> actions = new ArrayList<ActionItem>();
    private DefaultDockActionSource menuSource;
    private BasicTitleViewItem<JComponent> menuItem;
    private SimpleMenuAction menuAction;
    private DockActionIcon menuIcon;
    private int visibleActions = -1;

    public ButtonPanel(boolean menu) {
        this.setLayout(null);
        this.setOpaque(false);
        if (menu) {
            this.menuSource = new DefaultDockActionSource(new DockAction[0]);
            this.menuAction = new SimpleMenuAction(this.menuSource);
            this.menuIcon = new DockActionIcon("overflow.menu", this.menuAction){

                @Override
                protected void changed(Icon oldValue, Icon newValue) {
                    ButtonPanel.this.menuAction.setIcon(newValue);
                }
            };
        }
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
    }

    protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
        return dockable.getController().getActionViewConverter().createView(action, ViewTarget.TITLE, dockable);
    }

    public int getItemCount() {
        int count = 0;
        for (ActionItem entry : this.actions) {
            if (entry.item == null) continue;
            ++count;
        }
        return count;
    }

    public void setOrientation(DockTitle.Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            if (this.menuItem != null) {
                this.menuItem.setOrientation(orientation);
            }
            for (ActionItem item : this.actions) {
                if (item.item == null) continue;
                item.item.setOrientation(orientation);
            }
            this.revalidate();
        }
    }

    public DockTitle.Orientation getOrientation() {
        return this.orientation;
    }

    public void set(Dockable dockable) {
        if (dockable == null) {
            this.set(null, null);
        } else {
            this.set(dockable, dockable.getGlobalActionOffers());
        }
    }

    public void set(Dockable dockable, DockActionSource source) {
        this.set(dockable, source, false);
    }

    private void set() {
        this.set(this.dockable, this.source, true);
    }

    public void set(Dockable dockable, DockActionSource source, boolean force) {
        if (source == null != (dockable == null)) {
            throw new IllegalArgumentException("Either both arguments are null, or none");
        }
        if (force || this.source != source || this.dockable != dockable) {
            if (this.source != null) {
                this.removeAll();
                for (ActionItem item : this.actions) {
                    if (item.item == null) continue;
                    item.item.unbind();
                    item.action.unbind(this.dockable);
                }
                if (this.menuAction != null) {
                    if (this.menuItem != null) {
                        this.menuItem.unbind();
                        this.menuItem = null;
                    }
                    this.menuAction.unbind(this.dockable);
                    this.menuSource.removeAll();
                }
                this.actions.clear();
                this.source.removeDockActionSourceListener(this.listener);
            }
            this.source = source;
            this.dockable = dockable;
            this.listener.setDockable(dockable);
            if (source != null) {
                if (this.menuAction != null) {
                    this.menuAction.bind(dockable);
                    if (dockable.getController() != null) {
                        this.menuItem = this.createItemFor(this.menuAction, dockable);
                        if (this.menuItem != null) {
                            this.menuItem.setOrientation(this.orientation);
                            this.menuItem.setForeground(this.getForeground());
                            this.menuItem.setBackground(this.getBackground());
                            this.menuItem.bind();
                        }
                    }
                }
                source.addDockActionSourceListener(this.listener);
                for (DockAction action : source) {
                    BasicTitleViewItem<JComponent> item;
                    ActionItem actionItem = new ActionItem();
                    actionItem.action = action;
                    this.actions.add(actionItem);
                    if (dockable.getController() == null || (item = this.createItemFor(action, dockable)) == null) continue;
                    action.bind(dockable);
                    item.bind();
                    actionItem.item = item;
                    item.setOrientation(this.orientation);
                    item.setForeground(this.getForeground());
                    item.setBackground(this.getBackground());
                }
            }
            this.visibleActions = this.actions.size();
            this.resetVisibleActions();
            this.revalidate();
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.menuItem != null) {
            this.menuItem.setForeground(fg);
        }
        if (this.actions != null) {
            for (ActionItem item : this.actions) {
                if (item.item == null) continue;
                item.item.setForeground(fg);
            }
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.menuItem != null) {
            this.menuItem.setBackground(bg);
        }
        if (this.actions != null) {
            for (ActionItem item : this.actions) {
                if (item.item == null) continue;
                item.item.setBackground(bg);
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ButtonPanel.this.setForeground(ButtonPanel.this.getForeground());
                ButtonPanel.this.setBackground(ButtonPanel.this.getBackground());
            }
        });
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.actions.isEmpty()) {
            return new Dimension(0, 0);
        }
        if (this.menuItem == null) {
            return this.getPreferredSize();
        }
        return ((JComponent)this.menuItem.getItem()).getMinimumSize();
    }

    public Dimension[] getPreferredSizes() {
        if (this.actions.isEmpty()) {
            return new Dimension[]{new Dimension(0, 0)};
        }
        if (this.menuAction == null) {
            return new Dimension[]{this.getPreferredSize()};
        }
        Dimension current = new Dimension(0, 0);
        Dimension menuPreferred = this.menuItem == null ? new Dimension(0, 0) : ((JComponent)this.menuItem.getItem()).getPreferredSize();
        Dimension[] results = new Dimension[this.actions.size() + 1];
        results[0] = new Dimension(menuPreferred);
        int i = 0;
        int n = this.actions.size();
        while (i < n) {
            BasicTitleViewItem<JComponent> item = this.actions.get((int)i).item;
            if (item != null) {
                Dimension preferred = ((JComponent)item.getItem()).getPreferredSize();
                if (this.orientation.isHorizontal()) {
                    current.width += preferred.width;
                    current.height = Math.max(current.height, preferred.height);
                } else {
                    current.width = Math.max(current.width, preferred.width);
                    current.height += preferred.height;
                }
            }
            Dimension result = new Dimension(current);
            if (i + 1 < n) {
                if (this.orientation.isHorizontal()) {
                    result.width += menuPreferred.width;
                    result.height = Math.max(result.height, menuPreferred.height);
                } else {
                    result.width = Math.max(result.width, menuPreferred.width);
                    result.height += menuPreferred.height;
                }
            }
            results[i + 1] = result;
            ++i;
        }
        Insets insets = this.getInsets();
        Dimension[] dimensionArray = results;
        int n2 = results.length;
        int n3 = 0;
        while (n3 < n2) {
            Dimension dimension = dimensionArray[n3];
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            ++n3;
        }
        return results;
    }

    public Dimension getCurrentPreferredSize() {
        int i;
        int width = 0;
        int height = 0;
        if (this.orientation.isHorizontal()) {
            i = 0;
            int n = this.getComponentCount();
            while (i < n) {
                Dimension preferred = this.getComponent(i).getPreferredSize();
                width += preferred.width;
                height = Math.max(height, preferred.height);
                ++i;
            }
        } else {
            i = 0;
            int n = this.getComponentCount();
            while (i < n) {
                Dimension preferred = this.getComponent(i).getPreferredSize();
                width = Math.max(width, preferred.width);
                height += preferred.height;
                ++i;
            }
        }
        Insets insets = this.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        if (this.orientation.isHorizontal()) {
            for (ActionItem entry : this.actions) {
                if (entry.item == null) continue;
                Dimension preferred = ((JComponent)entry.item.getItem()).getPreferredSize();
                width += preferred.width;
                height = Math.max(height, preferred.height);
            }
        } else {
            for (ActionItem entry : this.actions) {
                if (entry.item == null) continue;
                Dimension preferred = ((JComponent)entry.item.getItem()).getPreferredSize();
                width = Math.max(width, preferred.width);
                height += preferred.height;
            }
        }
        Insets insets = this.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    public void setVisibleActions(int count) {
        if (this.visibleActions != count) {
            this.visibleActions = count;
            this.resetVisibleActions();
        }
    }

    private void resetVisibleActions() {
        this.removeAll();
        if (this.menuItem == null) {
            for (ActionItem entry : this.actions) {
                if (entry.item == null) continue;
                this.add((Component)entry.item.getItem());
            }
        } else {
            this.menuSource.removeAll();
            int set = 0;
            int index = 0;
            int max = this.actions.size();
            int length = this.actions.size();
            while (set < this.visibleActions && index < length) {
                BasicTitleViewItem<JComponent> item = this.actions.get((int)index++).item;
                if (item == null) {
                    --max;
                    continue;
                }
                ++set;
                this.add((Component)item.getItem());
            }
            if (set < max) {
                int i = set;
                int n = this.actions.size();
                while (i < n) {
                    this.menuSource.add(this.actions.get((int)i).action);
                    ++i;
                }
                this.add((Component)this.menuItem.getItem());
            }
        }
    }

    @Override
    public void doLayout() {
        Dimension current = this.getCurrentPreferredSize();
        Insets insets = this.getInsets();
        current.width -= insets.left + insets.right;
        current.height -= insets.top + insets.bottom;
        if (this.orientation.isHorizontal()) {
            if (current.width <= 0) {
                return;
            }
            int x = insets.left;
            int y = insets.top;
            int height = this.getHeight() - insets.top - insets.bottom;
            int width = this.getWidth() - insets.left - insets.right;
            if (width > current.width) {
                x += width - current.width;
                width = current.width;
            }
            int i = 0;
            int n = this.getComponentCount();
            while (i < n) {
                Component c = this.getComponent(i);
                Dimension preferred = c.getPreferredSize();
                if (current.width <= 0) {
                    if (width <= 0) {
                        width = 1;
                    }
                    current.width = width;
                }
                if (width == current.width) {
                    c.setBounds(x, y, preferred.width, height);
                } else {
                    double factor = (double)width / (double)current.width;
                    c.setBounds(x, y, (int)(factor * (double)preferred.width), height);
                }
                current.width -= preferred.width;
                width -= c.getWidth();
                x += c.getWidth();
                ++i;
            }
        } else {
            if (current.width <= 0) {
                return;
            }
            int x = insets.left;
            int y = insets.top;
            int height = this.getHeight() - insets.top - insets.bottom;
            int width = this.getWidth() - insets.left - insets.bottom;
            if (height > current.height) {
                y += height - current.height;
                height = current.height;
            }
            int i = 0;
            int n = this.getComponentCount();
            while (i < n) {
                Component c = this.getComponent(i);
                Dimension preferred = c.getPreferredSize();
                if (current.height <= 0) {
                    if (height <= 0) {
                        height = 1;
                    }
                    current.height = height;
                }
                if (height == current.height) {
                    c.setBounds(x, y, width, preferred.height);
                } else {
                    double factor = (double)height / (double)current.height;
                    c.setBounds(x, y, width, (int)(factor * (double)preferred.height));
                }
                current.height -= preferred.height;
                height -= c.getHeight();
                y += c.getHeight();
                ++i;
            }
        }
    }

    private static class ActionItem {
        public DockAction action;
        public BasicTitleViewItem<JComponent> item;

        private ActionItem() {
        }
    }

    private class Listener
    implements DockActionSourceListener,
    DockHierarchyListener {
        private Dockable dockable;

        private Listener() {
        }

        public void setDockable(Dockable dockable) {
            if (this.dockable != null) {
                this.dockable.removeDockHierarchyListener(this);
                this.dockable = null;
            }
            this.dockable = dockable;
            DockController controller = null;
            if (dockable != null) {
                dockable.addDockHierarchyListener(this);
                controller = dockable.getController();
            }
            if (ButtonPanel.this.menuIcon != null) {
                if (controller == null) {
                    ButtonPanel.this.menuIcon.setManager(null);
                } else {
                    ButtonPanel.this.menuIcon.setManager(controller.getIcons());
                }
            }
        }

        @Override
        public void controllerChanged(DockHierarchyEvent event) {
            DockController controller = null;
            if (this.dockable != null) {
                controller = this.dockable.getController();
            }
            if (ButtonPanel.this.menuIcon != null) {
                if (controller == null) {
                    ButtonPanel.this.menuIcon.setManager(null);
                } else {
                    ButtonPanel.this.menuIcon.setManager(controller.getIcons());
                }
            }
            ButtonPanel.this.set();
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent event) {
        }

        @Override
        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            int i = firstIndex;
            while (i <= lastIndex) {
                DockAction action = source.getDockAction(i);
                ActionItem entry = new ActionItem();
                entry.action = action;
                if (this.dockable.getController() != null) {
                    BasicTitleViewItem<JComponent> item = ButtonPanel.this.createItemFor(action, this.dockable);
                    entry.item = item;
                    if (item != null) {
                        action.bind(this.dockable);
                        item.bind();
                        item.setOrientation(ButtonPanel.this.orientation);
                        item.setForeground(ButtonPanel.this.getForeground());
                        item.setBackground(ButtonPanel.this.getBackground());
                    }
                }
                ButtonPanel.this.actions.add(i, entry);
                ++i;
            }
            ButtonPanel.this.visibleActions = ButtonPanel.this.actions.size();
            ButtonPanel.this.resetVisibleActions();
            ButtonPanel.this.revalidate();
        }

        @Override
        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            int i = lastIndex;
            while (i >= firstIndex) {
                ActionItem entry = (ActionItem)ButtonPanel.this.actions.remove(i);
                if (entry.item != null) {
                    entry.item.unbind();
                    entry.action.unbind(this.dockable);
                }
                --i;
            }
            ButtonPanel.this.visibleActions = ButtonPanel.this.actions.size();
            ButtonPanel.this.resetVisibleActions();
            ButtonPanel.this.revalidate();
        }
    }
}

