/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.mode;

import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModeSettings<A, B> {
    private List<DockableEntry> dockables = new ArrayList<DockableEntry>();
    private Map<Path, ModeSetting<A>> modes = new HashMap<Path, ModeSetting<A>>();
    private ModeSettingsConverter<A, B> converter;
    private Map<Path, ModeSettingFactory<A>> factories = new HashMap<Path, ModeSettingFactory<A>>();

    public ModeSettings(ModeSettingsConverter<A, B> converter) {
        if (converter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        this.converter = converter;
    }

    public ModeSettingsConverter<A, B> getConverter() {
        return this.converter;
    }

    public void addFactory(ModeSettingFactory<A> factory) {
        this.factories.put(factory.getModeId(), factory);
    }

    public void add(String id, Path current, Map<Path, A> properties, Collection<Path> history) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        if (history == null) {
            throw new NullPointerException("history");
        }
        DockableEntry entry = new DockableEntry();
        entry.id = id;
        entry.current = current;
        entry.history = history.toArray(new Path[history.size()]);
        entry.properties = new HashMap();
        for (Map.Entry<Path, A> next : properties.entrySet()) {
            entry.properties.put(next.getKey(), this.converter.convertToSetting(next.getValue()));
        }
        this.dockables.add(entry);
    }

    public void add(Mode<A> mode) {
        ModeSettingFactory<A> factory = this.factories.get(mode.getUniqueIdentifier());
        if (factory == null) {
            throw new IllegalArgumentException("no factory present for '" + mode.getUniqueIdentifier() + "'");
        }
        ModeSetting<A> setting = factory.create();
        if (setting != null) {
            mode.writeSetting(setting);
            this.modes.put(setting.getModeId(), setting);
        }
    }

    public void add(ModeSetting<A> mode) {
        this.modes.put(mode.getModeId(), mode);
    }

    public int size() {
        return this.dockables.size();
    }

    public int indexOf(String id) {
        int index = 0;
        for (DockableEntry entry : this.dockables) {
            if (entry.id.equals(id)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String getId(int index) {
        return this.dockables.get((int)index).id;
    }

    public Path getCurrent(int index) {
        return this.dockables.get((int)index).current;
    }

    public Path[] getHistory(int index) {
        return this.dockables.get((int)index).history;
    }

    public Map<Path, A> getProperties(int index) {
        HashMap<Path, A> result = new HashMap<Path, A>();
        for (Map.Entry entry : this.dockables.get((int)index).properties.entrySet()) {
            result.put(entry.getKey(), this.converter.convertToWorld(entry.getValue()));
        }
        return result;
    }

    public ModeSetting<A> getSettings(Path modeId) {
        return this.modes.get(modeId);
    }

    public void write(DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_8);
        out.writeInt(this.dockables.size());
        for (DockableEntry dockableEntry : this.dockables) {
            out.writeUTF(dockableEntry.id);
            if (dockableEntry.current == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(dockableEntry.current.toString());
            }
            out.writeInt(dockableEntry.history.length);
            Path[] pathArray = dockableEntry.history;
            int n = dockableEntry.history.length;
            int n2 = 0;
            while (n2 < n) {
                Path history = pathArray[n2];
                out.writeUTF(history.toString());
                ++n2;
            }
            out.writeInt(dockableEntry.properties.size());
            for (Map.Entry next : dockableEntry.properties.entrySet()) {
                out.writeUTF(next.getKey().toString());
                this.converter.writeProperty(next.getValue(), out);
            }
        }
        out.writeInt(this.modes.size());
        for (ModeSetting modeSetting : this.modes.values()) {
            out.writeUTF(modeSetting.getModeId().toString());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            modeSetting.write(dout, this.converter);
            out.writeInt(bout.size());
            bout.writeTo(out);
            dout.close();
        }
    }

    protected void rescueSettings(DataInputStream in, Version version) throws IOException {
    }

    protected void rescueSettings(XElement element) {
    }

    protected Path resuceMode(String identifier) {
        return null;
    }

    public void read(DataInputStream in) throws IOException {
        int count;
        boolean version7;
        Version version = Version.read(in);
        version.checkCurrent();
        boolean bl = version7 = Version.VERSION_1_0_7.compareTo(version) >= 0;
        if (version7) {
            Version.read(in);
        }
        this.dockables.clear();
        int i = 0;
        int n = in.readInt();
        while (i < n) {
            DockableEntry entry = new DockableEntry();
            this.dockables.add(entry);
            entry.id = in.readUTF();
            if (in.readBoolean()) {
                String key = in.readUTF();
                entry.current = version7 ? this.resuceMode(key) : new Path(key);
            }
            entry.history = new Path[in.readInt()];
            int j = 0;
            while (j < entry.history.length) {
                String key = in.readUTF();
                entry.history[j] = version7 ? this.resuceMode(key) : new Path(key);
                ++j;
            }
            if (version7) {
                count = 0;
                int j2 = 0;
                while (j2 < entry.history.length) {
                    if (entry.history[j2] != null) {
                        ++count;
                    }
                    ++j2;
                }
                if (count != entry.history.length) {
                    Path[] temp = entry.history;
                    entry.history = new Path[count];
                    int index = 0;
                    int j3 = 0;
                    while (j3 < temp.length) {
                        if (temp[j3] != null) {
                            entry.history[index++] = temp[j3];
                        }
                        ++j3;
                    }
                }
            }
            entry.properties = new HashMap();
            j = 0;
            int m = in.readInt();
            while (j < m) {
                String key = in.readUTF();
                Path mode = version7 ? this.resuceMode(key) : new Path(key);
                B property = this.converter.readProperty(in);
                if (mode != null) {
                    entry.properties.put(mode, property);
                }
                ++j;
            }
            ++i;
        }
        this.modes.clear();
        if (version7) {
            this.rescueSettings(in, version);
        } else {
            i = 0;
            n = in.readInt();
            while (i < n) {
                int read;
                Path id = new Path(in.readUTF());
                count = in.readInt();
                byte[] content = new byte[count];
                int offset = 0;
                int length = count;
                while (length > 0 && (read = in.read(content, offset, length)) > 0) {
                    offset += read;
                    length -= read;
                }
                ByteArrayInputStream bin = new ByteArrayInputStream(content);
                DataInputStream din = new DataInputStream(bin);
                ModeSettingFactory<A> factory = this.factories.get(id);
                if (factory != null) {
                    ModeSetting<A> setting = factory.create();
                    setting.read(din, this.converter);
                    din.close();
                    this.modes.put(setting.getModeId(), setting);
                }
                ++i;
            }
        }
    }

    public void writeXML(XElement element) {
        XElement delement = element.addElement("dockables");
        for (DockableEntry entry : this.dockables) {
            XElement xentry = delement.addElement("entry");
            xentry.addString("id", entry.id);
            if (entry.current != null) {
                xentry.addString("current", entry.current.toString());
            }
            XElement xhistory = xentry.addElement("history");
            Path[] pathArray = entry.history;
            int n = entry.history.length;
            int n2 = 0;
            while (n2 < n) {
                Path history = pathArray[n2];
                xhistory.addElement("mode").setString(history.toString());
                ++n2;
            }
            XElement xproperties = xentry.addElement("properties");
            for (Map.Entry next : entry.properties.entrySet()) {
                XElement xproperty = xproperties.addElement("property");
                xproperty.addString("id", next.getKey().toString());
                this.converter.writePropertyXML(next.getValue(), xproperty);
            }
        }
        XElement melement = element.addElement("modes");
        for (ModeSetting<A> mode : this.modes.values()) {
            XElement xmode = melement.addElement("entry");
            xmode.addString("id", mode.getModeId().toString());
            mode.write(xmode, this.converter);
        }
    }

    public void readXML(XElement element) {
        int n;
        this.dockables.clear();
        XElement delement = element.getElement("dockables");
        if (delement != null) {
            XElement[] xElementArray = delement.getElements("entry");
            n = xElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                XElement xhistory;
                XElement xentry = xElementArray[n2];
                DockableEntry entry = new DockableEntry();
                this.dockables.add(entry);
                entry.id = xentry.getString("id");
                XAttribute current = xentry.getAttribute("current");
                if (current != null) {
                    entry.current = new Path(current.getString());
                }
                if ((xhistory = xentry.getElement("history")) == null) {
                    entry.history = new Path[0];
                } else {
                    XElement[] xmodes = xhistory.getElements("mode");
                    entry.history = new Path[xmodes.length];
                    int i = 0;
                    while (i < xmodes.length) {
                        entry.history[i] = new Path(xmodes[i].getString());
                        ++i;
                    }
                }
                XElement xproperties = xentry.getElement("properties");
                entry.properties = new HashMap();
                if (xproperties != null) {
                    XElement[] xElementArray2 = xproperties.getElements("property");
                    int n3 = xElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        XElement xproperty = xElementArray2[n4];
                        entry.properties.put(new Path(xproperty.getString("id")), this.converter.readPropertyXML(xproperty));
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        this.modes.clear();
        XElement melement = element.getElement("modes");
        if (melement != null) {
            XElement[] xElementArray = melement.getElements("entry");
            int n5 = xElementArray.length;
            n = 0;
            while (n < n5) {
                XElement xmode = xElementArray[n];
                Path id = new Path(xmode.getString("id"));
                ModeSettingFactory<A> factory = this.factories.get(id);
                if (factory != null) {
                    ModeSetting<A> setting = factory.create();
                    setting.read(xmode, this.converter);
                    this.modes.put(setting.getModeId(), setting);
                }
                ++n;
            }
        } else {
            this.rescueSettings(element);
        }
    }

    private class DockableEntry {
        public String id;
        public Path current;
        public Map<Path, B> properties;
        public Path[] history;

        private DockableEntry() {
        }
    }
}

