/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PlaceholderMap {
    private int version;
    private Path format;
    private Map<Key, Map<String, Object>> data = new LinkedHashMap<Key, Map<String, Object>>();
    private PlaceholderStrategy strategy;
    private PlaceholderStrategyListener listener = new PlaceholderStrategyListener(){

        @Override
        public void placeholderInvalidated(Set<Path> placeholders) {
            PlaceholderMap.this.removeAll(placeholders, false);
        }
    };

    public PlaceholderMap(Path format, int version) {
        if (format == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        this.format = format;
        this.version = version;
    }

    public PlaceholderMap(DataInputStream in, PlaceholderStrategy strategy) throws IOException {
        this.setPlaceholderStrategy(strategy);
        Version version = Version.read(in);
        if (version.compareTo(Version.VERSION_1_0_8) != 0) {
            throw new IOException("unknown version: " + version);
        }
        this.version = in.readInt();
        this.format = new Path(in.readUTF());
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            PlaceholderKey key = new PlaceholderKey(in);
            if ((key = key.shrink(strategy)) != null) {
                this.add(key);
                Map<String, Object> map = this.data.get(key);
                int length = in.readInt();
                int j = 0;
                while (j < length) {
                    String subkey = in.readUTF();
                    Object value = this.read(in, strategy);
                    map.put(subkey, value);
                    ++j;
                }
            } else {
                int length = in.readInt();
                int j = 0;
                while (j < length) {
                    in.readUTF();
                    this.read(in, strategy);
                    ++j;
                }
            }
            ++i;
        }
    }

    public PlaceholderMap(XElement in, PlaceholderStrategy strategy) {
        this.setPlaceholderStrategy(strategy);
        XElement xversion = in.getElement("version");
        if (xversion == null) {
            throw new XException("missing element 'version'");
        }
        this.version = xversion.getInt();
        XElement xformat = in.getElement("format");
        if (xformat == null) {
            throw new XException("missing element 'format'");
        }
        this.format = new Path(xformat.getString());
        int i = 0;
        int n = in.getElementCount();
        while (i < n) {
            XElement xentry = in.getElement(i);
            if (xentry.getName().equals("entry")) {
                PlaceholderKey placeholder = new PlaceholderKey(xentry.getElement("key"));
                if ((placeholder = placeholder.shrink(strategy)) != null) {
                    this.add(placeholder);
                    Map<String, Object> map = this.data.get(placeholder);
                    int j = 0;
                    int m = xentry.getElementCount();
                    while (j < m) {
                        XElement xitem = xentry.getElement(j);
                        if (xitem.getName().equals("item")) {
                            String key = xitem.getString("key");
                            Object value = this.read(xitem, strategy);
                            map.put(key, value);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public void write(DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_8);
        out.writeInt(this.version);
        out.writeUTF(this.format.toString());
        out.writeInt(this.data.size());
        for (Map.Entry<Key, Map<String, Object>> entry : this.data.entrySet()) {
            ((PlaceholderKey)entry.getKey()).write(out);
            Map<String, Object> map = entry.getValue();
            out.writeInt(map.size());
            for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
                out.writeUTF(mapEntry.getKey());
                this.write(mapEntry.getValue(), out);
            }
        }
    }

    private void write(Object value, DataOutputStream out) throws IOException {
        if (value instanceof String) {
            out.writeByte(0);
            out.writeUTF((String)value);
        } else if (value instanceof Integer) {
            out.writeByte(1);
            out.writeInt((Integer)value);
        } else if (value instanceof Long) {
            out.writeByte(2);
            out.writeLong((Long)value);
        } else if (value instanceof Double) {
            out.writeByte(3);
            out.writeDouble((Double)value);
        } else if (value instanceof Boolean) {
            out.writeByte(4);
            out.writeBoolean((Boolean)value);
        } else if (value instanceof PlaceholderMap) {
            out.writeByte(5);
            ((PlaceholderMap)value).write(out);
        } else if (value instanceof Object[]) {
            out.writeByte(6);
            Object[] array = (Object[])value;
            out.writeInt(array.length);
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                this.write(item, out);
                ++n2;
            }
        } else {
            throw new IOException("unknown type: " + value.getClass());
        }
    }

    private Object read(DataInputStream in, PlaceholderStrategy strategy) throws IOException {
        byte kind = in.readByte();
        switch (kind) {
            case 0: {
                return in.readUTF();
            }
            case 1: {
                return in.readInt();
            }
            case 2: {
                return in.readLong();
            }
            case 3: {
                return in.readDouble();
            }
            case 4: {
                return in.readBoolean();
            }
            case 5: {
                return new PlaceholderMap(in, strategy);
            }
            case 6: {
                int length = in.readInt();
                Object[] result = new Object[length];
                int i = 0;
                while (i < length) {
                    result[i] = this.read(in, strategy);
                    ++i;
                }
                return result;
            }
        }
        throw new IOException("illegal format");
    }

    public void write(XElement out) {
        out.addElement("version").setInt(this.version);
        out.addElement("format").setString(this.format.toString());
        for (Map.Entry<Key, Map<String, Object>> entry : this.data.entrySet()) {
            XElement xplaceholder = out.addElement("entry");
            ((PlaceholderKey)entry.getKey()).write(xplaceholder.addElement("key"));
            Map<String, Object> map = entry.getValue();
            for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
                XElement xitem = xplaceholder.addElement("item");
                xitem.addString("key", mapEntry.getKey());
                this.write(mapEntry.getValue(), xitem);
            }
        }
    }

    private void write(Object value, XElement out) {
        if (value instanceof String) {
            out.addString("type", "s");
            out.setString((String)value);
        } else if (value instanceof Integer) {
            out.addString("type", "i");
            out.setInt((Integer)value);
        } else if (value instanceof Long) {
            out.addString("type", "l");
            out.setLong((Long)value);
        } else if (value instanceof Double) {
            out.addString("type", "d");
            out.setDouble((Double)value);
        } else if (value instanceof Boolean) {
            out.addString("type", "b");
            out.setBoolean((Boolean)value);
        } else if (value instanceof PlaceholderMap) {
            out.addString("type", "p");
            ((PlaceholderMap)value).write(out);
        } else if (value instanceof Object[]) {
            Object[] array;
            out.addString("type", "a");
            Object[] objectArray = array = (Object[])value;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                this.write(item, out.addElement("item"));
                ++n2;
            }
        } else {
            throw new XException("unknown type: " + value.getClass());
        }
    }

    private Object read(XElement in, PlaceholderStrategy strategy) {
        String type = in.getString("type");
        if ("s".equals(type)) {
            return in.getString();
        }
        if ("i".equals(type)) {
            return in.getInt();
        }
        if ("l".equals(type)) {
            return in.getLong();
        }
        if ("d".equals(type)) {
            return in.getDouble();
        }
        if ("b".equals(type)) {
            return in.getBoolean();
        }
        if ("p".equals(type)) {
            return new PlaceholderMap(in, strategy);
        }
        if ("a".equals(type)) {
            XElement[] xitems = in.getElements("item");
            Object[] result = new Object[xitems.length];
            int i = 0;
            while (i < xitems.length) {
                result[i] = this.read(xitems[i], strategy);
                ++i;
            }
            return result;
        }
        throw new XException("unknown type: " + type);
    }

    public PlaceholderMap copy() {
        PlaceholderMap result = new PlaceholderMap(this.format, this.version);
        for (Map.Entry<Key, Map<String, Object>> entry : this.data.entrySet()) {
            Key newKey = result.copyKey(entry.getKey());
            result.add(newKey);
            Map<String, Object> map = result.data.get(newKey);
            for (Map.Entry<String, Object> valueEntry : entry.getValue().entrySet()) {
                map.put(valueEntry.getKey(), this.copy(valueEntry.getValue()));
            }
        }
        return result;
    }

    public PlaceholderMap filter(PlaceholderStrategy strategy) {
        if (strategy == null || this.strategy == strategy) {
            return this;
        }
        PlaceholderMap copy = this.copy();
        copy.setPlaceholderStrategy(strategy);
        copy.setPlaceholderStrategy(null);
        return copy;
    }

    private Object copy(Object value) {
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Double) {
            return value;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof PlaceholderMap) {
            return ((PlaceholderMap)value).copy();
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            Object[] copy = new Object[array.length];
            int i = 0;
            while (i < copy.length) {
                copy[i] = this.copy(array[i]);
                ++i;
            }
            return copy;
        }
        throw new IllegalArgumentException("unknown type: " + value.getClass());
    }

    public Key newKey(Path ... placeholders) {
        return new PlaceholderKey(placeholders, true);
    }

    public Key newUniqueKey(Path ... placeholders) {
        return new PlaceholderKey(placeholders, false);
    }

    public Key copyKey(Key key) {
        return new PlaceholderKey(key.getPlaceholders(), key.isShared());
    }

    public void setPlaceholderStrategy(PlaceholderStrategy strategy) {
        if (this.strategy != null) {
            this.strategy.removeListener(this.listener);
        }
        this.strategy = strategy;
        for (Map<String, Object> map : this.data.values()) {
            for (Object value : map.values()) {
                this.setPlaceholderStrategy(value, strategy);
            }
        }
        if (this.strategy != null) {
            this.validate(this.strategy, false);
            this.strategy.addListener(this.listener);
        }
    }

    private void setPlaceholderStrategy(Object value, PlaceholderStrategy strategy) {
        if (value instanceof PlaceholderMap) {
            ((PlaceholderMap)value).setPlaceholderStrategy(strategy);
        } else if (value instanceof Object[]) {
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.setPlaceholderStrategy(child, strategy);
                ++n2;
            }
        }
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.strategy;
    }

    public void validate(PlaceholderStrategy strategy, boolean recursive) {
        Key[] keys;
        if (strategy == null) {
            return;
        }
        if (recursive) {
            for (Map<String, Object> map : this.data.values()) {
                for (Object value : map.values()) {
                    this.validate(value, strategy);
                }
            }
        }
        Key[] keyArray = keys = this.data.keySet().toArray(new Key[this.data.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Key key = keyArray[n2];
            PlaceholderKey replacement = ((PlaceholderKey)key).shrink(strategy);
            if (replacement != key) {
                Map<String, Object> map = this.data.remove(key);
                if (replacement != null) {
                    this.data.put(replacement, map);
                }
            }
            ++n2;
        }
    }

    private void validate(Object value, PlaceholderStrategy strategy) {
        if (value instanceof PlaceholderMap) {
            ((PlaceholderMap)value).validate(strategy, true);
        } else if (value instanceof Object[]) {
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.validate(child, strategy);
                ++n2;
            }
        }
    }

    public void removeAll(Path placeholder, boolean recursive) {
        HashSet<Path> placeholders = new HashSet<Path>();
        placeholders.add(placeholder);
        this.removeAll(placeholders, recursive);
    }

    public void removeAll(Set<Path> placeholders, boolean recursive) {
        Key[] keys;
        if (placeholders.isEmpty()) {
            return;
        }
        if (recursive) {
            for (Map<String, Object> map : this.data.values()) {
                for (Object value : map.values()) {
                    this.removeAll(value, placeholders);
                }
            }
        }
        Key[] keyArray = keys = this.data.keySet().toArray(new Key[this.data.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Key key = keyArray[n2];
            PlaceholderKey replacement = ((PlaceholderKey)key).shrink(placeholders);
            if (replacement != key) {
                Map<String, Object> map = this.data.remove(key);
                if (replacement != null) {
                    this.data.put(replacement, map);
                }
            }
            ++n2;
        }
    }

    private void removeAll(Object value, Set<Path> invalidated) {
        if (value instanceof PlaceholderMap) {
            ((PlaceholderMap)value).removeAll(invalidated, true);
        } else if (value instanceof Object[]) {
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.removeAll(child, invalidated);
                ++n2;
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    public Path getFormat() {
        return this.format;
    }

    public void add(Key placeholder) {
        if (placeholder == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        Map<String, Object> map = this.data.get(placeholder);
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
            this.data.put(placeholder, map);
        }
    }

    public void remove(Key placeholder) {
        this.data.remove(placeholder);
    }

    public Key[] getPlaceholders() {
        Set<Key> set = this.data.keySet();
        return set.toArray(new Key[set.size()]);
    }

    public String[] getKeys(Key placeholder) {
        Map<String, Object> map = this.data.get(placeholder);
        if (map == null) {
            return null;
        }
        Set<String> set = map.keySet();
        return set.toArray(new String[set.size()]);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void putString(Key placeholder, String key, String value) {
        this.put(placeholder, key, value);
    }

    public void putInt(Key placeholder, String key, int value) {
        this.put(placeholder, key, value);
    }

    public void putLong(Key placeholder, String key, long value) {
        this.put(placeholder, key, value);
    }

    public void putBoolean(Key placeholder, String key, boolean value) {
        this.put(placeholder, key, value);
    }

    public void putDouble(Key placeholder, String key, double value) {
        this.put(placeholder, key, value);
    }

    public void putMap(Key placeholder, String key, PlaceholderMap value) {
        this.put(placeholder, key, value);
    }

    public void putArray(Key placeholder, String key, Object[] value) {
        this.put(placeholder, key, value);
    }

    public void put(Key placeholder, String key, Object value) {
        Class<?> invalid = this.invalidType(value);
        if (invalid != null) {
            throw new IllegalArgumentException("value of illegal type: " + (invalid instanceof String ? invalid : invalid.getClass()));
        }
        this.add(placeholder);
        this.data.get(placeholder).put(key, value);
    }

    private Object invalidType(Object value) {
        if (value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Boolean || value instanceof PlaceholderMap) {
            return null;
        }
        if (value instanceof Object[]) {
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                Object result = this.invalidType(item);
                if (result != null) {
                    return result;
                }
                ++n2;
            }
        }
        if (value == null) {
            return "null";
        }
        return null;
    }

    public Object remove(Key placeholder, String key) {
        Map<String, Object> map = this.data.get(placeholder);
        if (map == null) {
            return null;
        }
        return map.remove(key);
    }

    public boolean contains(Key placeholder, String key) {
        return this.get(placeholder, key) != null;
    }

    public String getString(Key placeholder, String key) {
        Object data = this.get(placeholder, key);
        if (data instanceof String) {
            return (String)data;
        }
        throw new IllegalArgumentException();
    }

    public int getInt(Key placeholder, String key) {
        Object data = this.get(placeholder, key);
        if (data instanceof Integer) {
            return (Integer)data;
        }
        throw new IllegalArgumentException();
    }

    public long getLong(Key placeholder, String key) {
        Object data = this.get(placeholder, key);
        if (data instanceof Long) {
            return (Long)data;
        }
        throw new IllegalArgumentException();
    }

    public boolean getBoolean(Key placeholder, String key) {
        Object data = this.get(placeholder, key);
        if (data instanceof Boolean) {
            return (Boolean)data;
        }
        throw new IllegalArgumentException();
    }

    public double getDouble(Key placeholder, String key) {
        Object data = this.get(placeholder, key);
        if (data instanceof Double) {
            return (Double)data;
        }
        throw new IllegalArgumentException();
    }

    public PlaceholderMap getMap(Key placeholder, String key) {
        Object data = this.get(placeholder, key);
        if (data instanceof PlaceholderMap) {
            return (PlaceholderMap)data;
        }
        throw new IllegalArgumentException();
    }

    public Object[] getArray(Key placeholder, String key) {
        Object data = this.get(placeholder, key);
        if (data instanceof Object[]) {
            return (Object[])data;
        }
        throw new IllegalArgumentException();
    }

    public Object get(Key placeholder, String key) {
        Map<String, Object> map = this.data.get(placeholder);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public static interface Key {
        public Path[] getPlaceholders();

        public boolean isShared();
    }

    private class PlaceholderKey
    implements Key {
        private Path[] placeholders;
        private boolean shared;

        public PlaceholderKey(Path[] placeholders, boolean shared) {
            if (placeholders == null) {
                throw new IllegalArgumentException("placeholders must not be null");
            }
            Path[] pathArray = placeholders;
            int n = placeholders.length;
            int n2 = 0;
            while (n2 < n) {
                Path placeholder = pathArray[n2];
                if (placeholder == null) {
                    throw new IllegalArgumentException("placeholders does contain a null value");
                }
                ++n2;
            }
            this.placeholders = placeholders;
            this.shared = shared;
        }

        public PlaceholderKey(DataInputStream in) throws IOException {
            this.shared = in.readBoolean();
            this.placeholders = new Path[in.readInt()];
            int i = 0;
            while (i < this.placeholders.length) {
                this.placeholders[i] = new Path(in.readUTF());
                ++i;
            }
        }

        public PlaceholderKey(XElement in) {
            this.shared = in.getBoolean("shared");
            XElement[] xplaceholders = in.getElements("placeholder");
            this.placeholders = new Path[xplaceholders.length];
            int i = 0;
            while (i < xplaceholders.length) {
                this.placeholders[i] = new Path(xplaceholders[i].getString());
                ++i;
            }
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeBoolean(this.shared);
            out.writeInt(this.placeholders.length);
            Path[] pathArray = this.placeholders;
            int n = this.placeholders.length;
            int n2 = 0;
            while (n2 < n) {
                Path path = pathArray[n2];
                out.writeUTF(path.toString());
                ++n2;
            }
        }

        public void write(XElement out) {
            out.addBoolean("shared", this.shared);
            Path[] pathArray = this.placeholders;
            int n = this.placeholders.length;
            int n2 = 0;
            while (n2 < n) {
                Path placeholder = pathArray[n2];
                out.addElement("placeholder").setString(placeholder.toString());
                ++n2;
            }
        }

        public PlaceholderKey shrink(PlaceholderStrategy strategy) {
            if (strategy == null) {
                return this;
            }
            boolean[] remain = new boolean[this.placeholders.length];
            int count = 0;
            int i = 0;
            while (i < remain.length) {
                remain[i] = strategy.isValidPlaceholder(this.placeholders[i]);
                if (remain[i]) {
                    ++count;
                }
                ++i;
            }
            if (count == this.placeholders.length) {
                return this;
            }
            if (count == 0) {
                return null;
            }
            Path[] copy = new Path[count];
            int index = 0;
            int i2 = 0;
            while (i2 < this.placeholders.length) {
                if (remain[i2]) {
                    copy[index++] = this.placeholders[i2];
                }
                ++i2;
            }
            return new PlaceholderKey(copy, this.shared);
        }

        public PlaceholderKey shrink(Set<Path> invalidated) {
            boolean[] remain = new boolean[this.placeholders.length];
            int count = 0;
            int i = 0;
            while (i < remain.length) {
                boolean bl = remain[i] = !invalidated.contains(this.placeholders[i]);
                if (remain[i]) {
                    ++count;
                }
                ++i;
            }
            if (count == this.placeholders.length) {
                return this;
            }
            if (count == 0) {
                return null;
            }
            Path[] copy = new Path[count];
            int index = 0;
            int i2 = 0;
            while (i2 < this.placeholders.length) {
                if (remain[i2]) {
                    copy[index++] = this.placeholders[i2];
                }
                ++i2;
            }
            return new PlaceholderKey(copy, this.shared);
        }

        @Override
        public Path[] getPlaceholders() {
            return this.placeholders;
        }

        @Override
        public boolean isShared() {
            return this.shared;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Path[] pathArray = this.placeholders;
            int n = this.placeholders.length;
            int n2 = 0;
            while (n2 < n) {
                Path placeholder = pathArray[n2];
                builder.append(placeholder);
                builder.append(", ");
                ++n2;
            }
            builder.append("shared=");
            builder.append(this.shared);
            return builder.toString();
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.placeholders);
            if (this.shared) {
                return result;
            }
            return -result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.isShared()) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            PlaceholderKey that = (PlaceholderKey)obj;
            if (!that.isShared()) {
                return false;
            }
            return Arrays.equals(this.placeholders, that.placeholders);
        }
    }
}

