/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockStationListener;
import java.util.ArrayList;
import java.util.List;

public class DockStationListenerManager {
    private List<DockStationListener> listeners = new ArrayList<DockStationListener>();
    private DockStation station;

    public DockStationListenerManager(DockStation station) {
        if (station == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.station = station;
    }

    public DockStation getStation() {
        return this.station;
    }

    public void addListener(DockStationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DockStationListener listener) {
        this.listeners.remove(listener);
    }

    public void fireDockableVisibilitySet(Dockable dockable, boolean value) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener listener = dockStationListenerArray[n2];
            listener.dockableVisibiltySet(this.station, dockable, value);
            ++n2;
        }
    }

    public void fireDockableAdded(Dockable dockable) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener listener = dockStationListenerArray[n2];
            listener.dockableAdded(this.station, dockable);
            ++n2;
        }
    }

    public void fireDockableRemoved(Dockable dockable) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener listener = dockStationListenerArray[n2];
            listener.dockableRemoved(this.station, dockable);
            ++n2;
        }
    }

    public void fireDockableAdding(Dockable dockable) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener listener = dockStationListenerArray[n2];
            listener.dockableAdding(this.station, dockable);
            ++n2;
        }
    }

    public void fireDockableRemoving(Dockable dockable) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener listener = dockStationListenerArray[n2];
            listener.dockableRemoving(this.station, dockable);
            ++n2;
        }
    }

    public void fireDockableSelected(Dockable oldSelected, Dockable newSelected) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener listener = dockStationListenerArray[n2];
            listener.dockableSelected(this.station, oldSelected, newSelected);
            ++n2;
        }
    }

    public void fireDockablesRepositioned(Dockable ... dockables) {
        DockStationListener[] dockStationListenerArray = this.listeners.toArray(new DockStationListener[this.listeners.size()]);
        int n = dockStationListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockStationListener listener = dockStationListenerArray[n2];
            listener.dockablesRepositioned(this.station, dockables);
            ++n2;
        }
    }
}

