/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractTabContentFilter
implements TabContentFilter {
    private List<TabContentFilterListener> listeners = new ArrayList<TabContentFilterListener>();
    protected List<StackDockStation> stations = new ArrayList<StackDockStation>();
    protected List<StackDockComponent> components = new ArrayList<StackDockComponent>();
    private DockStationListener stationListener = new DockStationAdapter(){

        @Override
        public void dockableAdding(DockStation station, Dockable dockable) {
            AbstractTabContentFilter.this.added((StackDockStation)station, dockable);
        }

        @Override
        public void dockableRemoved(DockStation station, Dockable dockable) {
            AbstractTabContentFilter.this.removed((StackDockStation)station, dockable);
        }

        @Override
        public void dockableSelected(DockStation station, Dockable oldSelection, Dockable newSelection) {
            if (oldSelection != newSelection) {
                if (oldSelection != null) {
                    AbstractTabContentFilter.this.deselected((StackDockStation)station, oldSelection);
                }
                if (newSelection != null) {
                    AbstractTabContentFilter.this.selected((StackDockStation)station, newSelection);
                }
            }
        }
    };
    private ChangeListener componentListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
        }
    };

    @Override
    public void addListener(TabContentFilterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(TabContentFilterListener listener) {
        this.listeners.remove(listener);
    }

    protected TabContentFilterListener[] listeners() {
        return this.listeners.toArray(new TabContentFilterListener[this.listeners.size()]);
    }

    protected void fireChanged() {
        TabContentFilterListener[] tabContentFilterListenerArray = this.listeners();
        int n = tabContentFilterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabContentFilterListener listener = tabContentFilterListenerArray[n2];
            listener.contentChanged();
            ++n2;
        }
    }

    protected void fireChanged(Dockable dockable) {
        TabContentFilterListener[] tabContentFilterListenerArray = this.listeners();
        int n = tabContentFilterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabContentFilterListener listener = tabContentFilterListenerArray[n2];
            listener.contentChanged(dockable);
            ++n2;
        }
    }

    protected void fireChanged(StackDockStation station) {
        TabContentFilterListener[] tabContentFilterListenerArray = this.listeners();
        int n = tabContentFilterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabContentFilterListener listener = tabContentFilterListenerArray[n2];
            listener.contentChanged(station);
            ++n2;
        }
    }

    protected void fireChanged(StackDockComponent component) {
        TabContentFilterListener[] tabContentFilterListenerArray = this.listeners();
        int n = tabContentFilterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabContentFilterListener listener = tabContentFilterListenerArray[n2];
            listener.contentChanged(component);
            ++n2;
        }
    }

    @Override
    public void install(StackDockStation station) {
        this.stations.add(station);
        station.addDockStationListener(this.stationListener);
    }

    @Override
    public void install(StackDockComponent component) {
        this.components.add(component);
        component.addChangeListener(this.componentListener);
    }

    @Override
    public void uninstall(StackDockStation station) {
        this.stations.remove(station);
        station.removeDockStationListener(this.stationListener);
    }

    @Override
    public void uninstall(StackDockComponent component) {
        this.components.remove(component);
        component.removeChangeListener(this.componentListener);
    }

    @Override
    public TabContent filter(TabContent content, StackDockStation station, Dockable dockable) {
        return content;
    }

    @Override
    public TabContent filter(TabContent content, StackDockComponent component, Dockable dockable) {
        return content;
    }

    protected void added(StackDockStation station, Dockable dockable) {
    }

    protected void removed(StackDockStation station, Dockable dockable) {
    }

    protected void selected(StackDockStation station, Dockable dockable) {
    }

    protected void deselected(StackDockStation station, Dockable dockable) {
    }

    protected void selectionChanged(StackDockComponent component) {
    }
}

