/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.util.Path;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SplitDockPlaceholderProperty
extends AbstractDockableProperty {
    private Path placeholder;
    private DockableProperty backup;

    public SplitDockPlaceholderProperty() {
    }

    public SplitDockPlaceholderProperty(Path placeholder) {
        this(placeholder, (DockableProperty)null);
    }

    public SplitDockPlaceholderProperty(Path placeholder, SplitDockProperty backup) {
        this(placeholder, (DockableProperty)backup);
    }

    public SplitDockPlaceholderProperty(Path placeholder, SplitDockPathProperty backup) {
        this(placeholder, (DockableProperty)backup);
    }

    private SplitDockPlaceholderProperty(Path placeholder, DockableProperty backup) {
        if (placeholder == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        this.placeholder = placeholder;
        this.backup = backup;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    public DockableProperty toLocation(SplitNode target) {
        if (this.backup == null) {
            return this.toSplitLocation(target);
        }
        return this.backup;
    }

    public SplitDockProperty toSplitLocation(SplitNode target) {
        if (this.backup instanceof SplitDockProperty) {
            return (SplitDockProperty)this.backup;
        }
        if (this.backup instanceof SplitDockPathProperty) {
            return ((SplitDockPathProperty)this.backup).toLocation(target);
        }
        SplitDockProperty result = new SplitDockProperty(target.getX(), target.getY(), target.getWidth(), target.getHeight());
        result.setSuccessor(this.getSuccessor());
        return result;
    }

    @Override
    public void setSuccessor(DockableProperty successor) {
        super.setSuccessor(successor);
        if (this.backup != null) {
            this.backup.setSuccessor(successor);
        }
    }

    public DockableProperty getBackup() {
        return this.backup;
    }

    @Override
    public SplitDockPlaceholderProperty copy() {
        SplitDockPlaceholderProperty copy = new SplitDockPlaceholderProperty(this.placeholder, this.backup == null ? null : this.backup.copy());
        this.copy(copy);
        return copy;
    }

    @Override
    public String getFactoryID() {
        return "SplitDockPlaceholderProperty";
    }

    @Override
    public void store(DataOutputStream out) throws IOException {
        out.writeUTF(this.placeholder.toString());
        if (this.backup == null) {
            out.writeByte(0);
        } else if (this.backup instanceof SplitDockProperty) {
            out.writeByte(1);
            this.backup.store(out);
        } else if (this.backup instanceof SplitDockPathProperty) {
            out.writeByte(2);
            this.backup.store(out);
        } else {
            throw new IllegalStateException("never happens");
        }
    }

    @Override
    public void load(DataInputStream in) throws IOException {
        this.placeholder = new Path(in.readUTF());
        switch (in.readByte()) {
            case 0: {
                this.backup = null;
                break;
            }
            case 1: {
                this.backup = new SplitDockProperty();
                this.backup.load(in);
                break;
            }
            case 2: {
                this.backup = new SplitDockPathProperty();
                this.backup.load(in);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type of backup property");
            }
        }
    }

    @Override
    public void store(XElement element) {
        element.addElement("placeholder").setString(this.placeholder.toString());
        if (this.backup instanceof SplitDockProperty) {
            this.backup.store(element.addElement("backup-location"));
        } else if (this.backup instanceof SplitDockPathProperty) {
            this.backup.store(element.addElement("backup-path"));
        }
    }

    @Override
    public void load(XElement element) {
        this.placeholder = new Path(element.getElement("placeholder").getString());
        this.backup = null;
        XElement xchild = element.getElement("backup-path");
        if (xchild != null) {
            this.backup = new SplitDockPathProperty();
            this.backup.load(xchild);
        } else {
            xchild = element.getElement("backup-location");
            if (xchild != null) {
                this.backup = new SplitDockProperty();
                this.backup.load(xchild);
            }
        }
    }
}

