/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedButtonDockAction;
import bibliothek.gui.dock.station.screen.ScreenDockStationListener;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.util.PropertyValue;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class ScreenFullscreenAction
extends GroupedButtonDockAction<Boolean>
implements ListeningDockAction {
    private ScreenDockStation screen;
    private DockController controller;
    private DockActionIcon iconNormalize;
    private DockActionIcon iconMaximize;
    private DockActionText textNormalize;
    private DockActionText textMaximize;
    private DockActionText textNormalizeTooltip;
    private DockActionText textMaximizeTooltip;
    private PropertyValue<KeyStroke> accelerator = new PropertyValue<KeyStroke>(SplitDockStation.MAXIMIZE_ACCELERATOR){

        @Override
        protected void valueChanged(KeyStroke oldValue, KeyStroke newValue) {
            ScreenFullscreenAction.this.setAccelerator(Boolean.TRUE, newValue);
            ScreenFullscreenAction.this.setAccelerator(Boolean.FALSE, newValue);
        }
    };

    public ScreenFullscreenAction(ScreenDockStation station) {
        super(null);
        this.screen = station;
        this.setRemoveEmptyGroups(false);
        station.addScreenDockStationListener(new ScreenDockStationListener(){

            @Override
            public void windowRegistering(ScreenDockStation station, Dockable dockable, ScreenDockWindow window) {
            }

            @Override
            public void windowDeregistering(ScreenDockStation station, Dockable dockable, ScreenDockWindow window) {
            }

            @Override
            public void fullscreenChanged(ScreenDockStation station, Dockable dockable) {
                ScreenFullscreenAction.this.change(dockable, station.isFullscreen(dockable));
            }
        });
        this.textNormalize = new DockActionText("screen.normalize", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                ScreenFullscreenAction.this.setText(Boolean.TRUE, newValue);
            }
        };
        this.textMaximize = new DockActionText("screen.maximize", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                ScreenFullscreenAction.this.setTooltip(Boolean.FALSE, newValue);
            }
        };
        this.textNormalizeTooltip = new DockActionText("screen.normalize.tooltip", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                ScreenFullscreenAction.this.setTooltip(Boolean.TRUE, newValue);
            }
        };
        this.textMaximizeTooltip = new DockActionText("screen.maximize.tooltip", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                ScreenFullscreenAction.this.setTooltip(Boolean.FALSE, newValue);
            }
        };
        this.iconNormalize = new DockActionIcon("screen.normalize", this){

            @Override
            protected void changed(Icon oldValue, Icon newValue) {
                ScreenFullscreenAction.this.setIcon(true, newValue);
            }
        };
        this.iconMaximize = new DockActionIcon("screen.maximize", this){

            @Override
            protected void changed(Icon oldValue, Icon newValue) {
                ScreenFullscreenAction.this.setIcon(false, newValue);
            }
        };
    }

    @Override
    public void setController(DockController controller) {
        if (this.controller != controller) {
            this.controller = controller;
            this.accelerator.setProperties(controller);
            if (controller == null) {
                this.iconMaximize.setManager(null);
                this.iconNormalize.setManager(null);
            } else {
                this.iconMaximize.setManager(controller.getIcons());
                this.iconNormalize.setManager(controller.getIcons());
            }
            this.textNormalize.setController(controller);
            this.textNormalizeTooltip.setController(controller);
            this.textMaximize.setController(controller);
            this.textMaximizeTooltip.setController(controller);
        }
    }

    @Override
    public void action(Dockable dockable) {
        while (dockable.getDockParent() != this.screen) {
            DockStation station = dockable.getDockParent();
            if (station == null) {
                return;
            }
            dockable = station.asDockable();
            if (dockable != null) continue;
            return;
        }
        boolean state = this.screen.isFullscreen(dockable);
        this.screen.setFullscreen(dockable, !state);
    }

    private void change(Dockable dockable, Boolean value) {
        DockStation station;
        if (this.isKnown(dockable)) {
            this.setGroup(value, dockable);
        }
        if ((station = dockable.asDockStation()) != null) {
            int i = 0;
            int n = station.getDockableCount();
            while (i < n) {
                this.change(station.getDockable(i), value);
                ++i;
            }
        }
    }

    @Override
    protected Boolean createGroupKey(Dockable dockable) {
        while (dockable.getDockParent() != this.screen) {
            DockStation station = dockable.getDockParent();
            if (station == null) {
                return Boolean.FALSE;
            }
            dockable = station.asDockable();
            if (dockable != null) continue;
            return Boolean.FALSE;
        }
        return this.screen.isFullscreen(dockable);
    }
}

