/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.frontend.DockFrontendInternals;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.LayoutChangeStrategy;
import bibliothek.gui.dock.frontend.MissingDockableStrategy;
import bibliothek.gui.dock.frontend.RegisteringDockFactory;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.DockablePropertyFactory;
import bibliothek.gui.dock.layout.PredefinedDockSituation;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.perspective.PredefinedMap;
import bibliothek.gui.dock.perspective.PredefinedPerspective;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.xml.XException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultLayoutChangeStrategy
implements LayoutChangeStrategy {
    @Override
    public boolean setLayout(DockFrontendInternals frontend, Setting setting, boolean entry) throws IOException, XException {
        SettingAccess access;
        PredefinedDockSituation situation = this.createSituation(frontend, entry, true);
        DockSituationIgnore ignore = situation.getIgnore();
        if (ignore == null) {
            ignore = new DockSituationIgnore(){

                @Override
                public boolean ignoreChildren(DockStation station) {
                    return false;
                }

                @Override
                public boolean ignoreElement(DockElement element) {
                    return false;
                }

                @Override
                public boolean ignoreChildren(PerspectiveStation station) {
                    return false;
                }

                @Override
                public boolean ignoreElement(PerspectiveElement element) {
                    return false;
                }
            };
        }
        if (this.approveClosing(frontend, situation, access = this.createAccess(frontend, setting)) == null) {
            return false;
        }
        frontend.clean(ignore);
        this.applyLayout(frontend, situation, access, entry);
        this.applyInvisibleLayout(frontend, situation, access);
        return true;
    }

    protected SettingAccess createAccess(DockFrontendInternals frontend, Setting setting) {
        return new SettingAccess(setting);
    }

    @Override
    public PredefinedDockSituation createSituation(DockFrontendInternals frontend, boolean entry) {
        return this.createSituation(frontend, entry, false);
    }

    protected PredefinedDockSituation createSituation(final DockFrontendInternals frontend, final boolean entry, boolean onSetLayout) {
        Object factory;
        Object info;
        PredefinedDockSituation situation = new PredefinedDockSituation(){

            @Override
            protected boolean shouldLayout(DockElement element) {
                DockFrontend.DockInfo info;
                Dockable dockable;
                if (entry && (dockable = element.asDockable()) != null && (info = frontend.getInfo(dockable)) != null) {
                    info.isEntryLayout();
                }
                return true;
            }
        };
        Object[] objectArray = frontend.getDockables();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            info = objectArray[n2];
            if (((DockFrontend.DockInfo)info).getDockable() != null) {
                situation.put("dockable" + ((DockFrontend.DockInfo)info).getKey(), ((DockFrontend.DockInfo)info).getDockable());
            }
            ++n2;
        }
        objectArray = frontend.getRoots();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            info = objectArray[n2];
            situation.put("root" + ((DockFrontend.RootInfo)info).getName(), ((DockFrontend.RootInfo)info).getStation());
            ++n2;
        }
        objectArray = frontend.getDockFactories();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            factory = objectArray[n2];
            situation.add((DockFactory<?, ?, ?>)factory);
            ++n2;
        }
        objectArray = frontend.getBackupDockFactories();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object backup = objectArray[n2];
            situation.addBackup(new RegisteringDockFactory(frontend.getFrontend(), backup));
            ++n2;
        }
        objectArray = frontend.getAdjacentDockFactories();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            factory = objectArray[n2];
            situation.addAdjacent((AdjacentDockFactory<?>)factory);
            ++n2;
        }
        if (entry) {
            situation.setIgnore(frontend.getFrontend().getIgnoreForEntry());
        } else {
            situation.setIgnore(frontend.getFrontend().getIgnoreForFinal());
        }
        return situation;
    }

    @Override
    public PredefinedPerspective createPerspective(DockFrontendInternals frontend, boolean entry, final FrontendPerspectiveCache cache) {
        PerspectiveElement element;
        Object info;
        PredefinedDockSituation situation = this.createSituation(frontend, entry);
        PredefinedPerspective perspective = situation.createPerspective();
        Object[] objectArray = frontend.getDockables();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            info = objectArray[n2];
            if (((DockFrontend.DockInfo)info).getDockable() != null) {
                element = cache.get(((DockFrontend.DockInfo)info).getKey(), ((DockFrontend.DockInfo)info).getDockable(), false);
                perspective.put("dockable" + ((DockFrontend.DockInfo)info).getKey(), element);
            }
            ++n2;
        }
        objectArray = frontend.getRoots();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            info = objectArray[n2];
            element = cache.get(((DockFrontend.RootInfo)info).getName(), ((DockFrontend.RootInfo)info).getStation(), true);
            perspective.put("root" + ((DockFrontend.RootInfo)info).getName(), element);
            ++n2;
        }
        perspective.put(new PredefinedMap(){

            @Override
            public PerspectiveElement get(String id) {
                if (id.startsWith("dockable")) {
                    return cache.get(id.substring("dockable".length()), false);
                }
                if (id.startsWith("root")) {
                    return cache.get(id.substring("root".length()), true);
                }
                return null;
            }

            @Override
            public String get(PerspectiveElement element) {
                String id = cache.get(element);
                if (id == null) {
                    return null;
                }
                if (element.asStation() != null && cache.isRootStation(element.asStation())) {
                    return "root" + id;
                }
                return "dockable" + id;
            }
        });
        return perspective;
    }

    @Override
    public PropertyTransformer createTransformer(DockFrontendInternals frontend) {
        PropertyTransformer transformer = new PropertyTransformer();
        DockablePropertyFactory[] dockablePropertyFactoryArray = frontend.getPropertyFactories();
        int n = dockablePropertyFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockablePropertyFactory factory = dockablePropertyFactoryArray[n2];
            transformer.addFactory(factory);
            ++n2;
        }
        return transformer;
    }

    protected void applyLayout(DockFrontendInternals frontend, DockSituation situation, SettingAccess setting, boolean entry) throws IOException, XException {
        DockFrontend dockFrontend = frontend.getFrontend();
        MissingDockableStrategy missingDockable = frontend.getMissingDockableStrategy();
        DockFrontend.RootInfo[] rootInfoArray = frontend.getRoots();
        int n = rootInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontend.RootInfo info = rootInfoArray[n2];
            DockLayoutComposition layout = setting.getRoot(info.getName());
            if (layout != null) {
                Map<String, DockLayoutComposition> missingLayouts;
                Map<String, DockableProperty> missingLocations = this.listEstimateLocations(situation, layout = situation.fillMissing(layout));
                if (missingLocations != null) {
                    for (Map.Entry<String, DockableProperty> missing : missingLocations.entrySet()) {
                        String key = missing.getKey();
                        DockFrontend.DockInfo dockInfo = frontend.getInfo(key);
                        if (dockInfo == null && missingDockable.shouldStoreShown(key)) {
                            dockFrontend.addEmpty(key);
                            dockInfo = frontend.getInfo(key);
                        }
                        if (dockInfo == null) continue;
                        dockInfo.setLocation(info.getName(), missing.getValue());
                        dockInfo.setShown(true);
                    }
                }
                if ((missingLayouts = this.listLayouts(situation, layout)) != null) {
                    for (Map.Entry<String, DockLayoutComposition> missing : missingLayouts.entrySet()) {
                        String key = missing.getKey();
                        DockFrontend.DockInfo dockInfo = frontend.getInfo(key);
                        if (dockInfo == null && missingDockable.shouldStoreShown(key)) {
                            dockFrontend.addEmpty(key);
                            dockInfo = frontend.getInfo(key);
                        }
                        if (dockInfo == null) continue;
                        dockInfo.setShown(true);
                        if (entry && !dockInfo.isEntryLayout()) continue;
                        dockInfo.setLayout(missing.getValue());
                    }
                }
                situation.convert(layout);
            }
            ++n2;
        }
    }

    protected void applyInvisibleLayout(DockFrontendInternals frontend, DockSituation situation, SettingAccess setting) throws IOException, XException {
        DockFrontend dockFrontend = frontend.getFrontend();
        MissingDockableStrategy missingDockable = frontend.getMissingDockableStrategy();
        int i = 0;
        int n = setting.getInvisibleCount();
        while (i < n) {
            String key = setting.getInvisibleKey(i);
            DockFrontend.DockInfo info = frontend.getInfo(key);
            if (info == null && missingDockable.shouldStoreHidden(key)) {
                dockFrontend.addEmpty(key);
                info = frontend.getInfo(key);
            }
            if (info != null) {
                info.setShown(false);
                info.setLocation(setting.getInvisibleRoot(i), setting.getInvisibleLocation(i));
                DockLayoutComposition layout = setting.getInvisibleLayout(i);
                if (layout != null) {
                    layout = situation.fillMissing(layout);
                    if (info.getDockable() != null) {
                        situation.convert(layout);
                        layout = null;
                    }
                    info.setLayout(layout);
                }
            }
            ++i;
        }
    }

    protected Map<String, DockLayoutComposition> listLayouts(DockSituation situation, DockLayoutComposition layout) {
        if (situation instanceof PredefinedDockSituation) {
            Map<String, DockLayoutComposition> map = ((PredefinedDockSituation)situation).listLayouts(layout, true);
            HashMap<String, DockLayoutComposition> result = new HashMap<String, DockLayoutComposition>();
            for (Map.Entry<String, DockLayoutComposition> entry : map.entrySet()) {
                String key = entry.getKey();
                if (key.startsWith("dockable")) {
                    result.put(key.substring("dockable".length()), entry.getValue());
                    continue;
                }
                if (key.startsWith("root")) {
                    result.put(key.substring("root".length()), entry.getValue());
                    continue;
                }
                result.put(key, entry.getValue());
            }
            return result;
        }
        return null;
    }

    protected Map<String, DockableProperty> listEstimateLocations(DockSituation situation, DockLayoutComposition layout) {
        if (situation instanceof PredefinedDockSituation) {
            Map<String, DockableProperty> map = ((PredefinedDockSituation)situation).listEstimatedLocations(layout, true);
            HashMap<String, DockableProperty> result = new HashMap<String, DockableProperty>();
            for (Map.Entry<String, DockableProperty> entry : map.entrySet()) {
                String key = entry.getKey();
                if (key.startsWith("dockable")) {
                    result.put(key.substring("dockable".length()), entry.getValue());
                    continue;
                }
                if (key.startsWith("root")) {
                    result.put(key.substring("root".length()), entry.getValue());
                    continue;
                }
                result.put(key, entry.getValue());
            }
            return result;
        }
        return null;
    }

    @Override
    public void estimateLocations(DockFrontendInternals frontend, DockSituation situation, DockLayoutComposition layout) {
        if (situation instanceof PredefinedDockSituation) {
            ((PredefinedDockSituation)situation).estimateLocations(layout);
        }
    }

    protected Collection<Dockable> approveClosing(DockFrontendInternals frontend, DockSituation situation, SettingAccess setting) {
        HashSet<Dockable> remainingVisible = new HashSet<Dockable>();
        DockFrontend.RootInfo[] rootInfoArray = frontend.getRoots();
        int n = rootInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Set<Dockable> visible;
            DockFrontend.RootInfo info = rootInfoArray[n2];
            DockLayoutComposition layout = setting.getRoot(info.getName());
            if (layout != null && (visible = this.estimateVisible(frontend, situation, layout)) != null) {
                remainingVisible.addAll(visible);
            }
            ++n2;
        }
        Collection<Dockable> closing = this.getClosingDockables(frontend, remainingVisible);
        if (!closing.isEmpty() && !frontend.getVetos().expectToHide(closing, true)) {
            return null;
        }
        return closing;
    }

    protected Collection<Dockable> getClosingDockables(DockFrontendInternals frontend, Set<Dockable> visible) {
        ArrayList<Dockable> closing = new ArrayList<Dockable>();
        DockFrontend.DockInfo[] dockInfoArray = frontend.getDockables();
        int n = dockInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockFrontend.DockInfo info = dockInfoArray[n2];
            Dockable dockable = info.getDockable();
            if (dockable != null && info.isHideable() && !visible.contains(dockable)) {
                closing.add(info.getDockable());
            }
            ++n2;
        }
        return closing;
    }

    protected Set<Dockable> estimateVisible(DockFrontendInternals frontend, DockSituation situation, DockLayoutComposition layout) {
        if (situation instanceof PredefinedDockSituation) {
            HashSet<Dockable> allDockables = new HashSet<Dockable>();
            DockFrontend.DockInfo[] dockInfoArray = frontend.getDockables();
            int n = dockInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockFrontend.DockInfo info = dockInfoArray[n2];
                Dockable dockable = info.getDockable();
                if (dockable != null) {
                    allDockables.add(dockable);
                }
                ++n2;
            }
            PredefinedDockSituation predefined = (PredefinedDockSituation)situation;
            Set<Dockable> visible = predefined.listVisible(allDockables, layout);
            return visible;
        }
        return null;
    }

    @Override
    public PlaceholderStrategy getPlaceholderStrategy(DockFrontendInternals frontend) {
        return null;
    }

    protected class SettingAccess {
        private Setting setting;

        public SettingAccess(Setting setting) {
            this.setting = setting;
        }

        public Setting getSetting() {
            return this.setting;
        }

        public DockLayoutComposition getRoot(String root) {
            return this.setting.getRoot(root);
        }

        public String[] getRootKeys() {
            return this.setting.getRootKeys();
        }

        public int getInvisibleCount() {
            return this.setting.getInvisibleCount();
        }

        public String getInvisibleKey(int index) {
            return this.setting.getInvisibleKey(index);
        }

        public String getInvisibleRoot(int index) {
            return this.setting.getInvisibleRoot(index);
        }

        public DockableProperty getInvisibleLocation(int index) {
            return this.setting.getInvisibleLocation(index);
        }

        public DockLayoutComposition getInvisibleLayout(int index) {
            return this.setting.getInvisibleLayout(index);
        }

        public void fillMissing(DockSituation situation) {
            this.setting.fillMissing(situation);
        }
    }
}

