/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode.status;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.status.AbstractExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementFactory;

public class DefaultExtendedModeEnablement
extends AbstractExtendedModeEnablement {
    public static final ExtendedModeEnablementFactory FACTORY = new ExtendedModeEnablementFactory(){

        @Override
        public ExtendedModeEnablement create(LocationModeManager<?> manager) {
            return new DefaultExtendedModeEnablement(manager);
        }
    };
    private CDockablePropertyListener listener = new CDockableAdapter(){

        @Override
        public void minimizableChanged(CDockable dockable) {
            DefaultExtendedModeEnablement.this.fire(dockable.intern(), ExtendedMode.MINIMIZED, DefaultExtendedModeEnablement.this.isAvailable(dockable.intern(), ExtendedMode.MINIMIZED));
        }

        @Override
        public void maximizableChanged(CDockable dockable) {
            DefaultExtendedModeEnablement.this.fire(dockable.intern(), ExtendedMode.MAXIMIZED, DefaultExtendedModeEnablement.this.isAvailable(dockable.intern(), ExtendedMode.MAXIMIZED));
        }

        @Override
        public void externalizableChanged(CDockable dockable) {
            DefaultExtendedModeEnablement.this.fire(dockable.intern(), ExtendedMode.EXTERNALIZED, DefaultExtendedModeEnablement.this.isAvailable(dockable.intern(), ExtendedMode.EXTERNALIZED));
        }
    };

    public DefaultExtendedModeEnablement(LocationModeManager<?> manager) {
        super(manager);
        this.init();
    }

    @Override
    protected void connect(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(this.listener);
        }
    }

    @Override
    protected void disconnect(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(this.listener);
        }
    }

    @Override
    public boolean isAvailable(Dockable dockable, ExtendedMode mode) {
        DockStation station;
        if (mode == ExtendedMode.NORMALIZED) {
            return true;
        }
        if (dockable instanceof CommonDockable) {
            CDockable cdockable = ((CommonDockable)dockable).getDockable();
            if (mode == ExtendedMode.EXTERNALIZED) {
                return cdockable.isExternalizable();
            }
            if (mode == ExtendedMode.MAXIMIZED) {
                return cdockable.isMaximizable();
            }
            if (mode == ExtendedMode.MINIMIZED) {
                return cdockable.isMinimizable();
            }
        }
        if ((station = dockable.asDockStation()) != null) {
            int i = 0;
            int n = station.getDockableCount();
            while (i < n) {
                boolean result = this.isAvailable(station.getDockable(i), mode);
                if (!result) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return true;
    }
}

