/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.event;

import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.event.LocatedListener;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class LocatedListenerList<L extends LocatedListener> {
    private List<L> listeners = new ArrayList<L>();

    public void addListener(L listener) {
        this.listeners.add(listener);
    }

    public void removeListener(L listener) {
        this.listeners.remove(listener);
    }

    public int size() {
        return this.listeners.size();
    }

    public List<L> affected(DockElement element) {
        LinkedList<LocatedListener> list = new LinkedList<LocatedListener>();
        for (LocatedListener listener : this.listeners) {
            DockElement location = listener.getTreeLocation();
            if (location == null) {
                list.add(listener);
                continue;
            }
            if (element == null || !DockUtilities.isAncestor(location, element)) continue;
            list.add(listener);
        }
        Collections.sort(list, new Comparator<L>(){

            @Override
            public int compare(L o1, L o2) {
                DockElement b;
                DockElement a = o1.getTreeLocation();
                if (a == (b = o2.getTreeLocation())) {
                    return 0;
                }
                if (a == null) {
                    return -1;
                }
                if (b == null) {
                    return 1;
                }
                if (DockUtilities.isAncestor(a, b)) {
                    return -1;
                }
                return 1;
            }
        });
        return list;
    }
}

