/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.focus.AbstractFocusController;
import bibliothek.gui.dock.control.focus.FocusStrategy;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class DefaultFocusController
extends AbstractFocusController {
    private Dockable focusedDockable = null;
    private boolean onFocusing = false;
    private boolean focusingPending = false;
    private Component focusingComponent;
    private boolean focusingEnsure;

    public DefaultFocusController(DockController controller) {
        super(controller);
    }

    @Override
    public boolean isOnFocusing() {
        return this.onFocusing;
    }

    @Override
    public Dockable getFocusedDockable() {
        return this.focusedDockable;
    }

    @Override
    public FocusVetoListener.FocusVeto checkFocusedDockable(DockElementRepresentative source) {
        if (source == null) {
            return null;
        }
        Dockable dockable = source.getElement().asDockable();
        if (dockable == null) {
            return null;
        }
        FocusVetoListener.FocusVeto veto = source instanceof DockTitle ? this.fireVetoTitle((DockTitle)source) : this.fireVetoDockable(dockable);
        if (veto == null) {
            return FocusVetoListener.FocusVeto.NONE;
        }
        return veto;
    }

    @Override
    public FocusVetoListener.FocusVeto setFocusedDockable(DockElementRepresentative source, Component component, boolean force, boolean ensureFocusSet, boolean ensureDockableFocused) {
        if (this.onFocusing || this.isFrozen()) {
            return null;
        }
        FocusVetoListener.FocusVeto veto = this.checkFocusedDockable(source);
        if (veto != null && veto != FocusVetoListener.FocusVeto.NONE) {
            return veto;
        }
        Dockable focusedDockable = null;
        if (source != null) {
            focusedDockable = source.getElement().asDockable();
        }
        try {
            this.onFocusing = true;
            if (force || this.focusedDockable != focusedDockable) {
                Dockable oldFocused = this.focusedDockable;
                this.focusedDockable = focusedDockable;
                if (ensureFocusSet || ensureDockableFocused) {
                    if (EventQueue.isDispatchThread()) {
                        if (!this.focusingPending) {
                            this.focusingPending = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DefaultFocusController.this.focusingPending = false;
                                    DefaultFocusController.this.ensureFocusSet(DefaultFocusController.this.focusingEnsure, DefaultFocusController.this.focusingComponent);
                                    DefaultFocusController.this.focusingComponent = null;
                                }
                            });
                        }
                        this.focusingEnsure = ensureDockableFocused;
                        this.focusingComponent = component;
                    } else {
                        this.ensureFocusSet(ensureDockableFocused, component);
                    }
                }
                if (oldFocused != focusedDockable) {
                    this.fireDockableFocused(oldFocused, focusedDockable);
                }
            }
        }
        finally {
            this.onFocusing = false;
        }
        return FocusVetoListener.FocusVeto.NONE;
    }

    @Override
    public void ensureFocusSet(boolean dockableOnly) {
        this.ensureFocusSet(dockableOnly, null);
    }

    private void ensureFocusSet(boolean dockableOnly, Component component) {
        if (this.isFrozen()) {
            return;
        }
        Dockable focusedDockable = this.focusedDockable;
        if (focusedDockable != null) {
            Stack<Dockable> front = new Stack<Dockable>();
            Dockable temp = focusedDockable;
            while (temp != null) {
                DockStation parent = temp.getDockParent();
                if (parent != null) {
                    front.push(temp);
                }
                Dockable dockable = temp = parent == null ? null : parent.asDockable();
            }
            while (!front.isEmpty()) {
                Dockable element = (Dockable)front.pop();
                element.getDockParent().setFrontDockable(element);
            }
            if (!dockableOnly) {
                DockTitle[] titles = focusedDockable.listBoundTitles();
                Component focused = FocusManager.getCurrentManager().getFocusOwner();
                if (focused != null) {
                    if (SwingUtilities.isDescendingFrom(focused, focusedDockable.getComponent())) {
                        return;
                    }
                    DockTitle[] dockTitleArray = titles;
                    int n = titles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DockTitle title = dockTitleArray[n2];
                        if (SwingUtilities.isDescendingFrom(focused, title.getComponent())) {
                            return;
                        }
                        ++n2;
                    }
                }
            }
            boolean preset = component != null;
            FocusStrategy strategy = this.getStrategy();
            if (strategy != null) {
                Component replacement = strategy.getFocusComponent(focusedDockable, component);
                if (replacement != null) {
                    if (replacement != component) {
                        component = replacement;
                        preset = false;
                    }
                } else {
                    preset = false;
                }
            }
            if (component == null) {
                component = focusedDockable.getComponent();
            }
            if (component.isFocusable()) {
                component.requestFocus();
                component.requestFocusInWindow();
                this.focus(component, 10, 20);
            } else if (!preset) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(component);
            }
        }
    }

    private void focus(final Component component, int delay, int loops) {
        final Timer timer = new Timer(delay, null);
        timer.addActionListener(new ActionListener(loops){
            private int remaining;
            {
                this.remaining = n;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                --this.remaining;
                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                if (manager.getPermanentFocusOwner() != component) {
                    manager.clearGlobalFocusOwner();
                    component.requestFocus();
                    if (this.remaining > 0) {
                        timer.restart();
                    }
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }
}

