/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme.eclipse;

import bibliothek.extension.gui.dock.theme.eclipse.DefaultEclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnectorListener;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;

public class CommonEclipseThemeConnector
extends DefaultEclipseThemeConnector {
    private CControl control;
    private boolean listening = false;
    private CDockablePropertyListener propertyListener = new CDockableAdapter(){

        @Override
        public void singleTabShownChanged(CDockable dockable) {
            this.fire(dockable);
        }

        @Override
        public void titleShownChanged(CDockable dockable) {
            this.fire(dockable);
        }

        private void fire(CDockable cdockable) {
            CommonDockable dockable = cdockable.intern();
            EclipseThemeConnector.TitleBar bar = CommonEclipseThemeConnector.this.getTitleBarKind(dockable.getDockParent(), dockable);
            EclipseThemeConnectorListener[] eclipseThemeConnectorListenerArray = CommonEclipseThemeConnector.this.listeners();
            int n = eclipseThemeConnectorListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                EclipseThemeConnectorListener listener = eclipseThemeConnectorListenerArray[n2];
                listener.titleBarChanged(CommonEclipseThemeConnector.this, dockable, bar);
                ++n2;
            }
        }
    };

    public CommonEclipseThemeConnector(CControl control) {
        this.control = control;
    }

    @Override
    public void addEclipseThemeConnectorListener(EclipseThemeConnectorListener listener) {
        super.addEclipseThemeConnectorListener(listener);
        this.updateListening();
    }

    @Override
    public void removeEclipseThemeConnectorListener(EclipseThemeConnectorListener listener) {
        super.removeEclipseThemeConnectorListener(listener);
        this.updateListening();
    }

    private void updateListening() {
        if (this.hasListeners()) {
            if (!this.listening) {
                this.listening = true;
                this.control.addPropertyListener(this.propertyListener);
            }
        } else if (this.listening) {
            this.listening = false;
            this.control.removePropertyListener(this.propertyListener);
        }
    }

    @Override
    public EclipseThemeConnector.TitleBar getTitleBarKind(DockStation parent, Dockable dockable) {
        boolean singleTab;
        boolean titleShown;
        if (parent instanceof StackDockStation) {
            return EclipseThemeConnector.TitleBar.NONE;
        }
        if (dockable instanceof CommonDockable && !(titleShown = ((CommonDockable)dockable).getDockable().isTitleShown()) && !(singleTab = ((CommonDockable)dockable).getDockable().isSingleTabShown())) {
            return EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        }
        return super.getTitleBarKind(parent, dockable);
    }
}

