/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.font;

import bibliothek.gui.dock.common.FontMap;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.font.FontTransmitter;
import bibliothek.gui.dock.util.font.DockFont;
import bibliothek.gui.dock.util.font.FontManager;
import bibliothek.gui.dock.util.font.FontModifier;

public abstract class ListFontTransmitter
extends FontTransmitter {
    private String[] source;
    private String[] destination;

    public ListFontTransmitter(FontManager manager, String[] sourceKeys, String[] destinationKeys) {
        super(manager, destinationKeys);
        this.source = sourceKeys;
        this.destination = destinationKeys;
    }

    @Override
    protected FontModifier get(FontModifier value, String id, DockFont observer) {
        CDockable dockable = this.getDockable(observer);
        if (dockable == null) {
            return value;
        }
        return this.get(value, id, dockable);
    }

    @Override
    protected boolean isObservedMapKey(String key) {
        String[] stringArray = this.source;
        int n = this.source.length;
        int n2 = 0;
        while (n2 < n) {
            String observer = stringArray[n2];
            if (observer.equals(key)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private FontModifier getFirstNonNull(FontMap fonts, int index) {
        int i = index;
        int n = this.source.length;
        while (i < n) {
            FontModifier font = fonts.getFont(this.source[i]);
            if (font != null) {
                return font;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected FontModifier get(FontModifier value, String id, CDockable dockable) {
        FontModifier result = null;
        int i = 0;
        int n = this.destination.length;
        while (i < n) {
            if (this.destination[i].equals(id)) {
                result = this.getFirstNonNull(dockable.getFonts(), i);
                break;
            }
            ++i;
        }
        if (result == null) {
            result = value;
        }
        return result;
    }
}

