/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.PredefinedLayout;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSetting
extends Setting {
    private ModeSettings<Location, ?> modes;
    private Map<String, List<String>> multiFactoryDockables = new HashMap<String, List<String>>();

    public void setModes(ModeSettings<Location, ?> modes) {
        this.modes = modes;
    }

    public ModeSettings<Location, ?> getModes() {
        return this.modes;
    }

    public void putMultipleFactoryDockables(String factoryId, List<String> dockables) {
        if (dockables == null) {
            throw new IllegalArgumentException("dockables must not be null");
        }
        this.multiFactoryDockables.put(factoryId, dockables);
    }

    public List<String> getMultipleFactoryDockables(String factoryId) {
        return this.multiFactoryDockables.get(factoryId);
    }

    public DockLayoutComposition getPredefinedStation(String id) {
        String[] stringArray = this.getRootKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            DockLayoutComposition result = this.getPredefinedStation(id, this.getRoot(root));
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private DockLayoutComposition getPredefinedStation(String id, DockLayoutComposition current) {
        List<DockLayoutComposition> children;
        DockLayout<?> layout = current.getLayout().getDataLayout();
        if (layout != null && layout.getFactoryID().equals("predefined")) {
            PredefinedLayout predefined = (PredefinedLayout)layout.getData();
            String preloadedId = predefined.getPredefined();
            String root = "root";
            if (preloadedId.length() == id.length() + root.length() && preloadedId.startsWith(root) && preloadedId.endsWith(id)) {
                return current;
            }
        }
        if ((children = current.getChildren()) != null) {
            for (DockLayoutComposition child : children) {
                DockLayoutComposition result = this.getPredefinedStation(id, child);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public void write(DockSituation situation, PropertyTransformer transformer, boolean entry, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_8);
        super.write(situation, transformer, entry, out);
        this.modes.write(out);
        out.writeInt(this.multiFactoryDockables.size());
        for (Map.Entry<String, List<String>> factory : this.multiFactoryDockables.entrySet()) {
            out.writeUTF(factory.getKey());
            List<String> list = factory.getValue();
            out.writeInt(list.size());
            for (String dockable : list) {
                out.writeUTF(dockable);
            }
        }
    }

    @Override
    public void writeXML(DockSituation situation, PropertyTransformer transformer, boolean entry, XElement element) {
        super.writeXML(situation, transformer, entry, element.addElement("base"));
        this.modes.writeXML(element.addElement("modes"));
        if (!this.multiFactoryDockables.isEmpty()) {
            XElement xmultiFactories = element.addElement("multi-factories");
            for (Map.Entry<String, List<String>> factory : this.multiFactoryDockables.entrySet()) {
                XElement xfactory = xmultiFactories.addElement("factory");
                xfactory.addString("id", factory.getKey());
                for (String dockable : factory.getValue()) {
                    xfactory.addElement("dockable").addString("id", dockable);
                }
            }
        }
    }

    @Override
    public void read(DockSituation situation, PropertyTransformer transformer, boolean entry, DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        boolean version7 = version.compareTo(Version.VERSION_1_0_7) >= 0;
        super.read(situation, transformer, entry, in);
        this.modes.read(in);
        if (version7) {
            int i = 0;
            int n = in.readInt();
            while (i < n) {
                String id = in.readUTF();
                ArrayList<String> dockables = new ArrayList<String>();
                int j = 0;
                int m = in.readInt();
                while (j < m) {
                    dockables.add(in.readUTF());
                    ++j;
                }
                this.putMultipleFactoryDockables(id, dockables);
                ++i;
            }
        }
    }

    @Override
    public void readXML(DockSituation situation, PropertyTransformer transformer, boolean entry, XElement element) {
        super.readXML(situation, transformer, entry, element.getElement("base"));
        this.modes.readXML(element.getElement("modes"));
        XElement xmultiFactories = element.getElement("multi-factories");
        if (xmultiFactories != null) {
            XElement[] xElementArray = xmultiFactories.getElements("factory");
            int n = xElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                XElement xfactory = xElementArray[n2];
                ArrayList<String> dockables = new ArrayList<String>();
                XElement[] xElementArray2 = xfactory.getElements("dockable");
                int n3 = xElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    XElement xdockable = xElementArray2[n4];
                    String id = xdockable.getString("id");
                    if (id != null) {
                        dockables.add(id);
                    }
                    ++n4;
                }
                String id = xfactory.getString("id");
                if (id != null) {
                    this.putMultipleFactoryDockables(id, dockables);
                }
                ++n2;
            }
        }
    }
}

