/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.location.CWorkingAreaLocation;
import bibliothek.gui.dock.common.perspective.CWorkingPerspective;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.util.Path;

public class CWorkingArea
extends CGridArea {
    public static final Path TYPE_ID = new Path("dock", "CWorkingArea");

    public CWorkingArea(CControl control, String uniqueId) {
        super(control, uniqueId);
        this.setMaximizingArea(false);
    }

    @Override
    public boolean isWorkingArea() {
        return true;
    }

    @Override
    public CLocation getStationLocation() {
        return new CWorkingAreaLocation(this);
    }

    @Override
    public CWorkingPerspective createPerspective() {
        return new CWorkingPerspective(this.getUniqueId(), this.getTypeId());
    }

    @Override
    public void deploy(CGrid grid) {
        DockableSplitDockTree tree = grid.toTree();
        Dockable[] dockableArray = (Dockable[])tree.getDockables();
        int n = dockableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dockable dockable = dockableArray[n2];
            if (dockable instanceof CommonDockable) {
                CommonDockable cdock = (CommonDockable)dockable;
                cdock.getDockable().setWorkingArea(this);
            }
            ++n2;
        }
        this.getStation().dropTree(tree);
    }

    public <F extends SingleCDockable> F add(F dockable) {
        dockable.setWorkingArea(this);
        CControlAccess access = this.control();
        if (access != null) {
            access.getOwner().addDockable(dockable);
        }
        return dockable;
    }

    public <F extends MultipleCDockable> F add(F dockable) {
        dockable.setWorkingArea(this);
        CControlAccess access = this.control();
        if (access != null) {
            access.getOwner().addDockable(dockable);
        }
        return dockable;
    }

    @Deprecated
    public void setSuppressTitle(boolean suppressTitle) {
        this.setTitleShown(!suppressTitle);
    }

    @Deprecated
    public boolean isSuppressTitle() {
        return !this.isTitleShown();
    }

    @Override
    public Path getTypeId() {
        return TYPE_ID;
    }
}

