/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.dropdown;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.dropdown.AbstractDropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilterFactory;
import bibliothek.gui.dock.action.dropdown.DropDownView;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;

public class DefaultDropDownFilter
extends AbstractDropDownFilter {
    public static final DropDownFilterFactory FACTORY = new DropDownFilterFactory(){

        @Override
        public DropDownFilter createView(DropDownAction action, Dockable dockable, DropDownView view) {
            return new DefaultDropDownFilter(action, dockable, view);
        }
    };

    public DefaultDropDownFilter(DropDownAction action, Dockable dockable, DropDownView view) {
        super(action, dockable, view);
    }

    @Override
    public void update(DropDownViewItem selection) {
        this.updateEnabled(selection);
        this.updateSelected(selection);
        this.updateIcon(selection);
        this.updateDisabledIcon(selection);
        this.updateText(selection);
        this.updateTooltip(selection);
        this.updateRepresentative(selection);
    }

    protected void updateEnabled(DropDownViewItem selection) {
        this.getView().setEnabled(this.enabled);
    }

    protected void updateRepresentative(DropDownViewItem selection) {
        this.getView().setDockableRepresentation(this.representative);
    }

    protected void updateSelected(DropDownViewItem selection) {
        this.getView().setSelected(this.selected);
    }

    protected void updateIcon(DropDownViewItem selection) {
        if (this.icon == null) {
            this.getView().setIcon(this.getAction().getIcon(this.getDockable()));
        } else {
            this.getView().setIcon(this.icon);
        }
    }

    protected void updateDisabledIcon(DropDownViewItem selection) {
        if (this.disabledIcon == null) {
            this.getView().setDisabledIcon(this.getAction().getDisabledIcon(this.getDockable()));
        } else {
            this.getView().setDisabledIcon(this.disabledIcon);
        }
    }

    protected void updateText(DropDownViewItem selection) {
        if (this.text == null) {
            this.getView().setText(this.getAction().getText(this.getDockable()));
        } else {
            this.getView().setText(null);
        }
    }

    protected void updateTooltip(DropDownViewItem selection) {
        if (selection == null || !selection.isTriggerable(true)) {
            String tooltip = this.getAction().getTooltipText(this.getDockable());
            if (tooltip == null) {
                tooltip = this.tooltip;
            }
            if (tooltip == null) {
                tooltip = this.getAction().getText(this.getDockable());
            }
            if (tooltip == null) {
                tooltip = this.text;
            }
            this.getView().setTooltip(tooltip);
        } else {
            String tooltip = this.tooltip;
            if (tooltip == null) {
                tooltip = this.getAction().getTooltipText(this.getDockable());
            }
            if (tooltip == null) {
                tooltip = this.text;
            }
            if (tooltip == null) {
                tooltip = this.getAction().getText(this.getDockable());
            }
            this.getView().setTooltip(tooltip);
        }
    }
}

