/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.event.StandardDockActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractStandardDockAction
implements StandardDockAction {
    protected List<StandardDockActionListener> listeners = new ArrayList<StandardDockActionListener>();
    private Map<Dockable, Integer> bound = new HashMap<Dockable, Integer>();

    @Override
    public void addDockActionListener(StandardDockActionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeDockActionListener(StandardDockActionListener listener) {
        this.listeners.remove(listener);
    }

    protected void bound(Dockable dockable) {
    }

    protected void unbound(Dockable dockable) {
    }

    public boolean isBound(Dockable dockable) {
        return this.bound.containsKey(dockable);
    }

    public Set<Dockable> getBoundDockables() {
        return Collections.unmodifiableSet(this.bound.keySet());
    }

    @Override
    public void bind(Dockable dockable) {
        Integer old = this.bound.get(dockable);
        if (old == null) {
            this.bound.put(dockable, 1);
            this.bound(dockable);
        } else {
            this.bound.put(dockable, old + 1);
        }
    }

    @Override
    public void unbind(Dockable dockable) {
        Integer old = this.bound.get(dockable);
        if (old == null) {
            try {
                throw new NullPointerException("Unbind called too often, omit unbind and continue");
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
        } else if (old == 1) {
            this.bound.remove(dockable);
            this.unbound(dockable);
        } else {
            this.bound.put(dockable, old - 1);
        }
    }

    protected void fireActionTextChanged(Set<Dockable> dockables) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener listener = standardDockActionListenerArray[n2];
            listener.actionTextChanged(this, dockables);
            ++n2;
        }
    }

    protected void fireActionTooltipTextChanged(Set<Dockable> dockables) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener listener = standardDockActionListenerArray[n2];
            listener.actionTooltipTextChanged(this, dockables);
            ++n2;
        }
    }

    protected void fireActionIconChanged(Set<Dockable> dockables) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener listener = standardDockActionListenerArray[n2];
            listener.actionIconChanged(this, dockables);
            ++n2;
        }
    }

    protected void fireActionDisabledIconChanged(Set<Dockable> dockables) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener listener = standardDockActionListenerArray[n2];
            listener.actionDisabledIconChanged(this, dockables);
            ++n2;
        }
    }

    protected void fireActionEnabledChanged(Set<Dockable> dockables) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener listener = standardDockActionListenerArray[n2];
            listener.actionEnabledChanged(this, dockables);
            ++n2;
        }
    }

    protected void fireActionRepresentativeChanged(Set<Dockable> dockables) {
        StandardDockActionListener[] standardDockActionListenerArray = this.listeners.toArray(new StandardDockActionListener[this.listeners.size()]);
        int n = standardDockActionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            StandardDockActionListener listener = standardDockActionListenerArray[n2];
            listener.actionRepresentativeChanged(this, dockables);
            ++n2;
        }
    }
}

