/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.dockable.AbstractDockable;
import bibliothek.gui.dock.dockable.DockableBackgroundComponent;
import bibliothek.gui.dock.dockable.DockableIcon;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.LayoutFocusTraversalPolicy;

public class DefaultDockable
extends AbstractDockable {
    private BackgroundPanel pane = new BackgroundPanel(new BorderLayout(), true, false);
    private String factoryId = "DefaultDockableFactory";
    private Background background = new Background();

    public DefaultDockable() {
        this(null, null, null);
    }

    public DefaultDockable(Icon icon) {
        this(null, null, icon);
    }

    public DefaultDockable(String title) {
        this(null, title, null);
    }

    public DefaultDockable(Component component) {
        this(component, null, null);
    }

    public DefaultDockable(Component component, Icon icon) {
        this(component, null, icon);
    }

    public DefaultDockable(Component component, String title) {
        this(component, title, null);
    }

    public DefaultDockable(Component component, String title, Icon icon) {
        super(PropertyKey.DOCKABLE_TITLE, PropertyKey.DOCKABLE_TOOLTIP);
        this.pane.setFocusable(false);
        this.pane.setFocusTraversalPolicyProvider(true);
        this.pane.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.pane.setBackground(this.background);
        if (component != null) {
            this.getContentPane().setLayout(new GridLayout(1, 1));
            this.getContentPane().add(component);
        }
        if (icon != null) {
            this.setTitleIcon(icon);
        }
        this.setTitleText(title);
    }

    @Override
    protected DockIcon createTitleIcon() {
        return new DockableIcon("dockable.default", this){

            @Override
            protected void changed(Icon oldValue, Icon newValue) {
                DefaultDockable.this.fireTitleIconChanged(oldValue, newValue);
            }
        };
    }

    @Override
    public String getFactoryID() {
        return this.factoryId;
    }

    public void setFactoryID(String factoryId) {
        if (factoryId == null) {
            throw new IllegalArgumentException("FactoryID must not be null");
        }
        this.factoryId = factoryId;
    }

    @Override
    public Component getComponent() {
        return this.pane;
    }

    @Override
    public DockStation asDockStation() {
        return null;
    }

    public Container getContentPane() {
        return this.pane;
    }

    public void add(Component component) {
        this.getContentPane().add(component);
    }

    public void add(Component component, Object constraints) {
        this.getContentPane().add(component, constraints);
    }

    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    public void setLayout(LayoutManager layout) {
        this.getContentPane().setLayout(layout);
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        this.background.setController(controller);
    }

    private class Background
    extends BackgroundAlgorithm
    implements DockableBackgroundComponent {
        public Background() {
            super(DockableBackgroundComponent.KIND, "dock.background.dockable");
        }

        @Override
        public Component getComponent() {
            return this.getDockable().getComponent();
        }

        @Override
        public Dockable getDockable() {
            return DefaultDockable.this;
        }
    }
}

