/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.action.ActionGuard;
import bibliothek.gui.dock.action.ActionOffer;
import bibliothek.gui.dock.action.ActionPopupSuppressor;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.popup.ActionPopupMenuFactory;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.control.ComponentHierarchyObserver;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.DefaultDockControllerFactory;
import bibliothek.gui.dock.control.DockControllerFactory;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.DockRelocator;
import bibliothek.gui.dock.control.DockRelocatorMode;
import bibliothek.gui.dock.control.DockableSelector;
import bibliothek.gui.dock.control.DoubleClickController;
import bibliothek.gui.dock.control.KeyboardController;
import bibliothek.gui.dock.control.PopupController;
import bibliothek.gui.dock.control.SingleParentRemover;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.MouseFocusObserver;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockTitleBindingListener;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.DockableSelectionEvent;
import bibliothek.gui.dock.event.DockableSelectionListener;
import bibliothek.gui.dock.event.UIListener;
import bibliothek.gui.dock.themes.ThemeManager;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleManager;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.TextManager;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import bibliothek.gui.dock.util.WindowProviderWrapper;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.extension.ExtensionManager;
import bibliothek.gui.dock.util.font.FontManager;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.text.DefaultTextScheme;
import bibliothek.gui.dock.util.text.TextBridge;
import bibliothek.gui.dock.util.text.TextValue;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DockController {
    public static final PropertyKey<Boolean> RESTRICTED_ENVIRONMENT = new PropertyKey<Boolean>("dock.restricted_environment", new ConstantPropertyFactory<Boolean>(DockUI.getDefaultDockUI().isSecureEnvironment()), true);
    private DockRegister register;
    private ComponentHierarchyObserver componentHierarchyObserver;
    private DockRelocator relocator;
    private DoubleClickController doubleClickController;
    private KeyboardController keyboardController;
    private DockableSelector dockableSelector;
    private List<DockableSelectionListener> dockableSelectionListeners = new ArrayList<DockableSelectionListener>();
    private List<DockTitleBindingListener> dockTitleBindingListeners = new ArrayList<DockTitleBindingListener>();
    private MouseFocusObserver focusObserver;
    private FocusController focusController;
    private DockTitleObserver dockTitleObserver = new DockTitleObserver();
    private Map<DockTitle, Dockable> activeTitles = new HashMap<DockTitle, Dockable>();
    private DockTitleManager dockTitles;
    private IconManager icons;
    private TextManager texts;
    private ColorManager colors;
    private FontManager fonts;
    private ExtensionManager extensions;
    private List<ActionOffer> actionOffers = new ArrayList<ActionOffer>();
    private List<ActionGuard> guards = new ArrayList<ActionGuard>();
    private ActionOffer defaultActionOffer;
    private ActionViewConverter actionViewConverter;
    private MultiDockAcceptance acceptance = new MultiDockAcceptance();
    private PopupController popupController;
    private SingleParentRemover remover;
    private ThemeManager theme;
    private DockProperties properties;
    private DockControllerFactory factory;
    private Map<Component, DockElementRepresentative> componentToDockElements = new HashMap<Component, DockElementRepresentative>();
    private List<DockControllerRepresentativeListener> componentToDockElementsListeners = new ArrayList<DockControllerRepresentativeListener>();
    private WindowProviderWrapper rootWindowProvider;
    private Window rootWindow;
    private DockHierarchyLock lock = new DockHierarchyLock();

    public DockController() {
        this(new DefaultDockControllerFactory());
    }

    public DockController(DockControllerFactory factory) {
        if (factory != null) {
            this.initiate(factory, null);
        }
    }

    protected final void initiate(DockControllerFactory factory, ControllerSetupCollection setup) {
        if (this.factory != null) {
            throw new IllegalStateException("DockController already initialized");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Factory must not be null");
        }
        this.properties = new DockProperties(this);
        this.theme = new ThemeManager(this);
        this.icons = new IconManager(this);
        this.colors = new ColorManager(this);
        this.fonts = new FontManager(this);
        this.dockTitles = new DockTitleManager(this);
        this.texts = new TextManager(this);
        this.texts.setScheme(Priority.DEFAULT, this.createDefaultTextScheme());
        this.theme.init();
        this.rootWindowProvider = new WindowProviderWrapper();
        this.rootWindowProvider.addWindowProviderListener(new WindowProviderListener(){

            @Override
            public void windowChanged(WindowProvider provider, Window window) {
                Window oldWindow = DockController.this.rootWindow;
                DockController.this.rootWindow = window;
                DockController.this.rootWindowChanged(oldWindow, window);
            }

            @Override
            public void visibilityChanged(WindowProvider provider, boolean showing) {
            }
        });
        final LinkedList setupListeners = new LinkedList();
        if (setup == null) {
            setup = new ControllerSetupCollection(){

                @Override
                public void add(ControllerSetupListener listener) {
                    if (listener == null) {
                        throw new NullPointerException("listener must not be null");
                    }
                    setupListeners.add(listener);
                }
            };
        }
        this.factory = factory;
        this.register = factory.createRegister(this, setup);
        DockRegisterListener focus = factory.createVisibilityFocusObserver(this, setup);
        if (focus != null) {
            this.register.addDockRegisterListener(focus);
        }
        this.popupController = factory.createPopupController(this, setup);
        DockRegisterListener binder = factory.createActionBinder(this, setup);
        if (binder != null) {
            this.register.addDockRegisterListener(binder);
        }
        this.register.addDockRegisterListener(this.dockTitleObserver);
        this.addDockTitleBindingListener(this.dockTitleObserver);
        this.register.addDockRegisterListener(new DockableSelectionObserver());
        this.relocator = factory.createRelocator(this, setup);
        this.defaultActionOffer = factory.createDefaultActionOffer(this, setup);
        this.focusObserver = factory.createMouseFocusObserver(this, setup);
        this.focusController = factory.createFocusController(this, setup);
        this.actionViewConverter = factory.createActionViewConverter(this, setup);
        this.doubleClickController = factory.createDoubleClickController(this, setup);
        this.keyboardController = factory.createKeyboardController(this, setup);
        this.dockableSelector = factory.createDockableSelector(this, setup);
        this.extensions = factory.createExtensionManager(this, setup);
        this.extensions.init();
        this.setTheme(DockUI.getDefaultDockUI().getDefaultTheme().create(this));
        this.relocator.addMode(DockRelocatorMode.SCREEN_ONLY);
        this.relocator.addMode(DockRelocatorMode.NO_COMBINATION);
        this.properties.set(SplitDockStation.MAXIMIZE_ACCELERATOR, KeyStroke.getKeyStroke(77, 128));
        this.properties.set(DockFrontend.HIDE_ACCELERATOR, KeyStroke.getKeyStroke(115, 128));
        this.properties.set(DockableSelector.INIT_SELECTION, KeyStroke.getKeyStroke(69, 192));
        this.setSingleParentRemover(factory.createSingleParentRemover(this, setup));
        this.focusController.addDockableFocusListener(new FocusControllerObserver());
        for (ControllerSetupListener listener : setupListeners) {
            listener.done(this);
        }
    }

    protected UIScheme<String, TextValue, TextBridge> createDefaultTextScheme() {
        ResourceBundle bundle = ResourceBundle.getBundle("data.locale.text", Locale.getDefault(), this.getClass().getClassLoader());
        return new DefaultTextScheme(bundle);
    }

    public void kill() {
        this.focusObserver.kill();
        this.register.kill();
        this.keyboardController.kill();
        this.theme.kill();
        this.extensions.kill();
        this.setRootWindowProvider(null);
    }

    public void setRestrictedEnvironment(boolean restricted) {
        this.getProperties().set(RESTRICTED_ENVIRONMENT, restricted);
    }

    public boolean isRestrictedEnvironment() {
        return this.getProperties().get(RESTRICTED_ENVIRONMENT);
    }

    public MouseFocusObserver getMouseFocusObserver() {
        return this.focusObserver;
    }

    @Deprecated
    public MouseFocusObserver getFocusObserver() {
        return this.getMouseFocusObserver();
    }

    public FocusController getFocusController() {
        return this.focusController;
    }

    public DockRegister getRegister() {
        return this.register;
    }

    public ComponentHierarchyObserver getComponentHierarchyObserver() {
        if (this.componentHierarchyObserver == null) {
            this.componentHierarchyObserver = new ComponentHierarchyObserver(this);
            if (this.rootWindow != null) {
                this.componentHierarchyObserver.add(this.rootWindow);
            }
        }
        return this.componentHierarchyObserver;
    }

    public DockRelocator getRelocator() {
        return this.relocator;
    }

    public DoubleClickController getDoubleClickController() {
        return this.doubleClickController;
    }

    public KeyboardController getKeyboardController() {
        return this.keyboardController;
    }

    public ActionViewConverter getActionViewConverter() {
        return this.actionViewConverter;
    }

    public SingleParentRemover getSingleParentRemover() {
        return this.remover;
    }

    public void setSingleParentRemover(SingleParentRemover remover) {
        if (this.remover != null) {
            this.remover.uninstall(this);
        }
        this.remover = remover;
        if (this.remover != null) {
            this.remover.install(this);
            this.remover.testAll(this);
        }
    }

    public DockHierarchyLock getHierarchyLock() {
        return this.lock;
    }

    public boolean freezeLayout() {
        DockRegister register = this.getRegister();
        boolean frozen = register.isStalled();
        this.getRegister().setStalled(true);
        return frozen;
    }

    public boolean isLayoutFrozen() {
        return this.getRegister().isStalled();
    }

    public boolean meltLayout() {
        if (!this.isLayoutFrozen()) {
            throw new IllegalStateException("the layout is not frozen");
        }
        DockRegister register = this.getRegister();
        register.setStalled(false);
        return register.isStalled();
    }

    public MultiDockAcceptance getAcceptance() {
        return this.acceptance;
    }

    public void addAcceptance(DockAcceptance acceptance) {
        this.acceptance.add(acceptance);
    }

    public void removeAcceptance(DockAcceptance acceptance) {
        this.acceptance.remove(acceptance);
    }

    public ActionPopupSuppressor getPopupSuppressor() {
        return this.popupController.getPopupSuppressor();
    }

    public void setPopupSuppressor(ActionPopupSuppressor popupSuppressor) {
        this.popupController.setPopupSuppressor(popupSuppressor);
    }

    public ActionPopupMenuFactory getPopupMenuFactory() {
        return this.popupController.getPopupMenuFactory();
    }

    public void setPopupMenuFactory(ActionPopupMenuFactory factory) {
        this.popupController.setPopupMenuFactory(factory);
    }

    public PopupController getPopupController() {
        return this.popupController;
    }

    public ActionOffer getDefaultActionOffer() {
        return this.defaultActionOffer;
    }

    public void setDefaultActionOffer(ActionOffer defaultActionOffer) {
        if (defaultActionOffer == null) {
            throw new IllegalArgumentException();
        }
        this.defaultActionOffer = defaultActionOffer;
    }

    public void addActionOffer(ActionOffer offer) {
        if (offer == null) {
            throw new IllegalArgumentException();
        }
        this.actionOffers.add(offer);
    }

    public void removeActionOffer(ActionOffer offer) {
        this.actionOffers.remove(offer);
    }

    public ActionOffer getActionOffer(Dockable dockable) {
        for (ActionOffer offer : this.actionOffers) {
            if (!offer.interested(dockable)) continue;
            return offer;
        }
        return this.getDefaultActionOffer();
    }

    public void setTheme(DockTheme theme) {
        this.theme.setTheme(theme);
    }

    public DockTheme getTheme() {
        return this.theme.getTheme();
    }

    public ThemeManager getThemeManager() {
        return this.theme;
    }

    public DockProperties getProperties() {
        return this.properties;
    }

    public void addRepresentativeListener(DockControllerRepresentativeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.componentToDockElementsListeners.add(listener);
    }

    public void removeRepresentativeListener(DockControllerRepresentativeListener listener) {
        this.componentToDockElementsListeners.remove(listener);
    }

    public void addRepresentative(DockElementRepresentative representative) {
        DockControllerRepresentativeListener listener;
        int n;
        int n2;
        DockControllerRepresentativeListener[] dockControllerRepresentativeListenerArray;
        DockControllerRepresentativeListener[] listeners = this.componentToDockElementsListeners.toArray(new DockControllerRepresentativeListener[this.componentToDockElementsListeners.size()]);
        DockElementRepresentative old = this.componentToDockElements.put(representative.getComponent(), representative);
        if (old != null) {
            dockControllerRepresentativeListenerArray = listeners;
            n2 = listeners.length;
            n = 0;
            while (n < n2) {
                listener = dockControllerRepresentativeListenerArray[n];
                listener.representativeRemoved(this, old);
                ++n;
            }
        }
        dockControllerRepresentativeListenerArray = listeners;
        n2 = listeners.length;
        n = 0;
        while (n < n2) {
            listener = dockControllerRepresentativeListenerArray[n];
            listener.representativeAdded(this, representative);
            ++n;
        }
    }

    public void removeRepresentative(DockElementRepresentative representative) {
        if (this.componentToDockElements.remove(representative.getComponent()) != null) {
            DockControllerRepresentativeListener[] listeners;
            DockControllerRepresentativeListener[] dockControllerRepresentativeListenerArray = listeners = this.componentToDockElementsListeners.toArray(new DockControllerRepresentativeListener[this.componentToDockElementsListeners.size()]);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                DockControllerRepresentativeListener listener = dockControllerRepresentativeListenerArray[n2];
                listener.representativeRemoved(this, representative);
                ++n2;
            }
        }
    }

    public DockElementRepresentative searchElement(Component representative) {
        while (representative != null) {
            DockElementRepresentative element = this.componentToDockElements.get(representative);
            if (element != null && element.getElement().getController() == this) {
                return element;
            }
            representative = representative.getParent();
        }
        return null;
    }

    public void add(DockStation station) {
        this.register.add(station);
        this.register.setProtected(station, true);
    }

    public void remove(DockStation station) {
        this.register.remove(station);
    }

    public int getStationCount() {
        return this.register.getStationCount();
    }

    public DockStation getStation(int index) {
        return this.register.getStation(index);
    }

    public boolean isOnFocusing() {
        return this.focusController.isOnFocusing();
    }

    public void setAtLeastFocusedDockable(Dockable focusedDockable, Component component) {
        Dockable current = this.getFocusedDockable();
        if (current == null) {
            this.setFocusedDockable(focusedDockable, component, false);
        } else if (!DockUtilities.isAncestor(focusedDockable, current)) {
            this.setFocusedDockable(focusedDockable, component, false);
        }
    }

    public void setFocusedDockable(Dockable focusedDockable, boolean force) {
        this.setFocusedDockable(focusedDockable, null, force);
    }

    public void setFocusedDockable(Dockable focusedDockable, Component component, boolean force) {
        this.setFocusedDockable(focusedDockable, component, force, true, false);
    }

    public void setFocusedDockable(Dockable focusedDockable, Component component, boolean force, boolean ensureFocusSet, boolean ensureDockableFocused) {
        this.focusController.setFocusedDockable(focusedDockable, component, force, ensureFocusSet, ensureDockableFocused);
    }

    public boolean isFocused(Dockable dockable) {
        Dockable temp = this.getFocusedDockable();
        while (temp != null) {
            if (temp == dockable) {
                return true;
            }
            DockStation station = temp.getDockParent();
            Dockable dockable2 = temp = station == null ? null : station.asDockable();
        }
        return false;
    }

    public boolean isBound(DockTitle title) {
        return this.dockTitleObserver.isBound(title);
    }

    public void ensureFocusSet() {
        this.focusController.ensureFocusSet(false);
    }

    public Dockable getFocusedDockable() {
        return this.focusController.getFocusedDockable();
    }

    public DockableSelector getDockableSelector() {
        return this.dockableSelector;
    }

    public DockTitleManager getDockTitleManager() {
        return this.dockTitles;
    }

    public IconManager getIcons() {
        return this.icons;
    }

    public TextManager getTexts() {
        return this.texts;
    }

    public ColorManager getColors() {
        return this.colors;
    }

    public FontManager getFonts() {
        return this.fonts;
    }

    public ExtensionManager getExtensions() {
        return this.extensions;
    }

    public void setRootWindow(Window window) {
        if (window == null) {
            this.setRootWindowProvider(null);
        } else {
            this.setRootWindowProvider(new DirectWindowProvider(window));
        }
    }

    public void setRootWindowProvider(WindowProvider window) {
        this.rootWindowProvider.setDelegate(window);
    }

    public WindowProviderWrapper getRootWindowProvider() {
        return this.rootWindowProvider;
    }

    protected void rootWindowChanged(Window oldWindow, Window newWindow) {
        if (this.componentHierarchyObserver != null) {
            if (oldWindow != null) {
                this.componentHierarchyObserver.remove(oldWindow);
            }
            if (newWindow != null) {
                this.componentHierarchyObserver.add(newWindow);
            }
        }
    }

    public Window findRootWindow() {
        if (this.rootWindow != null) {
            return this.rootWindow;
        }
        Window window = null;
        Dialog dialog = null;
        DockElement[] dockElementArray = this.getRegister().listRoots();
        int n = dockElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component;
            Window ancestor;
            DockStation station = dockElementArray[n2];
            Dockable dockable = station.asDockable();
            if (dockable != null && (ancestor = SwingUtilities.getWindowAncestor(component = dockable.getComponent())) != null) {
                window = ancestor;
                if (ancestor instanceof Frame) {
                    return ancestor;
                }
                if (ancestor instanceof Dialog) {
                    dialog = (Dialog)ancestor;
                }
            }
            ++n2;
        }
        dockElementArray = this.getRegister().listDockables();
        n = dockElementArray.length;
        n2 = 0;
        while (n2 < n) {
            DockElement dockable = dockElementArray[n2];
            Component component = dockable.getComponent();
            Window ancestor = SwingUtilities.getWindowAncestor(component);
            if (ancestor != null) {
                window = ancestor;
                if (ancestor instanceof Frame) {
                    return ancestor;
                }
                if (ancestor instanceof Dialog) {
                    dialog = (Dialog)ancestor;
                }
            }
            ++n2;
        }
        if (dialog != null) {
            return dialog;
        }
        return window;
    }

    public void addActionGuard(ActionGuard guard) {
        if (guard == null) {
            throw new IllegalArgumentException("guard must not be null");
        }
        this.guards.add(guard);
    }

    public void removeActionGuard(ActionGuard guard) {
        this.guards.remove(guard);
    }

    public DockActionSource listOffers(Dockable dockable) {
        ArrayList<DockActionSource> guards = new ArrayList<DockActionSource>();
        ArrayList<DockActionSource> parents = new ArrayList<DockActionSource>();
        DockStation station = dockable.getDockParent();
        while (station != null) {
            parents.add(station.getIndirectActionOffers(dockable));
            Dockable transform = station.asDockable();
            station = transform != null ? transform.getDockParent() : null;
        }
        for (ActionGuard guard : this.guards) {
            if (!guard.react(dockable)) continue;
            guards.add(guard.getSource(dockable));
        }
        ActionOffer offer = this.getActionOffer(dockable);
        DockActionSource parentSource = null;
        if (dockable.getDockParent() != null) {
            parentSource = dockable.getDockParent().getDirectActionOffers(dockable);
        }
        return offer.getSource(dockable, dockable.getLocalActionOffers(), guards.toArray(new DockActionSource[guards.size()]), parentSource, parents.toArray(new DockActionSource[parents.size()]));
    }

    public void addDockTitleBindingListener(DockTitleBindingListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockTitleBindingListeners.add(listener);
    }

    public void removeDockTitleBindingListener(DockTitleBindingListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockTitleBindingListeners.remove(listener);
    }

    protected DockTitleBindingListener[] dockTitleBindingListeners() {
        return this.dockTitleBindingListeners.toArray(new DockTitleBindingListener[this.dockTitleBindingListeners.size()]);
    }

    public void addDockableFocusListener(DockableFocusListener listener) {
        this.focusController.addDockableFocusListener(listener);
    }

    public void removeDockableFocusListener(DockableFocusListener listener) {
        this.focusController.removeDockableFocusListener(listener);
    }

    public void addDockableSelectionListener(DockableSelectionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockableSelectionListeners.add(listener);
    }

    public void removeDockableSelectionListener(DockableSelectionListener listener) {
        this.dockableSelectionListeners.remove(listener);
    }

    protected DockableSelectionListener[] dockableSelectionListeners() {
        return this.dockableSelectionListeners.toArray(new DockableSelectionListener[this.dockableSelectionListeners.size()]);
    }

    protected void fireTitleBound(DockTitle title, Dockable dockable) {
        DockTitleBindingListener[] dockTitleBindingListenerArray = this.dockTitleBindingListeners();
        int n = dockTitleBindingListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockTitleBindingListener listener = dockTitleBindingListenerArray[n2];
            listener.titleBound(this, title, dockable);
            ++n2;
        }
    }

    protected void fireTitleUnbound(DockTitle title, Dockable dockable) {
        DockTitleBindingListener[] dockTitleBindingListenerArray = this.dockTitleBindingListeners();
        int n = dockTitleBindingListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockTitleBindingListener listener = dockTitleBindingListenerArray[n2];
            listener.titleUnbound(this, title, dockable);
            ++n2;
        }
    }

    protected void fireDockableSelected(DockStation station, Dockable oldSelected, Dockable newSelected) {
        DockableSelectionEvent event = new DockableSelectionEvent(this, station, oldSelected, newSelected);
        DockableSelectionListener[] dockableSelectionListenerArray = this.dockableSelectionListeners();
        int n = dockableSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableSelectionListener listener = dockableSelectionListenerArray[n2];
            listener.dockableSelected(event);
            ++n2;
        }
    }

    @Deprecated
    public void addUIListener(UIListener listener) {
        this.theme.addUIListener(listener);
    }

    @Deprecated
    public void removeUIListener(UIListener listener) {
        this.theme.removeUIListener(listener);
    }

    @Deprecated
    public void updateUI() {
        this.theme.updateUI();
    }

    private class DockTitleObserver
    extends DockRegisterAdapter
    implements DockTitleBindingListener {
        private Set<DockTitle> titles = new HashSet<DockTitle>();
        private DockableListener dockableListener = new DockableAdapter(){

            @Override
            public void titleBound(Dockable dockable, DockTitle title) {
                DockTitleObserver.this.titles.add(title);
                title.bind();
                DockController.this.fireTitleBound(title, dockable);
                DockStation station = dockable.getDockParent();
                boolean focused = false;
                Dockable temp = DockController.this.getFocusedDockable();
                while (!focused && temp != null) {
                    focused = temp == dockable;
                    DockStation parent = temp.getDockParent();
                    Dockable dockable2 = temp = parent == null ? null : parent.asDockable();
                }
                if (station == null) {
                    title.changed(new DockTitleEvent(dockable, focused));
                } else {
                    station.changed(dockable, title, focused);
                }
                if (focused) {
                    DockController.this.activeTitles.put(title, dockable);
                }
            }

            @Override
            public void titleUnbound(Dockable dockable, DockTitle title) {
                DockTitleObserver.this.titles.remove(title);
                title.unbind();
                DockController.this.fireTitleUnbound(title, dockable);
            }
        };

        private DockTitleObserver() {
        }

        public boolean isBound(DockTitle title) {
            return this.titles.contains(title);
        }

        @Override
        public void titleBound(DockController controller, DockTitle title, Dockable dockable) {
            DockController.this.addRepresentative(title);
        }

        @Override
        public void titleUnbound(DockController controller, DockTitle title, Dockable dockable) {
            DockController.this.removeRepresentative(title);
            DockController.this.activeTitles.remove(title);
            DockStation parent = dockable.getDockParent();
            if (parent != null) {
                parent.changed(dockable, title, false);
            } else {
                title.changed(new DockTitleEvent(dockable, false));
            }
        }

        @Override
        public void dockableRegistering(DockController controller, Dockable dockable) {
            dockable.addDockableListener(this.dockableListener);
        }

        @Override
        public void dockableRegistered(DockController controller, Dockable dockable) {
            DockTitle[] titles;
            DockController.this.addRepresentative(dockable);
            DockTitle[] dockTitleArray = titles = dockable.listBoundTitles();
            int n = titles.length;
            int n2 = 0;
            while (n2 < n) {
                DockTitle title = dockTitleArray[n2];
                if (this.titles.add(title)) {
                    title.bind();
                    DockController.this.fireTitleBound(title, dockable);
                }
                ++n2;
            }
        }

        @Override
        public void dockableUnregistered(DockController controller, Dockable dockable) {
            DockTitle[] titles;
            dockable.removeDockableListener(this.dockableListener);
            DockController.this.removeRepresentative(dockable);
            DockTitle[] dockTitleArray = titles = dockable.listBoundTitles();
            int n = titles.length;
            int n2 = 0;
            while (n2 < n) {
                DockTitle title = dockTitleArray[n2];
                if (this.titles.remove(title)) {
                    title.unbind();
                    DockController.this.fireTitleUnbound(title, dockable);
                }
                ++n2;
            }
        }
    }

    private class DockableSelectionObserver
    extends DockRegisterAdapter {
        private DockStationListener listener = new DockStationAdapter(){

            @Override
            public void dockableSelected(DockStation station, Dockable oldSelected, Dockable newSelected) {
                DockController.this.fireDockableSelected(station, oldSelected, newSelected);
            }
        };

        private DockableSelectionObserver() {
        }

        @Override
        public void dockStationRegistered(DockController controller, DockStation station) {
            station.addDockStationListener(this.listener);
        }

        @Override
        public void dockStationUnregistered(DockController controller, DockStation station) {
            station.removeDockStationListener(this.listener);
        }
    }

    private class FocusControllerObserver
    implements DockableFocusListener {
        private FocusControllerObserver() {
        }

        @Override
        public void dockableFocused(DockableFocusEvent event) {
            for (Map.Entry title : DockController.this.activeTitles.entrySet()) {
                DockStation parent = ((Dockable)title.getValue()).getDockParent();
                if (parent != null) {
                    parent.changed((Dockable)title.getValue(), (DockTitle)title.getKey(), false);
                    continue;
                }
                ((DockTitle)title.getKey()).changed(new DockTitleEvent((Dockable)title.getValue(), false));
            }
            DockController.this.activeTitles.clear();
            Dockable dockable = event.getNewFocusOwner();
            while (dockable != null) {
                DockStation station = dockable.getDockParent();
                if (station != null) {
                    DockTitle[] titles;
                    DockTitle[] dockTitleArray = titles = dockable.listBoundTitles();
                    int n = titles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DockTitle title = dockTitleArray[n2];
                        station.changed(dockable, title, true);
                        DockController.this.activeTitles.put(title, dockable);
                        ++n2;
                    }
                    station.setFrontDockable(dockable);
                    dockable = station.asDockable();
                    continue;
                }
                dockable = null;
            }
        }
    }
}

