/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.AbstractPreferenceModel;
import bibliothek.extension.gui.dock.preference.MergedPreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModelListener;
import bibliothek.extension.gui.dock.preference.PreferenceModelText;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.gui.DockController;
import bibliothek.util.Path;
import bibliothek.util.PathCombiner;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PreferenceTreeModel
extends AbstractPreferenceModel
implements TreeModel {
    private MergedPreferenceModel delegate;
    private PreferenceModelListener delegateListener = new PreferenceModelListener(){

        @Override
        public void preferenceAdded(PreferenceModel model, int beginIndex, int endIndex) {
            PreferenceTreeModel.this.firePreferenceAdded(beginIndex, endIndex);
        }

        @Override
        public void preferenceChanged(PreferenceModel model, int beginIndex, int endIndex) {
            PreferenceTreeModel.this.firePreferenceChanged(beginIndex, endIndex);
        }

        @Override
        public void preferenceRemoved(PreferenceModel model, int beginIndex, int endIndex) {
            PreferenceTreeModel.this.firePreferenceRemoved(beginIndex, endIndex);
        }
    };
    private List<TreeModelListener> treeListeners = new ArrayList<TreeModelListener>();
    private TreeNode root = new TreeNode(null, new Path());

    public PreferenceTreeModel(DockController controller) {
        super(controller);
        this.delegate = new MergedPreferenceModel(controller);
    }

    public PreferenceTreeModel(PathCombiner combiner, DockController controller) {
        super(controller);
        this.delegate = new MergedPreferenceModel(combiner, controller);
    }

    @Override
    protected boolean hasListeners() {
        return super.hasListeners() || this.treeListeners.size() > 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        boolean listeners = this.hasListeners();
        this.treeListeners.add(l);
        if (!listeners && this.hasListeners()) {
            this.delegate.addPreferenceModelListener(this.delegateListener);
            this.root.updateListening(true);
        }
    }

    @Override
    public void addPreferenceModelListener(PreferenceModelListener listener) {
        boolean listeners = this.hasListeners();
        super.addPreferenceModelListener(listener);
        if (!listeners && this.hasListeners()) {
            this.delegate.addPreferenceModelListener(this.delegateListener);
            this.root.updateListening(true);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        boolean listeners = this.hasListeners();
        this.treeListeners.remove(l);
        if (listeners && !this.hasListeners()) {
            this.delegate.removePreferenceModelListener(this.delegateListener);
            this.root.updateListening(false);
        }
    }

    @Override
    public void removePreferenceModelListener(PreferenceModelListener listener) {
        boolean listeners = this.hasListeners();
        super.removePreferenceModelListener(listener);
        if (listeners && !this.hasListeners()) {
            this.delegate.removePreferenceModelListener(this.delegateListener);
            this.root.updateListening(false);
        }
    }

    protected TreeModelListener[] getTreeModelListeners() {
        return this.treeListeners.toArray(new TreeModelListener[this.treeListeners.size()]);
    }

    private void fireNodeAdded(TreeNode parent, TreeNode child) {
        TreeModelListener[] listeners = this.getTreeModelListeners();
        if (listeners.length > 0) {
            TreeModelEvent event = new TreeModelEvent((Object)this, parent.getTreePath(), new int[]{parent.indexOf(child)}, new Object[]{child});
            TreeModelListener[] treeModelListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                TreeModelListener listener = treeModelListenerArray[n2];
                listener.treeNodesInserted(event);
                ++n2;
            }
        }
    }

    private void fireNodeChanged(TreeNode node) {
        TreeModelListener[] listeners = this.getTreeModelListeners();
        if (listeners.length > 0) {
            TreeNode parent = node.getParent();
            TreeModelEvent event = parent == null ? new TreeModelEvent((Object)this, node.getTreePath()) : new TreeModelEvent((Object)parent, parent.getTreePath(), new int[]{parent.indexOf(node)}, new Object[]{node});
            TreeModelListener[] treeModelListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                TreeModelListener listener = treeModelListenerArray[n2];
                listener.treeNodesChanged(event);
                ++n2;
            }
        }
    }

    private void fireNodeRemoved(TreeNode parent, int[] indices, Object[] children) {
        TreeModelListener[] listeners = this.getTreeModelListeners();
        if (listeners.length > 0) {
            TreeModelEvent event = new TreeModelEvent((Object)this, parent.getTreePath(), indices, children);
            TreeModelListener[] treeModelListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                TreeModelListener listener = treeModelListenerArray[n2];
                listener.treeNodesRemoved(event);
                ++n2;
            }
        }
    }

    @Override
    public Node getChild(Object parent, int index) {
        return ((TreeNode)parent).getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildrenCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).indexOf((TreeNode)child);
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((TreeNode)node).getChildrenCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public String getDescription(int index) {
        return this.delegate.getDescription(index);
    }

    @Override
    public boolean isNatural(int index) {
        return this.delegate.isNatural(index);
    }

    @Override
    public void setValueNatural(int index) {
        this.delegate.setValueNatural(index);
    }

    @Override
    public PreferenceOperation[] getOperations(int index) {
        return this.delegate.getOperations(index);
    }

    @Override
    public boolean isEnabled(int index, PreferenceOperation operation) {
        return this.delegate.isEnabled(index, operation);
    }

    @Override
    public void doOperation(int index, PreferenceOperation operation) {
        this.delegate.doOperation(index, operation);
    }

    @Override
    public void read() {
        this.delegate.read();
    }

    @Override
    public void write() {
        this.delegate.write();
    }

    @Override
    public String getLabel(int index) {
        return this.delegate.getLabel(index);
    }

    @Override
    public Path getPath(int index) {
        return this.delegate.getPath(index);
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    @Override
    public Path getTypePath(int index) {
        return this.delegate.getTypePath(index);
    }

    @Override
    public Object getValueInfo(int index) {
        return this.delegate.getValueInfo(index);
    }

    @Override
    public Object getValue(int index) {
        return this.delegate.getValue(index);
    }

    @Override
    public void setValue(int index, Object value) {
        this.delegate.setValue(index, value);
    }

    public void putNode(Path path, String name) {
        this.root.getNode(path, 0).setName(name);
    }

    public void putLinked(Path path, String nameId) {
        this.root.getNode(path, 0).setNameId(nameId);
    }

    public void putModel(Path path, PreferenceModel model) {
        this.root.getNode(path, 0).setModel(model);
        this.delegate.remove(path);
        this.delegate.add(model, path);
    }

    public void put(Path path, String name, PreferenceModel model) {
        this.delegate.remove(path);
        if (model != null) {
            this.delegate.add(model, path);
        }
        this.root.getNode(path, 0).set(name, model);
    }

    public void putLinked(Path path, String nameId, PreferenceModel model) {
        this.delegate.remove(path);
        if (model != null) {
            this.delegate.add(model, path);
        }
        this.root.getNode(path, 0).setLinked(nameId, model);
    }

    public PreferenceModel getModel(Path path) {
        return this.delegate.getModel(path);
    }

    public void delete(Path path) {
        this.root.delete(path, 0);
    }

    public static interface Node {
        public Path getPath();

        public String getName();

        public PreferenceModel getModel();
    }

    private class TreeNode
    implements Node {
        private TreeNode parent;
        private List<TreeNode> children;
        private Path path;
        private TreePath treePath;
        private PreferenceModelText name;
        private PreferenceModel model;

        public TreeNode(TreeNode parent, Path path) {
            this.parent = parent;
            this.path = path;
            this.name = new PreferenceModelText("null", PreferenceTreeModel.this){

                @Override
                protected void changed(String oldValue, String newValue) {
                    PreferenceTreeModel.this.fireNodeChanged(TreeNode.this);
                }
            };
            if (PreferenceTreeModel.this.hasListeners()) {
                this.name.setController(PreferenceTreeModel.this.getController());
            }
        }

        public void updateListening(boolean listening) {
            if (listening) {
                this.name.setController(PreferenceTreeModel.this.getController());
            } else {
                this.name.setController(null);
            }
            if (this.children != null) {
                for (TreeNode child : this.children) {
                    child.updateListening(listening);
                }
            }
        }

        public int getChildrenCount() {
            return this.children == null ? 0 : this.children.size();
        }

        public TreeNode getChild(int index) {
            return this.children.get(index);
        }

        public int indexOf(TreeNode child) {
            return this.children.indexOf(child);
        }

        public TreePath getTreePath() {
            if (this.treePath != null) {
                return this.treePath;
            }
            this.treePath = this.parent == null ? new TreePath(this) : this.parent.getTreePath().pathByAddingChild(this);
            return this.treePath;
        }

        public TreeNode getNode(Path path, int segment) {
            TreeNode child2;
            if (segment == path.getSegmentCount()) {
                return this;
            }
            if (this.children == null) {
                this.children = new ArrayList<TreeNode>();
            }
            String check = path.getSegment(segment);
            for (TreeNode child2 : this.children) {
                if (!check.equals(child2.getPath().getLastSegment())) continue;
                return child2.getNode(path, segment + 1);
            }
            child2 = new TreeNode(this, path.subPath(0, segment + 1));
            this.children.add(child2);
            PreferenceTreeModel.this.fireNodeAdded(this, child2);
            return child2.getNode(path, segment + 1);
        }

        public void delete(Path path, int segment) {
            if (segment == path.getSegmentCount()) {
                this.delete(false);
            } else if (this.children != null) {
                String check = path.getSegment(segment);
                for (TreeNode child : this.children) {
                    if (!check.equals(child.getPath().getLastSegment())) continue;
                    child.delete(path, segment + 1);
                    break;
                }
            }
        }

        public void delete(boolean silent) {
            if (this.children != null) {
                for (TreeNode child : this.children) {
                    child.delete(true);
                }
            }
            if (!silent) {
                if (this.parent == null) {
                    if (this.children != null) {
                        int[] indices = new int[this.children.size()];
                        int i = 0;
                        while (i < indices.length) {
                            indices[i] = i;
                            ++i;
                        }
                        Object[] removed = this.children.toArray();
                        this.children.clear();
                        PreferenceTreeModel.this.fireNodeRemoved(this, indices, removed);
                    }
                } else {
                    this.parent.delete(this);
                }
            }
        }

        public void delete(TreeNode child) {
            int index = this.indexOf(child);
            this.children.remove(index);
            PreferenceTreeModel.this.fireNodeRemoved(this, new int[]{index}, new Object[]{child});
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public String toString() {
            return (String)this.name.value();
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        public void setLinked(String name, PreferenceModel model) {
            this.model = model;
            this.setNameId(name);
            PreferenceTreeModel.this.fireNodeChanged(this);
        }

        public void set(String name, PreferenceModel model) {
            this.model = model;
            this.setName(name);
            PreferenceTreeModel.this.fireNodeChanged(this);
        }

        public void setNameId(String nameId) {
            this.name.setId(nameId);
        }

        public void setName(String name) {
            this.name.setValue(name);
        }

        @Override
        public String getName() {
            if (!PreferenceTreeModel.this.hasListeners()) {
                this.name.update(PreferenceTreeModel.this.getController().getTexts());
            }
            return (String)this.name.value();
        }

        public void setModel(PreferenceModel model) {
            this.model = model;
            PreferenceTreeModel.this.fireNodeChanged(this);
        }

        @Override
        public PreferenceModel getModel() {
            return this.model;
        }
    }
}

