/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.agencija.qui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.beanutils.BeanUtils;
import rs.pezar.agencija.qui.DodavanjeNew;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Firma;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogKomitenti
extends PzDialog {
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzToolBarIcon icnDodavanje;
    private JScrollPane tblScrollPane;
    private PzTable tblFirme;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnNBS;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel("0");
    private PzToolBarIcon icnDeaktivacija;
    private Properties localProperties;
    private File f;
    private String confFile = "";
    private PzToolBarIcon icnAktivacija;
    private PzToolBarIcon icnKopiranje;
    private PzToolBarIcon icnBrisanje;

    public PzDialogKomitenti(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
        try {
            this.restoreData();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private void postInit() {
        this.localProperties = new Properties();
        try {
            if (!PzDateUtility.getCurrentDate().equals(PzDateUtility.getLastDayOfCurrentYear())) {
                this.icnKopiranje.setVisible(false);
            }
            this.confFile = PzParameter.getParameterValue((String)"CONF_FILE", (String)(String.valueOf(PzApplication.getApplication().getDataFolder().getPath()) + File.separator + "config"));
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void restoreData() throws Exception {
        SwingWorker<List<Firma>, Object> worker = new SwingWorker<List<Firma>, Object>(){
            EntityManager em;

            @Override
            protected List<Firma> doInBackground() throws Exception {
                List<Object> data = new ArrayList<Firma>();
                try {
                    data = PzDialogKomitenti.this.confFile.equals("") ? (List)PzApplication.getApplication().getPropManager().loadBufferedObject("firme.sav") : (List)PzApplication.getApplication().getPropManager().loadBufferedObject("firme.sav", PzDialogKomitenti.this.confFile);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                if (data == null) {
                    data = new ArrayList();
                }
                return data;
            }

            @Override
            protected void done() {
                try {
                    try {
                        PzDialogKomitenti.this.tblFirme = new PzTable();
                        List firmas = (List)this.get();
                        Collections.sort(firmas, new Comparator<Firma>(){

                            @Override
                            public int compare(Firma o1, Firma o2) {
                                return -1 * o1.getBaza().compareTo(o2.getBaza());
                            }
                        });
                        PzDialogKomitenti.this.tblFirme.setData(firmas, Firma.class);
                        PzDialogKomitenti.this.tblScrollPane.setViewportView((Component)PzDialogKomitenti.this.tblFirme);
                        final Integer row = (Integer)PzApplication.getApplication().getSession().getRuntimeStore().get("komitenti_row");
                        if (row != null && row != 0 && !new Integer(-1).equals(row) && row < PzDialogKomitenti.this.tblFirme.getRowCount()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    PzDialogKomitenti.this.tblFirme.setRowSelectionInterval(row.intValue(), row.intValue());
                                    PzDialogKomitenti.this.tblFirme.scrollRowToVisible(row.intValue());
                                }
                            });
                        }
                        PzDialogKomitenti.this.setFilter();
                        PzDialogKomitenti.this.setRenderer();
                        PzDialogKomitenti.this.brDok.setText(String.valueOf(PzDialogKomitenti.this.tblFirme.getRowCount()));
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogKomitenti.this), (Throwable)e);
                        if (this.em != null) {
                            this.em.clear();
                            this.em.close();
                        }
                    }
                }
                finally {
                    if (this.em != null) {
                        this.em.clear();
                        this.em.close();
                    }
                }
            }
        };
        worker.execute();
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Spisak firmi za vo\u0111enje knjiga");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.toolbar.setOpaque(false);
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/businessman_add.png")));
            this.icnDodavanje.setText("Dodavanje|(INS)");
            this.icnDodavanje.setActionCommand("Dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/businessman_edit.png")));
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setActionCommand("Izmena");
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setShortcut("F3");
            this.icnAktivacija = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnAktivacija);
            this.icnAktivacija.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/businessman_preferences.png")));
            this.icnAktivacija.addActionListener((ActionListener)((Object)this));
            this.icnAktivacija.setActionCommand("aktivacija");
            this.icnAktivacija.setText("Aktiviranje|(Ctrl+A)");
            this.icnAktivacija.setShortcut("ctrl+A");
            this.icnDeaktivacija = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDeaktivacija);
            this.icnDeaktivacija.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/businessman_delete.png")));
            this.icnDeaktivacija.addActionListener((ActionListener)((Object)this));
            this.icnDeaktivacija.setActionCommand("deaktiviranje");
            this.icnDeaktivacija.setText("Deaktiviranje|(Ctrl+D)");
            this.icnDeaktivacija.setShortcut("Ctrl+D");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/businessman_delete.png")));
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.setText("Brisanje|(DEL)");
            this.icnBrisanje.setShortcut("DELETE");
            this.icnKopiranje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnKopiranje);
            this.icnKopiranje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/businessman_add.png")));
            this.icnKopiranje.setText("Nova godina|(INS)");
            this.icnKopiranje.setActionCommand("NovaGodina");
            this.icnKopiranje.addActionListener((ActionListener)((Object)this));
            this.icnKopiranje.setShortcut("INSERT");
            this.tblScrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.tblScrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(7, 7, 7, 7), 0, 0));
            this.tblFirme = new PzTable();
            this.tblScrollPane.setViewportView((Component)this.tblFirme);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj firmi:");
            JLabel renderer1 = new JLabel();
            renderer1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/nav_plain_red.png")));
            renderer1.setText("- Uga\u0161en ");
            JLabel renderer2 = new JLabel();
            renderer2.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/nav_plain_green.png")));
            renderer2.setText("- Aktivan ");
            this.statusBar.add((Component)this.brDok);
            this.statusBar.add((Component)renderer1);
            this.statusBar.add((Component)renderer2);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.setSize(505, 364);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (this.tblFirme == null) {
                return;
            }
            PzButton button = (PzButton)e.getSource();
            String actionCommand = button.getActionCommand();
            this.getSession().putParameter("tabela", (Object)this.tblFirme);
            this.getSession().putParameter("restoreData", null);
            if (actionCommand.equalsIgnoreCase("Izmena")) {
                if (this.tblFirme.getSelectedEntity() != null) {
                    if (((Firma)this.tblFirme.getSelectedEntity()).getStatus() == -1) {
                        PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Firma nije aktivan, izmena nije mogu\u0107a.");
                        return;
                    }
                    this.getSession().putParameter("firma", (Object)this.tblFirme.getSelectedEntity());
                    this.getSession().putParameter("update", (Object)true);
                    this.showDialog(DodavanjeNew.class);
                    if (this.getSession().getParameter("restoreData") != null) {
                        if (this.confFile.equals("")) {
                            PzApplication.getApplication().getPropManager().saveObject((Object)this.tblFirme.getAllEntities(), "firme.sav");
                        } else {
                            PzApplication.getApplication().getPropManager().saveBufferedObject((Object)this.tblFirme.getAllEntities(), "firme.sav", this.confFile);
                        }
                        this.restoreData();
                    }
                }
                return;
            }
            if (actionCommand.equalsIgnoreCase("Dodavanje")) {
                this.getSession().putParameter("update", (Object)false);
                this.getSession().putParameter("restoreData", null);
                this.showDialog(DodavanjeNew.class);
                if (this.getSession().getParameter("restoreData") != null) {
                    if (this.confFile.equals("")) {
                        PzApplication.getApplication().getPropManager().saveObject((Object)this.tblFirme.getAllEntities(), "firme.sav");
                    } else {
                        PzApplication.getApplication().getPropManager().saveBufferedObject((Object)this.tblFirme.getAllEntities(), "firme.sav", this.confFile);
                    }
                    this.restoreData();
                }
                return;
            }
            if (actionCommand.equalsIgnoreCase("deaktiviranje")) {
                if (this.tblFirme.getSelectedEntity() != null) {
                    Firma kom = (Firma)this.tblFirme.getSelectedEntity();
                    if (kom.getStatus() == -1) {
                        PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Firma nije aktivna, deaktivacija nije mogu\u0107a.");
                        return;
                    }
                    kom.setStatus(-1);
                    this.tblFirme.updateSelectedEntity((PzEntity)kom, true);
                    if (this.confFile.equals("")) {
                        PzApplication.getApplication().getPropManager().saveObject((Object)this.tblFirme.getAllEntities(), "firme.sav");
                    } else {
                        PzApplication.getApplication().getPropManager().saveBufferedObject((Object)this.tblFirme.getAllEntities(), "firme.sav", this.confFile);
                    }
                    this.restoreData();
                }
                return;
            }
            if (actionCommand.equalsIgnoreCase("aktivacija")) {
                if (this.tblFirme.getSelectedEntity() != null) {
                    Firma kom = (Firma)this.tblFirme.getSelectedEntity();
                    if (kom.getStatus() == 0) {
                        PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Firma je aktivna.");
                        return;
                    }
                    kom.setStatus(0);
                    this.tblFirme.updateSelectedEntityGUI((PzEntity)kom);
                    if (this.confFile.equals("")) {
                        PzApplication.getApplication().getPropManager().saveObject((Object)this.tblFirme.getAllEntities(), "firme.sav");
                    } else {
                        PzApplication.getApplication().getPropManager().saveBufferedObject((Object)this.tblFirme.getAllEntities(), "firme.sav", this.confFile);
                    }
                    this.restoreData();
                }
                return;
            }
            if (actionCommand.equalsIgnoreCase("brisanje")) {
                if (this.tblFirme.getSelectedEntity() != null) {
                    this.tblFirme.removeSelectedEntityGUI();
                    if (this.confFile.equals("")) {
                        PzApplication.getApplication().getPropManager().saveObject((Object)this.tblFirme.getAllEntities(), "firme.sav");
                    } else {
                        PzApplication.getApplication().getPropManager().saveBufferedObject((Object)this.tblFirme.getAllEntities(), "firme.sav", this.confFile);
                    }
                    this.restoreData();
                }
                return;
            }
            if (actionCommand.equalsIgnoreCase("NovaGodina")) {
                List data = this.confFile.equals("") ? (List)PzApplication.getApplication().getPropManager().loadBufferedObject("firme.sav") : (List)PzApplication.getApplication().getPropManager().loadBufferedObject("firme.sav", this.confFile);
                if (data == null) {
                    return;
                }
                ArrayList<Firma> nove = new ArrayList<Firma>();
                int godina = PzDateUtility.getCurrentYear();
                for (Firma firma : data) {
                    if (firma.getGodina() != godina) continue;
                    Firma nova = (Firma)BeanUtils.cloneBean((Object)firma);
                    nova.setBaza(nova.getBaza().replaceFirst(String.valueOf(godina), String.valueOf(godina + 1)));
                    nova.setGodina(godina + 1);
                    nove.add(nova);
                }
                nove.addAll(data);
                if (this.confFile.equals("")) {
                    PzApplication.getApplication().getPropManager().saveObject(nove, "firme.sav");
                } else {
                    PzApplication.getApplication().getPropManager().saveBufferedObject(nove, "firme.sav", this.confFile);
                }
                this.restoreData();
            }
            if (actionCommand.equalsIgnoreCase("stampa")) {
                if (this.tblFirme.getRowCount() == 0) {
                    return;
                }
                return;
            }
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void setRenderer() {
        if (this.tblFirme.getColumnByName("Status") == null) {
            return;
        }
        this.tblFirme.getColumnByName("Status").setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean isSelected, boolean arg3, int arg4, int arg5) {
                JLabel renderer = new JLabel();
                int ind = (Integer)value;
                if (ind == -1) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/nav_plain_red.png")));
                    PzDialogKomitenti.this.setForeground(Color.red);
                } else if (ind == 0) {
                    renderer.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/agencija/resource/img/nav_plain_green.png")));
                }
                if (isSelected) {
                    Color col = PzDialogKomitenti.this.tblFirme.getDefaultRenderer(Object.class).getTableCellRendererComponent((JTable)PzDialogKomitenti.this.tblFirme, value, isSelected, arg3, arg4, arg5).getBackground();
                    renderer.setBackground(col);
                    renderer.setForeground(Color.red);
                }
                renderer.setOpaque(true);
                renderer.setHorizontalAlignment(0);
                return renderer;
            }
        });
    }

    private void setFilter() {
        this.tblFirme.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                Firma f = (Firma)entity;
                return new Object[]{f.getStatus(), f.getNaziv(), f.getAdresa(), f.getPostBroj(), f.getGrad(), f.getTelefoni(), f.getPib(), f.getPdvObveznik() == 1 ? "DA" : "NE", f.getPdvObveznik() == 1 ? f.getPDVPeriod() : "", f.getMatBroj(), f.getServer(), f.getBaza()};
            }

            public String[] getColumnNames() {
                return new String[]{"Status", "Naziv", "Adresa", "<html>Po\u0161tanski<br/>broj</html>", "Grad", "Telefoni", "PIB", "PDV obveznik", "PDV period", "Mati\u010dni broj", "Server", "Baza"};
            }
        });
    }

    protected void thisWindowClosing(WindowEvent evt) {
        super.thisWindowClosing(evt);
        try {
            if (this.tblFirme != null && this.tblFirme.getSelectedRow() != -1) {
                if (this.confFile.equals("")) {
                    PzApplication.getApplication().getPropManager().saveObject((Object)this.tblFirme.getAllEntities(), "firme.sav");
                } else {
                    PzApplication.getApplication().getPropManager().saveBufferedObject((Object)this.tblFirme.getAllEntities(), "firme.sav", this.confFile);
                }
                PzApplication.getApplication().getSession().getRuntimeStore().put("komitenti_row", (Object)this.tblFirme.getSelectedRow());
            }
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

