/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.service.msg.chat.textComponent.hyperlink;

import java.awt.Color;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.commons.lang.StringUtils;

public class HyperlinkText {
    public static Color COLOR = Color.ORANGE;
    public static Integer initialFontSize = 13;
    public static final String HYPERLINK_MAIN_BEGIN = "<pzhylink>";
    public static final String HYPERLINK_MAIN_END = "</pzhylink>";
    public static final String HYPERLINK_TYPE_BEGIN = "<type>";
    public static final String HYPERLINK_TYPE_END = "</type>";
    public static final String HYPERLINK_TEXT_BEGIN = "<text>";
    public static final String HYPERLINK_TEXT_END = "</text>";
    public static final String HYPERLINK_PARAM1_BEGIN = "<p1>";
    public static final String HYPERLINK_PARAM1_END = "</p1>";
    public static final String HYPERLINK_PARAM2_BEGIN = "<p2>";
    public static final String HYPERLINK_PARAM2_END = "</p2>";
    public static final String HYPERLINK_PARAM3_BEGIN = "<p3>";
    public static final String HYPERLINK_PARAM3_END = "</p3>";
    public static final String TYPE_DOCUMENT = "DOKUMENT";
    public static final String TYPE_DIALOG = "DIALOG";
    public static final String PARAM_TYPE = "TYPE";
    public static final String PARAM_TEXT = "TEXT";
    public static final String PARAM_PARAM1 = "P1";
    public static final String PARAM_PARAM2 = "P2";
    public static final String PARAM_PARAM3 = "P3";
    private String type;
    private String text;
    private String param1;
    private String param2;
    private String param3;
    private Integer position = 0;
    private Integer length = 0;

    public static HyperlinkText decodeHyperLink(String text) {
        HyperlinkText temp = new HyperlinkText();
        String type = StringUtils.substringBetween((String)text, (String)HYPERLINK_TYPE_BEGIN, (String)HYPERLINK_TYPE_END);
        String txt = StringUtils.substringBetween((String)text, (String)HYPERLINK_TEXT_BEGIN, (String)HYPERLINK_TEXT_END);
        String param1 = StringUtils.substringBetween((String)text, (String)HYPERLINK_PARAM1_BEGIN, (String)HYPERLINK_PARAM1_END);
        String param2 = StringUtils.substringBetween((String)text, (String)HYPERLINK_PARAM2_BEGIN, (String)HYPERLINK_PARAM2_BEGIN);
        String param3 = StringUtils.substringBetween((String)text, (String)HYPERLINK_PARAM3_BEGIN, (String)HYPERLINK_PARAM3_BEGIN);
        if (type == null && txt == null && param1 == null && param2 == null && param3 == null) {
            return null;
        }
        if (type == null || txt == null || type.trim().length() == 0 || txt.trim().length() == 0) {
            return null;
        }
        if (param1 == null) {
            param1 = "";
        }
        if (param2 == null) {
            param2 = "";
        }
        if (param3 == null) {
            param3 = "";
        }
        temp.setText(txt);
        temp.setType(type);
        temp.setParam1(param1);
        temp.setParam2(param2);
        temp.setParam3(param3);
        return temp;
    }

    public static String codeHyperLink(HyperlinkText hyperlink) throws Exception {
        if (hyperlink == null || hyperlink.getText() == null || hyperlink.getType() == null || hyperlink.getType().trim().length() == 0 || hyperlink.getType().trim().length() == 0) {
            throw new Exception("Polja text i type ne smeju biti null i ne smeju biti prazni karakteri");
        }
        String temp = "";
        if (hyperlink.getParam1() != null) {
            temp = String.valueOf(temp) + HYPERLINK_PARAM1_BEGIN + hyperlink.getParam1() + HYPERLINK_PARAM1_END;
        }
        if (hyperlink.getText() != null) {
            temp = String.valueOf(temp) + HYPERLINK_TEXT_BEGIN + hyperlink.getText() + HYPERLINK_TEXT_END;
        }
        if (hyperlink.getParam2() != null) {
            temp = String.valueOf(temp) + HYPERLINK_PARAM2_BEGIN + hyperlink.getParam2() + HYPERLINK_PARAM2_BEGIN;
        }
        if (hyperlink.getType() != null) {
            temp = String.valueOf(temp) + HYPERLINK_TYPE_BEGIN + hyperlink.getType() + HYPERLINK_TYPE_END;
        }
        if (hyperlink.getParam3() != null) {
            temp = String.valueOf(temp) + HYPERLINK_PARAM3_BEGIN + hyperlink.getParam2() + HYPERLINK_PARAM3_BEGIN;
        }
        temp = HYPERLINK_MAIN_BEGIN + temp + HYPERLINK_MAIN_END;
        return temp;
    }

    public static SimpleAttributeSet getTextAttributes() {
        SimpleAttributeSet hyperLinkAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(hyperLinkAttributeSet, COLOR);
        StyleConstants.setBold(hyperLinkAttributeSet, true);
        StyleConstants.setFontSize(hyperLinkAttributeSet, initialFontSize);
        StyleConstants.setUnderline(hyperLinkAttributeSet, true);
        return hyperLinkAttributeSet;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private String getCustomIcon(String type) {
        return null;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public String getParam1() {
        return this.param1;
    }

    public void setParam1(String param1) {
        this.param1 = param1;
    }

    public String getParam2() {
        return this.param2;
    }

    public void setParam2(String param2) {
        this.param2 = param2;
    }

    public String getParam3() {
        return this.param3;
    }

    public void setParam3(String param3) {
        this.param3 = param3;
    }
}

