/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.tableModels;

import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.knjigaPausalnihObveznika.PzDialogKnjigaPausalnihObveznika;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.data.models.PzScrollableTableModel;

public class PzTableModelKPO
extends PzScrollableTableModel {
    public static final byte FIELD_RBR = 0;
    public static final byte FIELD_DATUM = 1;
    public static final byte FIELD_OPIS = 2;
    public static final byte FIELD_KOMITENT = 3;
    public static final byte FIELD_BR_FAKTURE = 4;
    public static final byte FIELD_PROIZVOD = 5;
    public static final byte FIELD_USLUGA = 6;
    public static final byte FIELD_UKUPNO = 7;
    public static final byte FIELD_SALDO = 8;
    public static final String[] zaglavlje = new String[9];
    public static final String[] kColNames;
    ScrollableCursor cursor;
    private final BigDecimal[] saldo;
    private final BigDecimal[] ukupno;
    private BigDecimal saldoPS = BigDecimal.ZERO;

    static {
        PzTableModelKPO.zaglavlje[0] = "Rbr";
        PzTableModelKPO.zaglavlje[1] = "Datum";
        PzTableModelKPO.zaglavlje[2] = "Opis";
        PzTableModelKPO.zaglavlje[3] = "Sifra kom.";
        PzTableModelKPO.zaglavlje[4] = "Oznaka dok.";
        PzTableModelKPO.zaglavlje[5] = "Proizvodi";
        PzTableModelKPO.zaglavlje[6] = "Usluge";
        PzTableModelKPO.zaglavlje[7] = "Ukupno";
        PzTableModelKPO.zaglavlje[8] = "Saldo";
        kColNames = new String[]{zaglavlje[0], zaglavlje[1], zaglavlje[2], zaglavlje[3], zaglavlje[4], zaglavlje[5], zaglavlje[6], zaglavlje[7], zaglavlje[8]};
    }

    public PzTableModelKPO(ScrollableCursor cursor, BigDecimal prenetoS, PzDialogKnjigaPausalnihObveznika dialog) {
        this.cursor = cursor;
        this.saldo = new BigDecimal[cursor.size()];
        this.ukupno = new BigDecimal[cursor.size()];
        this.saldoPS = prenetoS;
    }

    public synchronized String getColumnName(int columnIndex) {
        if (this.cursor.isClosed()) {
            return null;
        }
        return kColNames[columnIndex];
    }

    public synchronized int getColumnCount() {
        return kColNames.length;
    }

    public synchronized int getRowCount() {
        if (this.cursor.isClosed()) {
            return 0;
        }
        return this.cursor.size();
    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        ScrollableCursor sc = this.cursor;
        if (sc == null || sc.isClosed()) {
            return null;
        }
        sc.size();
        if (sc.size() > 0) {
            if (sc.absolute(rowIndex)) {
                Object e = sc.next();
                return this.getValueSet((Object[])e, rowIndex)[columnIndex];
            }
            return null;
        }
        return null;
    }

    private Object[] getValueSet(Object[] dok, int rowindex) {
        BigDecimal usluge;
        BigDecimal proizvod;
        String tipDok;
        int rbr = (Integer)dok[0];
        Date datum = (Date)dok[1];
        String kom = (String)dok[2];
        String oznDokumenta = dok[3] == null ? "" : dok[3];
        BigDecimal iznosP = dok[4] == null ? BigDecimal.ZERO : dok[4];
        BigDecimal iznosU = dok[5] == null ? BigDecimal.ZERO : dok[5];
        Integer storno = (Integer)(dok[6] == null ? Integer.valueOf(0) : dok[6]);
        String string = tipDok = dok[7] == null ? "" : dok[7];
        if (storno == 1) {
            proizvod = iznosP.negate();
            usluge = iznosU.negate();
        } else {
            proizvod = iznosP;
            usluge = iznosU;
        }
        this.ukupno[rowindex] = proizvod.add(usluge);
        this.saldo[rowindex] = rowindex == 0 ? this.ukupno[rowindex].add(this.saldoPS) : this.ukupno[rowindex];
        if (rowindex != 0) {
            this.saldo[rowindex] = this.saldo[rowindex].add(this.saldo[rowindex - 1]);
        }
        String opis = PzTableModelKPO.getDocumentOpis(tipDok, datum, oznDokumenta, kom, storno, rbr);
        Object[] results = new Object[16];
        results[0] = rbr;
        results[1] = datum;
        results[2] = opis;
        results[3] = kom;
        results[4] = oznDokumenta;
        results[5] = proizvod;
        results[6] = usluge;
        results[7] = this.ukupno[rowindex];
        results[8] = this.saldo[rowindex];
        return results;
    }

    public static String getDocumentOpis(String documentType, Date documentDate, String document, String komitent, Integer storno, Integer iddok) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy");
        String formattedDate = null;
        if (documentDate != null) {
            formattedDate = formatter.format(documentDate);
        }
        if (documentType.equals(TipDokumentConfig.get().FAKTURA_SERVISA)) {
            if (storno != 1) {
                return "Faktura servisa: " + document + ",od: " + formattedDate;
            }
            return "Storno fakture servisa: " + document + ",od: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().FAKTURA_USLUGA)) {
            if (storno != 1) {
                return "Faktura usluga: " + document + ",od: " + formattedDate;
            }
            return "Storno fakture usluga: " + document + ",od: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().FAKTURA)) {
            if (storno != 1) {
                return "Faktura: " + document + ",od: " + formattedDate;
            }
            return "Storno fakture: " + document + ",od: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().KPO_DOKUMENT)) {
            return "KPO dokument: " + document + ",od: " + formattedDate;
        }
        if (documentType.equals(TipDokumentConfig.get().FISKALNI_IZVESTAJ)) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj: " + document + ",od: " + formattedDate;
            }
            return "Storno Dn. fiskalni izve\u0161taj: " + document + ",od: " + formattedDate;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_GOT")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - ke\u0161: " + document + ",od: " + formattedDate;
            }
            return "Storno Dn. fiskalni izve\u0161taj - ke\u0161: " + document + ",od: " + formattedDate;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_PLK")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - kartica: " + document + ",od: " + formattedDate;
            }
            return "Storno Dn. fiskalni izve\u0161taj - kartica: " + document + ",od: " + formattedDate;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_CEK")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - \u010dek: " + document + ",od: " + formattedDate;
            }
            return "Storno Dn. fiskalni izve\u0161taj - \u010dek: " + document + ",od: " + formattedDate;
        }
        if (documentType.equals(String.valueOf(TipDokumentConfig.get().FISKALNI_IZVESTAJ) + "_FAK")) {
            if (storno != 1) {
                return "Dn. fiskalni izve\u0161taj - ostalo: " + document + ",od: " + formattedDate;
            }
            return "Storno Dn. fiskalni izve\u0161taj - ostalo: " + document + ",od: " + formattedDate;
        }
        return null;
    }
}

