/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.zatvoriFakturu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Uplata;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;

public class ZatvoriFakturuKupcaAvansom
extends PzDialog {
    private Faktura faktura;
    private JPanel pnlButtons;
    private JScrollPane jScrollPane1;
    private PzButton btnPotvrdi;
    private PzDoubleField dfUkupno;
    private PzDoubleField dfIznosFakture;
    private JLabel lblIznosFakture;
    private JPanel pnlFaktura;
    private JLabel lblUkupno;
    private JPanel pnlSummary;
    private PzTable tblZatvaranje;
    private PzButton btnBrisiAvans;
    private PzButton btnDodajAvans;
    private JPanel content;
    private Komitent komitent;
    private Date datum;
    private BigDecimal dugPoFakturi;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                ZatvoriFakturuKupcaAvansom inst = new ZatvoriFakturuKupcaAvansom(frame);
                inst.setVisible(true);
            }
        });
    }

    public ZatvoriFakturuKupcaAvansom(JFrame parent) {
        super(parent);
        this.initGUI();
    }

    public ZatvoriFakturuKupcaAvansom(PzDialog parent) {
        super(parent);
        if (this.getSession().getParameter("dokument") instanceof Faktura) {
            this.faktura = (Faktura)this.getSession().getParameter("dokument");
        }
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        this.datum = (Date)this.getSession().getParameter("datumDokumenta");
        this.dugPoFakturi = (BigDecimal)this.getSession().getParameter("dugPoFakturi");
        this.initGUI();
        this.populateGUI();
    }

    private void initGUI() {
        try {
            this.content = new JPanel();
            GridBagLayout contentLayout = new GridBagLayout();
            contentLayout.columnWidths = new int[]{7};
            contentLayout.rowHeights = new int[]{20, 7, 7, 20};
            contentLayout.columnWeights = new double[]{0.1};
            contentLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            this.getContentPane().add((Component)this.content, "Center");
            this.content.setLayout(contentLayout);
            this.pnlButtons = new JPanel();
            FlowLayout pnlButtonsLayout = new FlowLayout();
            pnlButtonsLayout.setAlignment(0);
            this.pnlButtons.setLayout(pnlButtonsLayout);
            this.content.add((Component)this.pnlButtons, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnDodajAvans = new PzButton();
            this.pnlButtons.add((Component)this.btnDodajAvans);
            this.btnDodajAvans.setName("btnDodajAvans");
            this.btnBrisiAvans = new PzButton();
            this.pnlButtons.add((Component)this.btnBrisiAvans);
            this.btnBrisiAvans.setName("btnBrisiAvans");
            this.jScrollPane1 = new JScrollPane();
            this.content.add((Component)this.jScrollPane1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tblZatvaranje = new PzTable();
            this.jScrollPane1.setViewportView((Component)this.tblZatvaranje);
            this.tblZatvaranje.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Uplata dok = (Uplata)entity;
                    return new Object[]{dok.getOznDokumenta(), dok.getIznos().subtract(dok.getStornoIznos()), dok.getDatum()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Broj av. racuna", "Iznos", "Datum av. racuna"};
                }
            });
            this.pnlSummary = new JPanel();
            FlowLayout pnlSummaryLayout = new FlowLayout();
            pnlSummaryLayout.setAlignment(2);
            this.pnlSummary.setLayout(pnlSummaryLayout);
            this.content.add((Component)this.pnlSummary, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblUkupno = new JLabel();
            this.pnlSummary.add(this.lblUkupno);
            this.lblUkupno.setName("lblUkupno");
            this.dfUkupno = new PzDoubleField();
            this.pnlSummary.add((Component)this.dfUkupno);
            this.dfUkupno.setPreferredSize(new Dimension(125, 26));
            this.btnPotvrdi = new PzButton();
            this.pnlSummary.add((Component)this.btnPotvrdi);
            this.btnPotvrdi.setName("btnPotvrdi");
            this.pnlFaktura = new JPanel();
            GridBagLayout pnlFakturaLayout = new GridBagLayout();
            this.content.add((Component)this.pnlFaktura, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFakturaLayout.rowWeights = new double[]{0.0};
            pnlFakturaLayout.rowHeights = new int[]{7};
            pnlFakturaLayout.columnWeights = new double[]{0.1, 0.1};
            pnlFakturaLayout.columnWidths = new int[]{7, 7};
            this.pnlFaktura.setLayout(pnlFakturaLayout);
            this.lblIznosFakture = new JLabel();
            this.pnlFaktura.add((Component)this.lblIznosFakture, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblIznosFakture.setName("lblIznosFakture");
            this.dfIznosFakture = new PzDoubleField();
            this.pnlFaktura.add((Component)this.dfIznosFakture, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.setSize(587, 440);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    private void populateGUI() {
        try {
            this.tblZatvaranje.setData(this.getAvansniRacuni(this.faktura), Uplata.class);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    private List<Uplata> getAvansniRacuni(Faktura f) throws Exception {
        String tipPDV = "SA_PDV";
        if (f.getSaPorezom() == 0) {
            tipPDV = f.getSaPravomNaOdbitak() == 1 ? "SA_PRAVOM" : "BEZ_PRAVA";
        }
        Vector list = PzEntityManager.select((String)("SELECT u FROM Uplata u WHERE u.tip='" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS + "' " + "AND u.arhiviran != -1 and u.komitent.sfrKomitent='" + this.komitent.getSfrKomitent() + "' and u.porez='" + tipPDV + "'"));
        Vector<Uplata> uplate = new Vector<Uplata>();
        for (PzEntity e : list) {
            uplate.add((Uplata)e);
        }
        return uplate;
    }
}

