/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogProdatiNeprodatiArtikli
extends PzDialog {
    private static final String BEZ_PRODAJE = "Bez prodaje duze od";
    private static final String PRODAJA = "Prodaja po mesecima";
    private static String JAN = "";
    private static String FEB = "";
    private static String MAR = "";
    private static String APR = "";
    private static String MAJ = "";
    private static String JUN = "";
    private static String JUL = "";
    private static String AVG = "";
    private static String SEP = "";
    private static String OKT = "";
    private static String NOV = "";
    private static String DEC = "";
    private Radnajedinica rj;
    private PzPanel mainPanel;
    private PzRadioGroup<String> panelRBs;
    private JLabel lblBrojDana;
    private JButton btnPotvrdi;
    private PzNumericOnlyTextField tfBrojDana;
    private ScrollableCursor cursor = null;
    private PzPanel pnlValute;
    private PzComboBox cbValute;

    public PzDialogProdatiNeprodatiArtikli(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        this.setDate();
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValute.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValute.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{25, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.columnWidths = new int[]{163, 69, 135, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.panelRBs = new PzRadioGroup((Object[])new String[]{BEZ_PRODAJE, PRODAJA});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRBs, 1);
            this.panelRBs.setLayout((LayoutManager)panelRBs2Layout);
            this.mainPanel.add(this.panelRBs, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.panelRBs.setBorder((Border)BorderFactory.createTitledBorder("Izbor pregleda"));
            this.panelRBs.setSelectedValue((Object)BEZ_PRODAJE);
            this.panelRBs.setOpaque(false);
            this.panelRBs.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogProdatiNeprodatiArtikli.BEZ_PRODAJE)) {
                            PzDialogProdatiNeprodatiArtikli.this.tfBrojDana.setEditable(true);
                        } else if (evt.getValue().equals(PzDialogProdatiNeprodatiArtikli.PRODAJA)) {
                            PzDialogProdatiNeprodatiArtikli.this.tfBrojDana.setEditable(false);
                        }
                    }
                }
            });
            this.lblBrojDana = new JLabel();
            this.mainPanel.add((Component)this.lblBrojDana, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblBrojDana.setText("Broj dana");
            this.tfBrojDana = new PzNumericOnlyTextField();
            this.mainPanel.add((Component)this.tfBrojDana, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlValute = new PzPanel();
            GridBagLayout pnlValuteLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.pnlValute, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            this.pnlValute.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            pnlValuteLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
            pnlValuteLayout.rowHeights = new int[]{7, 7, 7};
            pnlValuteLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
            pnlValuteLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlValute.setLayout((LayoutManager)pnlValuteLayout);
            this.cbValute = new PzComboBox();
            this.pnlValute.add((Component)this.cbValute, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(613, 192);
            this.setResizable(false);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (((String)this.panelRBs.getSelectedValue()).equals(BEZ_PRODAJE) && this.tfBrojDana.getVal().equals("0")) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            try {
                final EntityManager em = PzEntityManager.getEm();
                PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
                SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        em.getTransaction().begin();
                        if (PzDialogProdatiNeprodatiArtikli.this.cursor != null) {
                            PzDialogProdatiNeprodatiArtikli.this.cursor.close();
                        }
                        String upit = "";
                        Query q = null;
                        String valuta = PzDialogProdatiNeprodatiArtikli.this.cbValute.getSelectedChoice().getValue().toString();
                        if (((String)PzDialogProdatiNeprodatiArtikli.this.panelRBs.getSelectedValue()).equals(PzDialogProdatiNeprodatiArtikli.BEZ_PRODAJE)) {
                            upit = "select s.sfrproizvod, s.naziv, y.maxdatum, s.datzadulaza, s.kolicina from stanjeartikal s,(select a.sfrproizvod, max(x.datum) maxdatum from artikal a left join (Select ad.sfrproizvod, d.datum From Artikaldokument ad, Dokument d Where d.iddok = ad.iddok and d.oznRj =':rj' and d.oznOgranak = ':ogranak' and d.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%')  and d.storno = 0 and d.arhiviran = 1 ) x on a.sfrproizvod = x.sfrproizvod group by a.sfrproizvod order by a.sfrproizvod ) y where s.kolicina > 0 and  s.sfrproizvod = y.sfrproizvod and s.oznrj=':rj' and (y.maxdatum<= ':datumOd' or y.maxdatum is null)";
                        }
                        if (((String)PzDialogProdatiNeprodatiArtikli.this.panelRBs.getSelectedValue()).equals(PzDialogProdatiNeprodatiArtikli.PRODAJA)) {
                            upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(CASE WHEN (d1.datum>= '" + JAN + "' and d1.datum< '" + FEB + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + JAN + "' and d2.datum< '" + FEB + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + FEB + "' and d1.datum< '" + MAR + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + FEB + "' and d2.datum< '" + MAR + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + MAR + "' and d1.datum< '" + APR + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + MAR + "' and d2.datum< '" + APR + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + APR + "' and d1.datum< '" + MAJ + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + APR + "' and d2.datum< '" + MAJ + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + MAJ + "' and d1.datum< '" + JUN + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + MAJ + "' and d2.datum< '" + JUN + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + JUN + "' and d1.datum< '" + JUL + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + JUN + "' and d2.datum< '" + JUL + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + JUL + "' and d1.datum< '" + AVG + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + JUL + "' and d2.datum< '" + AVG + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + AVG + "' and d1.datum< '" + SEP + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + AVG + "' and d2.datum< '" + SEP + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + SEP + "' and d1.datum< '" + OKT + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + SEP + "' and d2.datum< '" + OKT + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + OKT + "' and d1.datum< '" + NOV + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + OKT + "' and d2.datum< '" + NOV + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + NOV + "' and d1.datum< '" + DEC + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + NOV + "' and d2.datum< '" + DEC + "') THEN ad2.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d1.datum>= '" + DEC + "' and d1.datum<= '" + PzDateUtility.getLastDayOfCurrentYear() + "') THEN ad1.kolicina ELSE 0 END),  " + "sum(CASE WHEN (d2.datum>= '" + DEC + "' and d2.datum<= '" + PzDateUtility.getLastDayOfCurrentYear() + "') THEN ad2.kolicina ELSE 0 END)  " + "FROM Radnajedinica rj, " + "(Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent " + "%valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON " + "d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena " + "WHERE %valutaW% d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%')  AND " + "d1.storno = 0 and d1.arhiviran = 1 AND rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and " + "rj.oznRj IN (%listaRj%) ";
                        }
                        if (((String)PzDialogProdatiNeprodatiArtikli.this.panelRBs.getSelectedValue()).equals(PzDialogProdatiNeprodatiArtikli.BEZ_PRODAJE)) {
                            upit = upit.replace(":datumOd", PzDateUtility.add((Date)PzDateUtility.getCurrentDate(), (int)(-PzDialogProdatiNeprodatiArtikli.this.tfBrojDana.getIntVal())).toString());
                            upit = upit.replace(":datumDo", PzDateUtility.getCurrentDate().toString());
                        } else {
                            upit = String.valueOf(upit) + " GROUP BY ad1.sfrProizvod, ad1.sfrSort, ad1.naziv, d1.datum ORDER BY ad1.sfrSort";
                        }
                        upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                        upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                        upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                        if (PzDialogRJ.getAvaliableRjString().equals("")) {
                            throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                        }
                        upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                        upit = upit.replace(":rj", PzDialogProdatiNeprodatiArtikli.this.rj.getId().getOznRj());
                        upit = upit.replace(":ogranak", PzDialogProdatiNeprodatiArtikli.this.rj.getId().getOznOgranak());
                        upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
                        upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                        upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                        upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                        upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                        q = em.createNativeQuery(upit);
                        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                        PzDialogProdatiNeprodatiArtikli.this.cursor = (ScrollableCursor)q.getSingleResult();
                        System.out.println("Kursor je nasao faktura" + PzDialogProdatiNeprodatiArtikli.this.cursor.size());
                        em.getTransaction().commit();
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            if (PzDialogProdatiNeprodatiArtikli.this.cursor.size() == 0) {
                                JOptionPane.showMessageDialog(PzDialogProdatiNeprodatiArtikli.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                                PzWorkerDialog.hideStatus();
                                return;
                            }
                            try {
                                PzDialogProdatiNeprodatiArtikli.this.showReports();
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle((Component)((Object)PzDialogProdatiNeprodatiArtikli.this), (Throwable)e);
                                PzWorkerDialog.hideStatus();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                };
                worker.execute();
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                PzWorkerDialog.hideStatus();
            }
        }
    }

    private void setDate() {
        Date jan = PzDateUtility.getFirstDayOfCurrentYear();
        JAN = jan.toString();
        Date feb = PzDateUtility.add((Date)jan, (int)PzDateUtility.getNumberDayOfMonth((int)0));
        FEB = feb.toString();
        Date mar = PzDateUtility.add((Date)feb, (int)PzDateUtility.getNumberDayOfMonth((int)1));
        MAR = mar.toString();
        Date apr = PzDateUtility.add((Date)mar, (int)PzDateUtility.getNumberDayOfMonth((int)2));
        APR = apr.toString();
        Date maj = PzDateUtility.add((Date)apr, (int)PzDateUtility.getNumberDayOfMonth((int)3));
        MAJ = maj.toString();
        Date jun = PzDateUtility.add((Date)maj, (int)PzDateUtility.getNumberDayOfMonth((int)4));
        JUN = jun.toString();
        Date jul = PzDateUtility.add((Date)jun, (int)PzDateUtility.getNumberDayOfMonth((int)5));
        JUL = jul.toString();
        Date avg = PzDateUtility.add((Date)jul, (int)PzDateUtility.getNumberDayOfMonth((int)6));
        AVG = avg.toString();
        Date sep = PzDateUtility.add((Date)avg, (int)PzDateUtility.getNumberDayOfMonth((int)7));
        SEP = sep.toString();
        Date okt = PzDateUtility.add((Date)sep, (int)PzDateUtility.getNumberDayOfMonth((int)8));
        OKT = okt.toString();
        Date nov = PzDateUtility.add((Date)okt, (int)PzDateUtility.getNumberDayOfMonth((int)9));
        NOV = nov.toString();
        Date dec = PzDateUtility.add((Date)nov, (int)PzDateUtility.getNumberDayOfMonth((int)10));
        DEC = dec.toString();
    }

    private void showReports() throws Exception {
        Vector<Object> data = new Vector<Object>();
        data.add(PzFirma.getFirma());
        data.add(this.rj);
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "";
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValute.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValute.getSelectedChoice().getText());
        String fname = "";
        if (((String)this.panelRBs.getSelectedValue()).equals(BEZ_PRODAJE)) {
            title = "PREGLED ARTIKALA BEZ PRODAJE DU\u017dE OD " + this.tfBrojDana.getIntVal() + " DANA ";
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.artikala.bez.prodaje.jasper";
        } else {
            title = "PREGLED PRODAJE ARTIKALA PO MESECIMA IZ RJ " + this.rj.getPunNaziv();
            fname = "rs/pezar/analitike/resource/reports/compiled/pregled.prodaje.po.mesecima.jasper";
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("subtitle", "");
        params.put("datum", today);
        params.put("reklama", "");
        params.put("valuta", valuta);
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource(fname), params, (String)title);
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        if (this.rj == null) {
            return false;
        }
        this.setTitle("Analiza prodaje i prenosa artikala. Radna jedinica " + this.rj.getPunNaziv());
        return true;
    }
}

