/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogNabavkaProdajaPoProizvodjacu
extends PzDialog {
    public static final String SVI_PROIZVODJACI = "Svi proizvo\u0111a\u010di";
    public static final String ODREDJENI_PROIZVODJAC = "Odre\u0111eni proizvo\u0111a\u010d";
    public static final String NABAVKA = "Nabavka";
    public static final String PRODAJA = "Prodaja";
    private PzTextField tfSifra;
    private PzTextField tfNaziv;
    private PzFieldIndikator indSifra;
    private JLabel lblSifra;
    private PzPanel pnlGlavni;
    private PzDateField dfKrajnjiDatum;
    private PzRadioGroup<String> panelRbs1;
    private PzRadioGroup<String> panelRbs2;
    private JLabel lblKrajnjiDatum;
    private PzDateField dfPocetniDatum;
    private JLabel lblPocetniDatum;
    private PzPanel pnlInfo;
    private PzButton btnPotvrdi;
    private Komitent entKomitent;
    private ScrollableCursor cursor = null;
    private PzComboBox cbValuta;
    private PzPanel pnlValuta;

    public PzDialogNabavkaProdajaPoProizvodjacu(JFrame frame) {
        super(frame);
        this.initGUI();
        this.setEnabledPro(false);
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Pregled nabavke/prodaje po nabavnim/prodajnim cenama");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{64, 63, 69, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlInfo = new PzPanel();
            GridBagLayout pnlInfoLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlInfo, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlInfoLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlInfoLayout.rowHeights = new int[]{5, 8, 25, 25, 5, 39, 25, 5, 25, 20};
            pnlInfoLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.1};
            pnlInfoLayout.columnWidths = new int[]{24, 91, 108, 5, 80, 64, 20, 7};
            this.pnlInfo.setLayout((LayoutManager)pnlInfoLayout);
            this.lblPocetniDatum = new JLabel();
            this.pnlInfo.add((Component)this.lblPocetniDatum, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPocetniDatum.setText("Po\u010detni datum");
            this.dfPocetniDatum = new PzDateField();
            this.pnlInfo.add((Component)this.dfPocetniDatum, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblKrajnjiDatum = new JLabel();
            this.pnlInfo.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKrajnjiDatum.setText("Krajnji datum");
            this.dfKrajnjiDatum = new PzDateField();
            this.pnlInfo.add((Component)this.dfKrajnjiDatum, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.panelRbs1 = new PzRadioGroup((Object[])new String[]{SVI_PROIZVODJACI, ODREDJENI_PROIZVODJAC});
            BoxLayout panelRBs1Layout = new BoxLayout((Container)this.panelRbs1, 1);
            this.panelRbs1.setLayout((LayoutManager)panelRBs1Layout);
            this.pnlInfo.add(this.panelRbs1, (Object)new GridBagConstraints(1, 5, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs1.setBorder((Border)BorderFactory.createTitledBorder("Izbor proizvo\u0111a\u010da"));
            this.panelRbs1.setSelectedValue((Object)SVI_PROIZVODJACI);
            this.panelRbs1.setOpaque(false);
            this.panelRbs1.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogNabavkaProdajaPoProizvodjacu.SVI_PROIZVODJACI)) {
                            PzDialogNabavkaProdajaPoProizvodjacu.this.setEnabledPro(false);
                        } else if (evt.getValue().equals(PzDialogNabavkaProdajaPoProizvodjacu.ODREDJENI_PROIZVODJAC)) {
                            PzDialogNabavkaProdajaPoProizvodjacu.this.setEnabledPro(true);
                        }
                    }
                }
            });
            this.panelRbs2 = new PzRadioGroup((Object[])new String[]{NABAVKA, PRODAJA});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRbs2, 1);
            this.panelRbs2.setLayout((LayoutManager)panelRBs2Layout);
            this.pnlInfo.add(this.panelRbs2, (Object)new GridBagConstraints(4, 5, 2, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs2.setBorder((Border)BorderFactory.createTitledBorder("Izvor"));
            this.panelRbs2.setSelectedValue((Object)NABAVKA);
            this.panelRbs2.setOpaque(false);
            this.lblSifra = new JLabel();
            this.pnlInfo.add((Component)this.lblSifra, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblSifra.setText(" \u0160ifra proizvo\u0111a\u010da");
            this.tfSifra = new PzTextField();
            this.pnlInfo.add((Component)this.tfSifra, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 21), 0, 0));
            this.tfSifra.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.indSifra = new PzFieldIndikator();
            this.pnlInfo.add((Component)this.indSifra, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 3, 0, 3), 0, 0));
            this.tfNaziv = new PzTextField();
            this.pnlInfo.add((Component)this.tfNaziv, (Object)new GridBagConstraints(4, 8, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNaziv.setEditable(false);
            this.tfNaziv.setFocusable(false);
            this.btnPotvrdi = new PzButton();
            this.pnlInfo.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 9, 8, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(130, 35));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlValuta = new PzPanel();
            this.pnlInfo.add((Component)this.pnlValuta, (Object)new GridBagConstraints(4, 1, 2, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlValuta.setLayout(null);
            this.pnlValuta.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            this.pnlValuta.setOpaque(false);
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta);
            this.cbValuta.setBounds(9, 24, 126, 25);
            this.pack();
            this.tfSifra.setStateIndikator(this.indSifra);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
            this.setSize(474, 275);
            this.setResizable(false);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (((String)this.panelRbs1.getSelectedValue()).equals(ODREDJENI_PROIZVODJAC) && this.entKomitent == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            this.indSifra.setState(PzFieldIndikator.STATE_INVALID);
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogNabavkaProdajaPoProizvodjacu.this.cursor != null) {
                        PzDialogNabavkaProdajaPoProizvodjacu.this.cursor.close();
                    }
                    String upit = "";
                    Query q = null;
                    String valuta = PzDialogNabavkaProdajaPoProizvodjacu.this.cbValuta.getSelectedChoice().getValue().toString();
                    if (((String)PzDialogNabavkaProdajaPoProizvodjacu.this.panelRbs2.getSelectedValue()).equals(PzDialogNabavkaProdajaPoProizvodjacu.PRODAJA)) {
                        upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina), sum(ad2.kolicina), sum((ad1.kolicina*ad1.prodCena)%valuta%), sum((ad2.kolicina*ad2.prodCena)%valuta%), sum(CASE WHEN (d1.tip = '%tipF%' or d1.tip = '%tipFR%') THEN ((ad1.kolicina*ad1.prodCena)*ad1.procRabata/100)%valuta% ELSE 0 END), sum(CASE WHEN (d2.tip = '%tipF%' or d2.tip = '%tipFR%') THEN ((ad2.kolicina*ad2.prodCena)*ad2.procRabata/100)%valuta% ELSE 0 END), k.sfrKomitent ,k.naziv FROM Radnajedinica rj, (Artikal a LEFT JOIN Komitent k ON a.proizvodjac = k.sfrKomitent), (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE d1.datum >= ':datumOd' AND d1.datum <= ':datumDo' AND d1.storno = 0 and d1.arhiviran = 1 AND ad1.sfrProizvod = a.sfrProizvod AND rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and rj.oznRj IN (%listaRj%) and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%')";
                    }
                    if (((String)PzDialogNabavkaProdajaPoProizvodjacu.this.panelRbs2.getSelectedValue()).equals(PzDialogNabavkaProdajaPoProizvodjacu.NABAVKA)) {
                        upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina),  sum(ad2.kolicina), sum((ad1.nabCena*ad1.kolicina)%valuta%), sum((ad2.nabCena*ad2.kolicina)%valuta%), sum(CASE WHEN (ad1.procRabata IS NULL) THEN 0 ELSE (ad1.kolicina*(ad1.nabCena/(1-ad1.procRabata/100)-ad1.nabCena))%valuta% END), sum(CASE WHEN (ad2.procRabata IS NULL) THEN 0 ELSE (ad2.kolicina*(ad2.nabCena/(1-ad2.procRabata/100)-ad2.nabCena))%valuta% END), k.sfrKomitent ,k.naziv FROM Radnajedinica rj, (Artikal a LEFT JOIN Komitent k ON a.proizvodjac = k.sfrKomitent), (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.datum >= ':datumOd' AND d1.datum <= ':datumDo' AND d1.storno = 0 and d1.arhiviran = 1 AND rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and rj.oznRj IN (%listaRj%) and ad1.sfrProizvod = a.sfrProizvod AND d1.tip = '%tipK%'";
                    }
                    if (((String)PzDialogNabavkaProdajaPoProizvodjacu.this.panelRbs1.getSelectedValue()).equals(PzDialogNabavkaProdajaPoProizvodjacu.ODREDJENI_PROIZVODJAC)) {
                        upit = String.valueOf(upit) + "  and k.sfrKomitent =':komitent'";
                        upit = upit.replace(":komitent", PzDialogNabavkaProdajaPoProizvodjacu.this.entKomitent.getSfrKomitent());
                    }
                    upit = upit.replace(":datumOd", PzDialogNabavkaProdajaPoProizvodjacu.this.dfPocetniDatum.getVal().toString());
                    upit = upit.replace(":datumDo", PzDialogNabavkaProdajaPoProizvodjacu.this.dfKrajnjiDatum.getVal().toString());
                    upit = String.valueOf(upit) + " GROUP BY k.sfrKomitent, k.naziv, ad1.sfrProizvod, ad1.sfrSort, ad1.naziv ORDER BY k.sfrKomitent, ad1.sfrSort";
                    upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                    upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                    upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and");
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
                    upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                    upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                    upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                    upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogNabavkaProdajaPoProizvodjacu.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogNabavkaProdajaPoProizvodjacu.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    block6: {
                        try {
                            try {
                                this.get();
                                if (PzDialogNabavkaProdajaPoProizvodjacu.this.cursor.size() == 0) {
                                    JOptionPane.showMessageDialog(PzDialogNabavkaProdajaPoProizvodjacu.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                                    PzWorkerDialog.hideStatus();
                                    break block6;
                                }
                                PzDialogNabavkaProdajaPoProizvodjacu.this.showReports();
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle((Component)((Object)PzDialogNabavkaProdajaPoProizvodjacu.this), (Throwable)e);
                                PzWorkerDialog.hideStatus();
                                em.close();
                            }
                        }
                        finally {
                            em.close();
                        }
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "";
        String subtitle = "NA NIVOU FIRME u periodu od: " + PzDateUtility.formatDate((Date)this.dfPocetniDatum.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfKrajnjiDatum.getVal());
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText());
        title = ((String)this.panelRbs2.getSelectedValue()).equals(PRODAJA) ? "PREGLED PRODAJE PO PRODAJNIM CENAMA " : "PREGLED NABAVKE PO NABAVNIM CENAMA ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("subtitle", subtitle);
        params.put("datum", today);
        params.put("reklama", "");
        params.put("pretraga", "");
        params.put("valuta", valuta);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/nabavka.prodaja.po.proizvidjacu.jasper"), params, (String)title);
    }

    private void setEnabledPro(boolean enabled) {
        this.tfSifra.setEditable(enabled);
        this.tfSifra.setFocusable(enabled);
        this.lblSifra.setEnabled(enabled);
        this.indSifra.setEnabled(enabled);
        if (!enabled) {
            this.tfNaziv.setVal((Object)"");
            this.tfSifra.setVal((Object)"");
            this.indSifra.setState(PzFieldIndikator.STATE_INVALID);
            this.entKomitent = null;
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.entKomitent = (Komitent)entity;
            if (this.entKomitent != null) {
                this.tfSifra.setVal((Object)this.entKomitent.getSfrKomitent());
                this.tfNaziv.setVal((Object)this.entKomitent.getNaziv());
            }
        }
    }
}

