/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.util.PzDateUtility;

public class PzDialogIzvodIzNabavkeArtikala
extends PzDialog {
    public static final String SVE_RADNE_JEDINICE = "Sve radne jedinice";
    public static final String ODREDJENA_RADNA_JEDINICA = "Odre\u0111ena radna jedinica";
    private PzPanel pnlGlavni;
    private PzPanel pnlValuta;
    private PzDateField dfKrajnjiDatum;
    private PzRadioGroup<String> panelRbs;
    private JLabel lblKrajnjiDatum;
    private PzDateField dfPocetniDatum;
    private JLabel lblPocetniDatum;
    private PzPanel pnlInfo;
    private PzButton btnPotvrdi;
    private PzDialog thisDialog;
    private Radnajedinica rj;
    private ScrollableCursor cursor = null;
    private PzPanel pnlDatum;
    private PzComboBox cbValuta;

    public PzDialogIzvodIzNabavkeArtikala(JFrame frame) {
        super(frame);
        this.thisDialog = this;
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValuta.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValuta.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Izvod iz nabavke artikala");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{37, 35, 49, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(507, 173));
            this.pnlInfo = new PzPanel();
            GridBagLayout pnlInfoLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlInfo, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlInfoLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlInfoLayout.rowHeights = new int[]{20, 16, 25, 25, 3, 7};
            pnlInfoLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlInfoLayout.columnWidths = new int[]{90, 74, 92, 100, 134, 7};
            this.pnlInfo.setLayout((LayoutManager)pnlInfoLayout);
            this.pnlInfo.setOpaque(false);
            this.panelRbs = new PzRadioGroup((Object[])new String[]{SVE_RADNE_JEDINICE, ODREDJENA_RADNA_JEDINICA});
            BoxLayout panelRBsLayout = new BoxLayout((Container)this.panelRbs, 1);
            this.panelRbs.setLayout((LayoutManager)panelRBsLayout);
            this.pnlInfo.add(this.panelRbs, (Object)new GridBagConstraints(0, 1, 2, 3, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.panelRbs.setBorder((Border)BorderFactory.createTitledBorder("Izbor radne jedinice"));
            this.panelRbs.setSelectedValue((Object)SVE_RADNE_JEDINICE);
            this.panelRbs.setOpaque(false);
            this.panelRbs.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1 && evt.getValue().equals(PzDialogIzvodIzNabavkeArtikala.ODREDJENA_RADNA_JEDINICA)) {
                        PzDialogIzvodIzNabavkeArtikala.this.rj = PzDialogRJ.getRJ((PzDialog)PzDialogIzvodIzNabavkeArtikala.this.thisDialog, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0))});
                        if (PzDialogIzvodIzNabavkeArtikala.this.rj == null) {
                            PzDialogIzvodIzNabavkeArtikala.this.panelRbs.setSelectedValue((Object)PzDialogIzvodIzNabavkeArtikala.SVE_RADNE_JEDINICE);
                        }
                    }
                }
            });
            this.btnPotvrdi = new PzButton();
            this.pnlInfo.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 5, 6, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlValuta = new PzPanel();
            this.pnlValuta.setLayout(null);
            this.pnlInfo.add((Component)this.pnlValuta, (Object)new GridBagConstraints(4, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlValuta.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            this.pnlValuta.setOpaque(false);
            this.cbValuta = new PzComboBox();
            this.pnlValuta.add((Component)this.cbValuta, (Object)"Center");
            this.cbValuta.setBounds(10, 31, 107, 27);
            this.pnlDatum = new PzPanel();
            GridBagLayout pnlDatumLayout = new GridBagLayout();
            this.pnlInfo.add((Component)this.pnlDatum, (Object)new GridBagConstraints(2, 1, 2, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlDatumLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlDatumLayout.rowHeights = new int[]{1, 25, 7, 7};
            pnlDatumLayout.columnWeights = new double[]{0.0, 0.1};
            pnlDatumLayout.columnWidths = new int[]{84, 7};
            this.pnlDatum.setLayout((LayoutManager)pnlDatumLayout);
            this.pnlDatum.setBorder((Border)BorderFactory.createTitledBorder("Izbor datuma"));
            this.pnlDatum.setOpaque(false);
            this.dfKrajnjiDatum = new PzDateField();
            this.pnlDatum.add((Component)this.dfKrajnjiDatum, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 2, 5), 0, 0));
            this.lblKrajnjiDatum = new JLabel();
            this.pnlDatum.add((Component)this.lblKrajnjiDatum, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKrajnjiDatum.setText("Krajnji datum");
            this.dfPocetniDatum = new PzDateField();
            this.pnlDatum.add((Component)this.dfPocetniDatum, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 2, 5), 0, 0));
            this.lblPocetniDatum = new JLabel();
            this.pnlDatum.add((Component)this.lblPocetniDatum, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPocetniDatum.setText("Po\u010detni datum");
            this.pack();
            this.setSize(516, 207);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogIzvodIzNabavkeArtikala.this.cursor != null) {
                        PzDialogIzvodIzNabavkeArtikala.this.cursor.close();
                    }
                    String upit = "";
                    String valuta = PzDialogIzvodIzNabavkeArtikala.this.cbValuta.getSelectedChoice().getValue().toString();
                    Query q = null;
                    upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina), sum(ad2.kolicina),ad1.nabCena%valuta%, ad1.procRabata, ad1.prodCena%valuta%, d1.sfrKomitent, d1.oznDokumenta, d1.datum FROM Radnajedinica rj, (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok %valutaF% ) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.oznRj = rj.oznRj AND d1.oznOgranak = rj.oznOGranak AND d1.tip = '%tipK%' AND rj.oznRj IN (%listaRj%) and d1.storno = 0 and d1.arhiviran = 1 AND d1.datum >= ':datumOd' AND d1.datum<= ':datumDo' ";
                    if (((String)PzDialogIzvodIzNabavkeArtikala.this.panelRbs.getSelectedValue()).equals(PzDialogIzvodIzNabavkeArtikala.ODREDJENA_RADNA_JEDINICA)) {
                        upit = String.valueOf(upit) + " and rj.oznRj=':rj' and rj.oznOgranak=':ogranak'";
                        upit = upit.replace(":rj", PzDialogIzvodIzNabavkeArtikala.this.rj.getId().getOznRj());
                        upit = upit.replace(":ogranak", PzDialogIzvodIzNabavkeArtikala.this.rj.getId().getOznOgranak());
                    }
                    upit = upit.replace(":datumOd", PzDialogIzvodIzNabavkeArtikala.this.dfPocetniDatum.getVal().toString());
                    upit = upit.replace(":datumDo", PzDialogIzvodIzNabavkeArtikala.this.dfKrajnjiDatum.getVal().toString());
                    upit = String.valueOf(upit) + " GROUP BY ad1.sfrProizvod, ad1.sfrSort, ad1.naziv, ad1.nabCena, ad1.procRabata, ad1.prodCena, d1.sfrKomitent, d1.oznDokumenta, d1.datum %valutaG% ORDER BY ad1.sfrSort";
                    upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                    upit = upit.replace("%valutaG%", valuta.equals("") ? " " : ", kurs.srednji, kurs.jedinica");
                    upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                    upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and");
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogIzvodIzNabavkeArtikala.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogIzvodIzNabavkeArtikala.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogIzvodIzNabavkeArtikala.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogIzvodIzNabavkeArtikala.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogIzvodIzNabavkeArtikala.this.showReports();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)PzDialogIzvodIzNabavkeArtikala.this.thisDialog, (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "PREGLED NABAVKE ARTIKALA U PERIODU OD " + PzDateUtility.formatDate((Date)this.dfPocetniDatum.getVal()) + " DO " + PzDateUtility.formatDate((Date)this.dfKrajnjiDatum.getVal());
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValuta.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValuta.getSelectedChoice().getText());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("datum", today);
        params.put("reklama", "");
        params.put("valuta", valuta);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/pregled.nabavke.jasper"), params, (String)title);
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogIzvodIzNabavkeArtikala(Boolean.FALSE);
    }

    public PzDialogIzvodIzNabavkeArtikala(Boolean initGUI) {
    }
}

