/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.pregledi.analizaNabavkeProdajeArtikala;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Model;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Valuta;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.reports.engine.standard.PzResultSetDataSourceAdapter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogModeli;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzComboBox;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogAnalizaProdajeNabavke
extends PzDialog {
    private static final String NABAVKA = "Nabavka";
    private static final String PRODAJA = "Prodaja";
    private static final String SVI_KOMITENTI = "Svi komitenti";
    private static final String IZABRANI_KOMITENT = "Izabrani komitent";
    private static final String SVI_PROIZVODJACI = "Svi proizvo\u0111a\u010di";
    private static final String IZABRANI_PROIZVODJACI = "Izabrani proizvo\u0111a\u010d";
    private static final String SVE_ROBNE_GRUPE = "Sve robne grupe";
    private static final String IZABRANA_ROBNA_GRUPA = "Izabrana robna grupa";
    private static final String SVI_MODELI = "Svi modeli";
    private static final String IZABRANI_MODEL = "Izabrani model";
    private static final String DETALJAN_PREGLED = "Detaljan pregled";
    private static final String ZBIRNI_PREGLED = "Zbirni pregled";
    private PzPanel pnlGlavni;
    private PzPanel panelUlazIzlaz;
    private PzFieldIndikator indSifraKomitenta;
    private JPanel pnlButton;
    private PzRadioGroup<String> panelRbs6;
    private PzDateField dfDo;
    private PzRadioGroup<String> panelRbs5;
    private PzPanel pnlModel;
    private PzTextField tfNazivRobneGrupe;
    private PzFieldIndikator indRobnaGrupa;
    private PzTextField tfRobnaGrupa;
    private JLabel lblRobnaGrupa;
    private PzTextField tfSifraProizvodjaca;
    private JLabel lblSifraProizvodjaca;
    private PzPanel pnlProizvodjac;
    private PzTextField tfNazivKomitenta;
    private PzTextField tfSifra;
    private JLabel lblDo;
    private PzDateField dfOd;
    private JLabel lblOd;
    private PzPanel pnlDatum;
    private PzPanel pnlOstalo;
    private PzTextField tfNazivModela;
    private PzFieldIndikator indModel;
    private PzTextField tfModel;
    private JLabel lblModel;
    private PzPanel pnlRobnaGrupa;
    private PzFieldIndikator indSifraProizvodjaca;
    private PzTextField tfNazivProizvodjaca;
    private JLabel lblSifra;
    private PzRadioGroup<String> panelRbs4;
    private PzRadioGroup<String> panelRbs3;
    private PzRadioGroup<String> panelRbs1;
    private PzRadioGroup<String> panelRbs2;
    private Komitent komitent;
    private Komitent proizvodjac;
    private Robnagrupa entRobnaGrupa;
    private Model entModel;
    private PzButton btnPotvrdi;
    private ScrollableCursor cursor = null;
    private PzComboBox cbValute;
    private PzPanel pnlValute;

    public PzDialogAnalizaProdajeNabavke(JFrame frame) {
        super(frame);
        this.initGUI();
        this.postInit();
    }

    private void postInit() {
        Query q = PzEntityManager.getEm().createQuery("Select v from Valuta v");
        Iterator i = q.getResultList().iterator();
        this.cbValute.addItem((Object)new PzChoice("", (Object)""));
        while (i.hasNext()) {
            Valuta v = (Valuta)i.next();
            this.cbValute.addItem((Object)new PzChoice(v.getNaziv(), (Object)v.getOznValuta()));
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Analiza prodaje i nabavke");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{10, 90, 60, 90, 90, 90, 96, 20};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.0};
            int[] nArray = new int[7];
            nArray[0] = 10;
            nArray[1] = 171;
            nArray[2] = 189;
            nArray[3] = 140;
            nArray[4] = 245;
            nArray[5] = 20;
            pnlGlavniLayout.columnWidths = nArray;
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.panelUlazIzlaz = new PzPanel();
            GridBagLayout panelUlazIzlazLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.panelUlazIzlaz, (Object)new GridBagConstraints(1, 1, 4, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panelUlazIzlazLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            panelUlazIzlazLayout.rowHeights = new int[]{20, 18, 17, 26, 25, 7};
            panelUlazIzlazLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1, 0.1};
            panelUlazIzlazLayout.columnWidths = new int[]{150, 105, 100, 100, 104, 20, 20};
            this.panelUlazIzlaz.setLayout((LayoutManager)panelUlazIzlazLayout);
            this.panelUlazIzlaz.setBorder((Border)BorderFactory.createTitledBorder("Ulaz/Izlaz"));
            this.panelUlazIzlaz.setOpaque(false);
            this.panelRbs1 = new PzRadioGroup((Object[])new String[]{PRODAJA, NABAVKA});
            BoxLayout panelRBs1Layout = new BoxLayout((Container)this.panelRbs1, 1);
            this.panelRbs1.setLayout((LayoutManager)panelRBs1Layout);
            this.panelUlazIzlaz.add(this.panelRbs1, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs1.setBorder((Border)BorderFactory.createTitledBorder("Izbor dokumenta"));
            this.panelRbs1.setSelectedValue((Object)PRODAJA);
            this.panelRbs1.setOpaque(false);
            this.panelRbs2 = new PzRadioGroup((Object[])new String[]{SVI_KOMITENTI, IZABRANI_KOMITENT});
            BoxLayout panelRBs2Layout = new BoxLayout((Container)this.panelRbs2, 1);
            this.panelRbs2.setLayout((LayoutManager)panelRBs2Layout);
            this.panelUlazIzlaz.add(this.panelRbs2, (Object)new GridBagConstraints(1, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs2.setBorder((Border)BorderFactory.createTitledBorder("Izbor komitenta"));
            this.panelRbs2.setSelectedValue((Object)SVI_KOMITENTI);
            this.panelRbs2.setOpaque(false);
            this.panelRbs2.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogAnalizaProdajeNabavke.SVI_KOMITENTI)) {
                            PzDialogAnalizaProdajeNabavke.this.setEnabledKomitent(false);
                        } else if (evt.getValue().equals(PzDialogAnalizaProdajeNabavke.IZABRANI_KOMITENT)) {
                            PzDialogAnalizaProdajeNabavke.this.setEnabledKomitent(true);
                        }
                    }
                }
            });
            this.lblSifra = new JLabel();
            this.panelUlazIzlaz.add((Component)this.lblSifra, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra komitenta");
            this.lblSifra.setEnabled(false);
            this.tfSifra = new PzTextField();
            this.panelUlazIzlaz.add((Component)this.tfSifra, (Object)new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifra.setEditable(false);
            this.tfSifra.setFocusable(false);
            this.tfSifra.addKeyListener((KeyListener)new KeyAdapter(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() != 10) return;
                    if (PzDialogAnalizaProdajeNabavke.this.tfSifra.getVal().equals("")) {
                        PzDialogAnalizaProdajeNabavke.this.komitent = PzDialogKomintenti.getKomitent((PzDialog)PzDialogAnalizaProdajeNabavke.this);
                        if (PzDialogAnalizaProdajeNabavke.this.komitent == null) return;
                        PzDialogAnalizaProdajeNabavke.this.tfSifra.setVal((Object)PzDialogAnalizaProdajeNabavke.this.komitent.getSfrKomitent());
                        PzDialogAnalizaProdajeNabavke.this.tfNazivKomitenta.setVal((Object)PzDialogAnalizaProdajeNabavke.this.komitent.getNaziv());
                        PzDialogAnalizaProdajeNabavke.this.indSifraKomitenta.setState(PzFieldIndikator.STATE_VALID);
                        return;
                    } else {
                        EntityManager em = PzEntityManager.getEm();
                        PzDialogAnalizaProdajeNabavke.this.komitent = (Komitent)em.find(Komitent.class, (Object)PzDialogAnalizaProdajeNabavke.this.tfSifra.getVal());
                        if (PzDialogAnalizaProdajeNabavke.this.komitent == null) {
                            JOptionPane.showMessageDialog((Component)((Object)PzDialogAnalizaProdajeNabavke.this), "Podatak sa izabranom \u0161ifrom ne postoji u bazi! Molim izaberite drugu \u0161ifru.", "Informacija", 1);
                            return;
                        }
                        PzDialogAnalizaProdajeNabavke.this.tfSifra.setVal((Object)PzDialogAnalizaProdajeNabavke.this.komitent.getSfrKomitent());
                        PzDialogAnalizaProdajeNabavke.this.tfNazivKomitenta.setVal((Object)PzDialogAnalizaProdajeNabavke.this.komitent.getNaziv());
                        PzDialogAnalizaProdajeNabavke.this.indSifraKomitenta.setState(PzFieldIndikator.STATE_VALID);
                    }
                }
            });
            this.tfNazivKomitenta = new PzTextField();
            this.panelUlazIzlaz.add((Component)this.tfNazivKomitenta, (Object)new GridBagConstraints(3, 4, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 0, 0), 0, 0));
            this.tfNazivKomitenta.setFocusable(false);
            this.tfNazivKomitenta.setEditable(false);
            this.indSifraKomitenta = new PzFieldIndikator();
            this.panelUlazIzlaz.add((Component)this.indSifraKomitenta, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indSifraKomitenta.setEnabled(false);
            this.pnlProizvodjac = new PzPanel();
            GridBagLayout pnlProizvodjacLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlProizvodjac, (Object)new GridBagConstraints(1, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlProizvodjacLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlProizvodjacLayout.rowHeights = new int[]{25, 25, 7};
            pnlProizvodjacLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1, 0.0, 0.1};
            pnlProizvodjacLayout.columnWidths = new int[]{150, 105, 100, 130, 20, 119, 7};
            this.pnlProizvodjac.setLayout((LayoutManager)pnlProizvodjacLayout);
            this.pnlProizvodjac.setBorder((Border)BorderFactory.createTitledBorder("Proizvo\u0111a\u010d"));
            this.pnlProizvodjac.setOpaque(false);
            this.panelRbs3 = new PzRadioGroup((Object[])new String[]{SVI_PROIZVODJACI, IZABRANI_PROIZVODJACI});
            BoxLayout panelRBs3Layout = new BoxLayout((Container)this.panelRbs3, 1);
            this.panelRbs3.setLayout((LayoutManager)panelRBs3Layout);
            this.pnlProizvodjac.add(this.panelRbs3, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelUlazIzlaz.add(this.panelRbs2, (Object)new GridBagConstraints(0, 3, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs2.setName("panelRbs2");
            this.panelRbs3.setBorder((Border)BorderFactory.createTitledBorder("Izbor"));
            this.panelRbs3.setSelectedValue((Object)SVI_PROIZVODJACI);
            this.panelRbs3.setOpaque(false);
            this.panelRbs3.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogAnalizaProdajeNabavke.SVI_PROIZVODJACI)) {
                            PzDialogAnalizaProdajeNabavke.this.setEnabledProizvodjac(false);
                        } else if (evt.getValue().equals(PzDialogAnalizaProdajeNabavke.IZABRANI_PROIZVODJACI)) {
                            PzDialogAnalizaProdajeNabavke.this.setEnabledProizvodjac(true);
                        }
                    }
                }
            });
            this.lblSifraProizvodjaca = new JLabel();
            this.pnlProizvodjac.add((Component)this.lblSifraProizvodjaca, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblSifraProizvodjaca.setText("\u0160ifra proizvo\u0111a\u010da");
            this.lblSifraProizvodjaca.setEnabled(false);
            this.tfSifraProizvodjaca = new PzTextField();
            this.pnlProizvodjac.add((Component)this.tfSifraProizvodjaca, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifraProizvodjaca.setFocusable(false);
            this.tfSifraProizvodjaca.setEditable(false);
            this.tfSifraProizvodjaca.addKeyListener((KeyListener)new KeyAdapter(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() != 10) return;
                    if (PzDialogAnalizaProdajeNabavke.this.tfSifraProizvodjaca.getVal().equals("")) {
                        PzDialogAnalizaProdajeNabavke.this.proizvodjac = PzDialogKomintenti.getKomitent((PzDialog)PzDialogAnalizaProdajeNabavke.this);
                        if (PzDialogAnalizaProdajeNabavke.this.proizvodjac == null) return;
                        PzDialogAnalizaProdajeNabavke.this.tfSifraProizvodjaca.setVal((Object)PzDialogAnalizaProdajeNabavke.this.proizvodjac.getSfrKomitent());
                        PzDialogAnalizaProdajeNabavke.this.tfNazivProizvodjaca.setVal((Object)PzDialogAnalizaProdajeNabavke.this.proizvodjac.getNaziv());
                        PzDialogAnalizaProdajeNabavke.this.indSifraProizvodjaca.setState(PzFieldIndikator.STATE_VALID);
                        return;
                    } else {
                        EntityManager em = PzEntityManager.getEm();
                        PzDialogAnalizaProdajeNabavke.this.proizvodjac = (Komitent)em.find(Komitent.class, (Object)PzDialogAnalizaProdajeNabavke.this.tfSifraProizvodjaca.getVal());
                        if (PzDialogAnalizaProdajeNabavke.this.proizvodjac == null) {
                            JOptionPane.showMessageDialog((Component)((Object)PzDialogAnalizaProdajeNabavke.this), "Podatak sa izabranom \u0161ifrom ne postoji u bazi! Molim izaberite drugu \u0161ifru.", "Informacija", 1);
                            return;
                        }
                        PzDialogAnalizaProdajeNabavke.this.tfSifraProizvodjaca.setVal((Object)PzDialogAnalizaProdajeNabavke.this.proizvodjac.getSfrKomitent());
                        PzDialogAnalizaProdajeNabavke.this.tfNazivProizvodjaca.setVal((Object)PzDialogAnalizaProdajeNabavke.this.proizvodjac.getNaziv());
                        PzDialogAnalizaProdajeNabavke.this.indSifraProizvodjaca.setState(PzFieldIndikator.STATE_VALID);
                    }
                }
            });
            this.tfNazivProizvodjaca = new PzTextField();
            this.pnlProizvodjac.add((Component)this.tfNazivProizvodjaca, (Object)new GridBagConstraints(3, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 0, 0), 0, 0));
            this.tfNazivProizvodjaca.setEditable(false);
            this.tfNazivProizvodjaca.setFocusable(false);
            this.indSifraProizvodjaca = new PzFieldIndikator();
            this.pnlProizvodjac.add((Component)this.indSifraProizvodjaca, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indSifraProizvodjaca.setEnabled(false);
            this.pnlRobnaGrupa = new PzPanel();
            GridBagLayout pnlRobnaGrupaLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlRobnaGrupa, (Object)new GridBagConstraints(1, 4, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlRobnaGrupaLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlRobnaGrupaLayout.rowHeights = new int[]{26, 25, 7};
            pnlRobnaGrupaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1, 0.1};
            pnlRobnaGrupaLayout.columnWidths = new int[]{150, 105, 100, 7, 20, 7};
            this.pnlRobnaGrupa.setLayout((LayoutManager)pnlRobnaGrupaLayout);
            this.pnlRobnaGrupa.setBorder((Border)BorderFactory.createTitledBorder("Robna grupa"));
            this.pnlRobnaGrupa.setOpaque(false);
            this.panelRbs4 = new PzRadioGroup((Object[])new String[]{SVE_ROBNE_GRUPE, IZABRANA_ROBNA_GRUPA});
            BoxLayout panelRBs4Layout = new BoxLayout((Container)this.panelRbs4, 1);
            this.panelRbs4.setLayout((LayoutManager)panelRBs4Layout);
            this.pnlRobnaGrupa.add(this.panelRbs4, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs4.setBorder((Border)BorderFactory.createTitledBorder("Izbor"));
            this.panelRbs4.setSelectedValue((Object)SVE_ROBNE_GRUPE);
            this.panelRbs4.setOpaque(false);
            this.panelRbs4.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogAnalizaProdajeNabavke.SVE_ROBNE_GRUPE)) {
                            PzDialogAnalizaProdajeNabavke.this.setEnabledRobnaGrupa(false);
                        } else if (evt.getValue().equals(PzDialogAnalizaProdajeNabavke.IZABRANA_ROBNA_GRUPA)) {
                            PzDialogAnalizaProdajeNabavke.this.setEnabledRobnaGrupa(true);
                        }
                    }
                }
            });
            this.lblRobnaGrupa = new JLabel();
            this.pnlRobnaGrupa.add((Component)this.lblRobnaGrupa, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblRobnaGrupa.setText("Robna grupa");
            this.lblRobnaGrupa.setEnabled(false);
            this.tfRobnaGrupa = new PzTextField();
            this.pnlRobnaGrupa.add((Component)this.tfRobnaGrupa, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfRobnaGrupa.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, true, null);
            this.tfRobnaGrupa.setFocusable(false);
            this.tfRobnaGrupa.setEditable(false);
            this.indRobnaGrupa = new PzFieldIndikator();
            this.pnlRobnaGrupa.add((Component)this.indRobnaGrupa, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indRobnaGrupa.setEnabled(false);
            this.tfNazivRobneGrupe = new PzTextField();
            this.pnlRobnaGrupa.add((Component)this.tfNazivRobneGrupe, (Object)new GridBagConstraints(3, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 0, 0), 0, 0));
            this.tfNazivRobneGrupe.setFocusable(false);
            this.tfNazivRobneGrupe.setEditable(false);
            this.pnlModel = new PzPanel();
            GridBagLayout pnlModelLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlModel, (Object)new GridBagConstraints(1, 5, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlModelLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlModelLayout.rowHeights = new int[]{25, 25, 7};
            pnlModelLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1};
            pnlModelLayout.columnWidths = new int[]{150, 105, 100, 7, 7};
            this.pnlModel.setLayout((LayoutManager)pnlModelLayout);
            this.pnlModel.setBorder((Border)BorderFactory.createTitledBorder("Izbor modela"));
            this.pnlModel.setOpaque(false);
            this.panelRbs5 = new PzRadioGroup((Object[])new String[]{SVI_MODELI, IZABRANI_MODEL});
            BoxLayout panelRBs5Layout = new BoxLayout((Container)this.panelRbs5, 1);
            this.panelRbs5.setLayout((LayoutManager)panelRBs5Layout);
            this.pnlModel.add(this.panelRbs5, (Object)new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs5.setBorder((Border)BorderFactory.createTitledBorder("Izbor"));
            this.panelRbs5.setSelectedValue((Object)SVI_MODELI);
            this.panelRbs5.setOpaque(false);
            this.panelRbs5.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getStateChange() == 1) {
                        if (evt.getValue().equals(PzDialogAnalizaProdajeNabavke.SVI_MODELI)) {
                            PzDialogAnalizaProdajeNabavke.this.setEnabledModel(false);
                        } else if (evt.getValue().equals(PzDialogAnalizaProdajeNabavke.IZABRANI_MODEL)) {
                            PzDialogAnalizaProdajeNabavke.this.setEnabledModel(true);
                        }
                    }
                }
            });
            this.lblModel = new JLabel();
            this.pnlModel.add((Component)this.lblModel, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblModel.setText("Model");
            this.lblModel.setEnabled(false);
            this.tfModel = new PzTextField();
            this.pnlModel.add((Component)this.tfModel, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfModel.setFKField(Model.class, PzDialogModeli.class, true, null);
            this.tfModel.setEditable(false);
            this.tfModel.setFocusable(false);
            this.tfNazivModela = new PzTextField();
            this.pnlModel.add((Component)this.tfNazivModela, (Object)new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 0, 0), 0, 0));
            this.tfNazivModela.setFocusable(false);
            this.tfNazivModela.setEditable(false);
            this.indModel = new PzFieldIndikator();
            this.pnlModel.add((Component)this.indModel, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indModel.setEnabled(false);
            this.pnlOstalo = new PzPanel();
            GridBagLayout pnlOstaloLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlOstalo, (Object)new GridBagConstraints(1, 6, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlOstaloLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlOstaloLayout.rowHeights = new int[]{7, 7, 7, 7};
            pnlOstaloLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlOstaloLayout.columnWidths = new int[]{150, 130, 188, 186, 7};
            this.pnlOstalo.setLayout((LayoutManager)pnlOstaloLayout);
            this.pnlOstalo.setBorder((Border)BorderFactory.createTitledBorder("Ostali parametri"));
            this.pnlOstalo.setOpaque(false);
            this.pnlDatum = new PzPanel();
            GridBagLayout pnlDatumLayout = new GridBagLayout();
            this.pnlOstalo.add((Component)this.pnlDatum, (Object)new GridBagConstraints(2, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlDatumLayout.rowWeights = new double[]{0.0, 0.0};
            pnlDatumLayout.rowHeights = new int[]{27, 27};
            pnlDatumLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlDatumLayout.columnWidths = new int[]{52, 55, 55, 7};
            this.pnlDatum.setLayout((LayoutManager)pnlDatumLayout);
            this.pnlDatum.setBorder((Border)BorderFactory.createTitledBorder("Period"));
            this.pnlDatum.setOpaque(false);
            this.lblOd = new JLabel();
            this.pnlDatum.add((Component)this.lblOd, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblOd.setText("Od");
            this.dfOd = new PzDateField();
            this.pnlDatum.add((Component)this.dfOd, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.lblDo = new JLabel();
            this.pnlDatum.add((Component)this.lblDo, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblDo.setText("Do");
            this.dfDo = new PzDateField();
            this.pnlDatum.add((Component)this.dfDo, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.panelRbs6 = new PzRadioGroup((Object[])new String[]{DETALJAN_PREGLED, ZBIRNI_PREGLED});
            BoxLayout panelRBs6Layout = new BoxLayout((Container)this.panelRbs6, 1);
            this.panelRbs6.setLayout((LayoutManager)panelRBs6Layout);
            this.pnlOstalo.add(this.panelRbs6, (Object)new GridBagConstraints(0, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelRbs6.setBorder((Border)BorderFactory.createTitledBorder("Oblik pregleda"));
            this.panelRbs6.setSelectedValue((Object)DETALJAN_PREGLED);
            this.panelRbs6.setOpaque(false);
            this.pnlButton = new JPanel();
            this.pnlOstalo.add((Component)this.pnlButton, (Object)new GridBagConstraints(3, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlButton.setOpaque(false);
            this.btnPotvrdi = new PzButton();
            this.pnlButton.add((Component)this.btnPotvrdi);
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pnlValute = new PzPanel();
            GridBagLayout pnlValuteLayout = new GridBagLayout();
            this.pnlOstalo.add((Component)this.pnlValute, (Object)new GridBagConstraints(1, 0, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlValute.setBorder((Border)BorderFactory.createTitledBorder("Izbor strane valute"));
            this.pnlValute.setOpaque(false);
            pnlValuteLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
            pnlValuteLayout.rowHeights = new int[]{7, 7, 7};
            pnlValuteLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
            pnlValuteLayout.columnWidths = new int[]{7, 7, 7};
            this.pnlValute.setLayout((LayoutManager)pnlValuteLayout);
            this.cbValute = new PzComboBox();
            this.pnlValute.add((Component)this.cbValute, (Object)new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfSifra.setStateIndikator(this.indSifraKomitenta);
            this.tfSifraProizvodjaca.setStateIndikator(this.indSifraProizvodjaca);
            this.tfRobnaGrupa.setStateIndikator(this.indRobnaGrupa);
            this.tfModel.setStateIndikator(this.indModel);
            this.pack();
            this.setPreferredSize(new Dimension(779, 670));
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (((String)this.panelRbs2.getSelectedValue()).equals(IZABRANI_KOMITENT) && this.komitent == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            return;
        }
        if (((String)this.panelRbs3.getSelectedValue()).equals(IZABRANI_PROIZVODJACI) && this.proizvodjac == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            return;
        }
        if (((String)this.panelRbs4.getSelectedValue()).equals(IZABRANA_ROBNA_GRUPA) && this.entRobnaGrupa == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            return;
        }
        if (((String)this.panelRbs5.getSelectedValue()).equals(IZABRANI_MODEL) && this.entModel == null) {
            PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Ne mo\u017eete nastaviti dalje dok ne popunite sva neophodna polja.");
            return;
        }
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            final EntityManager em = PzEntityManager.getEm();
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    em.getTransaction().begin();
                    if (PzDialogAnalizaProdajeNabavke.this.cursor != null) {
                        PzDialogAnalizaProdajeNabavke.this.cursor.close();
                    }
                    String upit = "";
                    Query q = null;
                    String valuta = PzDialogAnalizaProdajeNabavke.this.cbValute.getSelectedChoice().getValue().toString();
                    if (((String)PzDialogAnalizaProdajeNabavke.this.panelRbs1.getSelectedValue()).equals(PzDialogAnalizaProdajeNabavke.PRODAJA)) {
                        upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina), sum(ad2.kolicina), sum((ad1.kolicina*ad1.Cena)%valuta%), sum((ad2.kolicina*ad2.Cena)%valuta%), pro.sfrKomitent, pro.naziv, rg.oznRobGr, rg.naziv, m.oznModel, m.naziv FROM RobnaGrupa rg, Radnajedinica rj, ((Artikal a LEFT JOIN Komitent pro ON a.proizvodjac = pro.sfrKomitent) LEFT JOIN Model m ON a.oznModel = m.oznModel), (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.datum >= ':datumOd' AND d1.datum <= ':datumDo'  AND rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and d1.tip IN ('%tipF%', '%tipFI%', '%tipFS%', '%tipFR%') AND rj.oznRj IN (%listaRj%) and d1.storno = 0 and d1.arhiviran = 1 AND ad1.sfrProizvod = a.sfrProizvod AND a.oznRobGr = rg.oznRobGr ";
                    }
                    if (((String)PzDialogAnalizaProdajeNabavke.this.panelRbs1.getSelectedValue()).equals(PzDialogAnalizaProdajeNabavke.NABAVKA)) {
                        upit = "SELECT ad1.sfrProizvod, ad1.naziv, sum(ad1.kolicina),  sum(ad2.kolicina), sum((ad1.kolicina*ad1.nabCena)%valuta%), sum((ad2.kolicina*ad2.nabCena)%valuta%), pro.sfrKomitent, pro.naziv, rg.oznRobGr, rg.naziv, m.oznModel, m.naziv FROM RobnaGrupa rg, Radnajedinica rj, ((Artikal a LEFT JOIN Komitent pro  ON a.proizvodjac = pro.sfrKomitent) LEFT JOIN Model m ON a.oznModel = m.oznModel), (Dokument d1 INNER JOIN ArtikalDokument ad1 ON d1.idDok = ad1.idDok LEFT JOIN Komitent k ON d1.sfrKomitent = k.sfrKomitent %valutaF%) LEFT JOIN (Dokument d2 INNER JOIN ArtikalDokument ad2 ON d2.idDok = ad2.idDok) ON d1.idDok = d2.original AND ad1.sfrProizvod = ad2.sfrProizvod AND ad1.prodCena = ad2.prodCena WHERE %valutaW% d1.datum >= ':datumOd'  AND d1.datum <= ':datumDo' AND d1.tip = '%tipK%' AND d1.storno = 0 and d1.arhiviran = 1 AND ad1.sfrProizvod = a.sfrProizvod AND rj.oznRj = d1.oznRj and rj.oznOgranak = d1.oznOgranak and rj.oznRj IN (%listaRj%) and a.oznRobGr = rg.oznRobGr ";
                    }
                    if (((String)PzDialogAnalizaProdajeNabavke.this.panelRbs2.getSelectedValue()).equals(PzDialogAnalizaProdajeNabavke.IZABRANI_KOMITENT)) {
                        upit = String.valueOf(upit) + " and k.sfrKomitent=':komitent'";
                        upit = upit.replace(":komitent", PzDialogAnalizaProdajeNabavke.this.komitent.getSfrKomitent());
                    }
                    if (((String)PzDialogAnalizaProdajeNabavke.this.panelRbs3.getSelectedValue()).equals(PzDialogAnalizaProdajeNabavke.IZABRANI_PROIZVODJACI)) {
                        upit = String.valueOf(upit) + " and pro.sfrKomitent =':proizvodjac'";
                        upit = upit.replace(":proizvodjac", PzDialogAnalizaProdajeNabavke.this.proizvodjac.getSfrKomitent());
                    }
                    if (((String)PzDialogAnalizaProdajeNabavke.this.panelRbs4.getSelectedValue()).equals(PzDialogAnalizaProdajeNabavke.IZABRANA_ROBNA_GRUPA)) {
                        upit = String.valueOf(upit) + " and rg.oznRobGr IN " + PzDialogAnalizaProdajeNabavke.this.entRobnaGrupa.getRobnaGrupaListAsString();
                    }
                    if (((String)PzDialogAnalizaProdajeNabavke.this.panelRbs5.getSelectedValue()).equals(PzDialogAnalizaProdajeNabavke.IZABRANI_MODEL)) {
                        upit = String.valueOf(upit) + " and m.oznModel = ':model'";
                        upit = upit.replace(":model", PzDialogAnalizaProdajeNabavke.this.entModel.getOznModel());
                    }
                    upit = upit.replace(":datumOd", PzDialogAnalizaProdajeNabavke.this.dfOd.getVal().toString());
                    upit = upit.replace(":datumDo", PzDialogAnalizaProdajeNabavke.this.dfDo.getVal().toString());
                    upit = String.valueOf(upit) + " GROUP BY pro.sfrKomitent, pro.naziv, rg.oznRobGr, rg.naziv, m.oznModel, m.naziv,  ad1.sfrProizvod, ad1.sfrSort, ad1.naziv ORDER BY pro.sfrKomitent, rg.oznRobGr, m.oznModel, ad1.sfrSort";
                    upit = upit.replace("%valuta%", valuta.equals("") ? " " : "/kurs.srednji/kurs.jedinica");
                    upit = upit.replace("%valutaF%", valuta.equals("") ? " " : " INNER JOIN Kurs kurs ON kurs.datum = d1.datPrometa");
                    upit = upit.replace("%valutaW%", valuta.equals("") ? " " : " kurs.oznValuta='" + valuta + "' and ");
                    if (PzDialogRJ.getAvaliableRjString().equals("")) {
                        throw new PzInfoException("Informacija! Do\u0161lo je do gre\u0161ke prilikom dobavljanja liste dostupnih radnih jedinica! Poku\u0161ajte ponovo!");
                    }
                    upit = upit.replace("%listaRj%", PzDialogRJ.getAvaliableRjString());
                    upit = upit.replace("%tipK%", TipDokumentConfig.get().KALKULACIJA);
                    upit = upit.replace("%tipF%", TipDokumentConfig.get().FAKTURA);
                    upit = upit.replace("%tipFI%", TipDokumentConfig.get().FISKALNI_IZVESTAJ);
                    upit = upit.replace("%tipFR%", TipDokumentConfig.get().FISKALNI_RACUN);
                    upit = upit.replace("%tipFS%", TipDokumentConfig.get().FAKTURA_SERVISA);
                    q = em.createNativeQuery(upit);
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    PzDialogAnalizaProdajeNabavke.this.cursor = (ScrollableCursor)q.getSingleResult();
                    System.out.println("Kursor je nasao faktura" + PzDialogAnalizaProdajeNabavke.this.cursor.size());
                    em.getTransaction().commit();
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        if (PzDialogAnalizaProdajeNabavke.this.cursor.size() == 0) {
                            JOptionPane.showMessageDialog(PzDialogAnalizaProdajeNabavke.this.getParent(), "Nema podataka za prikazivanje", "Informacija", 1);
                            PzWorkerDialog.hideStatus();
                            return;
                        }
                        try {
                            PzDialogAnalizaProdajeNabavke.this.showReports();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogAnalizaProdajeNabavke.this), (Throwable)e);
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReports() throws Exception {
        Vector<Firma> data = new Vector<Firma>();
        Date today = PzDateUtility.getCurrentDate();
        PzDataSourceExtended ds = new PzDataSourceExtended(data, this.cursor);
        ds.setAdapter((PzDataSourceAdapter)new PzResultSetDataSourceAdapter());
        String title = "";
        String subtitle = "";
        String valuta = "Vrednosti su izra\u017eene u valuti: " + (this.cbValute.getSelectedChoice().getValue().equals("") ? "Dinar" : this.cbValute.getSelectedChoice().getText());
        if (((String)this.panelRbs1.getSelectedValue()).equals(PRODAJA)) {
            title = "PREGLED PRODAJE u periodu od: " + PzDateUtility.formatDate((Date)this.dfOd.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfDo.getVal());
            subtitle = ((String)this.panelRbs2.getSelectedValue()).equals(SVI_KOMITENTI) ? "SVI KUPCI" : "KUPAC: [" + this.komitent.getSfrKomitent() + "] " + this.komitent.getNaziv();
        } else {
            title = "PREGLED NABAVKE u periodu od: " + PzDateUtility.formatDate((Date)this.dfOd.getVal()) + " do " + PzDateUtility.formatDate((Date)this.dfDo.getVal());
            subtitle = ((String)this.panelRbs2.getSelectedValue()).equals(SVI_KOMITENTI) ? "SVI DOBAVLJA\u010cI" : "DOBAVLJA\u010c: [" + this.komitent.getSfrKomitent() + "] " + this.komitent.getNaziv();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", title);
        params.put("subtitle", subtitle);
        params.put("datum", today);
        params.put("reklama", "");
        params.put("valuta", valuta);
        data.add(PzFirma.getFirma());
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/analitike/resource/reports/compiled/analiza.prodaje.nabavke.jasper"), params, (String)title);
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Robnagrupa) {
            this.entRobnaGrupa = (Robnagrupa)entity;
            this.tfRobnaGrupa.setVal((Object)this.entRobnaGrupa.getOznRobGr());
            this.tfNazivRobneGrupe.setVal((Object)this.entRobnaGrupa.getNaziv());
            this.pnlRobnaGrupa.updateAllFieldsState();
        } else if (entity instanceof Model) {
            this.entModel = (Model)entity;
            this.tfModel.setVal((Object)this.entModel.getOznModel());
            this.tfNazivModela.setVal((Object)this.entModel.getNaziv());
            this.pnlModel.updateAllFieldsState();
        }
    }

    private void setEnabledKomitent(boolean enabled) {
        this.tfSifra.setEditable(enabled);
        this.tfSifra.setFocusable(enabled);
        this.lblSifra.setEnabled(enabled);
        this.indSifraKomitenta.setEnabled(enabled);
        if (!enabled) {
            this.tfNazivKomitenta.setVal((Object)"");
            this.tfSifra.setVal((Object)"");
            this.indSifraKomitenta.setState(PzFieldIndikator.STATE_INVALID);
            this.komitent = null;
        }
    }

    private void setEnabledProizvodjac(boolean enabled) {
        this.tfSifraProizvodjaca.setEditable(enabled);
        this.tfSifraProizvodjaca.setFocusable(enabled);
        this.lblSifraProizvodjaca.setEnabled(enabled);
        this.indSifraProizvodjaca.setEnabled(enabled);
        if (!enabled) {
            this.tfNazivProizvodjaca.setVal((Object)"");
            this.tfSifraProizvodjaca.setVal((Object)"");
            this.indSifraProizvodjaca.setState(PzFieldIndikator.STATE_INVALID);
            this.proizvodjac = null;
        }
    }

    private void setEnabledRobnaGrupa(boolean enabled) {
        this.tfRobnaGrupa.setEditable(enabled);
        this.tfRobnaGrupa.setFocusable(enabled);
        this.lblRobnaGrupa.setEnabled(enabled);
        this.indRobnaGrupa.setEnabled(enabled);
        if (!enabled) {
            this.tfNazivRobneGrupe.setVal((Object)"");
            this.tfRobnaGrupa.setVal((Object)"");
            this.indRobnaGrupa.setState(PzFieldIndikator.STATE_INVALID);
            this.entRobnaGrupa = null;
        }
    }

    private void setEnabledModel(boolean enabled) {
        this.tfModel.setEditable(enabled);
        this.tfModel.setFocusable(enabled);
        this.lblModel.setEnabled(enabled);
        this.indModel.setEnabled(enabled);
        if (!enabled) {
            this.tfNazivModela.setVal((Object)"");
            this.tfModel.setVal((Object)"");
            this.indModel.setState(PzFieldIndikator.STATE_INVALID);
            this.entModel = null;
        }
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogAnalizaProdajeNabavke(Boolean.FALSE);
    }

    public PzDialogAnalizaProdajeNabavke(Boolean initGUI) {
    }
}

