/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez.popdv;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXTitledPanel;
import rs.pezar.analitike.gui.porez.popdv.POPDVDataLoader;
import rs.pezar.analitike.gui.porez.popdv.POPDVReportManager;
import rs.pezar.analitike.gui.porez.popdv.form.Grupa;
import rs.pezar.analitike.gui.porez.popdv.form.Red;
import rs.pezar.analitike.gui.porez.popdv.form.Vrednost;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;

public class PzDialogPOPDV1
extends PzDialog {
    private PzPanelHeader pnlHeader;
    private JPanel pnlButtons;
    private JScrollPane scp;
    private JLabel lblDatKraj;
    private JLabel lblDatPoc;
    private PzDateField datKraj;
    private PzDateField datPoc;
    private PzPanel pnlDatumi;
    private PzButton btnStampaj;
    private PzButton btnPopuni;
    private JPanel pnlContent;
    private Properties prop;
    protected List<Grupa> grupe;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogPOPDV1 inst = new PzDialogPOPDV1(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogPOPDV1(JFrame frame) {
        super(frame);
        this.initGUI();
        this.loadProperties();
    }

    public void initGUI() {
        try {
            this.pnlHeader = new PzPanelHeader();
            this.pnlHeader.setTitle("POPUNJAVANJE OBRASCA POPDV");
            this.getContentPane().add((Component)this.pnlHeader, "North");
            this.pnlContent = new JPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlContent, "Center");
            pnlContentLayout.rowWeights = new double[]{0.1, 0.0};
            pnlContentLayout.rowHeights = new int[]{7, 7};
            pnlContentLayout.columnWeights = new double[]{0.1, 0.1};
            pnlContentLayout.columnWidths = new int[]{20, 7};
            this.pnlContent.setLayout(pnlContentLayout);
            this.pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.pnlButtons = new JPanel();
            FlowLayout pnlButtonsLayout = new FlowLayout();
            pnlButtonsLayout.setAlignment(2);
            this.pnlButtons.setLayout(pnlButtonsLayout);
            this.pnlContent.add((Component)this.pnlButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPopuni = new PzButton("Popuni");
            this.btnPopuni.addActionListener(this.createPopuniActionListener());
            this.pnlButtons.add((Component)this.btnPopuni);
            this.btnPopuni.setPreferredSize(new Dimension(95, 35));
            this.btnStampaj = new PzButton("Stampaj");
            this.btnStampaj.addActionListener(this.createStampaActionListener());
            this.pnlButtons.add((Component)this.btnStampaj);
            this.btnStampaj.setPreferredSize(new Dimension(95, 35));
            this.pnlDatumi = new PzPanel();
            FlowLayout pnlDatumiLayout = new FlowLayout();
            pnlDatumiLayout.setHgap(10);
            pnlDatumiLayout.setVgap(10);
            this.pnlDatumi.setLayout((LayoutManager)pnlDatumiLayout);
            this.pnlContent.add((Component)this.pnlDatumi, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblDatPoc = new JLabel("Od datuma: ");
            this.pnlDatumi.add((Component)this.lblDatPoc);
            this.datPoc = new PzDateField();
            this.pnlDatumi.add((Component)this.datPoc);
            this.datPoc.setPreferredSize(new Dimension(92, 26));
            this.lblDatKraj = new JLabel("Do datuma: ");
            this.pnlDatumi.add((Component)this.lblDatKraj);
            this.datKraj = new PzDateField();
            this.pnlDatumi.add((Component)this.datKraj);
            this.datKraj.setPreferredSize(new Dimension(97, 26));
            this.scp = new JScrollPane();
            this.scp.setPreferredSize(new Dimension(1024, 768));
            this.pnlContent.add((Component)this.scp, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setSize(814, 614);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ActionListener createStampaActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PzDialogPOPDV1.this.grupe == null) {
                    return;
                }
                POPDVReportManager.createAndShowReport(PzDialogPOPDV1.this.grupe, PzDialogPOPDV1.this, PzDialogPOPDV1.this.datPoc.getVal(), PzDialogPOPDV1.this.datKraj.getVal());
            }
        };
    }

    private ActionListener createPopuniActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SwingWorker<List<Grupa>, Object> sw = new SwingWorker<List<Grupa>, Object>(){

                    @Override
                    protected List<Grupa> doInBackground() throws Exception {
                        POPDVDataLoader builder = new POPDVDataLoader();
                        return builder.loadData(PzDialogPOPDV1.this.datPoc.getVal(), PzDialogPOPDV1.this.datKraj.getVal());
                    }

                    @Override
                    protected void done() {
                        try {
                            try {
                                (this).PzDialogPOPDV1.this.grupe = (List)this.get();
                                JPanel pnlGrupe = new JPanel();
                                BoxLayout pnlGrupeLayout = new BoxLayout(pnlGrupe, 1);
                                pnlGrupe.setLayout(pnlGrupeLayout);
                                pnlGrupe.removeAll();
                                for (Grupa grupa : (this).PzDialogPOPDV1.this.grupe) {
                                    pnlGrupe.add((Component)PzDialogPOPDV1.this.createGrupaPanel(grupa));
                                }
                                PzDialogPOPDV1.this.scp.setViewportView(pnlGrupe);
                                PzDialogPOPDV1.this.scp.doLayout();
                            }
                            catch (Exception e) {
                                PzMysqlExceptionHandler.handle((Throwable)e);
                                PzWorkerDialog.hideStatus();
                            }
                        }
                        finally {
                            PzWorkerDialog.hideStatus();
                        }
                    }
                };
                PzWorkerDialog.showStatus((String)"Prikupljanje podataka u toku, molim sacekajte", (PzDialog)PzDialogPOPDV1.this);
                sw.execute();
            }
        };
    }

    private JXTitledPanel createGrupaPanel(Grupa grupa) {
        JXTitledPanel pnlGrupaTitled = new JXTitledPanel();
        if (grupa.getNadgrupa() != null) {
            pnlGrupaTitled.setTitle(String.valueOf(grupa.getNadgrupa().getId()) + "." + grupa.getId() + ". " + this.getProperty(String.valueOf(grupa.getNadgrupa().getId()) + "." + grupa.getId()));
        } else {
            pnlGrupaTitled.setTitle(String.valueOf(grupa.getId()) + ". " + this.getProperty(grupa.getId()));
        }
        pnlGrupaTitled.setTitleFont(new Font("SansSerif", 1, 12));
        if (grupa.getPodgrupe().size() > 0) {
            JPanel pnlPodGrupe = new JPanel();
            BoxLayout pnlPodGrupeLayout = new BoxLayout(pnlPodGrupe, 1);
            pnlPodGrupe.setLayout(pnlPodGrupeLayout);
            for (Grupa podgrupa : grupa.getPodgrupe()) {
                pnlPodGrupe.add((Component)this.createGrupaPanel(podgrupa));
            }
            pnlGrupaTitled.setContentContainer((Container)pnlPodGrupe);
        } else {
            JPanel pnlGrupa = new JPanel();
            pnlGrupa.setLayout(new BoxLayout(pnlGrupa, 1));
            pnlGrupaTitled.setContentContainer((Container)pnlGrupa);
            if (grupa.getVrednost() != null) {
                JPanel pnlIznos = new JPanel();
                pnlIznos.setLayout(new BoxLayout(pnlIznos, 0));
                pnlIznos.add(new Label("Iznos:                                     "));
                pnlIznos.add(grupa.getVrednost().getPolje());
                pnlIznos.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                pnlGrupa.add(pnlIznos);
            }
            for (Red red : grupa.getRedovi()) {
                String redIdFull = grupa.getNadgrupa() == null ? String.valueOf(grupa.getId()) + "." + red.getId() : String.valueOf(grupa.getNadgrupa().getId()) + "." + grupa.getId() + "." + red.getId();
                pnlGrupa.add(this.createRedPanel(redIdFull, red.getVrednosti(), red.isSumarni()));
            }
        }
        return pnlGrupaTitled;
    }

    private JPanel createRedPanel(String redIdFull, List<Vrednost> vrednosti, boolean sumarni) {
        Font font = new Font("SansSerif", sumarni ? 1 : 0, 12);
        JPanel pnlRed = new JPanel();
        pnlRed.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        GridBagLayout pnlRedLayout = new GridBagLayout();
        pnlRedLayout.rowWeights = new double[]{0.1};
        pnlRedLayout.rowHeights = new int[]{7};
        pnlRedLayout.columnWeights = new double[]{0.0, 0.1, 0.0};
        pnlRedLayout.columnWidths = new int[]{7, 7, 7};
        pnlRed.setLayout(pnlRedLayout);
        pnlRed.setBorder(BorderFactory.createBevelBorder(1));
        JLabel lblRbr = new JLabel(" " + redIdFull + " ");
        lblRbr.setFont(font);
        pnlRed.add((Component)lblRbr, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JXLabel lblOpis = new JXLabel(this.getProperty(redIdFull));
        lblOpis.setLineWrap(true);
        lblOpis.setPreferredSize(new Dimension(350, 40));
        lblOpis.setFont(font);
        pnlRed.add((Component)lblOpis, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel pnlVred = new JPanel();
        pnlVred.setLayout(new FlowLayout());
        for (Vrednost vrednost : vrednosti) {
            vrednost.getPolje().setPreferredSize(new Dimension(100, 30));
            if (redIdFull.endsWith(".1")) {
                JPanel pnlVrednostHead = new JPanel();
                pnlVrednostHead.setLayout(new BoxLayout(pnlVrednostHead, 1));
                JLabel lblHeader = new JLabel(this.getHeaderProperty("h" + redIdFull.substring(0, redIdFull.lastIndexOf(46)) + "." + vrednost.getId()));
                lblHeader.setFont(new Font("SansSerif", 1, 10));
                lblHeader.setPreferredSize(new Dimension(20, 15));
                pnlVrednostHead.add(lblHeader);
                pnlVrednostHead.add(vrednost.getPolje());
                pnlVred.add(pnlVrednostHead);
                continue;
            }
            pnlVred.add(vrednost.getPolje());
        }
        pnlRed.add((Component)pnlVred, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return pnlRed;
    }

    private void loadProperties() {
        this.prop = new Properties();
        try {
            InputStream is = PzDialogPOPDV1.class.getClassLoader().getResourceAsStream("rs/pezar/analitike/gui/porez/popdv/resources/popdv.properties");
            this.prop.load(is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getProperty(String name) {
        String id = name.startsWith("8") ? name.replaceFirst("\\.", "") : name;
        if (this.prop.get(id) != null) {
            return (String)this.prop.get(id);
        }
        return "Opis";
    }

    private String getHeaderProperty(String name) {
        String id = name.startsWith("h8") ? name.replaceFirst("\\.", "") : name;
        if (this.prop.get(id) != null) {
            return (String)this.prop.get(id);
        }
        return "";
    }

    public void actionPerformed(ActionEvent e) {
    }
}

