/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez.popdv;

import java.io.InputStream;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import rs.pezar.analitike.gui.porez.popdv.form.Grupa;
import rs.pezar.analitike.gui.porez.popdv.form.Red;
import rs.pezar.analitike.gui.porez.popdv.form.Vrednost;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Firma;
import rs.pezar.reports.PzReportViewer;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.util.PzDateUtility;
import rs.pezar.util.PzFileUtility;

public class POPDVReportManager {
    public static void createAndShowReport(List<Grupa> grupe, PzDialog parent, Date datPoc, Date datKraj) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Firma f = PzFirma.getFirma();
            params.put("naziv", f.getNaziv());
            params.put("pib", f.getPib());
            params.put("datum_od", new SimpleDateFormat("dd.MM.").format(datPoc));
            params.put("datum_do", new SimpleDateFormat("dd.MM.").format(datKraj));
            params.put("godina", PzDateUtility.getCurrentYear());
            for (Grupa grupa : grupe) {
                POPDVReportManager.addParams(grupa, params);
            }
            JasperPrint jp = POPDVReportManager.createJasperPrint("rs/pezar/analitike/resource/reports/compiled/popdv.jasper,rs/pezar/analitike/resource/reports/compiled/ppppdv.jasper ", "Obrazac POPDV", params);
            PzReportViewer.viewReport((PzDialog)parent, (JasperPrint)jp, (String)"POPDV");
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
    }

    private static void addParams(Grupa grupa, Map<String, Object> params) {
        StringBuilder paramId = new StringBuilder();
        if (grupa.getNadgrupa() != null) {
            paramId.append(grupa.getNadgrupa().getId());
        }
        paramId.append(grupa.getId());
        if (grupa.getVrednost() != null) {
            params.put(paramId.toString(), grupa.getVrednost().getIznosAsInt());
        }
        if (grupa.getPodgrupe().size() > 0) {
            for (Grupa podgrupa : grupa.getPodgrupe()) {
                POPDVReportManager.addParams(podgrupa, params);
            }
        }
        for (Red red : grupa.getRedovi()) {
            if (red.getVrednosti().size() > 1) {
                for (Vrednost vrednost : red.getVrednosti()) {
                    params.put(String.valueOf(paramId.toString()) + red.getId() + vrednost.getId(), vrednost.getIznosAsInt());
                }
                continue;
            }
            params.put(String.valueOf(paramId.toString()) + red.getId(), red.getVrednosti().get(0).getIznosAsInt());
        }
    }

    public static JasperPrint createJasperPrint(String compiledFile, String title, Map<String, Object> params) throws Exception {
        HashMap<String, Object> params1 = new HashMap<String, Object>();
        if (params != null) {
            params1.putAll(params);
        }
        String[] paths = compiledFile.split(",");
        JasperReport[] jrArray = new JasperReport[paths.length];
        int j = 0;
        while (j < paths.length) {
            JasperReport jr;
            InputStream is = PzFileUtility.getReportFileAsInputStream((String)paths[j].trim(), (ClassLoader)POPDVReportManager.class.getClassLoader());
            jrArray[j] = jr = (JasperReport)JRLoader.loadObject((InputStream)is);
            is.close();
            ++j;
        }
        JasperReport firstReport = jrArray[0];
        JasperPrint jp = JasperFillManager.fillReport((JasperReport)firstReport, params1, (JRDataSource)new JREmptyDataSource());
        JasperReport secondReport = jrArray[1];
        JasperPrint jp1 = JasperFillManager.fillReport((JasperReport)secondReport, params1, (JRDataSource)new JREmptyDataSource());
        List pages = jp1.getPages();
        for (JRPrintPage page : pages) {
            jp.addPage(page);
        }
        return jp;
    }
}

