/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.analitike.gui.porez.popdv;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.persistence.queries.ScrollableCursor;
import rs.pezar.analitike.gui.porez.core.Porez;
import rs.pezar.analitike.gui.porez.popdv.form.Grupa;
import rs.pezar.analitike.gui.porez.popdv.form.Red;
import rs.pezar.analitike.gui.porez.popdv.form.SumarnaGrupa;
import rs.pezar.analitike.gui.porez.popdv.form.Vrednost;
import rs.pezar.analitike.gui.porez.popdv.proc.SumAvansDat;
import rs.pezar.analitike.gui.porez.popdv.proc.SumAvansPrimljen;
import rs.pezar.analitike.gui.porez.popdv.proc.SumIzlazOslobodjenoBezPrava;
import rs.pezar.analitike.gui.porez.popdv.proc.SumIzlazOslobodjenoSaPravom;
import rs.pezar.analitike.gui.porez.popdv.proc.SumIzlazSaPorezom;
import rs.pezar.analitike.gui.porez.popdv.proc.SumUlazPoljoprivrednici;
import rs.pezar.analitike.gui.porez.popdv.proc.SummationGroup;
import rs.pezar.analitike.gui.porez.popdv.proc.SummationGroupUlaz;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.globals.TipDokumentConfig;

public class POPDVDataLoader {
    private SummationGroup izlazOslSaPravom = new SumIzlazOslobodjenoSaPravom();
    private SummationGroup izlazOslSaPravomKosovo = new SumIzlazOslobodjenoSaPravom.Kosovo();
    private SummationGroup izlazOslSaPravomInostranstvo = new SumIzlazOslobodjenoSaPravom.Inostranstvo();
    private SummationGroup izlazOslSaPravomOstalo = new SumIzlazOslobodjenoSaPravom.Ostalo();
    private SummationGroup izlazOslBezPrava = new SumIzlazOslobodjenoBezPrava();
    private SummationGroup izlazSaPorezom = new SumIzlazSaPorezom();
    private SummationGroup izlazGradjevina = new SumIzlazSaPorezom.SumIzlazGradjevina();
    private SummationGroup izlazSaPorezomZaduzenje = new SumIzlazSaPorezom.SumIzlazSaPdvZaduzenje();
    private SummationGroup izlazSaPorezomOdobrenje = new SumIzlazSaPorezom.SumIzlazSaPdvOdobrenje();
    private SummationGroup primljenAvansOslSaPravom = new SumAvansPrimljen.OslobodjenoSaPravom();
    private SummationGroup primljenAvansOslBezPrava = new SumAvansPrimljen.OslobodjenoBezPrava();
    private SummationGroup primljenAvansSaPorezom = new SumAvansPrimljen.SaPorezom();
    private SummationGroup uvoz = new SummationGroupUlaz.SumUvoz();
    private SummationGroup ulazPoljoprovrednici = new SumUlazPoljoprivrednici();
    private SummationGroup ulazDomaciSaPdv = new SummationGroupUlaz.DomaciSaPdv();
    private SummationGroup ulazDomaciZaduzenjeSaPdv = new SummationGroupUlaz.DomaciZaduzenjeSaPdv();
    private SummationGroup ulazDomaciOdobrenjeSaPdv = new SummationGroupUlaz.DomaciOdobrenjeSaPdv();
    private SummationGroup ulazDomaciBezPrava = new SummationGroupUlaz.DomaciBezPrava();
    private SummationGroup ulazDomaciOslobodjeno = new SummationGroupUlaz.DomaciOslobodjeno();
    private SummationGroup ulazDomaciZaduzenjeOslobodjeno = new SummationGroupUlaz.DomaciZaduzenjeOslobodjeno();
    private SummationGroup ulazDomaciOdobrenjeOslobodjeno = new SummationGroupUlaz.DomaciOdobrenjeOslobodjeno();
    private SummationGroup ulazDomaciInterni = new SummationGroupUlaz.DomaciInterniObracun();
    private SummationGroup ulazDomaciZaduzenjeInterni = new SummationGroupUlaz.DomaciInterniZaduzenje();
    private SummationGroup ulazDomaciOdobrenjeInterni = new SummationGroupUlaz.DomaciInterniOdobrenje();
    private SummationGroup ulazIno = new SummationGroupUlaz.Ino();
    private SummationGroup ulazInoZaduzenje = new SummationGroupUlaz.InoZaduzenje();
    private SummationGroup ulazInoOdobrenje = new SummationGroupUlaz.InoOdobrenje();
    private SummationGroup ulazNijeObveznik = new SummationGroupUlaz.DomaciNijeObveznik();
    private SummationGroup ulazS1 = new SummationGroupUlaz.S1();
    private SummationGroup datAvansUkupno = new SumAvansDat();
    private SummationGroup datAvansBezPrava = new SumAvansDat.DatAvansBezPrava();
    private SummationGroup datAvansOslobodjeno = new SumAvansDat.DatAvansOslobodjeno();
    private List<? extends SummationGroup> grupaIzlaz = Arrays.asList(this.izlazOslSaPravom, this.izlazOslSaPravomKosovo, this.izlazOslSaPravomInostranstvo, this.izlazOslSaPravomOstalo, this.izlazOslBezPrava, this.izlazSaPorezom, this.izlazGradjevina, this.izlazSaPorezomZaduzenje, this.izlazSaPorezomOdobrenje);
    private List<? extends SummationGroup> grupaPrimljenAvans = Arrays.asList(this.primljenAvansOslSaPravom, this.primljenAvansOslBezPrava, this.primljenAvansSaPorezom);
    private List<? extends SummationGroup> grupaUlaz = Arrays.asList(this.ulazPoljoprovrednici, this.ulazDomaciSaPdv, this.ulazDomaciZaduzenjeSaPdv, this.ulazDomaciOdobrenjeSaPdv, this.ulazDomaciBezPrava, this.ulazDomaciOslobodjeno, this.ulazDomaciZaduzenjeOslobodjeno, this.ulazDomaciOdobrenjeOslobodjeno, this.ulazIno, this.ulazInoZaduzenje, this.ulazInoOdobrenje, this.ulazNijeObveznik, this.ulazDomaciInterni, this.ulazDomaciZaduzenjeInterni, this.ulazDomaciOdobrenjeInterni);
    private List<? extends SummationGroup> grupaDatAvans = Arrays.asList(this.datAvansUkupno, this.datAvansBezPrava, this.datAvansOslobodjeno);

    public List<Grupa> loadData(Date datPoc, Date datKraj) {
        this.popuniGrupe(datPoc, datKraj);
        Grupa g1 = new Grupa("1", 7, 1);
        g1.setRed(1, this.izlazOslSaPravomInostranstvo.getOslSP());
        g1.setRed(2, this.izlazOslSaPravomKosovo.getOslSP());
        g1.setRed(4, this.izlazOslSaPravomOstalo.getOslSP());
        g1.setSumarniRed(5, g1.getRed(1), g1.getRed(2), g1.getRed(3), g1.getRed(4));
        g1.setRed(7, this.primljenAvansOslSaPravom.getOslSP());
        Grupa g2 = new Grupa("2", 7, 1);
        g2.setRed(4, this.izlazOslBezPrava.getOslBP());
        g2.setSumarniRed(5, g2.getRed(1), g2.getRed(2), g2.getRed(3), g2.getRed(4));
        g2.setRed(7, this.primljenAvansOslBezPrava.getOslBP());
        Grupa g3 = new Grupa("3", 10, 4);
        g3.setRed(2, this.izlazSaPorezom.getOsnHi(), this.izlazSaPorezom.gettHi(), this.izlazSaPorezom.getOsnLo(), this.izlazSaPorezom.gettLo());
        g3.setRed(5, this.izlazSaPorezomZaduzenje.getOsnHi(), this.izlazSaPorezomZaduzenje.gettHi(), this.izlazSaPorezomZaduzenje.getOsnLo(), this.izlazSaPorezomZaduzenje.gettLo());
        g3.setRed(6, this.izlazSaPorezomOdobrenje.getOsnHi(), this.izlazSaPorezomOdobrenje.gettHi(), this.izlazSaPorezomOdobrenje.getOsnLo(), this.izlazSaPorezomOdobrenje.gettLo());
        g3.setSumarniRed(8, g3.getRed(1), g3.getRed(2), g3.getRed(3), g3.getRed(4), g3.getRed(5), g3.getRed(6), g3.getRed(7));
        g3.setRed(9, this.primljenAvansSaPorezom.getOsnHi(), this.primljenAvansSaPorezom.gettHi(), this.primljenAvansSaPorezom.getOsnLo(), this.primljenAvansSaPorezom.gettLo());
        g3.setSumarniRed(10, g3.getRed(8).kol(2, 4), g3.getRed(9).kol(2, 4));
        Grupa g3a = new Grupa("3a", 9, 2);
        g3a.setRed(3, this.ulazDomaciInterni.gettHi(), this.ulazDomaciInterni.gettLo());
        g3a.setRed(4, this.ulazDomaciZaduzenjeInterni.gettHi(), this.ulazDomaciZaduzenjeInterni.gettLo());
        g3a.setRed(5, this.ulazDomaciOdobrenjeInterni.gettHi(), this.ulazDomaciOdobrenjeInterni.gettLo());
        g3a.setSumarniRed(7, g3a.getRed(1), g3a.getRed(2), g3a.getRed(3), g3a.getRed(4), g3a.getRed(5), g3a.getRed(6));
        g3a.setSumarniRed(9, g3a.getRed(7), g3a.getRed(8));
        Grupa g4 = new Grupa("4", 0, 0);
        Grupa g41 = new Grupa("1", 4, 2);
        g41.setSumarniRed(3, g41.getRed(1), g41.getRed(2).negate());
        Grupa g42 = new Grupa("2", 4, 4);
        g42.setSumarniRed(3, g42.getRed(1), g42.getRed(2).negate());
        g4.addPodgrupa(g41);
        g4.addPodgrupa(g42);
        Grupa g5 = new Grupa("5", 7, 1);
        g5.setSumarniRed(1, g3.getRed(8).kol(1), g41.getRed(1).kol(1), g42.getRed(1).kol(1));
        g5.setSumarniRed(2, g3.getRed(10).kol(2), g3a.getRed(9).kol(1), g41.getRed(4).kol(2), g42.getRed(4).kol(3));
        Red g5r2 = g5.getRed(2);
        g5.setRed(2, g5r2.zeroIfNeg());
        g5.setSumarniRed(4, g3.getRed(8).kol(3), g42.getRed(1).kol(3));
        g5.setSumarniRed(5, g3.getRed(10).kol(4), g3a.getRed(9).kol(2), g42.getRed(4).kol(4));
        Red g5r5 = g5.getRed(5);
        g5.setRed(5, g5r5.zeroIfNeg());
        g5.setSumarniRed(6, g1.getRed(5), g2.getRed(5), g5.getRed(1), g5.getRed(4));
        g5.setSumarniRed(7, g5.getRed(3), g5.getRed(5));
        Grupa g6 = new Grupa("6", 0, 0);
        Grupa g61 = new Grupa("1", this.uvoz.getOslSP());
        Grupa g62 = new Grupa("2", 3, 2);
        g62.setRed(1, this.uvoz.getOsnHi(), this.uvoz.getOsnLo());
        SumarnaGrupa g63 = new SumarnaGrupa("3").zaRedove(g62.getRed(1), g62.getRed(2), g62.getRed(3)).zaVrednosti(g61.getVrednost());
        Grupa g64 = new Grupa("4", this.uvoz.gettHi().add(this.uvoz.gettLo()));
        g6.addPodgrupa(g61);
        g6.addPodgrupa(g62);
        g6.addPodgrupa(g63);
        g6.addPodgrupa(g64);
        Grupa g7 = new Grupa("7", 4, 2);
        g7.setRed(1, this.ulazPoljoprovrednici.getOsnHi(), this.ulazPoljoprovrednici.gettHi());
        Grupa g8 = new Grupa("8", 0, 0);
        Grupa g8a = new Grupa("a", 8, 4);
        g8.addPodgrupa(g8a);
        g8a.setRed(2, this.ulazDomaciSaPdv.getOsnHi(), this.ulazDomaciSaPdv.gettHi(), this.ulazDomaciSaPdv.getOsnLo(), this.ulazDomaciSaPdv.gettLo());
        g8a.setRed(4, this.ulazDomaciZaduzenjeSaPdv.getOsnHi(), this.ulazDomaciZaduzenjeSaPdv.gettHi(), this.ulazDomaciZaduzenjeSaPdv.getOsnLo(), this.ulazDomaciZaduzenjeSaPdv.gettLo());
        g8a.setRed(5, this.ulazDomaciOdobrenjeSaPdv.getOsnHi(), this.ulazDomaciOdobrenjeSaPdv.gettHi(), this.ulazDomaciOdobrenjeSaPdv.getOsnLo(), this.ulazDomaciOdobrenjeSaPdv.gettLo());
        g8a.setSumarniRed(6, g8a.getRed(1).kol(1, 3), g8a.getRed(2).kol(1, 3), g8a.getRed(3).kol(1, 3), g8a.getRed(4).kol(1, 3), g8a.getRed(5).kol(1, 3));
        g8a.setRed(7, this.datAvansUkupno.getOsnHi(), this.datAvansUkupno.gettHi(), this.datAvansUkupno.getOsnLo(), this.datAvansUkupno.gettLo());
        g8a.setSumarniRed(8, g8a.getRed(1).kol(2, 4), g8a.getRed(2).kol(2, 4), g8a.getRed(3).kol(2, 4), g8a.getRed(4).kol(2, 4), g8a.getRed(5).kol(2, 4), g8a.getRed(7).kol(2, 4));
        Grupa g8b = new Grupa("b", 7, 2);
        g8.addPodgrupa(g8b);
        g8b.setRed(2, this.ulazS1.getOsnHi(), BigDecimal.ZERO);
        g8b.setRed(2, this.ulazDomaciInterni.getOsnHi(), this.ulazDomaciInterni.getOsnLo());
        g8b.setRed(4, this.ulazDomaciZaduzenjeInterni.getOsnHi(), this.ulazDomaciZaduzenjeInterni.getOsnLo());
        g8b.setRed(5, this.ulazDomaciOdobrenjeInterni.getOsnHi(), this.ulazDomaciOdobrenjeInterni.getOsnLo());
        g8b.setSumarniRed(6, g8b.getRed(1), g8b.getRed(2), g8b.getRed(3), g8b.getRed(4), g8b.getRed(5));
        Grupa g8v = new Grupa("v", 4, 1);
        g8.addPodgrupa(g8v);
        g8v.setRed(2, this.ulazDomaciOslobodjeno.getOslSP().add(this.ulazDomaciZaduzenjeOslobodjeno.getOslSP()).add(this.ulazDomaciOdobrenjeOslobodjeno.getOslSP()));
        g8v.setSumarniRed(4, g8v.getRed(1), g8v.getRed(2), g8v.getRed(3));
        Grupa g8g = new Grupa("g", 6, 2);
        g8.addPodgrupa(g8g);
        g8g.setSumarniRed(5, g8g.getRed(1), g8g.getRed(2), g8g.getRed(3), g8g.getRed(4));
        Grupa g8d = new Grupa("d", 3, 1);
        g8.addPodgrupa(g8d);
        g8d.setRed(2, this.ulazNijeObveznik.getOslSP());
        g8d.setRed(3, this.ulazInoZaduzenje.getOsnHi().add(this.ulazInoZaduzenje.getOsnLo()).add(this.ulazInoOdobrenje.getOsnHi()).add(this.ulazInoOdobrenje.getOsnLo()));
        SumarnaGrupa g8dj = new SumarnaGrupa("dj").zaRedove(g8a.getRed(6).kol(1, 3), g8b.getRed(6), g8v.getRed(4), g8g.getRed(5), g8d.getRed(1), g8d.getRed(2), g8d.getRed(3));
        g8.addPodgrupa(g8dj);
        Grupa g8e = new Grupa("e", 6, 1);
        g8.addPodgrupa(g8e);
        Red redUlazBezPrava = new Red(0, this.ulazDomaciBezPrava.gettHi().add(this.ulazDomaciBezPrava.gettLo()).add(this.datAvansBezPrava.gettHi().add(this.datAvansBezPrava.gettLo())).negate());
        g8e.setSumarniRed(1, g8a.getRed(8).kol(2, 4), redUlazBezPrava);
        g8e.setSumarniRed(5, g8e.getRed(1), g8e.getRed(2), g8e.getRed(3), g8e.getRed(4));
        g8e.setSumarniRed(6, g8e.getRed(5), g5r2.absIfNeg(), g5r5.absIfNeg());
        g5.setSumarniRed(3, g5.getRed(2), g8e.getRed(6).absIfNeg());
        SumarnaGrupa g9 = new SumarnaGrupa("9").zaRedove(g7.getRed(1)).zaVrednosti(g63.getVrednost(), g8dj.getVrednost());
        Grupa g9a = new Grupa("9a", 4, 1);
        g9a.setRed(1, g64.getVrednost().getIznos());
        g9a.setSumarniRed(2, g7.getRed(3));
        g9a.setSumarniRed(3, g8e.getRed(5));
        g9a.setSumarniRed(4, g9a.getRed(1), g9a.getRed(2), g9a.getRed(3));
        SumarnaGrupa g10 = new SumarnaGrupa("10").zaRedove(g5.getRed(7), g9a.getRed(4).negate());
        Grupa g11 = new Grupa("11", 3, 1);
        Grupa pppdv = new Grupa("PPPPDV");
        Vrednost v001 = new Vrednost("001", g1.getRed(5).getVrednost("1"));
        Red pppdv1 = new Red("1", v001);
        pppdv.addRed(pppdv1);
        Vrednost v002 = new Vrednost("002", g2.getRed(5).getVrednost("1"));
        Red pppdv2 = new Red("2", v002);
        pppdv.addRed(pppdv2);
        Vrednost v003 = new Vrednost("003", g5.getRed(1).getVrednost("1"));
        Vrednost v103 = new Vrednost("103", g5.getRed(3).getVrednost("1"));
        Red pppdv3 = new Red("3", v003, v103);
        pppdv.addRed(pppdv3);
        Vrednost v004 = new Vrednost("004", g5.getRed(4).getVrednost("1"));
        Vrednost v104 = new Vrednost("104", g5.getRed(5).getVrednost("1"));
        Red pppdv4 = new Red("4", v004, v104);
        pppdv.addRed(pppdv4);
        Vrednost v005 = new Vrednost("005", g5.getRed(6).getVrednost("1"));
        Vrednost v105 = new Vrednost("105", g5.getRed(7).getVrednost("1"));
        Red pppdv5 = new Red("5", v005, v105);
        pppdv.addRed(pppdv5);
        Vrednost v006 = new Vrednost("006", g63.getVrednost());
        Vrednost v106 = new Vrednost("106", g9a.getRed(1).getVrednost("1"));
        Red pppdv6 = new Red("6", v006, v106);
        pppdv.addRed(pppdv6);
        Vrednost v007 = new Vrednost("007", g7.getRed(1).getVrednost("1"));
        Vrednost v107 = new Vrednost("107", g9a.getRed(2).getVrednost("1"));
        Red pppdv7 = new Red("7", v007, v107);
        pppdv.addRed(pppdv7);
        Vrednost v008 = new Vrednost("008", g8dj.getVrednost());
        Vrednost v108 = new Vrednost("108", g9a.getRed(3).getVrednost("1"));
        Red pppdv8 = new Red("8", v008, v108);
        pppdv.addRed(pppdv8);
        Vrednost v009 = new Vrednost("009", g9.getVrednost());
        Vrednost v109 = new Vrednost("109", g9a.getRed(4).getVrednost("1"));
        Red pppdv9 = new Red("9", v009, v109);
        pppdv.addRed(pppdv9);
        Vrednost v110 = new Vrednost("110", g10.getVrednost());
        Red pppdv10 = new Red("10", v110);
        pppdv.addRed(pppdv10);
        return Arrays.asList(g1, g2, g3, g3a, g4, g5, g6, g7, g8, g9, g9a, g10, g11, pppdv);
    }

    private void popuniGrupe(Date datPoc, Date datKraj) {
        Object[] dok;
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        ScrollableCursor sc = this.createCursor(em, this.getIzlazQuery(datPoc, datKraj));
        int rowIndex = 0;
        while (rowIndex < sc.size()) {
            if (sc.absolute(rowIndex)) {
                dok = (Object[])sc.next();
                for (SummationGroup summationGroup : this.grupaIzlaz) {
                    if (!summationGroup.accept(dok)) continue;
                    summationGroup.process(dok);
                }
            }
            ++rowIndex;
        }
        if (sc != null) {
            sc.close();
        }
        sc = this.createCursor(em, this.getPrimljeniAvansQuery(datPoc, datKraj));
        rowIndex = 0;
        while (rowIndex < sc.size()) {
            if (sc.absolute(rowIndex)) {
                dok = (Object[])sc.next();
                for (SummationGroup summationGroup : this.grupaPrimljenAvans) {
                    if (!summationGroup.accept(dok)) continue;
                    summationGroup.process(dok);
                }
            }
            ++rowIndex;
        }
        if (sc != null) {
            sc.close();
        }
        sc = this.createCursor(em, this.getUvozQuery(datPoc, datKraj));
        rowIndex = 0;
        while (rowIndex < sc.size()) {
            if (sc.absolute(rowIndex)) {
                dok = (Object[])sc.next();
                this.uvoz.process(dok);
            }
            ++rowIndex;
        }
        if (sc != null) {
            sc.close();
        }
        sc = this.createCursor(em, this.getUlazQuery(datPoc, datKraj));
        rowIndex = 0;
        while (rowIndex < sc.size()) {
            if (sc.absolute(rowIndex)) {
                dok = (Object[])sc.next();
                for (SummationGroup summationGroup : this.grupaUlaz) {
                    if (!summationGroup.accept(dok)) continue;
                    summationGroup.process(dok);
                }
            }
            ++rowIndex;
        }
        if (sc != null) {
            sc.close();
        }
        sc = this.createCursor(em, this.getDatAvansQuery(datPoc, datKraj));
        rowIndex = 0;
        while (rowIndex < sc.size()) {
            if (sc.absolute(rowIndex)) {
                dok = (Object[])sc.next();
                for (SummationGroup summationGroup : this.grupaDatAvans) {
                    if (!summationGroup.accept(dok)) continue;
                    summationGroup.process(dok);
                }
            }
            ++rowIndex;
        }
        if (sc != null) {
            sc.close();
        }
        if (em != null) {
            em.close();
        }
    }

    public ScrollableCursor createCursor(EntityManager em, String query) {
        Query q = em.createNativeQuery(query);
        q.setHint("eclipselink.cursor.scrollable", (Object)"True");
        ScrollableCursor sc = (ScrollableCursor)q.getSingleResult();
        return sc;
    }

    private String getIzlazQuery(Date datPoc, Date datKraj) {
        String dokumenta = "'" + TipDokumentConfig.get().FAKTURA + "'," + "'" + TipDokumentConfig.get().FAKTURA_INTERNI_RACUN + "'," + "'" + TipDokumentConfig.get().FAKTURA_SERVISA + "'," + "'" + TipDokumentConfig.get().KNJIZNO_ODOBRENJE_KUPCA_STAVKA + "'," + "'" + TipDokumentConfig.get().KNJIZNO_ZADUZENJE_KUPCA_STAVKA + "'," + "'" + TipDokumentConfig.get().FAKTURA_USLUGA + "'";
        String que = Porez.queueIzdateFakture.replace("{dokumenta}", dokumenta);
        que = que.replace("{komitent}", " ");
        que = que.replace("{pocetnidatum}", datPoc.toString());
        que = que.replace("{krajnjidatum}", datKraj.toString());
        que = que.replace("{radnajedinica}", " ");
        que = que.replace("{sort}", " ");
        return que;
    }

    private String getPrimljeniAvansQuery(Date datPoc, Date datKraj) {
        String pdv = "";
        String que = null;
        int i = 0;
        while (i < Porez.primljeniAvansi.length) {
            if (Porez.primljeniAvansi[i] != null) {
                pdv = String.valueOf(pdv) + "'" + Porez.primljeniAvansi[i] + "',";
            }
            ++i;
        }
        pdv = pdv.substring(0, pdv.length() - 1);
        que = String.format("SELECT a.ozndokumenta, a.tip, a.podtip, a.datprometa, a.sfrkomitent, a.storno, od.iznossaporezom, od.iznosbezporeza,(select sum(p.osnovica) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T1' OR p.ozntargr = 'T11'  or p.ozntargr = 'U1')), (select sum(p.osnovica) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T2' or p.ozntargr = 'U2')), (select sum(p.iznos) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T1' OR p.ozntargr = 'T11'  or p.ozntargr = 'U1')), (select sum(p.iznos) from dtaksa p where p.iddok = a.iddok and (p.ozntargr = 'T2' or p.ozntargr = 'U2')), k.naziv, k.grad, k.pib, k.srbija, k.zemljakomitenta, k.domacikomitent, od.str3, a.oznrj, a.oznOgranak,(select sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND p.ozntargr = 'S1')  FROM dokument a, opstidokument od, komitent k WHERE a.iddok = od.iddok AND a.sfrkomitent = k.sfrkomitent AND a.tip in (%s) AND (NOT a.podtip = 'POCETNO' OR a.podtip IS NULL) AND a.arhiviran = 1 %s AND a.datprometa >= '%s' AND a.datprometa <= '%s' ORDER BY k.domacikomitent", pdv, "", datPoc.toString(), datKraj.toString());
        return que;
    }

    private String getUlazQuery(Date datPoc, Date datKraj) {
        String dokumenta = "'" + TipDokumentConfig.get().KALKULACIJA + "'," + "'" + TipDokumentConfig.get().ZAPISNIK_OTPREMNICE + "'," + "'" + TipDokumentConfig.get().KNJIZNO_ODOBRENJE_DOBAVLJACA + "'," + "'" + TipDokumentConfig.get().KNJIZNO_ZADUZENJE_DOBAVLJACA + "'," + "'" + TipDokumentConfig.get().RACUN_DOBAVLJACA + "'," + "'" + TipDokumentConfig.get().TROSAK + "'," + "'" + TipDokumentConfig.get().PRIJEMNICA_REPRO + "'";
        String podtip = "'" + TipDokumentConfig.get().OTPREMNICA + "','" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "' , 'INTERNI', 'Kupac', 'POCETNO'";
        String que = String.format("SELECT * FROM (SELECT \ta.ozndokumenta, \ta.tip, \ta.podtip, \ta.datPrometa datpor, \ta.sfrkomitent, \ta.storno, \t(SELECT ka.rbroj FROM kalkulacija ka WHERE ka.iddok = a.iddok), \t(SELECT ka.pdv FROM kalkulacija ka WHERE ka.iddok = a.iddok) as pdvkalk, \t(SELECT sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1') AND NOT p.tip = 'UK'), \t(SELECT sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2') AND NOT p.tip = 'UK'), \t(SELECT sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3') AND NOT p.tip = 'UK'), \t(SELECT sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1') AND NOT p.tip = 'UK'), \t(SELECT sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2') AND NOT p.tip = 'UK'), \t(SELECT sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3') AND NOT p.tip = 'UK'), \tk.naziv, \tk.grad, \tk.pib, \tk.srbija, \tk.zemljakomitenta, \tk.domacikomitent, \t(SELECT ka.iznos FROM kalkulacija ka WHERE ka.iddok = a.iddok), \tk.obveznikpdv, \ta.iddok AS grupa, \t(SELECT  sum(p.iznos) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1), \t(SELECT  sum(p.iznos) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1), \t(SELECT  sum(p.iznos) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1), \t(SELECT t.osnovica FROM kalkulacija t WHERE a.iddok = t.iddok), \t(SELECT t.bezprava FROM kalkulacija t WHERE a.iddok = t.iddok), \t(SELECT t.oslobodjeno FROM kalkulacija t WHERE a.iddok = t.iddok), \ta.iznos, \t(SELECT p.str1 FROM opstidokument p WHERE a.iddok = p.iddok) as pdvodob, \t(SELECT p.str2 FROM opstidokument p WHERE a.iddok = p.iddok), \tCASE \t\tWHEN a.oznrj IS NULL THEN 'nema' \t\tELSE a.oznrj \tEND AS rj, \ta.oznOgranak,\tk.tip,    (select  sum(p.osnovica) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1),    (select  sum(p.osnovica) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1),    (select  sum(p.osnovica) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3') AND NOT p.tip = 'UK' AND p.porezkoduvoza = 1),    (select  sum(p.osnovica) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'S1') AND NOT p.tip = 'UK'),\t(SELECT  sum(p.iznos) FROM taksakalkulacija p WHERE p.iddok = a.iddok AND (p.ozntargr = 'S1') AND NOT p.tip = 'UK') FROM \tdokument a, komitent k WHERE \ta.sfrkomitent = k.sfrkomitent AND \ta.tip IN (%s) AND \t(NOT a.podtip IN (%s) OR a.podtip IS NULL) AND \ta.arhiviran = 1 and not a.rbrdok = -1 \t%s AND \ta.datprometa >= '%s' \tAND a.datprometa <= '%s' \t%s ) as PDV    {where}  ORDER BY\t%s datpor ", dokumenta, podtip, " ", datPoc, datKraj, " ", " ");
        return que.replace("{where}", "");
    }

    private String getUvozQuery(Date datPoc, Date datKraj) {
        String pdv = "";
        String que = null;
        int i = 0;
        while (i < Porez.ulaznaDokumentaZaUvoz.length) {
            if (Porez.ulaznaDokumentaZaUvoz[i] != null) {
                pdv = String.valueOf(pdv) + "'" + Porez.ulaznaDokumentaZaUvoz[i] + "',";
            }
            ++i;
        }
        pdv = pdv.substring(0, pdv.length() - 1);
        String podtip = "'" + TipDokumentConfig.get().OTPREMNICA + "', 'INTERNI','Kupac','POCETNO'";
        que = String.format(Porez.queuePrimljeneFaktureUvoz, pdv, podtip, datPoc, datKraj);
        return que;
    }

    private String getDatAvansQuery(Date datPoc, Date datKraj) {
        String pdv = "";
        String que = null;
        int i = 0;
        while (i < Porez.izdatiAvansi.length) {
            if (Porez.izdatiAvansi[i] != null) {
                pdv = String.valueOf(pdv) + "'" + Porez.izdatiAvansi[i] + "',";
            }
            ++i;
        }
        pdv = pdv.substring(0, pdv.length() - 1);
        que = String.format("SELECT a.ozndokumenta, a.tip, a.podtip, a.datum, a.sfrkomitent, a.storno, od.iznosbezporeza, od.str3, (select sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1')), (select sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2')), (select sum(p.osnovica) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3')), (select sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T1' OR p.ozntargr = 'T11' OR p.ozntargr = 'U1' OR p.ozntargr = 'S1')), (select sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T2' OR p.ozntargr = 'U2')), (select sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND (p.ozntargr = 'T3' OR p.ozntargr = 'U3')), k.naziv, k.grad, k.pib, k.srbija, k.zemljakomitenta, k.domacikomitent, od.iznossaporezom, k.obveznikpdv, a.oznrj, a.oznOgranak, (select sum(p.iznos) FROM dtaksa p WHERE p.iddok = a.iddok AND p.ozntargr = 'S1') FROM dokument a, opstidokument od, komitent k WHERE a.sfrkomitent = k.sfrkomitent AND a.tip IN (%s) AND (NOT a.podtip = 'POCETNO' OR a.podtip IS NULL) AND od.iddok = a.iddok AND a.arhiviran = 1 %s AND a.datum >= '%s' AND a.datum <= '%s'  {where} ORDER BY a.datum", pdv, "", datPoc.toString(), datKraj.toString());
        return que.replace("{where}", "");
    }
}

